def create_service_api_description(api_name="service_1",
                                   aef_id="aef_id",
                                   supported_features="0",
                                   vendor_specific_service_api_description=None,
                                   vendor_specific_aef_profile=None,
                                   api_status=None):
    aef_ids = list()
    if isinstance(aef_id, list):
        aef_ids = aef_id
        print("aef_id parameter is a list")
    elif isinstance(aef_id, str):
        print("aef_id parameter is a string")
        aef_ids.append(aef_id)

    profiles = create_aef_profiles(aef_ids)

    body = {
        "apiName": api_name,
        "aefProfiles": profiles,
        "description": "ROBOT_TESTING",
        "shareableInfo": {
            "isShareable": True,
            "capifProvDoms": [
                "string"
            ]
        },
        "serviceAPICategory": "string",
        "apiSuppFeats": "fffff",
        "pubApiPath": {
            "ccfIds": [
                "string"
            ]
        },
        "ccfId": "string"
    }

    if vendor_specific_service_api_description is not None:
        if isinstance(vendor_specific_service_api_description, dict):
            for key, value in vendor_specific_service_api_description.items():
                body[key] = value
    if vendor_specific_aef_profile is not None:
        if isinstance(vendor_specific_aef_profile, dict):
            for key, value in vendor_specific_aef_profile.items():
                body["aefProfiles"][0][key] = value
    if supported_features is not None:
        body['supportedFeatures'] = supported_features
    if api_status is not None:
        aef_ids_active = list()
        if isinstance(api_status, list):
            aef_ids_active = api_status
            print("api_status parameter is a list")
        elif isinstance(api_status, str):
            print("api_status parameter is a string")
            aef_ids_active.append(api_status)
        body['apiStatus'] = dict()
        body['apiStatus']['aefIds'] = aef_ids_active

    return body


def create_aef_profiles(aef_ids):
    profiles = list()
    index = 1
    for aef_id in aef_ids:
        profiles.append(create_aef_profile(aef_id, "resource_" + str(index)))
        index = index+1
    return profiles


def create_aef_profile(aef_id, resource_name):
    data = {
        "aefId": aef_id,
        "versions": [
            {
                "apiVersion": "v1",
                "expiry": "2021-11-30T10:32:02.004000+00:00",
                "resources": [
                    {
                        "resourceName": resource_name,
                        "commType": "REQUEST_RESPONSE",
                        "uri": "string",
                        "custOpName": "string",
                        "operations": [
                                    "GET"
                        ],
                        "description": "string"
                    }
                ],
            }
        ],
        "protocol": "HTTP_1_1",
        "dataFormat": "JSON",
        "securityMethods": ["PSK"],
        "interfaceDescriptions": [
                    {
                        "ipv4Addr": "string",
                        "port": 65535,
                        "securityMethods": ["PSK"]
                    }
        ]
    }
    return data


def create_service_api_description_patch(aef_id=None,
                                         description=None,
                                         shareable_info=None,
                                         api_status=None,
                                         service_api_category=None,
                                         api_supp_feats=None,
                                         pub_api_path=None,
                                         ccf_id=None):
    body = dict()

    # aef profiles
    aef_ids = list()
    if aef_id is None:
        aef_ids = None
    elif isinstance(aef_id, list):
        aef_ids = aef_id
        print("aef_id parameter is a list")
    elif isinstance(aef_id, str):
        print("aef_id parameter is a string")
        aef_ids.append(aef_id)
    if aef_ids is not None:
        profiles = create_aef_profiles(aef_ids)
        body['aefProfiles'] = profiles
    
    # description
    if description is not None:
        body['description'] = description

    # shareable info
    if shareable_info is not None:
        body['shareableInfo'] = shareable_info

    # service API Category
    if service_api_category is not None:
        body['serviceAPICategory'] = service_api_category

    # api Supp Feats
    if api_supp_feats is not None:
        body['apiSuppFeats'] = api_supp_feats

    # pub Api Path
    if pub_api_path is not None:
        body['pubApiPath'] = pub_api_path

    # ccf id
    if ccf_id is not None:
        body['ccfId'] = ccf_id

    # api Status
    if api_status is not None:
        aef_ids_active = list()
        if isinstance(api_status, list):
            aef_ids_active = api_status
            print("api_status parameter is a list")
        elif isinstance(api_status, str):
            print("api_status parameter is a string")
            aef_ids_active.append(api_status)
        body['apiStatus'] = dict()
        body['apiStatus']['aefIds'] = aef_ids_active

    return body
