import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model


class Snssai(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, sst=None, sd=None):  # noqa: E501
        """Snssai - a model defined in OpenAPI

        :param sst: The sst of this Snssai.  # noqa: E501
        :type sst: int
        :param sd: The sd of this Snssai.  # noqa: E501
        :type sd: str
        """
        self.openapi_types = {
            'sst': int,
            'sd': str
        }

        self.attribute_map = {
            'sst': 'sst',
            'sd': 'sd'
        }

        self._sst = sst
        self._sd = sd

    @classmethod
    def from_dict(cls, dikt) -> 'Snssai':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Snssai of this Snssai.  # noqa: E501
        :rtype: Snssai
        """
        return util.deserialize_model(dikt, cls)

    @property
    def sst(self) -> int:
        """Gets the sst of this Snssai.

        Unsigned integer, within the range 0 to 255, representing the Slice/Service Type.  It indicates the expected Network Slice behaviour in terms of features and services. Values 0 to 127 correspond to the standardized SST range. Values 128 to 255 correspond  to the Operator-specific range. See clause 28.4.2 of 3GPP TS 23.003. Standardized values are defined in clause 5.15.2.2 of 3GPP TS 23.501.    # noqa: E501

        :return: The sst of this Snssai.
        :rtype: int
        """
        return self._sst

    @sst.setter
    def sst(self, sst: int):
        """Sets the sst of this Snssai.

        Unsigned integer, within the range 0 to 255, representing the Slice/Service Type.  It indicates the expected Network Slice behaviour in terms of features and services. Values 0 to 127 correspond to the standardized SST range. Values 128 to 255 correspond  to the Operator-specific range. See clause 28.4.2 of 3GPP TS 23.003. Standardized values are defined in clause 5.15.2.2 of 3GPP TS 23.501.    # noqa: E501

        :param sst: The sst of this Snssai.
        :type sst: int
        """
        if sst is None:
            raise ValueError("Invalid value for `sst`, must not be `None`")  # noqa: E501
        if sst is not None and sst > 255:  # noqa: E501
            raise ValueError("Invalid value for `sst`, must be a value less than or equal to `255`")  # noqa: E501
        if sst is not None and sst < 0:  # noqa: E501
            raise ValueError("Invalid value for `sst`, must be a value greater than or equal to `0`")  # noqa: E501

        self._sst = sst

    @property
    def sd(self) -> str:
        """Gets the sd of this Snssai.

        3-octet string, representing the Slice Differentiator, in hexadecimal representation. Each character in the string shall take a value of \"0\" to \"9\", \"a\" to \"f\" or \"A\" to \"F\" and shall represent 4 bits. The most significant character representing the 4 most significant bits of the SD shall appear first in the string, and the character representing the 4 least significant bit of the SD shall appear last in the string. This is an optional parameter that complements the Slice/Service type(s) to allow to  differentiate amongst multiple Network Slices of the same Slice/Service type. This IE shall be absent if no SD value is associated with the SST.   # noqa: E501

        :return: The sd of this Snssai.
        :rtype: str
        """
        return self._sd

    @sd.setter
    def sd(self, sd: str):
        """Sets the sd of this Snssai.

        3-octet string, representing the Slice Differentiator, in hexadecimal representation. Each character in the string shall take a value of \"0\" to \"9\", \"a\" to \"f\" or \"A\" to \"F\" and shall represent 4 bits. The most significant character representing the 4 most significant bits of the SD shall appear first in the string, and the character representing the 4 least significant bit of the SD shall appear last in the string. This is an optional parameter that complements the Slice/Service type(s) to allow to  differentiate amongst multiple Network Slices of the same Slice/Service type. This IE shall be absent if no SD value is associated with the SST.   # noqa: E501

        :param sd: The sd of this Snssai.
        :type sd: str
        """
        if sd is not None and not re.search(r'^[A-Fa-f0-9]{6}$', sd):  # noqa: E501
            raise ValueError("Invalid value for `sd`, must be a follow pattern or equal to `/^[A-Fa-f0-9]{6}$/`")  # noqa: E501

        self._sd = sd
