from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model
from service_apis.models.geographical_coordinates import GeographicalCoordinates  # noqa: E501
from service_apis.models.supported_gad_shapes import SupportedGADShapes  # noqa: E501


class Point(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, shape=None, point=None):  # noqa: E501
        """Point - a model defined in OpenAPI

        :param shape: The shape of this Point.  # noqa: E501
        :type shape: SupportedGADShapes
        :param point: The point of this Point.  # noqa: E501
        :type point: GeographicalCoordinates
        """
        self.openapi_types = {
            'shape': SupportedGADShapes,
            'point': GeographicalCoordinates
        }

        self.attribute_map = {
            'shape': 'shape',
            'point': 'point'
        }

        self._shape = shape
        self._point = point

    @classmethod
    def from_dict(cls, dikt) -> 'Point':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Point of this Point.  # noqa: E501
        :rtype: Point
        """
        return util.deserialize_model(dikt, cls)

    @property
    def shape(self) -> SupportedGADShapes:
        """Gets the shape of this Point.


        :return: The shape of this Point.
        :rtype: SupportedGADShapes
        """
        return self._shape

    @shape.setter
    def shape(self, shape: SupportedGADShapes):
        """Sets the shape of this Point.


        :param shape: The shape of this Point.
        :type shape: SupportedGADShapes
        """
        if shape is None:
            raise ValueError("Invalid value for `shape`, must not be `None`")  # noqa: E501

        self._shape = shape

    @property
    def point(self) -> GeographicalCoordinates:
        """Gets the point of this Point.


        :return: The point of this Point.
        :rtype: GeographicalCoordinates
        """
        return self._point

    @point.setter
    def point(self, point: GeographicalCoordinates):
        """Sets the point of this Point.


        :param point: The point of this Point.
        :type point: GeographicalCoordinates
        """
        if point is None:
            raise ValueError("Invalid value for `point`, must not be `None`")  # noqa: E501

        self._point = point
