from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model


class GeographicalCoordinates(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, lon=None, lat=None):  # noqa: E501
        """GeographicalCoordinates - a model defined in OpenAPI

        :param lon: The lon of this GeographicalCoordinates.  # noqa: E501
        :type lon: float
        :param lat: The lat of this GeographicalCoordinates.  # noqa: E501
        :type lat: float
        """
        self.openapi_types = {
            'lon': float,
            'lat': float
        }

        self.attribute_map = {
            'lon': 'lon',
            'lat': 'lat'
        }

        self._lon = lon
        self._lat = lat

    @classmethod
    def from_dict(cls, dikt) -> 'GeographicalCoordinates':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The GeographicalCoordinates of this GeographicalCoordinates.  # noqa: E501
        :rtype: GeographicalCoordinates
        """
        return util.deserialize_model(dikt, cls)

    @property
    def lon(self) -> float:
        """Gets the lon of this GeographicalCoordinates.


        :return: The lon of this GeographicalCoordinates.
        :rtype: float
        """
        return self._lon

    @lon.setter
    def lon(self, lon: float):
        """Sets the lon of this GeographicalCoordinates.


        :param lon: The lon of this GeographicalCoordinates.
        :type lon: float
        """
        if lon is None:
            raise ValueError("Invalid value for `lon`, must not be `None`")  # noqa: E501
        if lon is not None and lon > 180:  # noqa: E501
            raise ValueError("Invalid value for `lon`, must be a value less than or equal to `180`")  # noqa: E501
        if lon is not None and lon < -180:  # noqa: E501
            raise ValueError("Invalid value for `lon`, must be a value greater than or equal to `-180`")  # noqa: E501

        self._lon = lon

    @property
    def lat(self) -> float:
        """Gets the lat of this GeographicalCoordinates.


        :return: The lat of this GeographicalCoordinates.
        :rtype: float
        """
        return self._lat

    @lat.setter
    def lat(self, lat: float):
        """Sets the lat of this GeographicalCoordinates.


        :param lat: The lat of this GeographicalCoordinates.
        :type lat: float
        """
        if lat is None:
            raise ValueError("Invalid value for `lat`, must not be `None`")  # noqa: E501
        if lat is not None and lat > 90:  # noqa: E501
            raise ValueError("Invalid value for `lat`, must be a value less than or equal to `90`")  # noqa: E501
        if lat is not None and lat < -90:  # noqa: E501
            raise ValueError("Invalid value for `lat`, must be a value greater than or equal to `-90`")  # noqa: E501

        self._lat = lat
