  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007448</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">New Feature</td>
<td class="print">public</td>
<td class="print">08-07-2016 12:14</td>
<td class="print">12-12-2016 18:22</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">high</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.8.1 (published 2016-07)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.9.1 (published 2017-05)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">Many</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">L.M.Ericsson</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007448: Allowing multiple encodings for
TTCN-3 types</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">Today the type of encoding of the test
data is not fixed in the specification in all cases. The simplest
example is that IoT common service level data is specified at the
abstract level and can be encoded by XML or by JSON, in the discretion
of the vendor. The abstract data structure can well be defined in
TTCN-3, however the different possible types of encoding is not
supported by the language.<br />
Therefore TTCN-3 shall, as well, be able to encode and decode the same
abstract data structures in different encodings.<br />
<br />
We ask to resolve the CR with urgency, as oneM2M is currently writing
the conformance test suite, where this problem has been raised. The
project will finish by end of the year, that means they need tool
support ASAP.<br />
<br />
Proposed solution can be found in the attached file.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007445</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></span> </td>
<td class="print">Part 01: TTCN-3 Core Language </td>
<td class="print">usage of encode/variant attributes should be
enhanced </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007353</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Part 01: TTCN-3 Core Language </td>
<td class="print">attributes should be attachable to their definition
only </td>
</tr>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007451</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Part 01: TTCN-3 Core Language </td>
<td class="print">Multiple occurrence of an attribute </td>
</tr>
<tr class="even">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007459</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></span> </td>
<td class="print">Part 01: TTCN-3 Core Language </td>
<td class="print">the overwriting rules for attributes and the examples
should be written more consistent </td>
</tr>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0007524</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></span> </td>
<td class="print">Part 06: TTCN-3 Control Interface </td>
<td class="print">TCI extension for multiple attributes </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> Allowing multiple encodings of TTCN PA3.docx (30,489)
<span class="italic">08-07-2016 12:16</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3412&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-1.docx (167,050) <span class="italic">16-08-2016
16:21</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3464&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-V2.docx (118,202) <span class="italic">17-08-2016
15:15</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3476&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-3.docx (170,626) <span class="italic">18-08-2016
09:43</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3486&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-4.docx (129,174) <span class="italic">18-08-2016
15:28</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3492&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-5.docx (129,427) <span class="italic">19-08-2016
13:24</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3499&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-6.docx (127,120) <span class="italic">19-08-2016
14:35</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3503&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-7.docx (185,850) <span class="italic">16-11-2016
11:21</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3532&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-8.docx (132,164) <span class="italic">16-11-2016
15:09</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3541&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7448-9.docx (133,532) <span class="italic">17-11-2016
09:50</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3547&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">08-07-2016 12:14</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">08-07-2016 12:16</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: Allowing multiple encodings of TTCN
PA3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-07-2016 10:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007445</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-07-2016 10:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007353</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-07-2016 09:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-07-2016 09:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2016 16:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0013993</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-07-2016 16:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-07-2016 16:11</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 12:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014005</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 12:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 12:04</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014005</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14005#r302</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 12:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014005</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14005#r303</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 12:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 12:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014005</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14005#r304</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 16:07</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014012</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">20-07-2016 16:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">20-07-2016 16:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 08:25</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Edited: 0014012</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14012#r306</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 09:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014024</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-07-2016 09:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-07-2016 09:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-08-2016 10:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a></td>
<td class="print">Note Added: 0014041</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-08-2016 13:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014042</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">02-08-2016 13:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014043</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">02-08-2016 13:46</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Edited: 0014042</td>
<td class="print">bug_revision_view_page.php?bugnote_id=14042#r312</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2016 16:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7448-1.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-08-2016 16:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014114</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2016 16:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-08-2016 16:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-08-2016 16:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007451</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 11:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 15:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Added: CR7448-V2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 15:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014134</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2016 15:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2016 15:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-08-2016 09:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7448-3.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-08-2016 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014150</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-08-2016 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-08-2016 09:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-08-2016 09:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007459</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-08-2016 15:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7448-4.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">18-08-2016 15:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014158</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">18-08-2016 16:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014161</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 13:24</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7448-5.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 13:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014178</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 13:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Tomas Urban</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 13:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-08-2016 14:35</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7448-6.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-08-2016 14:36</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014183</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-11-2016 15:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014230</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 11:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7448-7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Note Added: 0014259</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Assigned To</td>
<td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 11:15</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0007524</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 11:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Deleted: CR7448-7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 11:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a></td>
<td class="print">File Added: CR7448-7.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 15:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7448-8.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0014274</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.9.1 (published 2017-05)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">16-11-2016 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">16-11-2016 15:10</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; KristÃ³f Szabados</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:50</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">File Added: CR7448-9.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Note Added: 0014288</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Assigned To</td>
<td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 09:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 11:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0014300</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-11-2016 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-11-2016 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-12-2016 18:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0014395</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">12-12-2016 18:22</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013993)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-07-2016 16:10   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The part of the proposal concerning the way how
different encodings and associated variants are specified (multiple
encode statements, variants with an encode prefix and a colon) is
acceptable without any objections.<br />
<br />
In the case of selection the actual encoding the STF proposes to use the
static approach. We assume that there's (one or more global PDU)
containing potentially complicated structure of elements with multiple
encodings and variants. The desired encoding and the associated set of
variants will be selected by creating an alias type (or template) with a
dedicated "filtering" attribute. Please check the following
example:<br />
<br />
type Payload {<br />
    XSD.Integer foo,<br />
    XSD.Float bar<br />
} with {<br />
  encode "XML";<br />
  encode "Jason";<br />
  variant "XML":"name as uncapitalized"<br />
  variant "Jason":"name as 'dt'"<br />
}<br />
<br />
type record PDU {<br />
  Payload payload<br />
} with {<br />
  encode "XML";<br />
  encode "Jason";<br />
  variant "XML":"element"; // example of an XML variant<br />
  variant "JSON":"name as 'pd'"; // example of a Jason variant<br />
}<br />
<br />
type PDU XmlPDU with { encode @only "XML" }<br />
// This definition removes all Jason related attributes and keeps XML
(on all<br />
// levels), so that the XmlPDU type is equal to:<br />
// type record XmlPDU {<br />
// Payload payload<br />
// } with {<br />
// encode "XML";<br />
// variant "element";<br />
// variant(payload) "name as uncapitalized";<br />
// }<br />
<br />
type PDU JasonPDU { encode @only "JSON" }<br />
// type record JasonPDU {<br />
// Payload payload<br />
// } with {<br />
// encode "Jason";<br />
// variant "name as 'pd'";<br />
// variant(payload) "name as 'dt'";<br />
// }<br />
<br />
Could you please comment if the @only filter would work for you? It
should be possible to write a universal test suite for XML and Jason
with it. You will still need two different receive branches, but
handling can be common for both of them as the type structures are
equal.<br />
<br />
The main advantage of the @only modifier is that it doesn't require
complicated changes in the receiving, sending, encoding and decoding
statements and the impact on the TCI will be minimal. It is also easily
applicable to protocol stacks.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014005)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-07-2016 12:03   <br />
(edited on: 20-07-2016 12:09)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Depending on what the question is:<br />
- if @only is proposed *in addition* what the CR requests (i.e. allow
types with multiple encodings, where the actual codec is chosen by the
TE based on a runtime configuration parameter), it is acceptable, but is
useless, superfluous; it doesn't solve dynamic encoding control
either;<br />
- if all the multiple encoding problem is wanted to be solved by
aliases, it is not acceptable. It is principally wrong approach. It
would not need any language extension, just a clarification of
overwriting rules for encode and variant attributes for aliases.<br />
<br />
Considering the below type definitions;<br />
The requested solution looks like:<br />
<br />
template PDU t_PDU := { payload := { foo := 42, bar := 5.0 }<br />
<br />
function f() runs on CT {<br />
  P.send (t_PDU);<br />
  alt {<br />
      [] P.receive (PDU:?){...} //note, that receiving a "wrongly"
encoded message, i.e. of encoded by the 'another' encoding causes a
runtime error here<br />
  }<br />
  ...<br />
}<br />
<br />
----------------------------------------------------------------------<br />
The code with the proposed alias solution would look like:<br />
<br />
template XmlPDU t_PDUxml := { payload := { foo := 42, bar := 5.0 }<br />
template JasonPDU t_PDUjson := t_PDUxml;<br />
<br />
function f() runs on CT {<br />
  if (modulepar_encoding=="XML") {P.send (t_PDUxml)};<br />
  elseif (modulepar_encoding=="JSON") {P.send (t_PDUjson);<br />
  alt {<br />
      [modulepar_encoding=="XML"] P.receive (XmlPDU :?){...} //note,
that if receiving receiving a PDU encoded with "Jason" it will cause a
deadlock of the component here<br />
      [modulepar_encoding=="Jason"] P.receive (JasonPDU:?){...}// the
same for receiving an "XML" encoded message<br />
//Pls. note, if "XML" encoding is expected from the SUT, but it uses
"Jason" instead, this shall be a fail verdict as well!<br />
  }<br />
  ...<br />
}<br />
<br />
Drawbacks of the proposed alias solution:<br />
- huge amount of superfluous code, to be written for nothing, with all
its readability and other consequences (the TE could choose the needed
encoding itself, instead of this, the user shall explicitly control it
from the TTCN-3 code);<br />
- horrible maintain-ability: if a new, 3rd (or the 2nd) encoding is
introduced, the "whole" TTCN-3 code has to be updated: new type aliases,
new template aliases, new if~ and alt branches everywhere... if adding a
new if~ or alt branch is forgotten at a single place, or a wrong
template alias is used (a typical copy-paste error), the error cannot be
discovered @ compile time, only @ runtime, by a wrong test case result
(if, at all);<br />
for example, in standard test suites, where the code is typically
written by the standard body, but is not executed, this would cause a
nightmare.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014012)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">20-07-2016 16:07   <br />
(edited on: 21-07-2016 08:25)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We propose the following solution to the dynamic
problem:<br />
<br />
a) Keep the @only modifier for static filtering (for the users that
might find some use of it).<br />
b) Introduce a dynamic solution using a new encode statement:<br />
( PortReference | "all" "port" | "self") "." encode "(" (Type | all) ","
Expression ")"<br />
<br />
The encode statement would activate an encoding filter for a particular
port, all port or a whole component. The filter would apply to a
particular type, its part (useful for protocol stacks) or to all
messages passed to the codec. It would basically do the same thing as
the @only modifier, but dynamicly.<br />
<br />
Example for our XML/Jason case:<br />
modulepar universal charstring ENCODING; // set to "XML" by TCI-TM<br />
self.encode(PDU, ENCODING); // Disables all encodings that are not
"XML"<br />
    // and variants related to them<br />
p.send(PDU:{...}}; // When the message is sent out, only the "XML"
encode<br />
    // attribute and related "XML" variants are visible to the
codec<br />
<br />
// in order to go through all encodings:<br />
type record of universal charstring TEnc;<br />
var TEnc v_enc := {...} // dynamically specify acceptable
encodings<br />
var integer i := 0;<br />
p.encode(PDU, v_enc[i]);<br />
alt {<br />
  [] p.receive(PDU:?)<br />
  // [] ... other alternatives<br />
  [else] {<br />
     i := i + 1;<br />
     if (i &lt; lengthof(v_enc)) {<br />
       p.encode(PDU, v_enc[i]);<br />
       repeat;<br />
     }<br />
  }<br />
}<br />
<br />
The advantage of this approach is that we don't have to change the
syntax of the sending/receiving operations and of the enc_value and
dec_value functions. It contains support of protocol stacks as an
extended type reference can be used as the first parameter.<br />
<br />
Gyorgy, could you please say if it is acceptable for you?<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014024)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-07-2016 09:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">If I understand correctly:<br />
- several encode attributes can be attached to a type (group module ...)
and variant attributes can be scoped with the syntax proposed by the
CR;<br />
- P.encode(PDU,modPar_encoding); activates a concrete encoding to a
given port<br />
- all port.encode(PDU,modPar_encoding); activates a concrete encoding to
all ports of the given component, but NOT for encvalue/decvalue-s<br />
- self.encode(PDU,modPar_encoding); activates a concrete encoding to all
ports AND encvalue/decvalue-s of the given component<br />
- in addition, a new optional parameter will allow select/change the
default encoding for individual
encvalue/decvalue/encvalue_unichar/decvalue_unichar calls<br />
<br />
This solution, as a whole, is fine with me.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014041)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin
Hauch</a>   </td>
</tr>
<tr class="odd">
<td class="print">02-08-2016 10:50   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Questions:<br />
Where are the types defined, which should be used for "JSON" and "XML"
coding?<br />
Definitions from XSD:<br />
"Part 9: Using XML schema with TTCN-3" does not define variant
"XML":"element"; (or other "XML" renamings for elements or attributes).
Current "Part 11: Using JSON with TTCN-3" does not define variant
"JSON":name as 'pd'"<br />
Should the syntax for variant attributes be changed to bind the
variant-atrribute information to an encoding-rule in case of more than 1
encoding-rule is assigned?<br />
How should JSON-variants be added to these from XSD converted
types?<br />
How should xsd-defined types be encoded in JSON?<br />
<br />
Definitions from TTCN:<br />
I think this should work. The encode- and variant-attributes could be
defined for all types (as shown in your example), respecting the
possible attribute-values defined in the documents "Part 9: Using XML
schema with TTCN-3" and "Part 11: Using JSON with TTCN-3".</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0014042)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">02-08-2016 13:03   <br />
(edited on: 02-08-2016 13:46)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Thanks Martin, good points.<br />
I think both Part-9 and draft Part-11 shall be updated to allow
generating the variant scopings automatically (for backward
compatibility and readibility reasons this should be a user-choice
converter configuration parameter).<br />
As JSON doesn't have a schema, no JSON encoding instructions can be
generated automatically, they always need to be added manually to TTCN-3
files. Therefore, the output of an XML converter need to be decorated
with JSON variant attributes manually.<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014043)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">02-08-2016 13:46   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">During the internal discussions we were also
discussing a possible compact syntax to assign an encoding instruction
to multiple encode-s, something like<br />
<br />
variant (resourceName){"XML","JSON"}:"name as 'rn'";<br />
<br />
at the end this feature wasn't included into the initial proposal, to
keep it simple.<br />
<br />
However, now ETSI has raised the same issue, as the main attribute to be
used in the IoT conformance tests is name as, which is the same in both
XML and JSON. Another ETSI's point is that e.g. if a new, 3rd encoding
is added, it is easier to add the name of the new encoding to the list
of encodes, than copy-paste-change all the variants for the new
encoding, which would make the code long, nasty and hardly
readable.<br />
<br />
Could you please also consider a compact syntax, to add an encoding
instruction to multiple encodings by a single variant?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014114)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-08-2016 16:24   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Proposal uploaded. The document also contains a
resolution for all related CRs. Please check.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014134)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2016 15:17   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Please check again. Ericsson should also proofread
before resolving the issue.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014150)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-08-2016 09:48   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I am fine with the corrections. I only made a couple
of minor formating changes in the document.<br />
<br />
Kristóf, could you please look at the document too and discuss the
matter with György?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014158)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-08-2016 15:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I have added/changed multiple places according to our
discussions.<br />
<br />
Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014161)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">18-08-2016 16:44   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Hi, in general the proposal looks fine, but a few
comments/questions:<br />
<br />
1) Regarding the @local modifier I’m not sure if it’s really needed:
while it complicates the language and the tools, I can see little
practical use. Let see the example from the standard:<br />
    module M {<br />
        type record MyRec {<br />
            integer field1,<br />
            integer field1,<br />
        } with { encode @local "CodecB" }<br />
        // the record type MyRec will be encoded with CodecB, but its
fields with CodecA,<br />
        // because local attribute CodecB doesn’t affect elements of the
MyRec type.<br />
    } with { encode "CodecA" }<br />
<br />
In reality, typically protocol messages and their fields have encode
attributes, in which case fields are practically always some constrained
types, having their own type definitions (and thus inheriting the
attribute associated to the group/module). Maybe boolean fields are
exceptions, but I haven’t seen any of them being encoded differently
than the enclosing type; and if, it is more intuitive to add their
encoding to the field directly (than to understand what @local
means):<br />
    module M {<br />
<br />
type integer (0..255) Intfield;<br />
<br />
type record MyRec {<br />
  Intfield field1,<br />
  Intfield field2,<br />
  boolean field3<br />
} with { encode "CodecB";//this does not apply to fields field1 and
field2 acc. to the previous rule<br />
         encode (field3) “CodecA”}<br />
} with { encode "CodecA" }<br />
<br />
2) I think it would be more secure if variant attribute without encode
reference is allowed only, if there is just a single encode applied to
the scope (i.e. not to have "global variant"s). Once a new encoding is
added to a module, all variants has to be re-checked anyway, during
which it is easy to copy-paste the encoding scope in front of the
already existing variant. But with the current "global variant" rule,
variants forgotten to be cross-checked and scoped, will automatically
start effecting on the new encoding as well.<br />
<br />
3) If considering the example:<br />
    // Modifying list of allowed encodings<br />
    type Int Int2 with {<br />
        encode "CodecA"; // variants "CodecA"."Rule1" and "GlobalRule"
are kept<br />
        encode "CodecC"; variant "CodecC"."Rule6"; // new encoding and
related variant<br />
        // "CodecB" encoding and related variant are discarded as
"CodecB" is not<br />
        // explicitly referenced<br />
    }<br />
<br />
It is unclear why the @only modifier is needed.<br />
In the example<br />
    // Selecting encoding with an @only modifier<br />
    type MyRecord MyRecord2 with {<br />
        encode @only (field1) "CodecB"; // field1 will be encoded with
CodecB<br />
        encode @only "CodecA" // the record and field2 will be encoded
with CodecA<br />
    }<br />
Applying encode (field1) "CodecB" and encode "CodecA" would have exactly
the same effect: whatever other encodings applied to MyRecord and
MyRecord.field1 are simply discarded.<br />
<br />
4) Has ETSI’s request to allow associating a variant to several
encodings with a single statement been considered? Example (syntax below
is appropriate, any suitable syntax will do it):<br />
    module M {<br />
type record MyRecX {<br />
  Intfield field1,<br />
  Intfield field2,<br />
  boolean field3<br />
} with { variant(field1) {"CodecA”,”CodecB”}.”name as ‘f1’”;<br />
         variant(field2) {"CodecA”,”CodecB”}.”name as ‘f2’”;<br />
         variant(field3) {"CodecA”,”CodecB”}.”name as ‘f3’”}<br />
<br />
} with { encode "CodecA" }</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014178)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-08-2016 13:26   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added clarification, that variants without explicit
encoding relation are implicitly related to all encodings in
effect.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014183)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-08-2016 14:36   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added example to show the difference between encodes
with and without @only.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014230)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-11-2016 15:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF discussion:<br />
1) @local will be kept<br />
2) no global variants for multiple encodings<br />
4) one variant for multiple encodings by explicit naming<br />
<br />
3) @only will be skipped (no different scope level, same scope
level)<br />
<br />
- Precedence rules for 3) will be checked for tools represented in
STF.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014259)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-11-2016 11:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Specification updated according to STF discussion
conclusion. Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014274)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">16-11-2016 15:10   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">added a missing closing parenthesis in BNF, otherwise
ok, ready for implementation</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014288)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f
Szabados</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-11-2016 09:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Corrected some typos.<br />
Added a note before example 4.<br />
Corrected example in section 27.9 (in the testcase ContainerType needed
to be changed to PDU as that is the name of the type)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014300)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-11-2016 11:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">OK, ready for implementation.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0014395)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-12-2016 18:22   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to draft V4.8.2</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
