  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0007139</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">13-08-2015 08:28</td>
<td class="print">11-12-2015 14:29</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Tomas Urban</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Gyorgy Rethy</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">low</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.7.1 (published 2015-06)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.8.1 (published 2016-07)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.8.1 (published 2016-07)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">6.2.4</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">STF 487</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0007139: Unnecessary rule on uniqueness of
enumerated values</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">The section 6.2.4 states that: "The
identifiers of enumerated values shall only be reused within other
structured type definitions and shall not be used for identifiers of
local or global visibility at the same or a lower level of the same
branch of the scope hierarchy (see scope hierarchy in clause
5.2)."<br />
<br />
The scope of the enumerated values is the enumerated type itself. Thus,
there can never be a conflict with an identifier that has a global
visibility. And the rule forbidding reusing of identifiers inside the
same enumerated type (i.e. at the same and lower scope) is already
defined: "The identifiers of enumerated values shall be unique within
the enumerated type (but do not have to be globally unique) and are
consequently visible in the context of the given type only."<br />
<br />
For these reasons I find the above mentioned rule on global and local
visibility superfluous and suggest that it should be dropped.</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7139.docx (381,538) <span class="italic">04-11-2015
13:44</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3359&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="docx" /> CR7139_resolution_v2.docx (76,038) <span
class="italic">04-11-2015 15:02</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=3362&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2015 08:28</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-08-2015 09:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013153</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2015 09:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013154</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-08-2015 13:57</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013155</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2015 14:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013156</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">13-08-2015 14:37</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013157</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">13-08-2015 20:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013158</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-08-2015 07:56</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013159</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-08-2015 09:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013160</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-08-2015 12:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013161</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-08-2015 13:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013162</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-08-2015 13:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013165</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">14-08-2015 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Edited: 0013165</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13165#r155</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">14-08-2015 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Edited: 0013165</td>
<td class="print">bug_revision_view_page.php?bugnote_id=13165#r156</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-08-2015 08:41</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013168</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-08-2015 09:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a></td>
<td class="print">Note Added: 0013169</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2015 10:27</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; v4.8.1 (published 2016-07)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">21-09-2015 15:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013218</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">21-09-2015 15:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Priority</td>
<td class="print">normal =&gt; low</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2015 15:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013476</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-11-2015 15:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">03-11-2015 15:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 13:44</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: CR7139.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 13:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013486</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 13:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013487</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 13:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 13:53</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; confirmed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 14:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR7139_resolution_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 14:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: CR7139_resolution_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 15:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: CR7139_resolution_v2.docx</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 15:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013491</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 15:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 15:06</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">confirmed =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0013494</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; v4.8.1 (published 2016-07)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-11-2015 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-11-2015 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">11-12-2015 14:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0013590</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">11-12-2015 14:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013153)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 09:45   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The problem seems to be more complex. There is one
place suggesting that the identifiers of enumerated values cannot be
reused. The section 5.2.2 (uniqueness on identifiers) says that
enumerated value identifiers can be reused only in other enumerated
types: "Identifiers for fields of structured types, enumerated values
and groups do not have to be globally unique, however in the case of
enumerated values the identifiers shall only be reused for enumerated
values within other enumerated types."<br />
<br />
However the code in the example 1 of 6.2.4 violates this rule completely
and provides reasonable description suggesting a completely different
behaviour which is inline with complex-specific resolution of enumerate
value identifiers.<br />
<br />
In my opinion, the example is right and the rule on uniqueness should be
removed. There has been a shift to context-specific interpretation of
enumerated values in previous TTCN-3 specifications and I think that the
uniqueness rule was just left unnoticed. Nevertheless, if I am mistaken,
something has to be done with the example 1.<br />
<br />
There's also one additional rule that is affected by this issue: "When a
TTCN-3 module parameter, formal parameter, constant, variable,
non-parameterized template or parameterized template with all formal
parameters having default values of an imported enumerated type is
defined, the name of that definition shall not be the same as any of the
enumerated values of that type."<br />
<br />
In case the uniqueness rule is dropped, then it is possible to create
local definitions of an enumerated type reusing one of the enumerated
value identifiers:<br />
<br />
module Module1 {<br />
  type enumerated Days { Monday, Tuesday, Wednesday }<br />
  control {<br />
    var Days v_day := Monday, Monday := Tuesday;<br />
    if (v_day == Monday) {...} //comparing v_day with an enumerated
value<br />
    // but how to compare v_day and Monday variables?<br />
  }<br />
}<br />
<br />
The easy fix for this issue would be to remove the word "imported" from
the above mentioned rule.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013154)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 09:56   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In case of dropping the uniqueness rule, one more
issue has to be addressed: the enumerated value identifiers have to take
precedence over definitions. There's a rule for imported enumerations
covering this issue in 8.2.3.1: "when in the context of an enumerated
type (see clause 6.2.4), an enumerated value is clashing with the name
of a definition in the importing module, the enumerated value shall take
precedence and the definition in the importing module shall be
referenced by using its qualified name (see example 4 below in this
clause)."<br />
<br />
This rule should be valid to local definitions as well.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013155)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 13:57   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Since it is a definite source of a possible error to
define a thing of an enum type E with the same name as one of E's
values, I would still forbid this, even if there is some rule that
semantically defines this.<br />
<br />
imagine an enumeration E which does not have name V.<br />
<br />
I then declare<br />
<br />
var E V and subsequently use V.<br />
<br />
Later on, someone else changes E and adds V. Suddenly, my code means
something completely different in all places where I use V in the
context of E.<br />
<br />
This should be avoided and lead to an error, i.e. forcing me to rename
(or forcing the other person to choose a different name)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013156)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 14:26   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Jacob, I completely agree and I don't want to change
this. My point is that the current TTCN-3 rules provide three different
interpretations for reuse of identifiers:<br />
<br />
According to 5.2.2 the enumerated value identifier cannot be reused even
in other structured types in the same module.<br />
<br />
6.2.4 allows the reuse in structured type, but it probably (because the
text is not very comprehensive) doesn't allow the reuse e.g. as a name
of a type which should be completely harmless.<br />
<br />
And there is also the importing rule - variables etc. of imported enum
types cannot have the same name as one of the enumerated values. The
rule is brilliant, the only problem is that it should be valid for all
enumerations and not only for imported ones.<br />
<br />
My proposal is to drop the restrictions to a minimum: enumerated value
identifiers can be reused anywhere with the exception of the enum type
scope and values of the defining enumerated type.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013157)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 14:37   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">If I just understood what that means, I could agree.
Alas, I don't.<br />
<br />
In my opinion, enum value-names could be re-used for anything except
other value-names in the same enumerated type definition and all
entities declared with the enumerated type as their type.<br />
<br />
Also, imagine the following situation:<br />
<br />
enumerated E1 { a }<br />
enumerated E2 { b }<br />
<br />
const E1 b := a;<br />
const E2 a := b;<br />
<br />
What does the expression (a == b) mean?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013158)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">13-08-2015 20:49   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">&gt; In my opinion, enum value-names could be re-used
for anything except other value-names in the same enumerated type
definition and all entities declared with the enumerated type as their
type.<br />
<br />
Thumbs up for that. But compare it with the two problematic rules quoted
above:<br />
<br />
"The identifiers of enumerated values shall only be reused within other
structured type definitions and shall not be used for identifiers of
local or global visibility at the same or a lower level of the same
branch of the scope hierarchy (see scope hierarchy in clause
5.2)."<br />
<br />
"Identifiers for fields of structured types, enumerated values and
groups do not have to be globally unique, however in the case of
enumerated values the identifiers shall only be reused for enumerated
values within other enumerated types."<br />
<br />
Do these rule support your interpretation? I don't think so. And I don't
even think they are compatible. That's why I propose to remove them (and
eventually replace with something better).<br />
<br />
Your example is indeed quite tricky. Because statements are typically
processed in the textual order, I would expect "a" to be interpreted
first as the constant "a" (for no enumeration context is known at that
point - we just started processing) and "b" to be interpreted as the
enumerated value "b" of the type E2 (as we can establish an implicit
reference to the type E2 through the constant "a" at this point). The
expression would then yield true.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013159)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-08-2015 07:56   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I totally disagree. Expressions are first evaluated
for their syntactic and semantic properties and then evaluated.<br />
<br />
Otherwise, you could never write something like &lt;enumValue&gt; ==
&lt;enumVariable&gt; because enumValue has no enum context when
processing from left to right.<br />
<br />
But, since a == b should always be equivalent to b == a for expressions
a and b without side-effects, your approach would violate this
rule.<br />
<br />
Sure, we already have that situation at the moment if two enums share
the same values and then two values from that intersection are to be
compared (as then the enum-context also cannot be determined) but in
that situation at least only enum-values are involved and no additional
potential clash with local items is possible.<br />
<br />
Basically, the rules as they are now do the following:<br />
<br />
They disallow the situation that I have described (as a and b would be
disallowed in the same module to be redefined as constants) and they
always allow to resolve nameclashes by prefixing. If an enum-value can
shadow a local variable of the same type that is no longer the case, so
that definitely needs to stay forbidden).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013160)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-08-2015 09:18   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">&gt; Otherwise, you could never write something like
&lt;enumValue&gt; == &lt;enumVariable&gt; because enumValue has no enum
context when processing from left to right.<br />
<br />
I don't agree with that statement. Processing from left to right only
takes precedence. If it is not possible to use it, right to left is used
as the second option and resolves the symbols without any problem.<br />
<br />
Your example is currently a valid code in TTCN-3, in case the
enumeration types are imported to the module where constants "a" and "b"
are defined. So how do you resolve it in this case, especially if
constants are locally defined and cannot be prefixed?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013161)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-08-2015 12:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I disagree, at the moment it is invalid code because
it is ambiguous. There is no rule that says that the left argument takes
precedence over the right argument when determining enumeration
context.<br />
<br />
In the case of local definitions, I would always give precedence to the
local definition (as do all languages normally) and if it is a global
definition, I can prefix the constant and therby establish unambiguity.
(a must be defined in a different module than enum value a, same with b,
so the module prefix determines which it is).</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013162)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-08-2015 13:20   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">&gt; I disagree, at the moment it is invalid code
because it is ambiguous.<br />
Please refer to the TTCN-3 rules which are violated in the example
below.<br />
<br />
module Module1 {<br />
  type enumerated E1 { a }<br />
  type enumerated E2 { b }<br />
}<br />
<br />
module Module2 {<br />
  imports from Module1 all;<br />
  control {<br />
    const E1 b := a;<br />
    const E2 a := b;<br />
    log(a == b);<br />
  }<br />
}<br />
<br />
&gt; In the case of local definitions, I would always give precedence to
the local definition (as do all languages normally) and if it is a
global definition, I can prefix the constant and therby establish
unambiguity. (a must be defined in a different module than enum value a,
same with b, so the module prefix determines which it is).<br />
<br />
Unfortunately, TTCN-3 does NOT behave this way. The rules of 8.2.3.1
(which I already mentioned here) describe quite unambiguously this
situation: "There is one exception to this rule: when in the context of
an enumerated type (see clause 6.2.4), an enumerated value is clashing
with the name of a definition in the importing module, the enumerated
value shall take precedence and the definition in the importing module
shall be referenced by using its qualified name (see example 4 below in
this clause)." Please open the specification and take a look at the
example.<br />
<br />
But before you do that, just take a look at the discussion here. I
actually don't try to defend any kind of interpretation. I would be fine
with any as long as there's just one. My point is that the current rules
just don't offer that. They are contradictory and contain blank
spots.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">(0013165)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">14-08-2015 13:49   <br />
(edited on: 14-08-2015 13:51)</td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Maybe there's a simple solution for this
situation:<br />
<br />
1. Enumerated value identifiers shall be unique just within the
enumerated type<br />
2. Enumerated value identifiers can be reused for other definitions (in
the module where the enumeration is defined, in importing modules and
even for constant/variables/templates of the defining enumerated
type)<br />
3. When resolving identifiers, global and local references are ALWAYS
resolved first (i.e. if there's an enumerated value and a variable of
the same name, it is always resolved as a variable even if it means type
mismatch)<br />
4. In order to resolve name clashes, a new concept of extended
enumerated value reference will be introduced:
EnumeratedTypeReference.EnumeratedValue.<br />
<br />
What do you think?<br />
<br />
</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013168)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2015 08:41   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In principle, in a language where there is no other
overloading, I like this approach much better than what we have now, but
I'm sure that this change is not backward-compatible. (In pathological
cases, of course. At the moment, it is allowed to have an
integer-variable i and an enum-value i).<br />
<br />
type enumerated E { i }<br />
<br />
function(integer i, E e) {<br />
  if (e == i) { // enum interpretation of i<br />
  }<br />
  if (3 == i) { // integer interpretation of i<br />
  }<br />
}<br />
<br />
function g() {<br />
  var integer i := 3;<br />
  f(i, i); // first i is the integer variable, second i is the enum
value<br />
}<br />
<br />
So, to preserve this (unambiguous) behavior, I would suggest that only
in type-ambiguous cases of name-clashing identifiers (where the
enum-context cannot be unambiguously established), local definitions
shall have precedence before the enum value (and then the clash can be
resolved towards the enum-value by prefixing with the enum type - which
at the moment I always do with valueof(E:v) ;-)).<br />
<br />
So, the a == b example in this case would then cause an error as it
would resolve both a and b to the constants and their types are not
compatible. The user would have to add an enum-type-prefix either before
a or b or add a module-prefix before a or b (if they are global) to
establish an unambiguous enum-context.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013169)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas
Urban</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-08-2015 09:32   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I have no problem with this solution. It might require
more rules to describe, but backwards compatibility is important and the
compiler might always issue a warning in the cases where prefixing would
make code more readable. I am looking forward for the proposal
draft.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013218)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">21-09-2015 15:38   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion: CR is low priority, because the
restriction does not cause a problem.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013476)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">03-11-2015 15:03   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">STF discussion: analyse if the other enumerated rules
restricting enumeration value names are covering all possible name
clashing scenarios.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013486)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2015 13:51   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">aligned the description in 5.2 with the one in 6.2.4,
i.e. enum values in a module can be used as other enum values or as
fields of structured types but nothing else.<br />
<br />
The reasoning is that the existing restrictions align the feature with
the rest of the language:<br />
- no shadowing/overloading in the same module (re-using constant name as
type name is also not allowed, but would in principle not be a problem)
- except for enumerated values<br />
- name-clashes between local variable and imported value can always be
resolved by module-prefixing (no new enumtype-prefixing context
needed)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013487)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2015 13:53   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">please review and resolve</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013491)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2015 15:06   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">CR7139_resolution_v2.docx: the addition to clause
6.2.4 is true within a module only. In other modules, importing the
enumerated type, enumeration names can be used as names of
non-enumerated definitions. This is the whole "context business"
about.<br />
<br />
Please review.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013494)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">04-11-2015 17:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I think the addition is redundant as the scope of the
whole paragraph is talking about the uniqueness inside one module scope.
But, it doesn't hurt, either, so we can leave it as is.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0013590)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">11-12-2015 14:29   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Added to draft V4.7.4</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
