  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0006008</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">19-01-2012 17:18</td>
<td class="print">10-07-2012 13:59</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Nikolay Pakulin</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">N/A</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">won't fix</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v4.3.1 (published 2011-06)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.5.1 (published 2013-04)</td>
<td class="print-category">Fixed in Version</td>
<td class="print"></td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">B 1.1, 6.3</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">ISPRAS, STF 433</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0006008: Match omit Ð¼Ñ‹ undefined
value</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">The following test case is a refined case
when a record, initialized by an array, is matched back agains that
array. The pecularity of the test case is that the array contains an
undefined element. According to clause 6.3.2.2 corresponding optional
field of the record becomes *omit*.<br />
<br />
So, the question actually is: how to match an omitted value against an
undefined value. What output should the test case produce -- whether
full values match or not, whether omitted value matched undefined?</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">module match_omit_undefined {<br />
    type record Record {<br />
        integer a optional<br />
    }<br />
    type record length(1) of integer Array;<br />
    type component MTC {}<br />
    <br />
    testcase TC_match_omit_undefined() runs on MTC<br />
    {<br />
        var Array array := {-};<br />
        // recrd.a must be set to omit<br />
        // TTCN3, v.4.3.1<br />
        // Clause 6.3.2.2: If an element with an undefined value is
assigned to an optional element of the record, this will<br />
        // cause the optional element to be omitted.<br />
        var Record recrd := array;<br />
        var boolean v_match_structured_values := match(recrd,
array);<br />
        var boolean v_match_omit_undefined := match(recrd.a,
array[0]);<br />
   <br />
        log("Result of matching missing elements: ",
v_match_omit_undefined);<br />
        log("Result of matching structured values: ",
v_match_structured_values);<br />
    }<br />
    control {<br />
         execute(TC_match_omit_undefined())<br />
    }<br />
}</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0006165</td>
<td class="print">closed </td>
<td class="print"> </td>
<td class="print">Add recof2setof predefined function </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-01-2012 17:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay
Pakulin</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-01-2012 17:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay
Pakulin</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; B 1.1, 6.3</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">19-01-2012 17:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay
Pakulin</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; ISPRAS, STF 433</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">19-01-2012 17:21</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay
Pakulin</a></td>
<td class="print">Note Added: 0010546</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 09:32</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0006165</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010754</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">10-07-2012 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; won't fix</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">10-07-2012 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.5.1</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010546)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=704">Nikolay
Pakulin</a>   </td>
</tr>
<tr class="odd">
<td class="print">19-01-2012 17:21   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">The title of the CR should read: "Match omit vs
undefined value".<br />
Cyrillic "Ð¼Ñ‹" crawled in due to automatic keyboard layout
switcher.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010754)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">10-07-2012 13:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">There is no statement that undefined content is
changed to omit. According to clause 11.1 restriction d) and e) the
assignment recrd := array and both match operations above shall cause an
error.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
