  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0005809</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">24-11-2010 12:49</td>
<td class="print">17-07-2011 07:03</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Andrus Lehtmets</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">high</td>
<td class="print-category">Severity</td>
<td class="print">major</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print"></td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v4.3.2 (interim 2011)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v4.3.2 (interim 2011)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">CL chapter 15.11 Concatenating templates
of string and list types and BNF</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Elvior</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0005809: CL chapter 15.11 Concatenating
templates of string and list types is not supported by BNF</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">CL chapter 15.11 Concatenating templates
of string and list types is not supported by BNF.<br />
<br />
We propose to modify BNF so:<br />
 111. SingleValueOrAttrib ::= MatchingSymbol |<br />
SingleExpression |<br />
( TemplateRefWithParList [ ExtendedFieldReference ] ) [ TemplateConcat
]<br />
<br />
NewRule.<br />
TemplateConcat ::= StringOp SingleValueOrAttrib [TemplateConcat ]<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"><table data-border="0" width="100%"
data-cellpadding="0" data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print"><span class="nowrap">related to</span> </td>
<td class="print">0005513</td>
<td class="print">closed </td>
<td class="print"><span class="nowrap"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></span> </td>
<td class="print">resolution of CR5092 contains bogus examples for
charstring </td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> es_20187301v040205m_CR_5809.doc (92,160) <span
class="italic">26-05-2011 14:17</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2506&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> es_20187301v040205m_CR_5809_v2.doc (115,200) <span
class="italic">30-06-2011 08:48</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2529&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> es_20187301v040205m_CR_5809_v3.doc (103,936) <span
class="italic">01-07-2011 11:09</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2544&amp;type=bug<br />
<img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> es_20187301v040205m_CR_5809_v4.doc (109,056) <span
class="italic">17-07-2011 06:19</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=2558&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-11-2010 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus
Lehtmets</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-11-2010 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus
Lehtmets</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; CL chapter 15.11 Concatenating templates of
string and list types and BNF</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-11-2010 12:49</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=509">Andrus
Lehtmets</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Elvior</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-11-2010 16:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a></td>
<td class="print">Note Added: 0009804</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-11-2010 11:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a></td>
<td class="print">Note Added: 0009805</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-11-2010 14:54</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009806</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">25-11-2010 16:05</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a></td>
<td class="print">Note Added: 0009807</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-11-2010 13:08</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Relationship added</td>
<td class="print">related to 0005513</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-11-2010 13:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0009827</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-11-2010 10:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a></td>
<td class="print">Note Added: 0009837</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">03-12-2010 10:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 4.3.2 (interim)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-05-2011 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010031</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-05-2011 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-05-2011 15:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-05-2011 19:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Priority</td>
<td class="print">normal =&gt; high</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">25-05-2011 09:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010044</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-05-2011 14:17</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">26-05-2011 14:23</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010088</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">26-05-2011 15:29</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">27-05-2011 15:47</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010106</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-05-2011 13:30</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010109</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-06-2011 18:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-06-2011 18:18</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Note Added: 0010149</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-06-2011 18:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: es_20187301v040205m_CR_5809_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">29-06-2011 18:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">29-06-2011 18:26</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-06-2011 08:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Deleted: es_20187301v040205m_CR_5809_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-06-2011 08:48</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809_v2.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">30-06-2011 09:34</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010152</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">30-06-2011 16:31</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Assigned To</td>
<td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">01-07-2011 11:02</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">Note Added: 0010173</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">01-07-2011 11:09</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809_v3.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">04-07-2011 14:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">04-07-2011 14:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-07-2011 14:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; feedback</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-07-2011 14:38</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">fixed =&gt; reopened</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-07-2011 14:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Assigned To</td>
<td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-07-2011 14:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Status</td>
<td class="print">feedback =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">05-07-2011 14:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Resolution</td>
<td class="print">reopened =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">05-07-2011 14:39</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 4.3.2 (interim)</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-07-2011 06:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0010224</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">17-07-2011 06:19</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">File Added: es_20187301v040205m_CR_5809_v4.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">17-07-2011 07:03</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009804)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a>   </td>
</tr>
<tr class="odd">
<td class="print">24-11-2010 16:43   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Dear Andrus,<br />
<br />
I think the new rule could be described as:<br />
<br />
TemplateConcat ::= StringOp SingleValueOrAttrib<br />
<br />
because you have the TemplateConcat [optional] recursion through the
updated SingleValueOrAttrib rule.<br />
<br />
Anyway, I think this rule is not enough in order to provide full support
to clause 15.11.<br />
<br />
I would suggest to add the "Syntactical Structure", "Semantic
Description" and "Restrictions" sections in order to clarify the
operation usage.<br />
<br />
Regards,<br />
David (MTP)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009805)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-11-2010 11:54   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We have some additional comments on this.<br />
<br />
Reading the 15.11 clause, a "new" concept seems to be defined: "single
template". What's this? What's the syntax supported in this kind of
statement?<br />
I mean that a deep analysis should be performed in order to know what is
going to be supported for concatenating "single templates". Because
going through the actual TemplateBody rule will lead to provide
syntactic support to absolutely all TTCN-3 templates, including for
instance the "ifpresent" keyword (we can not rely this check in the
semantic side!) and, in addition to this, due to this rule:<br />
<br />
53. StringLength ::= LengthKeyword "(" SingleConstExpression [".."
UpperBound] ")"<br />
<br />
we are also supporting the use of ranges when specifying length
restrictions (and this is not supported according to 15.11
description).<br />
<br />
In conclusion, we suggest to:<br />
<br />
1- Clarify this standard clause through the "Syntactical Structure",
"Semantic Description" and "Restrictions" sections (Mantis CR - <a
href="http://t-ort.etsi.org/view.php?id=5809">http://t-ort.etsi.org/view.php?id=5809</a>
[<a href="http://t-ort.etsi.org/view.php?id=5809"
target="_blank">^</a>])<br />
2- To specify the BNF rules required for this new operation performed
over "single templates" expressions, once the 15.11 has been fully
defined.<br />
<br />
Best regards,<br />
David (MTP)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009806)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-11-2010 14:54   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">I think this issue is already resolved by the CR
5513.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009807)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-11-2010 16:05   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Dear Jacob,<br />
<br />
Thanks a lot for providing this info!<br />
<br />
After reviewing the proposed solution â€œCR5513_resolution v7.doc [^]
(91,648 bytes) 22-07-2010 11:58â€?, I think this issue is not fully
resolved, as far as:<br />
<br />
- It is still possible to specify length restrictions using ranges,
despite the clause remains stating â€œ constrained to a fixed
lengthâ€?.<br />
<br />
- Usage and restrictions on the outer template [ExtraMatchingAttributes]
mechanisms, if any, should be described â€“ I agree this could be
confusing to everybody â€“ not only the user. If no limitation is going
to be provided on this, samples are welcome. Let me please insist on
requesting for detailed information on this clause. I think it is
complex enough to provide the â€œusualâ€? sections we can see all along
the standard document (Syntactical Structure, Semantic Description and
Restrictions)<br />
<br />
Best regards,<br />
David (MTP)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009827)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-11-2010 13:09   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I agree with your point 1 and have amended a note to
CR5513 in that regard.<br />
<br />
But I don't know what restrictions in the ExtraMatchingAttributes you
are talking about? Please provide an example of what you want restricted
and why.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0009837)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=159">David
Diaz (MTP)</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-11-2010 10:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Hi Jacob,<br />
<br />
I don't want to add any restriction to the outer matching attribute. I
just ask for clarifications on the â€œusage (and restrictions, if any is
going to be considered)â€? of the ExtraMatchingAttributes when
concatenating templates.<br />
<br />
Example:<br />
The following statements are syntactically valid:<br />
<br />
template charstring t_Mycharstring := "ABC" &amp; * length(2) &amp;
"E?F" length(1..7); //is this valid?<br />
template charstring t_Mycharstring := "ABC" &amp; * length(2)
length(1..7); //is this valid?<br />
template charstring t_Mycharstring := "ABC" &amp; * length(2) &amp;
"E?F" ifpresent; //this is not valid<br />
<br />
template Mymessage MyTemplate:=<br />
{ :<br />
field2 := "ABC" &amp; * length(2) &amp; "E?F" ifpresent, //is this
valid?<br />
field3 := ? length(3) //according to the proposed BNF, which rule is
being applied?<br />
field4 := ? length(1..4)<br />
:<br />
}<br />
<br />
Additionally, according to the proposed BNF, which rule is being applied
for field3 and field4:<br />
<br />
the ( AnyValue [ LengthMatch ] ) | from rule 4. MatchingSymbol<br />
or the [ExtraMatchingAttributes] from rule 1. TemplateBody ?<br />
<br />
I think the first one is being applied, so this issue should be
considered in case of defining a different syntax when concatenating
templates, because â€œExtraMatchingAttributesâ€? allows the usage of
ranges, but this should not be the case when concatenating
templates.<br />
<br />
Regards,<br />
David (MTP)</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010031)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">24-05-2011 15:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Check the comment.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010044)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">25-05-2011 09:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">We should add a NOTE (not a restriction, as it is not
really restricting anything), saying that if a concatenation expression
in a TemplateBody ends with a AnyValue or AnyValueOrOmit followed by a
length restriction, this is supposed to be the WildcardLengthMatch
associated with the Wildcard. Other extra matching attributes apply to
the whole expression in the TemplateBody.<br />
<br />
Example:<br />
<br />
template hexstring x := 'f00'H &amp; ? length(0..3); // length(0..3)
applies to ?<br />
template hexstring x2 := 'f00'H &amp; ? length(0..3) length(3..6) //
length(0..3) applies to ?, length(3..6) applies to the whole
expression.<br />
<br />
template hexstring x3 := 'f00'H &amp; ? length(0..1) &amp; 'b*'H
length(0..20) // length(0..20) applies to the whole expression.<br />
<br />
To me this last example also seems kind of illogical, as the length
restriction could as easily be interpreted (naively) to be applicable to
'b*'H, thereby confusing the user. Maybe we should allow
WildcardLengthMatch also for other MatchingMechanisms that can be
concatenated (and could have variable length).<br />
<br />
This would lead to the situation that, if the user WANTS to restrict the
length of the whole template that does not end with a particle with a
length restriction, they would need to add a paranthesis around the
concatenation before appending the ExtraMatchingAttributes length
restriction.<br />
<br />
If that is a scenario we could live with, then we should remove this
confusing feature. It would be a backward compatible change in regard to
the situation before concatenation of templates was allowed. But, it
would not be backward compatible to 4.3.1.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010088)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">26-05-2011 14:23   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">I've aligned the examples to the text (only specific
values and (length restricted) wildcards and no OctetStringMatch etc.
are allowed) in 15.11.<br />
<br />
I've disallowed StringLength in ExtraMatchingAttributes when SimpleSpec
in TemplateBody is a concatenation expression as the length of any
concatenation is fix/known anyway (because of the fixed length of the
WildcardLengthMatch) and thus an extra StringLength would be
superfluous/redundant anyway.<br />
<br />
This resolves the syntactical ambiguity as any length appearing at the
end of a concatenation must then be WildcardLengthMatch.<br />
<br />
I also allowed SingleExpression (with static semantics type integer) in
WildcardLengthMatch instead of ConstantExpression as there is no such
restriction to a constant in the main text and there is an example using
a variable.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010106)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">27-05-2011 15:47   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">In case of binary strings why to disallow e.g. '*'B
when ? is allowed (and ? is then transformed back to '*' in the resulted
string)? They are equivalent, refering to exactly the same set of values
(all values allowed by the type).<br />
On the other hand, in the case<br />
type bitstring MyBit5 length (5);<br />
type bitstring MyBit;<br />
template MyBit5 c_bit5 := ?;<br />
template MyBit c_bit := '1'B &amp; c_bit5 &amp; '1'B;<br />
//what is the resulted template:<br />
// '1*1'B length(7) or '1*1'B ?</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010109)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-05-2011 13:30   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">&gt; In case of binary strings why to disallow e.g.
'*'B when ? is allowed (and ?<br />
&gt; is then transformed back to '*' in the resulted string)? They are
equivalent,<br />
&gt; refering to exactly the same set of values (all values allowed by
the type).<br />
<br />
I don't know. The text forbids it. I didn't write the text. I just
aligned the examples with the text.<br />
<br />
&gt; On the other hand, in the case<br />
&gt; type bitstring MyBit5 length (5);<br />
&gt; type bitstring MyBit;<br />
&gt; template MyBit5 c_bit5 := ?;<br />
&gt; template MyBit c_bit := '1'B &amp; c_bit5 &amp; '1'B;<br />
&gt; //what is the resulted template:<br />
&gt; // '1*1'B length(7) or '1*1'B ?<br />
<br />
I don't think this is allowed by the text either, as I understood it,
only specific values (i.e. string literals) and (possibly
fixed-length-restricted) wildcards are allowed. I quote:<br />
<br />
"The single templates of binary string and list types shall contain only
the matching mechanisms specific values, AnyValue or AnyValueOrNone
constrained to a fixed length, AnyElement, or AnyElementsOrNone possibly
constrained with a length attribute for list types"</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010149)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy
Rethy</a>   </td>
</tr>
<tr class="odd">
<td class="print">29-06-2011 18:18   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">1) By the '*'B vs. ? question I just meant that the
ext allows both but the example '*'B has been replaced by ?; by this is
not essential.<br />
2) Jacob wrote:<br />
"template hexstring x3 := 'f00'H &amp; ? length(0..1) &amp; 'b*'H
length(0..20) // length(0..20) applies to the whole expression.<br />
<br />
To me this last example also seems kind of illogical, as the length
restriction could as easily be interpreted (naively) to be applicable to
'b*'H, thereby confusing the user."<br />
<br />
I totally agree, I'm sure, this will be very confusing for the user. So
I propose to completely forbid ExtraMatchingAttribute after
concatenation, i.e. if the user wants to restrict the length of anything
produced by concatenation, ALWAYS force the use of parantheses,
independent of what is being concatenated.<br />
<br />
Pls. note, even the simple case<br />
'f00'H &amp; 'b'H length(0..2)<br />
is ambiguous, as length(0..2) may be understood as applied to the whole
concatenation (in which case will not match anything) or applied to 'b'H
only (in which case will match 'f00b'H).<br />
<br />
Pls. review changes in es_20187301v040205m_CR_5809_v2.doc</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010152)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">30-06-2011 09:34   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">&gt; 1) By the '*'B vs. ? question I just meant that
the ext allows both but the example '*'B has been replaced by ?; by this
is not essential.<br />
<br />
You're right, I overlooked AnyElementsOrNone. So the special case '*'O
length(X) is also allowed by the text.<br />
<br />
Otherwise, we seem to be in agreement on disallowing length constraint
on a concatenation expression.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010173)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob
Wieland - Spirent</a>   </td>
</tr>
<tr class="odd">
<td class="print">01-07-2011 11:02   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">Adding the optional "(" ")" in the BNF makes no sense
as they are already included in SingleExpression<br />
<br />
SingleExpression =&gt;* Primary =&gt; "(" SingleExpression ")"</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0010224)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">17-07-2011 06:19   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">Implemented with editorial changes, see v4</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
