  

<table class="width100" style="width:100%;" data-cellspacing="1">
<colgroup>
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
<col style="width: 16%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="6" class="form-title"><div class="center">
ETSI's Bug Tracker - Part 01: TTCN-3 Core Language
</div></td>
</tr>
<tr class="even">
<td colspan="6" class="form-title">View Issue Details</td>
</tr>
<tr class="odd">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="even print-category">
<td class="print" width="16%">ID</td>
<td class="print" width="16%">Project</td>
<td class="print" width="16%">Category</td>
<td class="print" width="16%">View Status</td>
<td class="print" width="16%">Date Submitted</td>
<td class="print" width="16%">Last Update</td>
</tr>
<tr class="odd print">
<td class="print">0002753</td>
<td class="print">Part 01: TTCN-3 Core Language</td>
<td class="print">Clarification</td>
<td class="print">public</td>
<td class="print">23-01-2008 08:45</td>
<td class="print">24-04-2008 12:01</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Reporter</td>
<td class="print">Thomas DeiÃŸ</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Assigned To</td>
<td class="print">Ina Schieferdecker</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Priority</td>
<td class="print">normal</td>
<td class="print-category">Severity</td>
<td class="print">minor</td>
<td class="print-category">Reproducibility</td>
<td class="print">have not tried</td>
</tr>
<tr class="even print">
<td class="print-category">Status</td>
<td class="print">closed</td>
<td class="print-category">Resolution</td>
<td class="print">fixed</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="odd print">
<td class="print-category">Platform</td>
<td class="print"></td>
<td class="print-category">OS</td>
<td class="print"></td>
<td class="print-category">OS Version</td>
<td class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Product Version</td>
<td class="print">v3.2.1 (published 2007-02)</td>
<td colspan="4" class="print"> </td>
</tr>
<tr class="odd">
<td class="print-category">Target Version</td>
<td class="print">v3.4.1 (published 2008-09)</td>
<td class="print-category">Fixed in Version</td>
<td class="print">v3.4.1 (published 2008-09)</td>
<td colspan="2" class="print"> </td>
</tr>
<tr class="even print">
<td class="print-category">Clause Reference(s)</td>
<td colspan="4" class="print">part 1, clause 12; part 4 clause 9.40</td>
<td></td>
</tr>
<tr class="odd print">
<td class="print-category">Source (company - Author)</td>
<td colspan="4" class="print">Thomas DeiÃŸ, Nokia Siemens Networks</td>
<td></td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd print">
<td class="print-category">Summary</td>
<td colspan="5" class="print">0002753: Clarification on timer
lifetime</td>
</tr>
<tr class="even print">
<td class="print-category">Description</td>
<td colspan="5" class="print">It is unclear whether a timer declared and
started in a scope unit such as e.g. a function does still exist after
the function is left.<br />
<br />
Clause 12 contains a note stating: "Visibility of timer names follow the
scoping rules given in clause 5. For example, the name of a timer
defined locally in a function can be seen within that function only,
though the timer is started on the component instance; on returning from
that function the specific timer cannot be stopped directly, but only
indirectly by an all timer.stop statement. Also, its timeout cannot be
checked directly, but only indirectly by an any timer.timeout
statement."<br />
<br />
This means that after executing the function f() as defined below<br />
<br />
function f() {<br />
  timer t := 5.0;<br />
  t.start;<br />
  return<br />
}<br />
<br />
the timer t would still be running and might cause a timeout in the
statement<br />
<br />
 any timer.timeout;<br />
<br />
So, even if the scope unit in which the timer was declared has ceased to
exist, the timer would still exist and might contribute to the test
case.<br />
<br />
The note exists in both 3.2.1 and 3.3.x.<br />
<br />
On the other hand, if one is reading part 4, i.e. the operational
semantics, this mentions quite explicitly that entering a new scope unit
and declaring a timer in this scope unit means to create a new
'timer-binding' on a stack of timer-bindings. Leaving the scope unit
means to destroy also this timer-binding, meaning that the timer ceases
to exist. This is mentioned several times, e.g. in the definition of the
semantics of the return statement (clause 9.40 of part4).<br />
<br />
This means that there is a contradiction between parts 1 and 4.<br />
<br />
Proposed solution: remove the note completely or change it to:<br />
"Timers declared and started in scope units such as functions cease to
exist when the scope unit is left. They do not contribute to the
behaviour once the scope unit is left."<br />
<br />
</td>
</tr>
<tr class="odd print">
<td class="print-category">Steps To Reproduce</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="even print">
<td class="print-category">Additional Information</td>
<td colspan="5" class="print">Originally, the issue has been found by
Wolfgang Seka.</td>
</tr>
<tr class="odd print">
<td class="print-category">Tags</td>
<td colspan="5" class="print">No tags attached.</td>
</tr>
<tr class="even print">
<td class="print-category">Relationships</td>
<td colspan="5" class="print"></td>
</tr>
<tr class="odd print">
<td class="print-category">Attached Files</td>
<td colspan="5" class="print"><img
src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif"
alt="doc" /> CR-2753-Clarification-on-timer-lifetime.doc (124,928) <span
class="italic">23-04-2008 15:51</span><br />
http://oldforge.etsi.org/mantis/file_download.php?file_id=1441&amp;type=bug</td>
</tr>
<tr class="even">
<td colspan="6" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="form-title">Issue History</td>
<td></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr class="even print-category">
<td class="row-category-history">Date Modified</td>
<td class="row-category-history">Username</td>
<td class="row-category-history">Field</td>
<td class="row-category-history">Change</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-01-2008 08:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">New Issue</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-01-2008 08:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Status</td>
<td class="print">new =&gt; assigned</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-01-2008 08:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Assigned To</td>
<td class="print">=&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-01-2008 08:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Clause Reference(s)</td>
<td class="print">=&gt; part 1, clause 12; part 4 clause 9.40</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-01-2008 08:45</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Source (company - Author)</td>
<td class="print">=&gt; Thomas DeiÃŸ, Nokia Siemens Networks</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">12-03-2008 13:59</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Note Added: 0005207</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-04-2008 11:20</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Target Version</td>
<td class="print">=&gt; Edition 3.4.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-04-2008 15:43</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Ina Schieferdecker =&gt; Jens Grabowski</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-04-2008 15:51</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">File Added:
CR-2753-Clarification-on-timer-lifetime.doc</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-04-2008 15:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Note Added: 0005522</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-04-2008 15:52</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a></td>
<td class="print">Assigned To</td>
<td class="print">Jens Grabowski =&gt; Thomas DeiÃŸ</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-04-2008 16:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Note Added: 0005528</td>
<td class="print"></td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-04-2008 16:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Assigned To</td>
<td class="print">Thomas DeiÃŸ =&gt; Ina Schieferdecker</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">23-04-2008 16:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Status</td>
<td class="print">assigned =&gt; resolved</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">23-04-2008 16:12</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a></td>
<td class="print">Resolution</td>
<td class="print">open =&gt; fixed</td>
<td></td>
<td></td>
</tr>
<tr class="even print">
<td class="print">24-04-2008 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Status</td>
<td class="print">resolved =&gt; closed</td>
<td></td>
<td></td>
</tr>
<tr class="odd print">
<td class="print">24-04-2008 12:01</td>
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a></td>
<td class="print">Fixed in Version</td>
<td class="print">=&gt; Edition 3.4.1 (not yet published)</td>
<td></td>
<td></td>
</tr>
</tbody>
</table>

  

<table class="width100" data-cellspacing="1">
<colgroup>
<col style="width: 50%" />
<col style="width: 50%" />
</colgroup>
<tbody>
<tr class="odd">
<td colspan="2" class="form-title">Notes</td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0005207)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina
Schieferdecker</a>   </td>
</tr>
<tr class="odd">
<td class="print">12-03-2008 13:59   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">This note made it into v3.2.1 as result of reviewing
the draft by ETSI members. We have not been careful when accepting the
change: it is in conflict with the current part 4 semantics and with
clause 23.1 in part 1.<br />
<br />
It relates to CR 2151.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0005522)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens
Grabowski</a>   </td>
</tr>
<tr class="odd">
<td class="print">23-04-2008 15:52   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">The attached file implements the proposal of the
CR.</td>
</tr>
</tbody>
</table></td>
</tr>
<tr class="even">
<td colspan="2" class="print-spacer"><hr /></td>
</tr>
<tr class="odd">
<td class="nopad" data-valign="top" width="20%"><table class="hide"
data-cellspacing="1">
<tbody>
<tr class="odd">
<td class="print">(0005528)</td>
</tr>
<tr class="even">
<td class="print"><a
href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas
DeiÃŸ</a>   </td>
</tr>
<tr class="odd">
<td class="print">23-04-2008 16:12   </td>
</tr>
</tbody>
</table></td>
<td class="nopad" data-valign="top" width="85%"><table class="hide"
data-cellspacing="1">
<colgroup>
<col style="width: 100%" />
</colgroup>
<tbody>
<tr class="odd">
<td class="print">STF 349, Thomas.<br />
Proposal checked: ok.</td>
</tr>
</tbody>
</table></td>
</tr>
</tbody>
</table>
