# How to make a change request?

## Purpose

This document describes how to make a change request for the TTCN-3 standard.
Change requests are the basis for managing changes and tracking discussions on
the standard.

When this procedure is followed correctly:
- Change requests will contain all the necessary information.
- Change requests will be actionable.
- Discussions, progress and decisions on the change request will be tracked.

When this procedure is not followed:
- Change requests may be incomplete or unclear.
- Duplicate change requests may be created.
- Change requests might be rejected due to lack of information.


## Procedure

**Inputs:**
- An EOL or an individual account.

**Steps:**

1. **[Sign in](https://labs.etsi.org/rep/users/sign_in)**: Use your EOL account
   (same credentials as in the ETSI portal) or individual account to sign in.

2. **Assure your request have not been made before:** Navigate to our [issue
   tracker](https://labs.etsi.org/rep/mts/ttcn3/standard/-/issues/?sort=created_date&state=all&first_page_size=20#)
   and search for issues that match to your request. Make sure you search for all
   issues, not only the open ones. 
   If your request has already been made, you can add a comment to the existing.

3. **Open issue form**: After you made sure, that your request have not been
   made before, open the issue form by clicking on ["New
   issue"](https://labs.etsi.org/rep/mts/ttcn3/standard/-/issues/new).

4. **Add title**: Choose a title that describes your change request concisely.
   Some good exampleis: "Proposal: Add Rust interface", "Typo in section
   3.2.1", "Clarify the definition of 'foo'", ...

5. **Choose a description template**": Choose a template from the dropdown box
   that fits your change request most. ![issue
   templates](assets/issue-templates.png) The templates will help you to
   provide the necessary information and to structure your request efficiently.  
   You may add or remove parts of the template as needed.

6. **Fill in the details**": Describe your change request. GitLab specific
   fields like "Assignee", "Milestone", "Labels" can be left empty.  
   If you have related or similar change requests, it is good practice to link
   them in the description.

7. **Add attachements**: If you have additional files, like a document or
   images that describe the change request in detail, you can attach it to the
   issue.


**Outputs:**
- An issue describing your change request is created.


## FAQs

**Where do I get an account?** 
If you represent an ETSI member or ISG/SDG Participant organization, you can
request your EOL [here](https://webapp.etsi.org/createaccount/). 
If you don't represent any organization, you can create an Individual Account
with your personal email address [here](https://labs.etsi.org/signup/).

**Which description template should I choose for my change request?** 
Following templates are available:  
The _Editorial Changes_ template is used for changes that do not affect
meaning of the standard. For example, fixing typos, grammar, or formatting.
_Clarification Needed_ is used when the standard is unclear or ambiguous. For
example, if a term is not defined, or if an enumeration is missing a value and
it is unclear if this is on purpose.  
Create a _Bug Report_ if the standard does not specify TTCN-3 as intended. For
example, if two specifications contradict each other, or if an example does not
reflect defined behavior.  
A _Feature proposal_ is used to suggest new features, interfaces, documents
or changes to existing ones.  
You do not need to provide a full specification document, yet. It is practice
to discuss the proposal first and create the document when the proposal is
accepted and all details are clear.
