# How to write a Standard Operating Procedure

## Purpose

This SOP outlines the process for creating a clear, actionable, and efficient
Standard Operating Procedure (SOP) that can be easily followed, maintained, and
improved by team members.

When followed correctly:
- SOPs will streamline tasks and ensure consistency across operations.
- SOPs will be easy to follow, concise, and actionable, leading to increased
  efficiency.

When not followed:
- SOPs will become too lengthy, complex, or unclear, leading to confusion or
  inefficiency.
- Team members may avoid using the SOP, resulting in inconsistent processes and
  inefficient on-boarding.

## Procedure

**Inputs:**
- Write access to this repository
- SOP template at the end of this document
- Optional:
 - Subject Matter Expert (SME) to define the procedure details
 - SOP Owner to write, implement, and maintain the SOP. SME and owner may be
   the same person.


1. **Choose the topic**: Select a topic starting with "How to" (e.g., "How to
   invoice a client"). Ensure the process is one that will add value and be
   frequently used by the team.

2. **Create document**: Create a new document in the `docs/` folder using the
   SOP topic as file name. Use lowercase letters, replace spaces with hyphens
   and append a `.md` extension. For example,
   `how-to-write-a-standard-operating-procedure.md`. You may create the
   document locally and push it to the repository via Git, or edit it your
   browser on GitLab by pressing the "+"-Button. You have to be signed in to do
   so. 
   Copy the SOP template at the end of this document into the new file.

3. **Capture key steps**: Identify the first and the last step for the SOP and
   then break it down into mini-results or actionable steps. Each step should
   be concise and focused on a specific task. Do not include more than 8 steps,
   split big SOPs into smaller ones.

4. **Define purpose, inputs, outputs and clarify details:**
   - **Purpose:** Describe the goal of the SOP (e.g., "Effectively invoice
     clients").
   - **Inputs:** List the resources needed (e.g., software, templates).
   - **Outputs:** Describe the tangible results (e.g., "A client invoice is
     sent")

5. **Fill in step-details and FAQs**: Provide clear descriptions for each step
   and answer any common questions in the FAQ section to prevent
   misunderstandings.

6. **Proofread and finalize**: Review the SOP for clarity, accuracy, and
   completeness. Ensure that the steps are in the correct order and that the
   document is easy to follow.

7. **Commit document**: Commit the document to the repository. If you created
   the document locally, push it to the repository. If you created it in the
   browser, press the "Commit changes" button.

8. **Use and Improve**: Share the SOP with the team, ask them to follow it,
   gather feedback, and adjust based on team suggestions. Regularly review the
   SOP to keep it relevant and efficient.


**Outputs:**
- A clear and concise SOP document that team members can use to execute tasks consistently.
- Updated procedures based on continuous improvement feedback.


## FAQs

**What if a step changes?**  
Update the SOP immediately and document the change using version history.


## Template

Copy this template into your file and fill in the details:

```
# How to ...

## Purpose

What is the purpose of this SOP?

When this procedure is followed correctly:
-
-

When this procedure is not followed:
-
-

## Procedure

**Inputs:**
-
-




1. <Write a 3- to 10-word description of this mini result>  
   Description of how to achieve this mini result.

2. <Write a 3- to 10-word description of this mini result>  
   Description of how to achieve this mini result.

...


**Outputs:**
-
-


## FAQs

**This is a question?**  
This is an answer.

```
