# How to process a change request

## Purpose

This SOP outlines the process for handling change requests using GitLab. GitLab
supports a wide range of different workflows. This makes it easy to get lost in
the many planning features and provided tools.

This SOP aims to provide a minimal and
[Kanban-like](https://en.wikipedia.org/wiki/Kanban_(development)) process,
which can be extended and customized once the team is comfortable with the
basics.

When followed correctly:
- Migration from Mantis to GitLab will be smooth and efficient.
- Frustration about the new tool will be minimized.
- You will have a clear understanding of what has been done and what needs to
  be done.

When not followed:
- Inconsistencies in the process may lead to confusion and overwhelm.

## Procedure

**Inputs:**
- You are signed in to GitLab
- You have write access to the project

**Steps**

0. **Open the [developer
   board.](https://labs.etsi.org/rep/mts/ttcn3/standard/-/boards):** You will
   see columns for new issues, planned issues, issues in progress, issues ready
   for review, issues done, and closed issues. Columns can be minimized to save
   space using the arrow in the top right corner of the column.

1. **New issues:** All open issues that do not belong to one of the other
   list appear here. If you want to work an issue:
   - assign it to yourself by adding your name in the assignee field on the right
   - move it to the To-Do column by dragging it to the right

2. **Planned issues:** In this column you'll find all issues that are planned
   to be worked on, but not started yet.
   If you want to start working on an issue:
   - assign it to yourself, if not already done
   - move it to the work in progress (WIP) column by dragging it to the right

3. **Issues in progress:** This column contains all issues that are currently
   being worked on. If you are working on an issue, make sure to move it to this
   column. If you are done with the issue:
   1. move it to the review column by dragging it to the right.
   2. remove yourself as the assignee.
   3. add at least one reviewer by assigning the issue to them.

4. **Issues ready for review:** This column contains all issues that are ready
   for review. If you are a reviewer assign the issue to yourself. You may add
   questions or comments to the issue comment section. If you are done
   reviewing move the issue either to the "Done" column or back to the To-Do if
   column if further refinement is needed.

5. **Issues done:** This column contains all issues that are done, but still
   open. The team lead closes the issue by clicking on the "Close issue"
   button.  
   When you close an issue, it is good practice to assign a resolve-label and
   a short rationale, if possible. This serves as helpful documentation for
   future reference. Following labels are available:
   - **Fixed**: The issue was implemented as suggested. Most change requests
     will have this label. Additional comments are usually not required.
   - **Duplicate**: If an issue is a duplicate of another request use this
     label. Also reference the original issue. This makes it easier to navigate
     changes.
   - Use the **Won't Fix** label for requests that were rejected. If possible
     add a short rationale why the request was rejected, or reference a
     decision record. Such documentation becomes valuable, should a request
     re-opened. For example as is was with the shorthand assignments (`i++`).
   - The label **By Design** is used to clarify that the standard is correct
     and the issue is not a bug. For example, someone could create a bug-report
     that inout-parameters should not require strong-typing, but this is by
     design. It avoid issues with references to unions.

6. **Closed issues:**
   Issues that are reviewed and do not need further refinement are moved to the "Done" column

7. **Use and improve:** An important part of the process is to continuously
   improve the process and refine it where necessary. If you have suggestions
   for improvements, please share them.

**Outputs:**
- You will understand the purpose of the developer board and its columns
- You will know how to change the status or assigmnent of an issue
