<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:21 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008155: Issue with the number of elements of templates - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008155</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">12-12-2022 14:20</td><td class="print">15-01-2024 12:22</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">n/a</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia - Matthias Simon</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008155: Issue with the number of elements of templates</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">How do I get the number of elements of a string or list?<br />
For example of a hexstring template:<br />
<br />
&#160;&#160;&#160;&#160;template hexstring s := '1*F'H<br />
&#160;&#160;&#160;&#160;for (var integer i := 0; i&lt;lengthof(s); i := i + 1) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(s[i]);<br />
&#160;&#160;&#160;&#160;}<br />
<br />
I would expect the number of elements in this template would be 3 (as suggested by clause 15.6.1). However lengthof produces a (justified) runtime error and sizeof is deprecated.<br />
<br />
Is there a mechanism for retrieving the number of elements in a string or list in TTCN-3 or do we need a new predefined function?</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">12-12-2022 14:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2022 13:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016442</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2022 13:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">20-12-2022 13:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">20-12-2022 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016443</td><td class="print"></td></tr><tr class="print"><td class="print">07-11-2023 16:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">07-11-2023 16:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016541</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 10:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016544</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 23:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Added: 0016558</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 23:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Added: 0016559</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 23:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Deleted: 0016559</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 23:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Edited: 0016558</td><td class="print">bug_revision_view_page.php?bugnote_id=16558#r623</td></tr><tr class="print"><td class="print">10-11-2023 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016571</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2023 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">10-11-2023 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">10-11-2023 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">15-01-2024 12:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016591</td><td class="print"></td></tr><tr class="print"><td class="print">15-01-2024 12:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016442)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-12-2022 13:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Has to be studied. Cannot be resolved for the next version. To be shifted into 2023.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016443)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-12-2022 13:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: lenghtof function needs to be revised.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016541)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-11-2023 16:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Resolution will be based on an optional parameter.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016544)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2023 10:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We should reconsider our resolution, because a new proposal has come up (method-syntax).<br />
<br />
Following options are available for discussion (only the first 3 are relevant in my opinion):<br />
<br />
1. Optional Parameter<br />
&#160;&#160;&#160;Example: lengthof({1,*,5}, true) // true uses new lengthof behaviour<br />
&#160;&#160;&#160;+ Backwards compatible<br />
&#160;&#160;&#160;- Surprising users can get surprising runtime errors, because behavior is aligned with length-constraint-assignment-rules<br />
&#160;&#160;&#160;- Clumsy design (but seldom used, most users won't notice)<br />
<br />
2. Just Change Behavior<br />
&#160;&#160;&#160;Example: lengthof({1,*,5}) // returns 3<br />
&#160;&#160;&#160;+ Expected behavior aligned with index-access-rules<br />
&#160;&#160;&#160;+ easy to understand, good design<br />
&#160;&#160;&#160;- Backwards incompatible (but only for rare corner cases, for fix an easy fix is available)<br />
<br />
3. Method Syntax:<br />
&#160;&#160;&#160;Example: {1,*,5}.lengthof()<br />
&#160;&#160;&#160;+ Does not pollute existing namespaces<br />
&#160;&#160;&#160;+ Easy to understand<br />
&#160;&#160;&#160;- Method syntax is not very common in TTCN-3<br />
&#160;&#160;&#160;- Grammar needs restructuring<br />
&#160;&#160;&#160;- two different lengthof functionalities is confusing<br />
<br />
4. New Syntax:<br />
&#160;&#160;&#160;Random Example: lengthof @lastindex ({1,*,5})<br />
&#160;&#160;&#160;+ Backwards compatible<br />
&#160;&#160;&#160;+ Could be easy to understand, <br />
&#160;&#160;&#160;+ New syntax could unlock other features (e.g. a[lengthof] := 23)<br />
&#160;&#160;&#160;- New syntax increases language complexity<br />
&#160;&#160;&#160;- We have no proposal how such syntax could look like<br />
<br />
4. New Function:<br />
&#160;&#160;&#160;Example: lastindex({1,*,3})<br />
&#160;&#160;&#160;+ Easy to understand, no confusion about different lengthof behaviors<br />
&#160;&#160;&#160;+ Could unlock other features by circumventing making lengthof issue<br />
&#160;&#160;&#160;- Backwards incompatible, due to new keywords<br />
<br />
5. Using length<br />
&#160;&#160;&#160;Example: length({1,*,3})<br />
&#160;&#160;&#160;+ Backwards compatible<br />
&#160;&#160;&#160;+ Could reduce keywords by making lengthof superfluous<br />
&#160;&#160;&#160;- Having two different length functions is confusing			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016558)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2023 23:48&#160;&#160;&#160;
				<br />(edited on:&#32;08-11-2023 23:50)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Ericsson can accept backward incompability, so the lengthof() function can be extended (without adding an extra optional parameter) to reach the desired behaviour also for templates instead of resulting in a run-time error.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016571)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-11-2023 08:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Summary:<br />
A deeper investigation is required, because the situation is unclear.<br />
There seem to be contradictions between the lengthof-spec and its examples; also between binary-string values/templates and indexing rules, ...<br />
<br />
A new CR for this topic will be created.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016591)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-01-2024 12:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				No action required at the moment.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
