<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:15 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008153: Extend usage of break and continue statements - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008153</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">11-12-2022 19:21</td><td class="print">16-12-2024 10:26</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">resolved</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">19.2, 19.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia - Matthias Simon</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008153: Extend usage of break and continue statements</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">* Allow break statements in select statements.<br />
* Allow optional label to break/continue from nested loops</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8153.docx (114,777) <span class="italic">11-12-2022 20:07</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4093&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">11-12-2022 19:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 20:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Summary</td><td class="print">Add optional label to break and continue =&gt; Extend usage of break and continue statements</td></tr><tr class="print"><td class="print">11-12-2022 20:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Description Updated</td><td class="print">bug_revision_view_page.php?rev_id=607#r607</td></tr><tr class="print"><td class="print">11-12-2022 20:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">File Added: CR8153.docx</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2022 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016441</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2022 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">20-12-2022 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">07-11-2023 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016542</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2023 21:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Added: 0016570</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2023 12:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a></td><td class="print">Note Added: 0016581</td><td class="print"></td></tr><tr class="print"><td class="print">26-01-2024 16:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a></td><td class="print">Note Added: 0016608</td><td class="print"></td></tr><tr class="print"><td class="print">21-11-2024 18:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016700</td><td class="print"></td></tr><tr class="print"><td class="print">21-11-2024 18:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016700</td><td class="print">bug_revision_view_page.php?bugnote_id=16700#r625</td></tr><tr class="print"><td class="print">16-12-2024 10:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016718</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2024 10:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">16-12-2024 10:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016441)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-12-2022 12:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Additional idea: Add label to loop header.<br />
<br />
TTF discussion: To be discussed in the scope of the next TTF. Proposal cannot be implemented as proposed for select case statement. It would lead to a backwards incompatible change.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016542)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-11-2023 17:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Break and Continue shall be analysed in the scope of the major release. Additional ideas include the deprecation of Goto as well as introduction of breaks/continue across several scope units.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016570)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2023 21:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				After diiscussions within TTF:<br />
<br />
Possible solution can be &quot;named cycles&quot;<br />
while (...) {<br />
&#160;&#160;&#160;while (...){<br />
&#160;&#160;&#160;&#160;&#160;&#160;break w1;  //or continue w1;<br />
&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;} : w1<br />
<br />
break w1; will terminate both cycles, execution continues with the next instruction after w1.<br />
continue w1; will terminate the innermost cycle and takes the next iteration of the &quot;w1&quot; cycle.<br />
<br />
Similar construct can be applied for nested alt instructions with break/repeat &quot;named alt&quot;).<br />
<br />
alt {<br />
&#160;&#160;[] ...{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;alt {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[] ... {break a1;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;[] ....<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
}: a1;<br />
<br />
&quot;altlabels&quot; and &quot;cyclelabels&quot; can be mixed, until they do not &quot;jump&quot; out of the scope.<br />
<br />
alt {<br />
[] ... { while (...) { break a2;}}<br />
...<br />
}: a2  <br />
<br />
If this construct is implemented it may cause to deprecate the goto/label.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016581)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=783">Gusztáv Adamis</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-11-2023 12:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The resolution of the ticket shall be postponed to the next major revision.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016608)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-01-2024 16:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It seems to be another flavour of &quot;goto&quot;, so we do not see the benefit. On the other hand, it is increasing the complexity of the language allowing further flavours of code writing. Also, we are not aware that code cannot be written using existing means.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016700)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				21-11-2024 18:33&#160;&#160;&#160;
				<br />(edited on:&#32;21-11-2024 18:37)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think you are right. A goto to break a loop is perfectly fine, even for Dijkstra's standards.<br />
<br />
However, breaking out of loops without using any kind of goto is possible, but cumbersome and inefficient. For example compare this linear search algorithm.<br />
<br />
// Using goto<br />
var integer x,y,z;<br />
for (x := 0; x &lt; width; x++) {<br />
&#160;&#160;&#160;&#160;for (y := 0; y &lt; height; y++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (z := 0; z &lt; depth; z++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (space[x][y][z] == RedDwarf) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;goto end;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
}<br />
label end;<br />
log(&quot;found red dwarf at coords&quot;, x,y,z) <br />
<br />
// Using named loops<br />
var integer x,y,z;<br />
L1:<br />
for (x := 0; x &lt; width; x++) {<br />
&#160;&#160;&#160;&#160;for (y := 0; y &lt; height; y++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (z := 0; z &lt; depth; z++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (space[x][y][z] == RedDwarf) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;break L1;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
}<br />
log(&quot;found red dwarf at coords&quot;, x,y,z)<br />
<br />
// Without Goto using booleans<br />
var integer x,y,z;<br />
var boolean found;<br />
for (x := 0; x &lt; width &amp;&amp; not found; x++) {<br />
&#160;&#160;&#160;&#160;for (y := 0; y &lt; height &amp;&amp; not found; y++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (z := 0; z &lt; depth &amp;&amp; not found; z++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (space[x][y][z] == RedDwarf) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;found := true;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
}<br />
log(&quot;found red dwarf at coords&quot;, x-1,y-1,z-1)<br />
<br />
<br />
// Without Goto using functions<br />
var integer x, y, z;<br />
searchSpaceXYZ(space, x, y, z);<br />
log(&quot;found red dwarf at coords:, x, y, z);<br />
<br />
function searchSpaceXYZ(record of record of record of Obj space, inout integer x, inout integer y, inout integer z) boolean {<br />
&#160;&#160;&#160;&#160;for (x := 0; x &lt; lengthof(space); x++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (searchSpaceYZ(space, x, y, z)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return true;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;return false;<br />
}<br />
<br />
function searchSpaceYZ(record of record of record of Obj space, inout integer x, inout integer y, inout integer z) boolean {<br />
&#160;&#160;&#160;&#160;for (y := 0; y &lt; lengthof(space[x]); y++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (searchSpaceZ(space, x, y, z)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return true;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;return false;<br />
}<br />
<br />
function searchSpaceZ(record of record of record of Obj space, inout integer x, inout integer y, inout integer z) boolean {<br />
&#160;&#160;&#160;&#160;for (z := 0; z &lt; lengthof(space[x][y]); z++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (space[x][y][z] == RedDwarf) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return true;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;return false;<br />
}<br />
<br />
<br />
If I had to rate existing means for readability and code-quality I'd say:<br />
1. Goto <br />
2. Named-loop<br />
3. Boolean-loop<br />
4. Function-loop<br />
<br />
Place 2 and 3 are very close, because for simple loops boolean-loops are easier to comprehend. But they can become very ugly and inefficient very fast.<br />
<br />
After reviewing available options, I personally would stick with the goto.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016718)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-12-2024 10:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Discussion will be continued in Gitlab.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
