<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:18 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008098: Mandatory module prefix for imported module defintitions - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008098</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">09-08-2022 13:27</td><td class="print">26-01-2024 16:30</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">8.2.3.1 -- General format of import</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia - Matthias Simon</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008098: Mandatory module prefix for imported module defintitions</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">SUMMARY<br />
<br />
Make the module prefix mandatory for imported module definitions, to improve TTCN-3 readability.<br />
<br />
<br />
DESCRIPTION<br />
<br />
Module definitions usually have some kind of module-prefix or suffix in their name to communicate their ownership/domain (similar to C).<br />
Here's one example from an ETSI SIP module:<br />
<br />
&#160;&#160;&#160;&#160;module LibSip_Interface {<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record Address4SIP ...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;signature s_SIP_conversation ...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type port SipPort ...<br />
&#160;&#160;&#160;&#160;type port OperatorPort ...<br />
<br />
<br />
There are some issues which make this module harder to use and harder to comprehend:<br />
<br />
* Names are difficult to remember, because of inconsistent naming schemes.<br />
* Cumbersome and long disambiguation (`LibSip_Interface.s_SIP_conversation`).<br />
* Missing/optional module names make it difficult to find the owning module of a definition (e.g. `OperatorPort`).<br />
<br />
Looking at languages like Go or C++, there's a better way to name things: Encourage (or enforce) developers to drop the custom prefixes/suffixes and consistently use the full qualified name of imported module definitions:<br />
<br />
&#160;&#160;&#160;&#160;module SIP {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record Address ...<br />
&#160;&#160;&#160;&#160;signature s_conversation ...<br />
&#160;&#160;&#160;&#160;type port Port ...<br />
&#160;&#160;&#160;&#160;type port OperatorPort ...<br />
<br />
The usage of module definitions would be easier to understand: `SIP.s_conversation` vs. `LibSip_Interface.s_SIP_conversation`, `SIP.OperatorPort` vs `OperatorPort`.<br />
<br />
<br />
PROPOSAL<br />
<br />
Make the module prefix mandatory for referencing imported module definitions.<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">09-08-2022 13:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016222</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 13:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">17-08-2022 08:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-08-2022 08:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">17-08-2022 08:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">17-08-2022 08:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">26-01-2024 16:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a></td><td class="print">Note Added: 0016613</td><td class="print"></td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016222)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2022 13:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Not backwards compatible.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016613)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-01-2024 16:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The proposal is not backward compatible and would cause us(TF160) to change everything (all function calls would need a module prefix)! <br />
In general naming conventions shall be project-specific with project specific tools checking them.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
