<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:30 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008070: If-else statements with initializers - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008070</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">06-12-2021 16:01</td><td class="print">03-01-2023 11:50</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">19.2 The If-else statement</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Matthias Simon - Nokia</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008070: If-else statements with initializers</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">SUMMARY<br />
<br />
Allow initializers in conditional statements, similar to for loops: if (init-statement; condition). This statement simplifies common code patterns and helps developers keep scopes tight.<br />
<br />
<br />
MOTIVATION<br />
<br />
In many cases we check a return value and perform conditional operations on this value. TTCN-3 code looks like this usually:<br />
<br />
&#160;&#160;&#160;&#160;type record of charstring Users<br />
&#160;&#160;&#160;&#160;var Users ret := getUsers()<br />
&#160;&#160;&#160;&#160;if (lengthof(ret) &gt; 0) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// do something with &quot;users&quot;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
There are two issues, because the variable &quot;ret&quot; leaks into surrounding scope:<br />
<br />
1) You must take extra care not to access variables outside intended scope:<br />
<br />
&#160;&#160;&#160;&#160;type record of charstring Users<br />
&#160;&#160;&#160;&#160;var Users ret := getUsers()<br />
&#160;&#160;&#160;&#160;if (lengthof(ret) &gt; 0) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// do something with &quot;users&quot;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;var Users users = ret;<br />
&#160;&#160;&#160;&#160;log(users[0]) // ERROR: index out of bounds, or worse.<br />
<br />
<br />
2) You cannot reuse variable &quot;ret&quot; with different types in the same scope anymore:<br />
<br />
&#160;&#160;&#160;&#160;var Users ret := getUsers()<br />
&#160;&#160;&#160;&#160;if (lengthof(ret) &gt; 0) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;var float ret := rnd() // ERROR: &quot;ret&quot; already defined.<br />
&#160;&#160;&#160;&#160;if (ret &gt; 0.5) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
PROPOSAL<br />
<br />
**Semantic Description**<br />
<br />
&#160;&#160;&#160;&#160;if &quot;(&quot; [ VarInstance &quot;;&quot;] BooleanExpression &quot;)&quot; StatementBlock<br />
<br />
The branching of the control flow is decided upon the value of the Boolean expressions - the condition. A statement<br />
block - and only one - will be executed, if its condition evaluates to true.<br />
<br />
An optional variable (or constant) can be declared and initialized before being used in the if statement. The scope of the variable is limited to the statement block, i.e. it is only visible inside the statement block.<br />
<br />
<br />
**Examples**<br />
<br />
&#160;&#160;&#160;&#160;// Example 1: improved getUsers<br />
&#160;&#160;&#160;&#160;type record of charstring Users<br />
&#160;&#160;&#160;&#160;if (var Users ret := getUsers(); lengthof(ret) &gt; 0 ) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// do something with &quot;users&quot;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Example 2: else-if statements<br />
&#160;&#160;&#160;&#160;if (var charstring ret := hostname(); ret == &quot;localhost&quot;) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// do something with ret (charstring)<br />
&#160;&#160;&#160;&#160;} else if (var float ret := rnd(); rnd &gt; 0.4) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// do something with ret (float)<br />
&#160;&#160;&#160;&#160;} else {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// &quot;ret&quot; variable is not accessible in this scope<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
OPEN QUESTIONS<br />
<br />
Should we allow initializers in switch-statements as well?<br />
<br />
&#160;&#160;&#160;&#160;switch (var Person p := createPerson(); p.Name)<br />
&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;case (&quot;Alice&quot;) {  /* ... */ }<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;case (&quot;Bob&quot;) {  /* ... */ }<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;case else { /* ... */ }<br />
&#160;&#160;&#160;&#160;}<br />
<br />
What are the scopes of variable &quot;p&quot;.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8070.docx (118,037) <span class="italic">11-12-2022 12:26</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4092&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">06-12-2021 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2021 09:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0016146</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 14:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">17-08-2022 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">17-08-2022 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">17-08-2022 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016235</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">File Added: CR8070.docx</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016376</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">11-12-2022 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">12-12-2022 12:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016383</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 12:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">12-12-2022 12:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">12-12-2022 12:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">03-01-2023 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016446</td><td class="print"></td></tr><tr class="print"><td class="print">03-01-2023 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016146)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2021 09:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I support this proposal. It could be a number of declarations, too.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016235)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2022 11:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF dicussion: Scope of variables needs to be studied. If we go for this approach, variables may be added to all constructs that define their own scope unit.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016376)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-12-2022 12:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The first version of the resolution uploaded. Please check and let me know what should be changed or added. 			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016383)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2022 12:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The solution files looks correct.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016446)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-01-2023 11:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
