<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:55 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007893: Allow use of non-deterministic functions in alt-statement header - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007893</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">24-01-2020 11:25</td><td class="print">16-12-2020 14:55</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">4.12.1 (published 2020-05)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">4.13.1 (ongoing)</td><td class="print-category">Fixed in Version</td><td class="print">4.13.1 (ongoing)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">20.2.</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Spirent - Jacob Wieland </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007893: Allow use of non-deterministic functions in alt-statement header</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">At the moment, inside alt-statements, no function can be invoked that is non-deterministic to preserve the alt-statement-snapshot semantics. <br />
<br />
However, it would sometimes be convenient to allow initialization of local alt-variables by use of nondeterministic (especially time-related) functions.<br />
As an alt-statement is needs to enter the snapshot-semantic only before the evaluation of alternatives, this would not violate the snapshot-semantic.<br />
<br />
The evaluation would be: <br />
1) Initialization of local-alt-variables<br />
2) Enter snapshot<br />
3) Evaluate alternatives<br />
4) Leave snapshot<br />
<br />
If the alt-statement is re-evaluated (either because of repeat or because no alternative was chosen), the whole process would be repeated, i.e. the local-alt-variables are re-initialized for every alt-cycle.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5">Consider the following use case:<br />
<br />
We have messages that contain a timestamp in the form of a date-string.<br />
<br />
type charstring UTCTimestamp;<br />
<br />
And we have a functions<br />
<br />
external function f_currentTime() return integer;<br />
function f_convertToTimeMillis(UTCTimestamp p_timestamp) return integer { ... }<br />
<br />
And a template (advanced matching)<br />
<br />
template UTCTimestamp isCloseTo(integer timeMillis, int tolerance) := @dynamic {<br />
&#160;&#160;return Math.abs(f_convertToTimeMillis(value) - timeMillis) &lt;= tolerance<br />
}<br />
<br />
Now, we want to check whether the field of a message is close to a timestamp that is determined shortly before awaiting/expecting the message.<br />
<br />
alt {<br />
&#160;&#160;var integer currentTime := f_getCurrentTime();<br />
[] p.receive(Message:{ ..., ts := isCloseTo(currentTime, 10) }) { ... }<br />
...<br />
}<br />
<br />
<br />
<br />
</td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">This feature is especially useful if the alt-statement uses repeat statements (otherwise, the assignments could simply be placed before the alt-statement).<br />
<br />
This feature would only be allowed for top-level alt-statements, not for altstep definitions. Alternatively, it could be allowed for altstep-definitions as well, but these altstep-definitions then shall only be usable for top-level invocations (not as alternative-headers in other alt-statements or altsteps).</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7893.docx (270,972) <span class="italic">12-08-2020 13:00</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3922&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7893-2.docx (327,153) <span class="italic">13-08-2020 10:29</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3933&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">24-01-2020 11:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2020 11:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">10-08-2020 11:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-08-2020 11:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">12-08-2020 13:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7893.docx</td><td class="print"></td></tr><tr class="print"><td class="print">12-08-2020 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015709</td><td class="print"></td></tr><tr class="print"><td class="print">12-08-2020 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">12-08-2020 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">13-08-2020 10:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7893-2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">13-08-2020 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015724</td><td class="print"></td></tr><tr class="print"><td class="print">13-08-2020 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">13-08-2020 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">13-08-2020 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">16-12-2020 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0015863</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2020 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">16-12-2020 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print"> =&gt; 4.12.1 (published 2020-05)</td></tr><tr class="print"><td class="print">16-12-2020 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; 4.13.1 (ongoing)</td></tr><tr class="print"><td class="print">16-12-2020 14:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; 4.13.1 (ongoing)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015709)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-08-2020 13:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added propoosal, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015724)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-08-2020 10:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I made a single font change in the draft. Otherwise, it looks good. The proposed change resolves the issue described in this CR and is ready to be added to the next version of the core language standard.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015863)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-12-2020 14:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented in draft 4.12.2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
