<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:12 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007807: Generalizing the modifies operation - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007807</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">11-10-2018 08:58</td><td class="print">06-01-2019 08:50</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print">4.11.1 (published 2019-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.4</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Spirent - Jacob Wieland </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007807: Generalizing the modifies operation</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">At the moment, it is very restricted where you can use modifies, even though it is a powerful and useful construct.<br />
<br />
It would be useful if the result of a modification could be directly used inside of a template expression (TemplateBody).<br />
<br />
Also, at the moment, it is unclear what it means if a partially initialized variable (template or not) appears in the modification operand of the modifies construct. From the text it appears that it would possibly just overwrite the corresponding part in the parent template, but that would lead to assignments of uninitialized parts (circumventing the rule that you cannot un-initialize something already initialized). <br />
<br />
Instead, uninitialized fields in the modification part should be treated as 'unchanged' for the purpose of the modification algorithm. <br />
<br />
This has the property that it doesn't matter whether I first assign the modification to a variable and then use the variable or write the same syntax in the modification directly:<br />
<br />
var MyRecord x := { f1 := 1, f2 := - } // f2 remains uninitialized<br />
template MyRecord t modifies t2 := x; // f2 remains unchanged <br />
<br />
would be the same as<br />
<br />
template MyRecord t modifies t2 := { f1 := 1, f2 := - } <br />
<br />
This has the advantage that modifications can be stored in variables, passed around as parameters and be reused and even modified themselves.<br />
<br />
Syntactically, because the current 'inline' version of modifies has the confusing assignment symbol, we should instead introduce a new mixfix operator:<br />
<br />
modifies &lt;ParentTemplate&gt; { with &lt;ModificationTemplate&gt; }+<br />
<br />
The grammar should be amended in the following way:<br />
<br />
Rename the rule of TemplateBody to BaseTemplateBody<br />
<br />
Introduce new rules:<br />
<br />
TemplateBody ::= BaseTemplateBody | DerivedTemplateBody<br />
DerivedTemplateBody ::= ModifiesKeyword BaseTemplateBody {WithKeyword BaseTemplateBody}+</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7807.docx (181,870) <span class="italic">12-10-2018 10:01</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3810&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">11-10-2018 08:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">11-10-2018 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">11-10-2018 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">12-10-2018 10:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7807.docx</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2018 10:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015269</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2018 10:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">12-10-2018 10:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">12-10-2018 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015270</td><td class="print"></td></tr><tr class="print"><td class="print">12-10-2018 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">12-10-2018 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">12-10-2018 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">06-01-2019 08:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">06-01-2019 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0015325</td><td class="print"></td></tr><tr class="print"><td class="print">06-01-2019 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">06-01-2019 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; 4.11.1 (published 2019-05)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015269)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-10-2018 10:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As the 'with' clashes with the with-part (at least if repeated) and the := syntax and the with syntax are so similar in placement, I just generalized the modified template to a TemplateBody and distinguish between TemplateBody, DerivedTemplateBody (the inline modifies construct) and BaseTemplateBody (all other template body constructions) where the left and right hand side of DerivedTemplateBody can only be BaseTemplateBody (to avoid weird stacking of modifies without giving parantheses).<br />
<br />
Please check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015270)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-10-2018 10:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Reviewed. No issues found. Can be added to the next version of the core language specification.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015325)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-01-2019 08:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft v4.10.2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
