<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:19 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007754: Clarify initialization of constants and module parameters - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007754</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">08-03-2018 09:32</td><td class="print">04-01-2019 16:53</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Thilo Lauer</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print">4.11.1 (published 2019-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">ES 201 873-1 v4.9.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Devoteam - Thilo Lauer</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007754: Clarify initialization of constants and module parameters</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Clarification required on following subject:<br />
<br />
The current standard version does not clearly define, wheather initialization of a constant with module parameters is allowed or not.<br />
<br />
If constant initializations by module parameters shall be permitted, than the semantic for default values of such module parameters needs to be clarified.<br />
<br />
Example 1:<br />
<br />
&#160;&#160;modulepar integer px_int1 := tsc_const1 + 3;<br />
&#160;&#160;modulepar integer px_int2;   // note: no default value assigned here!<br />
&#160;&#160;const integer tsc_const1 := px_int2;<br />
<br />
Should this example be allowed and what is the semantic of it?<br />
<br />
Notes:<br />
- px_int2 must be provided at runtime (e.g. by a module-parameter file)<br />
- px_int1 could be provided at runtime, but if not, it can be computed by<br />
&#160;&#160;the default-expression<br />
- tsc_const1 must be computed at runtime as its value depends on <br />
&#160;&#160;module parameters<br />
- if px_int2 value is NOT provided at runtime, should this lead to <br />
&#160;&#160;an error message anyway or only if px_int1, px_int2, tsc_const1 are<br />
&#160;&#160;really used in a test run?<br />
&#160;&#160;And should there be a warning issued at compile time, that this may<br />
&#160;&#160;lead to an error at runtime?<br />
<br />
If it should be allowed to init a constant by module parameter values, what about the following example:<br />
<br />
Example 2:<br />
<br />
&#160;&#160;modulepar integer px_int3 := tsc_const2 + 3;<br />
&#160;&#160;const integer tsc_const2 := px_int3;<br />
<br />
<br />
Our clarification suggestion would be:<br />
- module parameters can be initialized by using constants, but<br />
- constant values SHALL NOT depend on module parameters<br />
<br />
A clarification would be helpful here.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR-7754 Clarify initialization of constants and module parameters.docx (69,445) <span class="italic">19-07-2018 11:07</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3774&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">08-03-2018 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">08-03-2018 13:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015063</td><td class="print"></td></tr><tr class="print"><td class="print">16-07-2018 13:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015130</td><td class="print"></td></tr><tr class="print"><td class="print">16-07-2018 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">16-07-2018 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">18-07-2018 10:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015156</td><td class="print"></td></tr><tr class="print"><td class="print">18-07-2018 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015157</td><td class="print"></td></tr><tr class="print"><td class="print">18-07-2018 15:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015164</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2018 11:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015171</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2018 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-7754 Clarify initialization of constants and module parameters.docx</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2018 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015173</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2018 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">19-07-2018 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">19-07-2018 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015177</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2018 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">19-07-2018 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">19-07-2018 13:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">04-01-2019 16:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0015301</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2019 16:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">04-01-2019 16:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; 4.11.1 (published 2019-05)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015063)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-03-2018 13:09&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think the actual issue here is the circularity of the default values (const-value being used that is also dependent on that usage).<br />
<br />
That, of course, must be disallowed (and probably is).<br />
<br />
Otherwise, I see no problem with non-circular usage between constants and modulepar-defaults.<br />
<br />
In essence, modulepars are just constants with an unknown value at compile-time, so a constant filled with something depending on a modulepar is also just a constant with an unknown value. <br />
<br />
Thus, if it would be allowed for two modulepars, why would it not be allowed for a combination of const and modulepar?<br />
<br />
Constants are just values that are initialized once (at the latest before their first usage) and never changed afterwards (during the life-cycle of a testsystem or at least a single testcase-run). <br />
<br />
The same is true for modulepars with the additional feature that they can be configured explicitly and can be provided a default value.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015130)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-07-2018 13:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: Check standard regarding current rules.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015156)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2018 10:39&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The example<br />
<br />
Example 2:<br />
<br />
&#160;&#160;modulepar integer px_int3 := tsc_const2 + 3;<br />
&#160;&#160;const integer tsc_const2 := px_int3;<br />
<br />
<br />
is not allowed. The general clause &quot;5.5	Cyclic Definitions&quot; should apply.<br />
(The notions &quot;definition&quot; and &quot;declaration&quot; of variables, constants, types and other language elements are used interchangeably.)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015157)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2018 11:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&gt; Example 1:<br />
&gt;<br />
&gt;  modulepar integer px_int1 := tsc_const1 + 3;<br />
&gt;  modulepar integer px_int2; // note: no default value assigned here!<br />
&gt;  const integer tsc_const1 := px_int2;<br />
&gt;<br />
&gt; Should this example be allowed and what is the semantic of it?<br />
&gt;<br />
&gt; Notes:<br />
&gt; - px_int2 must be provided at runtime (e.g. by a module-parameter file)<br />
<br />
YES<br />
<br />
&gt; - px_int1 could be provided at runtime, but if not, it can be computed by<br />
&gt;   the default-expression<br />
<br />
YES <br />
<br />
&gt; - tsc_const1 must be computed at runtime as its value depends on<br />
&gt;   module parameters<br />
<br />
YES<br />
<br />
&gt; - if px_int2 value is NOT provided at runtime, should this lead to<br />
&gt;   an error message anyway or only if px_int1, px_int2, tsc_const1 are<br />
&gt;   really used in a test run?<br />
<br />
The standard states:<br />
&quot;If the test system does not provide an actual runtime value for a module parameter, the default value shall be used during test execution, otherwise the actual value provided by the test system.&quot;<br />
I.e., the otherwise part applies, but includes a least a typo. I believe the words &quot;shall be&quot; are missing. The correction needs a discussion within the STF.<br />
<br />
<br />
&gt;   And should there be a warning issued at compile time, that this may<br />
&gt;   lead to an error at runtime?<br />
<br />
A warning is a tool specific issue. The standard cannot prescribe the tool capabilities. However, note may be added.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015164)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2018 15:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
<br />
Restriction &quot;The expression shall evaluate to a value, which is at least partially initialized.&quot; has to be added to constant declaration section.<br />
<br />
Add sentence to Clause 8.2.0: Module definitions can be evaluated at runtime and can be evaluated in any order. A definition shall be evaluated latest before the first reference to it.<br />
<br />
Add note: If a definition is not used, it may not be evaluated at all.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015171)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-07-2018 11:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The CR is resolved as follows:<br />
<br />
In Clause &quot;10 Declaring constants&quot; the restriction<br />
<br />
&quot;d) The right hand side of the assignment that initializes a constant shall evaluate to an object that is at least partially initialized.&quot;<br />
<br />
In the &quot;Semantic Description&quot; part of Clause &quot;8.2.0 General&quot; behind the sentence &quot;Definitions in the module definitions part may be made in any order.&quot; the following sentences an note have been added:<br />
<br />
&quot;Module definitions can be evaluated at runtime and can be evaluated in any order. A definition shall be evaluated latest before the first reference to it.<br />
<br />
NOTE:	If a definition is not used, it may not be evaluated at all.&quot;<br />
<br />
The circularity of the default values is covered by Clause &quot;5.5 Cyclic Definitions&quot;.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015173)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-07-2018 11:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Tomas, please crosscheck.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015177)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-07-2018 13:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Reviewed, no issues found. The proposal is ready to be added to the next version of the core language specification.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015301)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-01-2019 16:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft V4.10.2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
