<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:35 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007694: dynamic encoding (usage of statement port.setencode(type,&quot;EncodingRule1&quot;); - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007694</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Technical</td><td class="print">public</td><td class="print">24-07-2017 10:16</td><td class="print">02-01-2018 12:34</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Martin Hauch</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Encode/Decode handling TCI-interface 7.3.2.2.1 ff</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Devoteam, Martin Hauch</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007694: dynamic encoding (usage of statement port.setencode(type,&quot;EncodingRule1&quot;);</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">With introduction of multiple encoding rules and the setencode-statement the following problem for tci-Codec interface has to be solved:<br />
<br />
The information about the encoding-rule, which should be used is not available for the tci-interface (Chapter 7.3.2.2.2 in document ETSI ES 201 873-6 V4.9.1 (2017-05))! The interface description encode(in Value value) does not provide any information about the encoding set for the type of this value on the port.<br />
The same problem is present for decode (Chapter 7.3.2.2.1)!<br />
In a similar way this also concerns the TTCN-3 predefined functions encvalue, encvalue_unichar, decvalue, decvalue_unichar and the tci-codec interface functions encodeValue and decodeValue ( Chapter 7.3.2.2.3f). </td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7694-v1.docx (204,639) <span class="italic">25-07-2017 16:34</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3655&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7694-v2.docx (205,136) <span class="italic">26-07-2017 08:50</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3658&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">24-07-2017 10:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 14:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">24-07-2017 14:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">24-07-2017 14:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014736</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 16:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014744</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 07:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014745</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 15:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014756</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 16:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7694-v1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 16:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014761</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 16:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">25-07-2017 16:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">26-07-2017 08:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014766</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 08:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014767</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 08:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">26-07-2017 08:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">26-07-2017 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7694-v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 08:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014768</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 08:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">26-07-2017 08:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">26-07-2017 09:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014774</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 09:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">26-07-2017 09:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">26-07-2017 09:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">26-07-2017 09:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control Interface</td></tr><tr class="print"><td class="print">02-01-2018 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014982</td><td class="print"></td></tr><tr class="print"><td class="print">02-01-2018 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014736)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-07-2017 14:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				To be checked how the different tools (Jacob, Kristof) interpret this feature.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014744)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-07-2017 16:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Dear Martin,<br />
<br />
It is correct that the encode and decode operations do not contain information on the selected encoding (and related variants) in a dedicated parameter. However, this information is available in the value (encode) or decodingHypothesis parameters (decode). When generating the TCI Type and Value instances, the TE shall take into account all previous setencode calls and the context from which the codec operation is called and pass such a Value or Type instance to the TCI that contains only the selected encoding and related variants.<br />
<br />
Example:<br />
<br />
type charstring MyString with { encode &quot;binary&quot; encode &quot;text&quot; }<br />
....<br />
p.setencode(MyString, &quot;binary&quot;);<br />
p.receive(MyString:?);<br />
// at this point, TCI decode is called<br />
// if the user calls decodingHypothesis.getTypeEncoding, the returned value will be &quot;binary&quot;<br />
p.setencode(MyString, &quot;text&quot;);<br />
p.receive(MyString:?);<br />
// at this point, TCI decode is called again<br />
// however, if the user calls decodingHypothesis.getTypeEncoding, the returned value will be &quot;text&quot; this time<br />
enc_value(MyString:&quot;abc&quot;);<br />
// inside the TCI encode operation, the value.getValueEncoding call will return &quot;binary&lt;CR&gt;&lt;LF&gt;text&quot; <br />
// because the dynamic_encoding parameter is not used and no self.setencode call has been made so far<br />
<br />
Could you please say if the provided explanation is satisfactory? If there are any questions, please feel free to ask.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014745)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-07-2017 07:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Dear Thomas,<br />
I do not agree to this. It is possible that for the same type various encoding-types are active in parallel.<br />
p1.setencode(MyString,&quot;binary&quot;);<br />
p2.setencode(MyString,&quot;text&quot;);<br />
p3.setencode(MyString,&quot;something else&quot;);<br />
As far as I understand the TCI-interface the method getTypeEncoding() returns type encoding as defined in the TTCN-3 module, means encode-attributes, that belong to the type e.g.:<br />
with { encode &quot;binary&quot;; encode &quot;text&quot;} getTypeEncoding should return always &quot;binary&lt;CR&gt;&lt;LF&gt;text&quot; as it is the information, that belongs to the type and this information is independent from dynamic setencode-statements!<br />
<br />
Also if the interleave-statement is used or there are parallel test-components using the same types, the same type may be used in parallel with different encoding-rules. In my opinion an extra parameter representing the dynamic setencode-settings is necessary. The dynamic setencode information belongs to the port or component, not to the type. So you could define an interface function like<br />
String getDyanmicEncodingDescription(EncodingSettings setEncodeSettings,Type type)<br />
<br />
Another point should be clarified:<br />
<br />
p1.setencode(MyString,&quot;binary&quot;);<br />
self.setencode(MyString,&quot;text&quot;);<br />
/* which encoding is to be used for p1.send(Mystring:&quot;...&quot;); <br />
&#160;&#160;&#160;does self.setencode() overwrite port.setencode()?<br />
&#160;&#160;&#160;does self.setencode() only overwrite type encoding from p1.setencode or<br />
&#160;&#160;&#160;are all type encodings of p1.setencode() calls deleted and only the <br />
&#160;&#160;&#160;encodings of self.setencode() are valid? */			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014756)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-07-2017 15:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The intended way of using multiple encodings is as I described above, i.e. the TCI Type instance doesn't have to be related to the TTCN-3 type definition in the source code. Instead, the TE might create an anonymous TCI Type instance with different attributes according to the context from which the TCI call is made. We will rephrase the TCI description to explain this in detail.<br />
<br />
This principle is already used in several places of TTCN-3, e.g. when a type is imported to two different modules with different attributes or when a receive statement uses templates of the same type but with different attributes.<br />
<br />
The solution you propose has several drawbacks:<br />
1. Adding the additional parameter(s) to the existing methods is not possible because of backwards compatibility.<br />
2. Eventual new methods for types with multiple encodings:<br />
&#160;&#160;&#160;a. Make the creation of the codec more complicated<br />
&#160;&#160;&#160;b. Require update of existing codec so that they can be compiled with the new TCI<br />
&#160;&#160;&#160;c. Should contain several (more or less) mandatory calls to get the actual encoding<br />
3. There will still be situation when more encodings are possible for the same type (e.g. the case with two templates).<br />
<br />
As regards the p1.setencode call followed by self.setencode, it will indeed override the encoding setting for p1, because the self.setencode call is valid for all communication operations of the current component (including the ones made from p1).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014761)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-07-2017 16:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please check the update of the TCI standard.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014766)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-07-2017 08:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				other than the one missing 'variant' word before 'encoding attribute' for getTypeEncodingVariant, it's fine			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014767)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-07-2017 08:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please add the missing word			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014768)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-07-2017 08:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Missing word added. Please check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014774)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-07-2017 09:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				fine with me			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014982)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-01-2018 12:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented in draft V4.9.2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
