<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:31 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007672: Compatibility of enumerated types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007672</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">03-05-2017 11:00</td><td class="print">05-01-2018 09:55</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.10.1 (published 2018-05)</td><td class="print-category">Fixed in Version</td><td class="print">v4.10.1 (published 2018-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.3.2.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007672: Compatibility of enumerated types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The new rules on compatibility of enumerated types are based on individual enumerated values which means that types are sometimes compatible and sometimes not. That makes static semantic analysis quite difficult and leads to runtime errors.<br />
<br />
Example:<br />
type enumerated EWorkDays { Mon, Tue, Wed, Thu, Fri }<br />
type enumerated EWeekDays { Mon, Tue, Wed, Thu, Fri, Sat, Sun }<br />
...<br />
var EWorkDays v_workDay := Mon;<br />
var EWeekDays v_weekDay := Mon;<br />
log (v_workDay == v_weekDay); // ok, logs &quot;true&quot;<br />
v_weekDay := Sat;<br />
log (v_workDay == v_weekDay); // leads to type compatibility error<br />
<br />
Proposal:<br />
1. Add an additional rule to the relation operations that would produce false in case of comparing non-compatible values of partially compatible enumerations as in the example above.<br />
2. Describe in detail the assignment process with all possible errors and create examples (v_weekDay := v_workDay should be always possible, v_workDay := v_weekDay could work, but it can produce runtime errors too).</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;7672.doc (15,360) <span class="italic">24-07-2017 07:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3646&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;7672_2.doc (16,896) <span class="italic">25-07-2017 10:59</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3651&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;7672_3.doc (31,232) <span class="italic">26-10-2017 11:40</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3711&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;7672_4.doc (32,256) <span class="italic">26-10-2017 14:46</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3716&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7276_5.docx (74,327) <span class="italic">04-01-2018 11:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3733&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">03-05-2017 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">03-05-2017 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014614</td><td class="print"></td></tr><tr class="print"><td class="print">06-06-2017 11:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Julien Deltour</td></tr><tr class="print"><td class="print">06-06-2017 11:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">07-06-2017 08:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1021">szabados</a></td><td class="print">Note Added: 0014636</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 07:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">File Added: 7672.doc</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 07:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Note Added: 0014730</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 07:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">24-07-2017 07:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Assigned To</td><td class="print">Julien Deltour =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">24-07-2017 07:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">24-07-2017 10:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014731</td><td class="print"></td></tr><tr class="print"><td class="print">24-07-2017 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Julien Deltour</td></tr><tr class="print"><td class="print">25-07-2017 10:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">File Added: 7672_2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Note Added: 0014749</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Assigned To</td><td class="print">Julien Deltour =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">25-07-2017 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">25-07-2017 16:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014760</td><td class="print"></td></tr><tr class="print"><td class="print">25-07-2017 16:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Deleted: 0014760</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 09:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014770</td><td class="print"></td></tr><tr class="print"><td class="print">26-07-2017 09:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Julien Deltour</td></tr><tr class="print"><td class="print">26-07-2017 09:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">26-10-2017 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">File Added: 7672_3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">26-10-2017 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Note Added: 0014886</td><td class="print"></td></tr><tr class="print"><td class="print">26-10-2017 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">26-10-2017 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Assigned To</td><td class="print">Julien Deltour =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">26-10-2017 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">26-10-2017 14:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014897</td><td class="print"></td></tr><tr class="print"><td class="print">26-10-2017 14:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: 7672_4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">26-10-2017 14:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014898</td><td class="print"></td></tr><tr class="print"><td class="print">26-10-2017 14:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">26-10-2017 14:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">02-01-2018 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014986</td><td class="print"></td></tr><tr class="print"><td class="print">02-01-2018 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014987</td><td class="print"></td></tr><tr class="print"><td class="print">02-01-2018 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">02-01-2018 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">02-01-2018 13:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">04-01-2018 11:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014992</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2018 11:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR7276_5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2018 11:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">04-01-2018 11:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; confirmed</td></tr><tr class="print"><td class="print">04-01-2018 11:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014992</td><td class="print">bug_revision_view_page.php?bugnote_id=14992#r454</td></tr><tr class="print"><td class="print">04-01-2018 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014992</td><td class="print">bug_revision_view_page.php?bugnote_id=14992#r455</td></tr><tr class="print"><td class="print">04-01-2018 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014992</td><td class="print">bug_revision_view_page.php?bugnote_id=14992#r456</td></tr><tr class="print"><td class="print">04-01-2018 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014992</td><td class="print">bug_revision_view_page.php?bugnote_id=14992#r457</td></tr><tr class="print"><td class="print">04-01-2018 11:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.10.1 (published 2018-05)</td></tr><tr class="print"><td class="print">05-01-2018 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014998</td><td class="print"></td></tr><tr class="print"><td class="print">05-01-2018 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">05-01-2018 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">05-01-2018 09:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014992</td><td class="print">bug_revision_view_page.php?bugnote_id=14992#r458</td></tr><tr class="print"><td class="print">05-01-2018 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0015003</td><td class="print"></td></tr><tr class="print"><td class="print">05-01-2018 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">05-01-2018 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.10.1 (published 2018-05)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014614)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-05-2017 11:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It should behave the same way as for restricted integer types.<br />
<br />
type integer I1 (1 .. 10);<br />
type integer I2 (5 .. 50);<br />
<br />
var I1 v_1 := 5;<br />
var I2 v_2 := 5;<br />
log(v_1 == v2); // should produce true<br />
v_1 := 1;<br />
log(v_1 == v_2);// should produce false<br />
<br />
Basically, the comparison should work on the least-upper-bound of the two enumerated types, i.e. an (imaginary) enumerated type that contains all named values from both involved enumerated types. If they are not compatible, there is no least-upper-bound.<br />
<br />
This is the same principle as for the integer-comparison, here, the base type (which is an upper bound of all integer types) is used for the actual comparison semantics.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014636)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1021">szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-06-2017 08:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I believe, that this understanding would require some examples in standard.<br />
example1:<br />
&#160;2 enums compatible if the only difference is that in one of them has the numbers explicitly set, the other not.<br />
&#160;&#160;&quot;<br />
type enumerated EWeekDays2 { Mon(0), Tue(1), Wed(2), Thu(3), Fri(4), Sat(5), Sun(6) }<br />
var EWeekDays2 v_weekDay2 := Mon;<br />
log (v_weekDay == v_weekDay2); // ok, logs &quot;true&quot;<br />
&#160;&#160;&quot;<br />
<br />
example2:<br />
&#160;2 enums that contain the same value and have the same semantic meaning are not compatible if the values are listed in a different order.<br />
&quot;<br />
type enumerated EWeekDaysReordered { Sun, Mon, Tue, Wed, Thu, Fri, Sat }<br />
var EWeekDaysReordered v_weekDayReordered := Mon;<br />
log (v_weekDay == EWeekDaysReordered); // ok, logs &quot;false&quot;<br />
&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014730)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-07-2017 07:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014731)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-07-2017 10:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				while the examples are very good, the description why comparing two enumerated types who are only partly (or not at all) compatible leads to false is somehow missing in the description text.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014749)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-07-2017 11:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The description of why two partially compatible enumerated types can return false has been added. Can you please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014770)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-07-2017 09:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have not found it. Also, I would expect this description in the definition of the equality operator, not in the type compatibility section.<br />
<br />
The description should define that values of two enumerated types which can be combined to a larger enumerated type by merging their members together can be compared and will lead to true if the value with the same number associated exists in both enumerated types is the same on both sides of the equality operator, otherwise, the expression will evaluate to false.<br />
<br />
Thus, equality can only produce an error if the two types cannot be merged,i.e. if a number value is associated with two different names after the merging process.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014886)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1052">Julien Deltour</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-10-2017 11:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please can you check for this new proposal ?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014897)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-10-2017 14:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have reworded it slightly and in a way that is consistent with the proposal that two enumerated entities can only be compared if their types are mergeable. Otherwise, it is a static error.<br />
<br />
I have removed the assignment part as that has nothing to do with the mergeability of the enumerated types, but only with the simple compatibility rule. (a can be assigned to var of type B if a is compatible to B)<br />
<br />
The comparison examples should probably be moved to the section defining the comparison operators.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014898)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-10-2017 14:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please check as well			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014986)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-01-2018 13:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Ok			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014987)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-01-2018 13:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				György, please have a final check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014992)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-01-2018 11:36&#160;&#160;&#160;
				<br />(edited on:&#32;05-01-2018 09:46)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Example 2 is showing cases of compatible/incompatible assignments. This is OK.<br />
<br />
But the new text and example 1 are related to comparing enum. values, which is described in clause 7.1.3 Relational operators. Now, the new text 6.3.2.1 and the current text in 7.1.3 are contradicting. In 7.1.3: &quot;The relational operators less than (&lt;), greater than (&gt;), greater than or equal to (&gt;=), and less than or equal to (&lt;=) shall have only operands... or instances of the same enumerated type. It is not allowed to compare instances of different root types.<br />
...<br />
Operands of equality (==) and non-equality (!=) shall be ... of type compatible root types ...&quot;<br />
<br />
New text in the CR allows comparing values of different, non-compatible enumerated types, while current 7.1.3 text forbids this. So, I propose to replace the current rule in 7.1.3 with the new one in this CR. <br />
<br />
See my resolution text proposal in CR7672_5.doc<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014998)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-01-2018 09:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Yes, looks good.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015003)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-01-2018 09:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented in draft V4.9.3.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
