<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:54 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007473: Chapter 6.2.1 inconsitencies in optionial attribute &quot;explicit omit&quot; - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007473</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Editorial</td><td class="print">public</td><td class="print">09-08-2016 11:38</td><td class="print">16-12-2016 21:37</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Martin Hauch</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print-category">Fixed in Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.2.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;Devoteam - Martin Hauch</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007473: Chapter 6.2.1 inconsitencies in optionial attribute &quot;explicit omit&quot;</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The &quot;implicit explicit omit&quot; rule applies also to variables, even if the optional attribute is not allowed for variables. There are 2 paragraphs in 6.2.1 which are not coherent, especially when reassigning variables:<br />
<br />
&quot;<br />
Paragraph 1:<br />
When using the value list notation, all fields in the structure shall be specified either with a value, the not used symbol &quot;-&quot; or the omit keyword. The omit keyword shall only be used for optional fields. Its result is that the given field is not present in the given value. The first component of the list (a value, a &quot;-&quot; or omit) is associated with the first field, the second list component is associated with the second field, etc. No empty assignment is allowed (i.e. two commas, the second immediately following the first or only with white space between them). Fields or elements to be left unchanged shall be explicitly skipped in the list by using the not-used-symbol &quot;-&quot;. <br />
<br />
Paragraph 2:<br />
When the value list notation is used in a scope, where the optional attribute is implicitly or explicitly set to &quot;explicit omit, already initialized fields or elements left without an associated component in a value list notation (i.e. at the end of a value ) are becoming uninitialized. In this way, a value with initialized fields or elements can be made empty by using an empty pair of curly brackets (&quot;{}&quot;).<br />
&quot;<br />
<br />
Paragraph 1 says, ALL fields shall be specified. Paragraph 2 allows to leave out values if the optional attribute is implicitly set to explicit omit, which is the case in Paragraph 1!<br />
<br />
Also, paragraph 2 leads to the conclusion that if we have mandatory fields in the value, using &quot;{}&quot; to &quot;clear&quot; a value affects mandatory fields, whereas the &quot;optional&quot; attribute should only be related to optional fields in my opinion. This is very confusing and has to be clarified.<br />
<br />
As mentioned in CR7471 the assignment of sub-fields of a variable could be done by modified templates or<br />
myVar.field1[3]:= { ... }</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007471</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">editorial: inconsistency in the standard regarding partially initialized values&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007288</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Not described use cases for optional attribute&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7288_CR7473_proposal.docx (160,152) <span class="italic">17-08-2016 10:16</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3468&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7288_CR7473_proposal_v2.docx (159,887) <span class="italic">17-08-2016 22:19</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3482&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7288_CR7473_proposal_v3.docx (163,514) <span class="italic">18-08-2016 14:12</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3489&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7288_CR7473_proposal_v4.docx (171,981) <span class="italic">01-09-2016 11:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3508&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7288_CR7473_proposal_v5.docx (172,677) <span class="italic">15-11-2016 16:42</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3527&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">09-08-2016 11:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">15-08-2016 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">15-08-2016 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">15-08-2016 10:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Relationship added</td><td class="print">related to 0007471</td></tr><tr class="print"><td class="print">15-08-2016 10:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014066</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 05:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Relationship added</td><td class="print">related to 0007288</td></tr><tr class="print"><td class="print">17-08-2016 05:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014120</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 07:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014121</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 10:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7288_CR7473_proposal.docx</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 11:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">17-08-2016 22:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7288_CR7473_proposal_v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 14:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7288_CR7473_proposal_v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014175</td><td class="print"></td></tr><tr class="print"><td class="print">22-08-2016 08:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014193</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2016 11:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7288_CR7473_proposal_v4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">01-09-2016 11:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014199</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 16:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">14-11-2016 16:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">15-11-2016 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR7288_CR7473_proposal_v5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0014255</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">15-11-2016 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">15-11-2016 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">15-11-2016 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">12-12-2016 09:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014369</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2016 09:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014369</td><td class="print">bug_revision_view_page.php?bugnote_id=14369#r338</td></tr><tr class="print"><td class="print">12-12-2016 09:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">12-12-2016 09:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014370</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2016 09:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">12-12-2016 09:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">12-12-2016 09:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Deleted: 0014370</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2016 11:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014380</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2016 11:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0014380</td><td class="print">bug_revision_view_page.php?bugnote_id=14380#r340</td></tr><tr class="print"><td class="print">14-12-2016 13:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014437</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2016 16:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014438</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2016 21:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014455</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2016 21:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; closed</td></tr><tr class="print"><td class="print">16-12-2016 21:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">16-12-2016 21:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">16-12-2016 21:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014066)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-08-2016 10:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
<br />
Paragraph 1: Makes only sense for &quot;records&quot;<br />
<br />
Paragraph 2: Makes only sense for &quot;record of&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014120)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2016 05:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR7288 we also changed the example of section 6.2.1 where implicit/explicit omit is attached to variables, so that they are attached to constants.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014121)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2016 07:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree, that paragraph 2 makes only sens for &quot;record of&quot;, but it is defined in chapter &quot;Record type and values&quot; and all examples in this chapter are records.<br />
I also think the optional attribute is only allowed for record-values (not record- or set-of-values). <br />
So paragraph 2 either must be deleted or moved to chapter 6.2.3 &quot;Records and sets of single types&quot;.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014175)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-08-2016 10:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
- even in partial assignment cases fields in the assignment notation should be unique (section 6.2.0 2nd paragraph).<br />
- the same for index notation.<br />
<br />
- value list notation used on record/set type changes only the values listed in scopes where &quot;optional omit&quot; is set explicitly or implicitly<br />
<br />
- The first sentence of 15.5 (starting with &quot;Normally, &quot;) should be deleted as it does not introduce a new constraint.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014193)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-08-2016 08:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think value list notation needs clarification: In my opinion value list needs complete value-assignment using '-' to let a field uninitialized or unchanged. Exception in case of &quot;optional implicit omit&quot;, remaining optional fields at the end of the type definition (all remaining fields are optional),  can be left out, if wished to be omitted.<br />
<br />
The first sentence of 15.5 should not be removed, as it clarifies that a modified template only changes values/matching-mechanisms for parts of a completely defined base-template. The base constraint is a complete assigned template. Templates need to be complete assigned, because they are used for sending and receiving (first sentence chapter 15 &quot;Declaring templates&quot;. <br />
<br />
Remarks to changes in CR7288_CR7473_proposal_v3-1:<br />
<br />
Example 8 in chapter 6.2.1:<br />
const R c_x3 := { 1, -, 2 }<br />
// after the assignment c_x3 contains { 1, &lt;undefined&gt;, 2, &lt;undefined&gt;, &lt;undefined&gt;}<br />
const R c_x4 := c_x3 with { optional &quot;implicit omit&quot; }<br />
//  after the assignment c_x4 contains { 1, omit, 2, omit, omit }<br />
<br />
Definition of c_x3 is not correct, because 6.2.1 says: &quot;When using the value list notation, all fields in the notation shall be specified.&quot; There is no optional attribute &quot;implicit omit&quot; set. So, this line should look like<br />
<br />
const R c_x3 := { 1, -, 2, -, - };<br />
<br />
Remarks to examples in chapter 27.7:<br />
Templates definitions must be comlete in my opininion. Therefore i think most of the examples are not correct. Template are used for send/receive (as chapter 15 first sentence says) and this is only possible with complete defined templates!			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014199)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-09-2016 11:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Sorry for the delay; uploaded the text version that is in line with the STF decision.<br />
<br />
The first sentence from 15.5 is removed as it does not add to or take away from the standard.<br />
It is read (and can be mentally extended with): normally, you should do something like this (at other times, other kinds of usages are fine too)<br />
<br />
Maybe we could add a note to show some generic programming best practices, something like this:<br />
&quot;Those templates which will be used directly in send/receive operations shall be completely initialized, otherwise they would result in test case error at the time of the send/receive operation.<br />
On the other hand there are cases where some templates must, by design, never reach send/receive operations directly. For example partially initialized templates are to be used when one field must hold some unique identifier, that is not known statically. In these cases choosing any dummy number would run the risk of directing future tests, where the template is used and the field not overwritten, on unexpected execution paths. This would result in tests not testing what they were meant to be, and result in large debugging and maintenance cost where the problems is realised. Partially initialized templates can still be used to initialize other templates or as bases of modified templates; which have the uninitilized fields filled in, and can be used in send/receive operations&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014255)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-11-2016 16:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				just some small minor editorial modifications			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014369)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2016 09:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented the current v5 version of the resolution. During this I have noticed an issue.<br />
<br />
In clause 6.2.1.0 General, in the paragraph following example 4, is written<br />
&quot;... The omit keyword shall only be used for optional fields. Its result is that the given field is not present in the given value. ...&quot;<br />
<br />
The 2nd sentence is misleading as the field is not present in the ENCODED value, but present and perfectly defined in the abstract TTCN-3 value. I can see this type of misunderstanding at users several times.<br />
<br />
My proposals:<br />
a) delete the sentence<br />
b) move the sentence to a note and adding &quot;...given field is not present in the encoded instance of the given value.&quot;<br />
<br />
What do you think?<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014380)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2016 11:18&#160;&#160;&#160;
				<br />(edited on:&#32;12-12-2016 11:20)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				the concept of present-ness is tightly coupled with the optionality of fields, so I think it is perfectly alright stated as is. An optional field whose DEFINITION syntactically is present, but defined using omit is not present in the template(present) sense, i.e. ispresent() will yield false. Maybe this should be clarified in the definitions section, if not already clear enough.<br />
<br />
So, even unencoded, abstract TTCN-3 values can have optional field which are not present, not just encoded ones.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014437)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2016 13:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Seems we may have different understanding here.<br />
<br />
I think that<br />
template integer mw_int := omit;<br />
is an existing definition, i.e. present and defined at the abstract TTCN-3 level, it can be referenced in other definitions.<br />
<br />
To my view the same is true for optional fields:<br />
type record MyRec {<br />
&#160;&#160;integer int optional<br />
}<br />
<br />
template MyRec mw_rec := {<br />
&#160;&#160;&#160;int := omit<br />
} <br />
is not an empty record, but a record with one field, which has the omit property assigned (e.g. in PER it will even be encoded as a single &quot;0&quot; bit!); also isbound(mw_rec.int) will return true!<br />
<br />
At the abstract TTCN-3 level both the above template mw_int and template field mw_rec.int are reference-able and bound, therefore they shall exist (i.e. shall be present and set to the &quot;special value&quot; omit).<br />
<br />
PS: ispresent() is just a name given by us, the human meaning of a name  doesn't define its semantics.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014438)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2016 16:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Using that kind of definition of present-ness, pretty much everything is present, even the void, because that also can be referenced. Thus, such a definition is useless.<br />
<br />
Throughout the standard, we have a very clear understanding what 'being present' means in the context of an optional field of a value (i.e. it is initialized and not set to omit) or a template (it is initialized with a matching mechanism that does not match omit). This is captured by the semantics of the functions ispresent() and also by the template(present) restriction.<br />
<br />
To summarize: in my understanding explicitly or implicitly omitted fields are definitely not present in the value, they may be present in some form in the encoded value (i.e. their not-present-ness can take up some space in the encoded value), and of course they are present in some form also in the decoded value (i.e. represented by some data in the memory that captures the non-presentness), but from the TTCN-3 point of view, and that is what we are talking about in that section, they are not.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014455)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-12-2016 21:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK, it was just a side note for a possible last minute clarification; as the draft need to be submitted, I don't think we need to go into or have time for a discussion.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
