<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:16:11 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007471: editorial: inconsistency in the standard regarding partially initialized values - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007471</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Editorial</td><td class="print">public</td><td class="print">08-08-2016 14:00</td><td class="print">09-12-2016 15:43</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">KristÃ³f Szabados</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print-category">Fixed in Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.2.1, 19.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L. M. Ericsson</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007471: editorial: inconsistency in the standard regarding partially initialized values</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In his feedback Martin Hauch pointed out an inconsistency in the core standard.<br />
<br />
&quot;<br />
Another point regarding assignments of structured types which is related and should also be clarified:<br />
<br />
Chapter 19.1 :<br />
A structured value on the right-hand side of the assignment shall be assigned completely to the variable on the left-hand side of the assignment, If a partially initialized value is assigned to a completely initialized variable, fields uninitialized at the right-hand side of the assignment shall also become uninitialized at the left-hand side.<br />
But in Chapter 6.2.1 &quot;Record type and values&quot; there are many examples that contradict this statement e.g. EXAMPLE 5<br />
<br />
var MyRecordType MyVariable := <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field1 := '111'B,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field2 := false,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field3 := -<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MyVariable :=<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field2 := true<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// after this, MyVariable contains:<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;//        { '111'B /* unchanged */, true, &lt;undefined&gt; /* unchanged */ }<br />
<br />
In my opinion (regarding chapter 19.1) fields field1 and field3 are not assigned and so must be unitialized after the assignment. If I only want to change the second field of the variable, it should be written:<br />
<br />
&#160;&#160;&#160;&#160;MyVariable.field2 := true; <br />
<br />
In case of more complex situations, the usage of modified templates is semantically a better solution to change complex values, when some special fields should be assigned to a new value. The concept of &quot;modified templates&quot; is a clear semantic, how templates can be defined using base template definitions. This also would make the use of the &quot;-&quot; in assignments unnecessary.<br />
<br />
I think the sentence in 19.1 is more clear and intuitive, than the long description in chapter 6.2.1 Record type and values. In 6.2.1, fields on the left hand side are kept unchanged implicitly, which can lead to side effects and is completely against the way assignments should work in my opinion.<br />
&quot;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007473</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Chapter 6.2.1 inconsitencies in optionial attribute &quot;explicit omit&quot;&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">08-08-2016 14:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">08-08-2016 15:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014046</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2016 10:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014047</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2016 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0014046</td><td class="print">bug_revision_view_page.php?bugnote_id=14046#r314</td></tr><tr class="print"><td class="print">09-08-2016 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0014046</td><td class="print">bug_revision_view_page.php?bugnote_id=14046#r315</td></tr><tr class="print"><td class="print">09-08-2016 15:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014048</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2016 13:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014049</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2016 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014050</td><td class="print"></td></tr><tr class="print"><td class="print">15-08-2016 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">15-08-2016 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">15-08-2016 10:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Relationship added</td><td class="print">related to 0007473</td></tr><tr class="print"><td class="print">17-08-2016 11:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">14-11-2016 16:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014233</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014256</td><td class="print"></td></tr><tr class="print"><td class="print">15-11-2016 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">15-11-2016 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.10.1 (published 2018-05)</td></tr><tr class="print"><td class="print">15-11-2016 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">17-11-2016 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014311</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">17-11-2016 14:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">17-11-2016 14:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">feedback =&gt; resolved</td></tr><tr class="print"><td class="print">17-11-2016 14:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Fixed in Version</td><td class="print">v4.10.1 (published 2018-05) =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">17-11-2016 14:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">17-11-2016 14:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">09-12-2016 15:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014368</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2016 15:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014046)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-08-2016 15:49&#160;&#160;&#160;
				<br />(edited on:&#32;09-08-2016 15:51)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Here, the commenter confused the assignment syntax with the value-syntax. On the right-hand-side of an assignment, a structured expression is currently seen only as a short-hand notation for a lot of sub-structure assignments (i.e. only those fields that are written down, except those with the dash on the right-hand-side) are actually overwritten, everything else remains unchanged.<br />
<br />
I also think this is a weird interpretation of the syntax, as the same syntax used in a different context, e.g. as an actual parameter, has a different meaning than on the right-hand side of an assignment.<br />
<br />
The problem mainly here is the dash symbol which only has meaning on the right-hand-side of an assignment. It cannot be interpreted as 'uninitialized' as then the assignment would overwrite an already initialized field with 'uninitialized'  unless the semantics is changed that this is always the case for assigning uninitialized.<br />
<br />
It is also weird that the expression that can be used on the right-hand-side (using dash) cannot be used as an actual parameter and then when the corresponding formal parameter is assigned does not have the same semantics as in a direct assignment.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014047)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2016 10:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				From example above (initialized value {field1 := '111'B,field2 := false,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field3 := -}<br />
<br />
The right-hand-side of the assignment <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MyVariable :=<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field2 := true<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
contains a partial value. So as defined in chapter 19.1 the value after assignment is {field1 &lt;unitialized&gt;, field2 true, field3 &lt;unitialized&gt;}. The definition in 19.1 contradicts to chapter 6.2.1 which (implicitly) introduces the short hand notation you mention. Either chapter 6.2.1 must be changed or the sentence in 19.1, which defines the assignment-semantic, must be changed!<br />
<br />
I think it would be clearer to say 19.1 is correct! Use modified templates or syntax MyVariable.field1:='001'B, if only parts of a structure should be reassigned. The syntax and semantic of<br />
<br />
MyVariable.field1:='001'B,<br />
<br />
is much clearer than <br />
<br />
MyVariable :={field2 := true}<br />
<br />
where complicate descriptions have to be analysed to understand, what the assignment is exactly doing (depends on value-list-notation, assignment-notation,with &quot;optional explicit omit&quot;, with &quot;optional implicit omit&quot;).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014048)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2016 15:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				No, { field2 := true } on the right-hand-side of an assignment is not a value, but just syntax for several assignments rolled into one, which is why it is not in conflict with 19.1.<br />
<br />
The result of the assignment (if MyVariable has uninitialized fields other than field2 before the assignment) that is stored in MyVariable is then an partially initialized value. Using that (i.e. MyVariable) on the right-hand-side of an assignment would then invoke the rules in 19.1, i.e. the uninitialized fields would be treated differently than the left-out fields in the syntax above.<br />
<br />
The standard in 6.2.1. is very clear about this:<br />
<br />
<br />
I quote:<br />
<br />
When the assignment notation is used in a scope, where the optional attribute is implicitly or explicitly set to<br />
&quot;explicit omit&quot;, fields, not explicitly referred to in the notation, shall remain unchanged. <br />
<br />
and also:<br />
<br />
When the assignment notation is used in a scope, where the optional attribute is set to &quot;implicit omit&quot;,<br />
optional fields, not directly referred to in the notation, shall implicitly be set to omit, while mandatory fields shall<br />
remain unchanged (see also clause 27.7).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014049)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-08-2016 13:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Question 1:<br />
What are variable MyVariable2,MyVariable4 representing in the following example (btw. the type MyRecordType seems to be not the type that is used vor the defined variables in EXAMPLE 5 in chapter 6.2.1 of the core language):<br />
{<br />
&#160;&#160;type record MyRecordType{	<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer 			field1,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;boolean          	field2 optional,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;charstring 			field3<br />
&#160;&#160;}<br />
<br />
var MyRecordType MyVariable:={field1:=1,field2:=false,field3:=&quot;hallo&quot;};<br />
var MyRecordType MyVariable2:={field1:=1,field2:=false,field3:=&quot;hallo&quot;};<br />
var MyRecordType MyVariable3,MyVariable4,;<br />
MyVariable:={field2:=True}; //MARK1 completely assigned variable<br />
MyVariable3:={field2:=True};//MARK2 partially assigned variable<br />
MyVariable2:=MyVariable3;   //MARK3 partially or complete assigned variable??<br />
MyVariable4:=MyVariable3;   //MARK4 partially assigned variable<br />
}<br />
From an intuitive view I would first expect that MyVariable and MyVariable3 are the same (because of the same rhs in MARK1 and MARK2) and  MyVariable2 and MyVariable4 represent the same, i.e. ALL variables are identical. But respecting the definitions in 6.2.1 this is not the case. The content of MyVariable2 (MARK3) is not clear to me. Does the variable assignment overwrite initialized values with 'unitialized'? It is very unintuitive that you have to know the &quot;history&quot; of assignments to a variable to interpret the resulting value of obviously identical assignments like MARK1 and MARK2 correctly.<br />
<br />
Question 2:<br />
What is the complete notation for this shorthand notation:<br />
<br />
// MyVariable is uninitialized here<br />
MyVariable :={field2 := true} <br />
<br />
?<br />
<br />
I can only think of<br />
<br />
MyVariable:={field1:=MyVariable.field1,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field2:=true, <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;field3:=MyVariable.field3}<br />
<br />
because according to 19.1.a the rhs has to be type compatible with the lhs. But then, MyVariable.field1 and MyVariable.field3 are unbound and the assignment is invalid. The type compatibility according to 19.1.a is the main point for my concerns. In chapter 19.1 EXAMPLE 3 shows, how a variable could be partially assigned.<br />
So my conclusion from above definitions in 19.1 is:<br />
The assignment<br />
MyVariable :={field2 := true}<br />
is only allowed, if MyVariable has still assigned 'values' or 'omit to optional fields' &quot;field1&quot; and &quot;field3&quot;. Otherwise it is an error.<br />
If this is correct, the examples above from question 1 are not allowed, because a variable could not be initialized partially this way!  <br />
<br />
We have to be careful not to confuse/mix this with the optional omit attribute, because this is not allowed for variables yet (or at least it is unclear), and the described shorthand notation can also be used for variables with only mandatory fields.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014050)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-08-2016 15:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Answer to question 1:<br />
MARK1: {1,true,&quot;hallo&quot;} (field1/field3 remain unchanged)<br />
MARK2: {&lt;undefined&gt;,true,&lt;undefined&gt;} (field1/field3 remain unchanged, i.e. undefined)<br />
MARK3: {&lt;undefined&gt;,true,&lt;undefined&gt;} (all of MyVariable3 overwrites MyVariable2)<br />
MARK4: {&lt;undefined&gt;,true,&lt;undefined&gt;} (all of MyVariable3 overwrites MyVariable4)<br />
<br />
You have the same problem when assigning fields with individual assignment statements, you have to know the history of the whole variable to know the end-result. Again, the field-assignment notation is just a shorthand for a set of field assignments of the mentioned fields in the notation.<br />
<br />
In principle, I agree with your intuition, coming from other computer languages where such a notation would simply denote a (partial) value and would then be treated as such whereever it occurs, not differently just because it is on the rhs of an assignment. In that way, the language is inconsistent with other languages and the intuition they convey.<br />
<br />
Answer to question 2:<br />
The complete notation is<br />
<br />
MyVariable := { <br />
&#160;&#160;field1 := - /* explicit unchanged */, <br />
&#160;&#160;field2 := true, <br />
&#160;&#160;field3 := - <br />
}<br />
<br />
which is again shorthand for:<br />
MyVariable.field1 := -;<br />
MyVariable.field2 := true;<br />
MyVariable.field3 := -;<br />
<br />
where, of course, the assignments with - (unchanged symbol) on the right-hand-side are NOPs.<br />
<br />
The 'shorthand' gain comes off only once you have larger structures with deep paths, that you have to repeat in each assignment statement over and over again otherwise.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014233)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-11-2016 16:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Same as CR 0007473.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014256)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-11-2016 16:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolved in CR 7473			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014311)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-11-2016 14:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				incorrectly assigned at resolve			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014368)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2016 15:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolution see in CR 7473			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
