<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:16:05 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007448: Allowing multiple encodings for TTCN-3 types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007448</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">08-07-2016 12:14</td><td class="print">12-12-2016 18:22</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.8.1 (published 2016-07)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print-category">Fixed in Version</td><td class="print">v4.9.1 (published 2017-05)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Many</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">L.M.Ericsson</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007448: Allowing multiple encodings for TTCN-3 types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Today the type of encoding of the test data is not fixed in the specification in all cases. The simplest example is that IoT common service level data is specified at the abstract level and can be encoded by XML or by JSON, in the discretion of the vendor. The abstract data structure can well be defined in TTCN-3, however the different possible types of encoding is not supported by the language.<br />
Therefore TTCN-3 shall, as well, be able to encode and decode the same abstract data structures in different encodings.<br />
<br />
We ask to resolve the CR with urgency, as oneM2M is currently writing the conformance test suite, where this problem has been raised. The project will finish by end of the year, that means they need tool support ASAP.<br />
<br />
Proposed solution can be found in the attached file. </td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007445</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></span>&#160;</td><td class="print">Part 01: TTCN-3 Core Language&#160;</td><td class="print">usage of encode/variant attributes should be enhanced&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007353</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Part 01: TTCN-3 Core Language&#160;</td><td class="print">attributes should be attachable to their definition only&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007451</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Part 01: TTCN-3 Core Language&#160;</td><td class="print">Multiple occurrence of an attribute&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007459</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Part 01: TTCN-3 Core Language&#160;</td><td class="print">the overwriting rules for attributes and the examples should be written more consistent&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007524</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></span>&#160;</td><td class="print">Part 06: TTCN-3 Control Interface&#160;</td><td class="print">TCI extension for multiple attributes&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;Allowing multiple encodings of TTCN PA3.docx (30,489) <span class="italic">08-07-2016 12:16</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3412&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-1.docx (167,050) <span class="italic">16-08-2016 16:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3464&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-V2.docx (118,202) <span class="italic">17-08-2016 15:15</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3476&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-3.docx (170,626) <span class="italic">18-08-2016 09:43</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3486&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-4.docx (129,174) <span class="italic">18-08-2016 15:28</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3492&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-5.docx (129,427) <span class="italic">19-08-2016 13:24</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3499&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-6.docx (127,120) <span class="italic">19-08-2016 14:35</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3503&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-7.docx (185,850) <span class="italic">16-11-2016 11:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3532&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-8.docx (132,164) <span class="italic">16-11-2016 15:09</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3541&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7448-9.docx (133,532) <span class="italic">17-11-2016 09:50</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3547&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">08-07-2016 12:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2016 12:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: Allowing multiple encodings of TTCN PA3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2016 10:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0007445</td></tr><tr class="print"><td class="print">11-07-2016 10:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0007353</td></tr><tr class="print"><td class="print">18-07-2016 09:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">18-07-2016 09:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">19-07-2016 16:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0013993</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2016 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">19-07-2016 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; feedback</td></tr><tr class="print"><td class="print">20-07-2016 12:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014005</td><td class="print"></td></tr><tr class="print"><td class="print">20-07-2016 12:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">20-07-2016 12:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014005</td><td class="print">bug_revision_view_page.php?bugnote_id=14005#r302</td></tr><tr class="print"><td class="print">20-07-2016 12:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014005</td><td class="print">bug_revision_view_page.php?bugnote_id=14005#r303</td></tr><tr class="print"><td class="print">20-07-2016 12:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">20-07-2016 12:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014005</td><td class="print">bug_revision_view_page.php?bugnote_id=14005#r304</td></tr><tr class="print"><td class="print">20-07-2016 16:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014012</td><td class="print"></td></tr><tr class="print"><td class="print">20-07-2016 16:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">20-07-2016 16:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; feedback</td></tr><tr class="print"><td class="print">21-07-2016 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Edited: 0014012</td><td class="print">bug_revision_view_page.php?bugnote_id=14012#r306</td></tr><tr class="print"><td class="print">21-07-2016 09:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014024</td><td class="print"></td></tr><tr class="print"><td class="print">21-07-2016 09:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">21-07-2016 09:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">02-08-2016 10:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a></td><td class="print">Note Added: 0014041</td><td class="print"></td></tr><tr class="print"><td class="print">02-08-2016 13:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014042</td><td class="print"></td></tr><tr class="print"><td class="print">02-08-2016 13:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014043</td><td class="print"></td></tr><tr class="print"><td class="print">02-08-2016 13:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0014042</td><td class="print">bug_revision_view_page.php?bugnote_id=14042#r312</td></tr><tr class="print"><td class="print">16-08-2016 16:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7448-1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 16:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014114</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 16:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">16-08-2016 16:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">16-08-2016 16:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0007451</td></tr><tr class="print"><td class="print">17-08-2016 11:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">17-08-2016 15:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR7448-V2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 15:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014134</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2016 15:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">17-08-2016 15:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">18-08-2016 09:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7448-3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014150</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">18-08-2016 09:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">18-08-2016 09:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0007459</td></tr><tr class="print"><td class="print">18-08-2016 15:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7448-4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014158</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 16:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014161</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 13:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7448-5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 13:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014178</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 13:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">19-08-2016 13:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">19-08-2016 14:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7448-6.docx</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014183</td><td class="print"></td></tr><tr class="print"><td class="print">14-11-2016 15:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014230</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7448-7.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014259</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">16-11-2016 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">16-11-2016 11:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0007524</td></tr><tr class="print"><td class="print">16-11-2016 11:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Deleted: CR7448-7.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 11:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7448-7.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 15:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7448-8.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 15:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014274</td><td class="print"></td></tr><tr class="print"><td class="print">16-11-2016 15:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">16-11-2016 15:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.9.1 (published 2017-05)</td></tr><tr class="print"><td class="print">16-11-2016 15:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">16-11-2016 15:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">17-11-2016 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; KristÃ³f Szabados</td></tr><tr class="print"><td class="print">17-11-2016 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">17-11-2016 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">17-11-2016 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">File Added: CR7448-9.docx</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 09:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Note Added: 0014288</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 09:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Assigned To</td><td class="print">KristÃ³f Szabados =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-11-2016 09:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">17-11-2016 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014300</td><td class="print"></td></tr><tr class="print"><td class="print">17-11-2016 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">17-11-2016 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">17-11-2016 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">12-12-2016 18:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0014395</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2016 18:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013993)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-07-2016 16:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The part of the proposal concerning the way how different encodings and associated variants are specified (multiple encode statements, variants with an encode prefix and a colon) is acceptable without any objections. <br />
<br />
In the case of selection the actual encoding the STF proposes to use the static approach. We assume that there's (one or more global PDU) containing potentially complicated structure of elements with multiple encodings and variants. The desired encoding and the associated set of variants will be selected by creating an alias type (or template) with a dedicated &quot;filtering&quot; attribute. Please check the following example:<br />
<br />
type Payload { <br />
&#160;&#160;&#160;&#160;XSD.Integer foo,    <br />
&#160;&#160;&#160;&#160;XSD.Float bar <br />
} with { <br />
&#160;&#160;encode &quot;XML&quot;;<br />
&#160;&#160;encode &quot;Jason&quot;;<br />
&#160;&#160;variant &quot;XML&quot;:&quot;name as uncapitalized&quot; <br />
&#160;&#160;variant &quot;Jason&quot;:&quot;name as 'dt'&quot;<br />
}<br />
<br />
type record PDU {<br />
&#160;&#160;Payload payload<br />
} with {<br />
&#160;&#160;encode &quot;XML&quot;;<br />
&#160;&#160;encode &quot;Jason&quot;;<br />
&#160;&#160;variant &quot;XML&quot;:&quot;element&quot;;  // example of an XML variant<br />
&#160;&#160;variant &quot;JSON&quot;:&quot;name as 'pd'&quot;; // example of a Jason variant<br />
}<br />
<br />
type PDU XmlPDU with { encode @only &quot;XML&quot; }<br />
// This definition removes all Jason related attributes and keeps XML (on all<br />
// levels), so that the XmlPDU type is equal to:<br />
// type record XmlPDU {<br />
//   Payload payload<br />
// } with {<br />
//   encode &quot;XML&quot;;<br />
//   variant &quot;element&quot;;<br />
//   variant(payload) &quot;name as uncapitalized&quot;;<br />
// }<br />
<br />
type PDU JasonPDU { encode @only &quot;JSON&quot; }<br />
// type record JasonPDU {<br />
//   Payload payload<br />
// } with {<br />
//   encode &quot;Jason&quot;;<br />
//   variant &quot;name as 'pd'&quot;;<br />
//   variant(payload) &quot;name as 'dt'&quot;;<br />
// }<br />
<br />
Could you please comment if the @only filter would work for you? It should be possible to write a universal test suite for XML and Jason with it. You will still need two different receive branches, but handling can be common for both of them as the type structures are equal.<br />
<br />
The main advantage of the @only modifier is that it doesn't require complicated changes in the receiving, sending, encoding and decoding statements and the impact on the TCI will be minimal. It is also easily applicable to protocol stacks.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014005)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-07-2016 12:03&#160;&#160;&#160;
				<br />(edited on:&#32;20-07-2016 12:09)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Depending on what the question is:<br />
- if @only is proposed *in addition* what the CR requests (i.e. allow types with multiple encodings, where the actual codec is chosen by the TE based on a runtime configuration parameter), it is acceptable, but is useless, superfluous; it doesn't solve dynamic encoding control either;<br />
- if all the multiple encoding problem is wanted to be solved by aliases, it is not acceptable. It is principally wrong approach. It would not need any language extension, just a clarification of overwriting rules for encode and variant attributes for aliases.<br />
<br />
Considering the below type definitions;<br />
The requested solution looks like:<br />
<br />
template PDU t_PDU := { payload := { foo := 42, bar := 5.0 }<br />
<br />
function f() runs on CT {<br />
&#160;&#160;P.send (t_PDU);<br />
&#160;&#160;alt {<br />
&#160;&#160;&#160;&#160;&#160;&#160;[] P.receive (PDU:?){...} //note, that receiving a &quot;wrongly&quot; encoded message, i.e. of encoded by the 'another' encoding causes a runtime error here<br />
&#160;&#160;}<br />
&#160;&#160;...<br />
}<br />
<br />
----------------------------------------------------------------------<br />
The code with the proposed alias solution would look like:<br />
<br />
template XmlPDU t_PDUxml := { payload := { foo := 42, bar := 5.0 }<br />
template JasonPDU t_PDUjson := t_PDUxml;<br />
<br />
function f() runs on CT {<br />
&#160;&#160;if (modulepar_encoding==&quot;XML&quot;) {P.send (t_PDUxml)};<br />
&#160;&#160;elseif (modulepar_encoding==&quot;JSON&quot;) {P.send (t_PDUjson);<br />
&#160;&#160;alt {<br />
&#160;&#160;&#160;&#160;&#160;&#160;[modulepar_encoding==&quot;XML&quot;] P.receive (XmlPDU :?){...} //note, that if receiving receiving a PDU encoded with &quot;Jason&quot; it will cause a deadlock of the component here<br />
&#160;&#160;&#160;&#160;&#160;&#160;[modulepar_encoding==&quot;Jason&quot;] P.receive (JasonPDU:?){...}// the same for receiving an &quot;XML&quot; encoded message<br />
//Pls. note, if &quot;XML&quot; encoding is expected from the SUT, but it uses &quot;Jason&quot; instead, this shall be a fail verdict as well!<br />
&#160;&#160;}<br />
&#160;&#160;...<br />
}<br />
<br />
Drawbacks of the proposed alias solution:<br />
- huge amount of superfluous code, to be written for nothing, with all its readability and other consequences (the TE could choose the needed encoding itself, instead of this, the user shall explicitly control it from the TTCN-3 code);<br />
- horrible maintain-ability: if a new, 3rd (or the 2nd) encoding is introduced, the &quot;whole&quot; TTCN-3 code has to be updated: new type aliases, new template aliases, new if~ and alt branches everywhere... if adding a new if~ or alt branch is forgotten at a single place, or a wrong template alias is used (a typical copy-paste error), the error cannot be discovered @ compile time, only @ runtime, by a wrong test case result (if, at all);<br />
for example, in standard test suites, where the code is typically written by the standard body, but is not executed, this would cause a nightmare.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014012)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-07-2016 16:07&#160;&#160;&#160;
				<br />(edited on:&#32;21-07-2016 08:25)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We propose the following solution to the dynamic problem:<br />
<br />
a) Keep the @only modifier for static filtering (for the users that might find some use of it).<br />
b) Introduce a dynamic solution using a new encode statement:<br />
( PortReference | &quot;all&quot; &quot;port&quot; | &quot;self&quot;) &quot;.&quot; encode &quot;(&quot; (Type | all) &quot;,&quot; Expression &quot;)&quot;<br />
<br />
The encode statement would activate an encoding filter for a particular port, all port or a whole component. The filter would apply to a particular type, its part (useful for protocol stacks) or to all messages passed to the codec. It would basically do the same thing as the @only modifier, but dynamicly.<br />
<br />
Example for our XML/Jason case:<br />
modulepar universal charstring ENCODING; // set to &quot;XML&quot; by TCI-TM <br />
self.encode(PDU, ENCODING); // Disables all encodings that are not &quot;XML&quot; <br />
&#160;&#160;&#160;&#160;// and variants related to them<br />
p.send(PDU:{...}}; // When the message is sent out, only the &quot;XML&quot; encode<br />
&#160;&#160;&#160;&#160;// attribute and related &quot;XML&quot; variants are visible to the codec<br />
<br />
// in order to go through all encodings:<br />
type record of universal charstring TEnc;<br />
var TEnc v_enc := {...} // dynamically specify acceptable encodings<br />
var integer i := 0;<br />
p.encode(PDU, v_enc[i]);<br />
alt {<br />
&#160;&#160;[] p.receive(PDU:?)<br />
&#160;&#160;// [] ... other alternatives<br />
&#160;&#160;[else] {<br />
&#160;&#160;&#160;&#160;&#160;i := i + 1;<br />
&#160;&#160;&#160;&#160;&#160;if (i &lt; lengthof(v_enc)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;p.encode(PDU, v_enc[i]);<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;repeat;<br />
&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
The advantage of this approach is that we don't have to change the syntax of the sending/receiving operations and of the enc_value and dec_value functions. It contains support of protocol stacks as an extended type reference can be used as the first parameter.<br />
<br />
Gyorgy, could you please say if it is acceptable for you?<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014024)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				21-07-2016 09:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				If I understand correctly:<br />
- several encode attributes can be attached to a type (group module ...) and variant attributes can be scoped with the syntax proposed by the CR;<br />
- P.encode(PDU,modPar_encoding); activates a concrete encoding to a given port<br />
- all port.encode(PDU,modPar_encoding); activates a concrete encoding to all ports of the given component, but NOT for encvalue/decvalue-s<br />
- self.encode(PDU,modPar_encoding); activates a concrete encoding to all ports AND encvalue/decvalue-s of the given component<br />
- in addition, a new optional parameter will allow select/change the default encoding for individual encvalue/decvalue/encvalue_unichar/decvalue_unichar calls<br />
<br />
This solution, as a whole, is fine with me.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014041)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=862">Martin Hauch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-08-2016 10:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Questions:<br />
Where are the types defined, which should be used for &quot;JSON&quot; and &quot;XML&quot; coding?<br />
Definitions from XSD:<br />
&quot;Part 9: Using XML schema with TTCN-3&quot; does not define variant &quot;XML&quot;:&quot;element&quot;; (or other &quot;XML&quot; renamings for elements or attributes). Current &quot;Part 11: Using JSON with TTCN-3&quot; does not define variant &quot;JSON&quot;:name as 'pd'&quot;<br />
Should the syntax for variant attributes be changed to bind the variant-atrribute information to an encoding-rule in case of more than 1 encoding-rule is assigned?<br />
How should JSON-variants be added to these from XSD converted types?<br />
How should xsd-defined types be encoded in JSON?<br />
<br />
Definitions from TTCN:<br />
I think this should work. The encode- and variant-attributes could be defined for all types (as shown in your example), respecting the possible attribute-values defined in the documents &quot;Part 9: Using XML schema with TTCN-3&quot; and &quot;Part 11: Using JSON with TTCN-3&quot;.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014042)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-08-2016 13:03&#160;&#160;&#160;
				<br />(edited on:&#32;02-08-2016 13:46)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thanks Martin, good points.<br />
I think both Part-9 and draft Part-11 shall be updated to allow generating the variant scopings automatically (for backward compatibility and readibility reasons this should be a user-choice converter configuration parameter).<br />
As JSON doesn't have a schema, no JSON encoding instructions can be generated automatically, they always need to be added manually to TTCN-3 files. Therefore, the output of an XML converter need to be decorated with JSON variant attributes manually.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014043)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-08-2016 13:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				During the internal discussions we were also discussing a possible compact syntax to assign an encoding instruction to multiple encode-s, something like<br />
<br />
variant (resourceName){&quot;XML&quot;,&quot;JSON&quot;}:&quot;name as 'rn'&quot;;<br />
<br />
at the end this feature wasn't included into the initial proposal, to keep it simple.<br />
<br />
However, now ETSI has raised the same issue, as the main attribute to be used in the IoT conformance tests is name as, which is the same in both XML and JSON. Another ETSI's point is that e.g. if a new, 3rd encoding is added, it is easier to add the name of the new encoding to the list of encodes, than copy-paste-change all the variants for the new encoding, which would make the code long, nasty and hardly readable.<br />
<br />
Could you please also consider a compact syntax, to add an encoding instruction to multiple encodings by a single variant?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014114)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2016 16:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposal uploaded. The document also contains a resolution for all related CRs. Please check. 			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014134)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2016 15:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please check again. Ericsson should also proofread before resolving the issue.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014150)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-08-2016 09:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I am fine with the corrections. I only made a couple of minor formating changes in the document.<br />
<br />
Kristóf, could you please look at the document too and discuss the matter with György?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014158)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-08-2016 15:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have added/changed multiple places according to our discussions.<br />
<br />
Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014161)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-08-2016 16:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi, in general the proposal looks fine, but a few comments/questions:<br />
<br />
1)	Regarding the @local modifier I’m not sure if it’s really needed: while it complicates the language and the tools, I can see little practical use. Let see the example from the standard:<br />
&#160;&#160;&#160;&#160;module M {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record MyRec {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer field1,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer field1,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;} with { encode @local &quot;CodecB&quot; } <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// the record type MyRec will be encoded with CodecB, but its fields with CodecA,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// because local attribute CodecB doesn’t affect elements of the MyRec type.<br />
&#160;&#160;&#160;&#160;} with { encode &quot;CodecA&quot; }<br />
<br />
In reality, typically protocol messages and their fields have encode attributes, in which case fields are practically always some constrained types, having their own type definitions (and thus inheriting the attribute associated to the group/module). Maybe boolean fields are exceptions, but I haven’t seen any of them being encoded differently than the enclosing type; and if, it is more intuitive to add their encoding to the field directly (than to understand what @local means):<br />
&#160;&#160;&#160;&#160;module M {<br />
<br />
type integer (0..255) Intfield;<br />
<br />
type record MyRec {<br />
&#160;&#160;Intfield field1,<br />
&#160;&#160;Intfield field2,<br />
&#160;&#160;boolean field3<br />
} with { encode &quot;CodecB&quot;;//this does not apply to fields field1 and field2 acc. to the previous rule<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;encode (field3) “CodecA”}<br />
} with { encode &quot;CodecA&quot; }<br />
<br />
2)	I think it would be more secure if variant attribute without encode reference is allowed only, if there is just a single encode applied to the scope (i.e. not to have &quot;global variant&quot;s). Once a new encoding is added to a module, all variants has to be re-checked anyway, during which it is easy to copy-paste the encoding scope in front of the already existing variant. But with the current &quot;global variant&quot; rule, variants forgotten to be cross-checked and scoped, will automatically start effecting on the new encoding as well.<br />
<br />
3)	If considering the example:<br />
&#160;&#160;&#160;&#160;// Modifying list of allowed encodings<br />
&#160;&#160;&#160;&#160;type Int Int2 with { <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;encode &quot;CodecA&quot;; // variants &quot;CodecA&quot;.&quot;Rule1&quot; and &quot;GlobalRule&quot; are kept<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;encode &quot;CodecC&quot;; variant &quot;CodecC&quot;.&quot;Rule6&quot;; // new encoding and related variant<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// &quot;CodecB&quot; encoding and related variant are discarded as &quot;CodecB&quot; is not <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// explicitly referenced <br />
&#160;&#160;&#160;&#160;}<br />
<br />
It is unclear why the @only modifier is needed.<br />
In the example <br />
&#160;&#160;&#160;&#160;// Selecting encoding with an @only modifier<br />
&#160;&#160;&#160;&#160;type MyRecord MyRecord2 with { <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;encode @only (field1) &quot;CodecB&quot;; // field1 will be encoded with CodecB<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;encode @only &quot;CodecA&quot; // the record and field2 will be encoded with CodecA <br />
&#160;&#160;&#160;&#160;}<br />
Applying encode (field1) &quot;CodecB&quot; and encode &quot;CodecA&quot; would have exactly the same effect: whatever other encodings applied to MyRecord and MyRecord.field1 are simply discarded.<br />
<br />
4)	Has ETSI’s request to allow associating a variant to several encodings with a single statement been considered? Example (syntax below is appropriate, any suitable syntax will do it):<br />
&#160;&#160;&#160;&#160;module M {<br />
type record MyRecX {<br />
&#160;&#160;Intfield field1,<br />
&#160;&#160;Intfield field2,<br />
&#160;&#160;boolean field3<br />
} with { variant(field1) {&quot;CodecA”,”CodecB”}.”name as ‘f1’”;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;variant(field2) {&quot;CodecA”,”CodecB”}.”name as ‘f2’”;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;variant(field3) {&quot;CodecA”,”CodecB”}.”name as ‘f3’”}<br />
<br />
} with { encode &quot;CodecA&quot; }			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014178)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-08-2016 13:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added clarification, that variants without explicit encoding relation are implicitly related to all encodings in effect.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014183)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-08-2016 14:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added example to show the difference between encodes with and without @only.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014230)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-11-2016 15:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
1) @local will be kept<br />
2) no global variants for multiple encodings<br />
4) one variant for multiple encodings by explicit naming<br />
<br />
3) @only will be skipped (no different scope level, same scope level)<br />
<br />
- Precedence rules for 3) will be checked for tools represented in STF.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014259)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-11-2016 11:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Specification updated according to STF discussion conclusion. Please review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014274)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-11-2016 15:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added a missing closing parenthesis in BNF, otherwise ok, ready for implementation			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014288)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=361">KristÃ³f Szabados</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-11-2016 09:52&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Corrected some typos.<br />
Added a note before example 4.<br />
Corrected example in section 27.9 (in the testcase ContainerType needed to be changed to PDU as that is the name of the type)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014300)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-11-2016 11:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK, ready for implementation.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014395)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2016 18:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft V4.8.2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
