<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:16:27 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007200: Allow ranges and value list for enumerated types - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007200</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">15-10-2015 09:14</td><td class="print">10-12-2015 16:54</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">tepelmann</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.8.1 (published 2016-07)</td><td class="print-category">Fixed in Version</td><td class="print">v4.8.1 (published 2016-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6.2.4, C.1.30</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007200: Allow ranges and value list for enumerated types</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The type enumerated provides the tester with meaningful values during development and execution without the necessity to interpret specific values.<br />
However there is one disadvantage in cases where not all possible values are specified inside the enumerated, e.g. reserved values. This occurs in the majority of protocol specifications.<br />
Simple example: A 8Bit enocded enumerated Color - <br />
type enumerated Color {<br />
&#160;&#160;e_red(0),<br />
&#160;&#160;e_green(1),<br />
&#160;&#160;e_blue(2),<br />
&#160;&#160;e_reserved<br />
}<br />
<br />
On the sending side it is not possible to select all values - e_reserved has only one value: 3, where values between 0 and 255 would be selectable.<br />
On the receiving side there are two possible pitfalls in case of receiving a value not expressed by the enumerated type. Either you get an error because the value is not assignable, or you have special decoding mapping the unassignable value to 'reserved' but loosing the actual value.<br />
<br />
Proposal: Allow ranges and value list for the type enumerated<br />
E.g.<br />
type enumerated Color {<br />
&#160;&#160;e_red(0),<br />
&#160;&#160;e_green(1),<br />
&#160;&#160;e_blue(2),<br />
&#160;&#160;e_reserved(3..255)<br />
}<br />
<br />
type enumerated Color {<br />
&#160;&#160;e_red(0),<br />
&#160;&#160;e_green(1),<br />
&#160;&#160;e_blue(3),<br />
&#160;&#160;e_reserved(2,4..255)<br />
}<br />
<br />
For the sending(and receiving) side the explicit value of 'reserved' could be expressed in brackets - reserved(127).<br />
For receiving - where the actual value is unknown beforehand - the actual value could be retrieved via the existing enum2int predefined function.<br />
<br />
If the explicit value is not given the lowest possible value could be used by default - this is the current behaviour.<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7200.docx (520,017) <span class="italic">04-11-2015 17:14</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3364&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7200-1-v2.docx (254,422) <span class="italic">05-11-2015 14:08</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3368&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7200-1-v3.docx (314,507) <span class="italic">09-12-2015 15:47</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3389&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">15-10-2015 09:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">02-11-2015 08:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Note Added: 0013432</td><td class="print"></td></tr><tr class="print"><td class="print">03-11-2015 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013480</td><td class="print"></td></tr><tr class="print"><td class="print">03-11-2015 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">03-11-2015 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">04-11-2015 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.8.1 (published 2016-07)</td></tr><tr class="print"><td class="print">04-11-2015 17:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7200.docx</td><td class="print"></td></tr><tr class="print"><td class="print">04-11-2015 17:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013493</td><td class="print"></td></tr><tr class="print"><td class="print">04-11-2015 17:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">04-11-2015 17:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">05-11-2015 14:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0013501</td><td class="print"></td></tr><tr class="print"><td class="print">05-11-2015 14:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR7200-1-v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">05-11-2015 14:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">05-11-2015 14:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">05-11-2015 14:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">06-11-2015 08:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0013480</td><td class="print">bug_revision_view_page.php?bugnote_id=13480#r214</td></tr><tr class="print"><td class="print">09-12-2015 15:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR7200-1-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2015 15:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR7200-1-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2015 15:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR7200-1-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2015 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013571</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2015 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">09-12-2015 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.8.1 (published 2016-07)</td></tr><tr class="print"><td class="print">09-12-2015 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">10-12-2015 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013582</td><td class="print"></td></tr><tr class="print"><td class="print">10-12-2015 16:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013432)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-11-2015 08:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Real world example: 3GPP TS 24.008, 10.5.3.3 CM service type:<br />
Service type (octet 1)<br />
Bits<br />
4	3	2	1	<br />
0	0	0	1	Mobile originating call establishment or packet mode connection establishment<br />
0	0	1	0	Emergency call establishment<br />
0	1	0	0	Short message service<br />
1	0	0	0	Supplementary service activation<br />
1	0	0	1	Voice group call establishment<br />
1	0	1	0	Voice broadcast call establishment<br />
1	0	1	1	Location Services	(NOTE)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<br />
All other values are reserved.<br />
<br />
Could result in:<br />
type enumerated CM_ServiceType {<br />
&#160;&#160;e_mobileOrigCallEstab_packetModConEstab(1),<br />
&#160;&#160;e_emergCallEstab(2),<br />
&#160;&#160;e_sms(4),<br />
&#160;&#160;e_supplServAct(8),<br />
&#160;&#160;e_voiceGroupCallEstab(9),<br />
&#160;&#160;e_voiceBcastCallEstab(10),<br />
&#160;&#160;e_locServices(11),<br />
&#160;&#160;reserved(3, 5..6, 12..15)<br />
}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013480)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-11-2015 16:42&#160;&#160;&#160;
				<br />(edited on:&#32;06-11-2015 08:53)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: practical usefulness is agreed. The &quot;range&quot; enumerated names can be used as TTCN-3 values with concrete associated integer values only. Otherwise they can be used in templates.<br />
Prepare a concrete proposal.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013493)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-11-2015 17:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added proposal allowing enum ranges, enum values with single integer and enum templates with integer template list<br />
<br />
please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013501)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-11-2015 14:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Corrected one or two typos.<br />
<br />
György: In this resolution, Jacob also corrected examples on page 12 of the attachment which are not directly related to enum ranges. Please check them also. For this reason a put this issue to confirm instead of resolved.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013571)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2015 15:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				1 example causing error is added to $6.2.4 (enumerated value with associated integer is used) plus editorials.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013582)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-12-2015 16:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft V4.7.4			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
