<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:15:48 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007174: New matching mechanism: matching by function - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Ext Pack: Advanced Matching (ES 203 022)</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007174</td><td class="print">Ext Pack: Advanced Matching (ES 203 022)</td><td class="print">New Feature</td><td class="print">public</td><td class="print">11-09-2015 08:57</td><td class="print">24-12-2016 12:01</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v1.1.1 (published 2017-07)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.7, B.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr class="print"><td class="print-category">TS version</td><td class="print" colspan="4"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007174: New matching mechanism: matching by function</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Current TTCN-3 matching mechanisms are very efficient in dealing with quite many standard situations. However, there's always possibility that matching conditions are too complicated and none of the matching mechanisms can be used. The typical solution in this case is performing additional checking in the code block attached to receive statements. <br />
<br />
This approach has unfortunately quite many drawbacks that are mostly related to the jump out of the snapshot mechanism. For that reason I propose a new matching mechanism that would allow the users to define their own custom matching procedure.<br />
<br />
Syntax:<br />
<br />
function match FunctionIdentifier<br />
// NOTE: there might be more elegant syntax options. The current proposal <br />
// advantage is that it uses existing keywords and pretty well describes<br />
// the functionality<br />
<br />
Semantics:<br />
FunctionIdentifier shall be a reference to a function that accepts a single in value parameter and returns boolean. The matching mechanism matches values of the same type or compatible type as the type of the parameter. <br />
<br />
When matching, the referenced function is called with the matched value passed to it as an actual parameter. Succesful match is achieved only if the function returns true.<br />
<br />
Restrictions:<br />
a. When used in receiving communication operations, rules from the section 16.1.4 apply.<br />
b. An error shall be produced when the referenced function returns something else than a boolean value.<br />
c. An error shall be produced when the referenced function contains a different number of parameter than 1.<br />
d. An error shall be produced when the parameter of the referenced function is not an in value paremeter.<br />
<br />
Required modifications in other rules: <br />
15.6: the matching mechanism doesn't allow to reference subfields and it should be therefore listed in 15.6.2.a, 15.6.3.b, 15.6.4.a, 15.6.5.a<br />
<br />
Example:<br />
<br />
type record R {  <br />
&#160;&#160;charstring startDate,<br />
&#160;&#160;charstring endDate<br />
}<br />
<br />
function f_extractMonth(charstring p_date) return integer {<br />
&#160;&#160;// unspecified algorithm to extract month from a string-based date<br />
}<br />
<br />
function f_isMonthTheSame(in R p_rec) return boolean {<br />
&#160;&#160;return f_extractMonth(p_rec.startDate) == f_extractMonth(p_rec.endDate);<br />
}<br />
<br />
template R mw_monthMatch := function match f_isMonthTheSame;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007494</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">TRI and TCI extensions for advanced matching&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007175</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">No easy way to describe conjunction matching mechanism.&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0007167</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">Matching mechanism to match multiple items in arrays, records and sets of single types&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/ppt.gif" alt="pptx" />&#160;Dynamic-Matching-Templates-Ideas-160722.pptx (31,688) <span class="italic">22-07-2016 13:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3434&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7174.docx (147,228) <span class="italic">16-08-2016 09:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3450&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7174-v2.docx (148,644) <span class="italic">16-08-2016 11:44</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3459&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7174-3.docx (167,385) <span class="italic">18-08-2016 15:23</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3491&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7174-4.docx (170,169) <span class="italic">19-08-2016 15:08</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3505&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">11-09-2015 08:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">11-09-2015 10:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013196</td><td class="print"></td></tr><tr class="print"><td class="print">11-09-2015 10:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0013196</td><td class="print">bug_revision_view_page.php?bugnote_id=13196#r162</td></tr><tr class="print"><td class="print">11-09-2015 10:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0013196</td><td class="print">bug_revision_view_page.php?bugnote_id=13196#r163</td></tr><tr class="print"><td class="print">11-09-2015 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a></td><td class="print">Note Added: 0013197</td><td class="print"></td></tr><tr class="print"><td class="print">21-09-2015 10:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">related to 0007175</td></tr><tr class="print"><td class="print">21-09-2015 10:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.8.1 (ongoing)</td></tr><tr class="print"><td class="print">21-09-2015 11:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">related to 0007167</td></tr><tr class="print"><td class="print">22-09-2015 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013237</td><td class="print"></td></tr><tr class="print"><td class="print">22-09-2015 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0013237</td><td class="print">bug_revision_view_page.php?bugnote_id=13237#r171</td></tr><tr class="print"><td class="print">24-09-2015 13:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013289</td><td class="print"></td></tr><tr class="print"><td class="print">25-09-2015 10:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013301</td><td class="print"></td></tr><tr class="print"><td class="print">30-09-2015 15:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a></td><td class="print">Note Added: 0013342</td><td class="print"></td></tr><tr class="print"><td class="print">01-10-2015 08:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013343</td><td class="print"></td></tr><tr class="print"><td class="print">01-10-2015 09:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013344</td><td class="print"></td></tr><tr class="print"><td class="print">01-10-2015 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a></td><td class="print">Note Added: 0013345</td><td class="print"></td></tr><tr class="print"><td class="print">01-10-2015 11:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0013346</td><td class="print"></td></tr><tr class="print"><td class="print">01-10-2015 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0013346</td><td class="print">bug_revision_view_page.php?bugnote_id=13346#r175</td></tr><tr class="print"><td class="print">03-11-2015 11:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.8.1 (ongoing) =&gt; Next version (to be defined)</td></tr><tr class="print"><td class="print">03-11-2015 11:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0013465</td><td class="print"></td></tr><tr class="print"><td class="print">03-11-2015 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0013465</td><td class="print">bug_revision_view_page.php?bugnote_id=13465#r200</td></tr><tr class="print"><td class="print">05-11-2015 11:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">Part 01: TTCN-3 Core Language =&gt; Ext Pack: Advanced Matching (ES 203 022)</td></tr><tr class="print"><td class="print">05-11-2015 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print">v4.7.1 (published 2015-06) =&gt; </td></tr><tr class="print"><td class="print">05-11-2015 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">Next version (to be defined) =&gt; v1.1.1 (published 2017-07)</td></tr><tr class="print"><td class="print">18-07-2016 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">18-07-2016 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">22-07-2016 13:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: Dynamic-Matching-Templates-Ideas-160722.pptx</td><td class="print"></td></tr><tr class="print"><td class="print">15-08-2016 13:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">15-08-2016 16:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7174.docx</td><td class="print"></td></tr><tr class="print"><td class="print">15-08-2016 16:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014081</td><td class="print"></td></tr><tr class="print"><td class="print">15-08-2016 16:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">15-08-2016 16:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">16-08-2016 09:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Deleted: CR7174.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 09:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7174.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 09:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0014087</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR7174-v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0014103</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2016 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">16-08-2016 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">18-08-2016 15:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7174-3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 15:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Relationship added</td><td class="print">related to 0007494</td></tr><tr class="print"><td class="print">18-08-2016 15:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0014157</td><td class="print"></td></tr><tr class="print"><td class="print">18-08-2016 15:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">18-08-2016 15:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">19-08-2016 15:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR7174-4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0014188</td><td class="print"></td></tr><tr class="print"><td class="print">19-08-2016 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">19-08-2016 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">14-11-2016 10:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">17-11-2016 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">17-11-2016 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">24-12-2016 12:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013196)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-09-2015 10:07&#160;&#160;&#160;
				<br />(edited on:&#32;11-09-2015 10:09)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I second the proposal. Since other templates can also use functions for initialization, there is no new problem concerning the Halting Problem with these new functions.<br />
<br />
Also, since no object can be both of type T and of type T =&gt; boolean, it would probably be sufficient to just allow any deterministic function-reference of type function(T x) return boolean as matching mechanism for a template of type T.<br />
<br />
I.e. <br />
<br />
I would also simply allow:<br />
<br />
template R x := f<br />
<br />
if f is of type function(R y) return boolean.<br />
<br />
Since this at the moment is a semantic error, there is no backward compatibility issue with that.<br />
<br />
If used in modifies, it should be replaced fully (if it is part of the base template) or replace fully if it is in the modifying template.<br />
<br />
I'm a bit against using 'function' as a keyword for that matching mechanism as this will make error-recovery for parsers harder which rely on declaration-keywords. In that case, I would prefer a modifier @matching or simple @is, i.e.<br />
<br />
template R x := @matching f<br />
<br />
or <br />
<br />
template R x := @is f<br />
<br />
This @is is motivated by the fact that boolean functions are normally considered semantically equivalent to predicates and for a predicate P 'P(v)' is the same as 'v is P'.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013197)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-09-2015 10:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have no problem with the proposed modifiers. However, I would prefer not to use function identifiers directly because of a negative impact on readability of the code. The syntax looks the same as a variable/template reference and if naming convensions are not strictly followed, the real meaning of the matching mechanism won't be immediately obvious. It is probably also more complicated to implement it than the solution with a modifier.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013237)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-09-2015 11:35&#160;&#160;&#160;
				<br />(edited on:&#32;22-09-2015 11:40)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
- the feature is useful<br />
- the body shall be deterministic and without side effects to snapshots<br />
- its declaration is open yet: it can be a new language &quot;class&quot; user defined matching mechanism or a function with a specific prototype. This to be decided.<br />
- Parameterization to be allowed, but the concrete syntax still need to be agreed.<br />
- Alternative idea defining dynamic templates with a function-like body (see restrictions above) and returning boolean (without a return clause in the header).<br />
- A new package for advanced matching is to be considered.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013289)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-09-2015 13:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Syntactically, I would propose the following:<br />
<br />
@dynamic template ReferencedType Identifier[FormalParList] StatementBlock<br />
<br />
In the body part, I would refer to the argument per default as _ (single underscore).<br />
<br />
In easy expressions, this looks like this:<br />
<br />
return _ &gt; 5;<br />
<br />
If a name should be given to the parameter, it can be done by simple variable/constant declaration:<br />
<br />
var T x := _;<br />
<br />
This way, there is no need for an additional syntactical way of declaring the template-instance-parameter name and it is still possible to give it a name, if so desired.<br />
<br />
The underscore does not clash with the normal identifiers as they need to start with a letter.<br />
<br />
Alternatively, we could allow the following lambda-closure-like syntax:<br />
<br />
@dynamic template ReferencedType Identifier[FormalParList] &quot;:=&quot; &quot;(&quot; Identifier &quot;)&quot; &quot;=&gt;&quot; StatementBlock<br />
<br />
where the Identifier before the &quot;=&gt;&quot; is the name of the value to be matched<br />
<br />
This would actually also work great with inline-templates:<br />
<br />
T:(x) =&gt; { ... }<br />
<br />
because<br />
<br />
T:{ ... } needs possibly indefinite parser lookahead (you need to find out if the block begins with a statement of with a field assignment or with an element) to distinguish from non-dynamic templates.<br />
<br />
If not going with the lambda-notation, inline dynamic templates thus need also be prefixed with the @dynamic modifier:<br />
<br />
p.receive(@dynamic T:{...})<br />
<br />
Additionally, as a shorthand notation for statement blocks that only contain a return statement, we could use the declarative notation:<br />
<br />
@dynamic template ReferencedType Identifier[FormalParList] := [(Identifier) =&gt;] BooleanExpression<br />
<br />
as in (if isOdd is a @deterministic boolean function with an integer formal parameter):<br />
<br />
@dynamic template integer odd := isOdd(_);<br />
<br />
or inline<br />
<br />
@dynamic integer:isOdd(_) <br />
<br />
or <br />
<br />
@dynamic template integer odd := (x) =&gt; isOdd(x);<br />
<br />
or inline<br />
<br />
@dynamic integer:(x) =&gt; isOdd(x)<br />
<br />
For the very common pattern: (x) =&gt; f(x), we could also allow just f, which would shorten the above to:<br />
<br />
@dynamic template integer odd := isOdd;<br />
or inline<br />
@dynamic integer:isOdd<br />
<br />
Finally, for places where the type of the template is already known, i.e. for template fields or template parameters, we could allow both<br />
<br />
(Identifier) =&gt; BooleanExpression, <br />
(Identifier) =&gt; StatementBlock and <br />
BooleanFunctionReference<br />
<br />
(maybe the last thing should be (optionally or mandatory) prefixed with @dynamic)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013301)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-09-2015 10:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thinking about this some more, I think it is probably best to not allow the underscore-notation. It is too abstract and also not compositional (i.e. if in the body of the function, another inline template is used, the inner _ would shadow the outer _ and that is normally not allowed in TTCN-3.<br />
<br />
The notation<br />
<br />
(x) =&gt; BooleanExpression <br />
<br />
also has the drawback that you potentially need indefinite look-ahead in the parser (if using LL-approach) to determine that it is not the (x) =&gt; StatementBlock notation (in the special, though probably pathological case that the boolean expression starts with a compound value, like in { ... } == x. Limiting the syntax of the BooleanExpression to a subset that does not clash in prefix with the StatementBlock is not good language design, either.<br />
<br />
So, the remaining syntaxes would be:<br />
<br />
(x) =&gt; StatementBlock<br />
<br />
FunctionReference (for the special case (x) =&gt; { return f(x) }), possibly with a modifier in front like @dynamic or @match or @is.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013342)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-09-2015 15:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think it is better to keep things as simple as possible. Parameter passing can be resolved by using lambda closure in a similar way as in the case of @lazy and @fuzzy variables.<br />
<br />
From the syntactical point of view, I would skip the (x) part completely and use a modifier as a prefix followed always by a statement block. This kind of syntax should be easy to parse and won't cause any grammar conflicts. The syntax would be then:<br />
<br />
modifier StatementBlock<br />
<br />
For referencing the matched value, I would use a universal identifier such as &quot;value&quot;. The value keyword is already present in TTCN-3 and it is commonly used as a context-specific variable identifier (e.g. in C#).<br />
<br />
Examples:<br />
// @dynamic modifier is used, but any of Jacob's proposed alternatives is fine<br />
<br />
// simple dynamic template<br />
template integer mw_greaterThan2 := @dynamic { return value &gt; 2; }<br />
<br />
// parameterized dynamic template<br />
template integer mw_greaterThanParam(integer p_par) := @dynamic { return value &gt; p_par; }<br />
<br />
// calling a function<br />
template integer mw_matchByFunction := @dynamic { return f_myFunc(value); }<br />
<br />
// when used inside a block<br />
function f_createTemplate() return template integer<br />
{<br />
&#160;&#160;var integer v_var1, v_var2;<br />
&#160;&#160;// ... compute v_var1 and v_var2<br />
<br />
&#160;&#160;// lambda closure required to keep the values of v_var1 and v_var2 after exiting the function<br />
&#160;&#160;return @dynamic { return value * v_var1 &gt; v_var2; };<br />
}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013343)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-10-2015 08:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I am fine with this proposal (although it complicates the implementation of the compilation frontend quite a bit).<br />
<br />
It is also compositional (if a dynamic template uses another dynamic template inside its body, it must simply declare a variable/constant referring to the value so that the inner template can access it (as the inner 'value' shadows that outer 'value'). <br />
<br />
It cannot clash with the normal use of the value-keyword as inside such bodies, no blocking or otherwise state-changing statements are allowed.<br />
<br />
It would still like to have a shorthand version for the @dynamic { return f(value) } template. Either <br />
<br />
@dynamic &lt;FunctionReference&gt; (which is clearly distinguished syntactically as &lt;FunctionReference&gt; must start with an identifier and the other starts with opening bracket '{')<br />
<br />
or using a different modifier like @is or @match (which is simply more readable but introduces another modifier)<br />
<br />
For the last example you gave (which produced the closure), I would add a restriction that a dynamic template shall not reference their context's inout or out parameters or their sub-structures as the target of an assignment (or not at all, to avoid confusion). That way, there is no need to explain what the semantics of such an assignment would be.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013344)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-10-2015 09:18&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thinking some more on this, I would actually disallow any reference to any variable or parameter (except read-access to the template-parameters if we are contextually inside a parameterized template because they cannot change) inside a @dynamic body.<br />
<br />
consider the following example:<br />
function g(template integer p) {<br />
}<br />
<br />
function f(integer p) return template integer {<br />
&#160;&#160;var template integer t := @dynamic { value &gt; p };<br />
&#160;&#160;while (...) {<br />
&#160;&#160;&#160;&#160;ptc.start(g(t));<br />
&#160;&#160;&#160;&#160;p := ...;<br />
&#160;&#160;&#160;&#160;ptc.done;<br />
&#160;&#160;}<br />
}<br />
<br />
Here, it would be unclear that the reference p inside the lambda-template when used by g would be and even worse, there is suddenly some data-sharing between the component running f and the one running g. Similar things are true if write-access to outside-variables by the dynamic template were allowed.<br />
<br />
If we restrict that the only things from outside the dynamic block that can be referenced are const and non-var template and formal parameters of the containing template, this cannot happen.<br />
<br />
Of course, in your lambda-example, this would lead to the inconvenience that v_var1 and v_var2 need to be copied to const c_1 and c_2 and referenced as these from the dynamic block.<br />
<br />
If this restriction is not added, then a different semantics needs to be given to references of outside-variables inside a dynamic block, i.e. they are implicit formal in parameters whose initial value is the one their outside-namesake has when the @dynamic block is instantiated. While this approach is a little bit more convenient for the user, it has a level of implicitly that might be confusing (it could also be added later if the restrictive approach is deemed to cumbersome).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013345)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=787">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-10-2015 10:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Well written, Jacob! I didn't notice the component issue at all.<br />
<br />
1. I like the explanation you provided for the direct function call notation, i.e. that @dynamic FunctionIdentifier is a shorthand for @dynamic { return FunctionIdentifier(value); }<br />
<br />
This so far the best explanation and completely in-line with similar shortcuts that are already present in the TTCN-3 specification.<br />
<br />
2. For the closure issues I propose two semantic restrictions:<br />
<br />
a. In the statement block of the @dynamic matching mechanism, only variables defined in this block can appear on left hand side of an assignment and as an actual parameter of formal out and inout parameters. Using any other variable in these place shall produce an error.<br />
-&gt; This restriction should prevent the assignment issue already in the compilation stage. We don't have to use copying which might be actually undesirable, because in some cases the user might want to compare the matched value against the actual variable value.<br />
<br />
b. Templates containing a @dynamic matching mechanism created in functions, test cases or altsteps running on a main or parallel test component cannot be used as a parameter of a function referenced in a component.start operation. Using such a template shall produce an error.<br />
-&gt; The rule should prevent possibility of dynamic access to other component variables.<br />
<br />
I agree that compilation might be complicated, because the mechanism itself is not strongly typed, but the type should be always visible from the the context:<br />
<br />
template MyType mw_t1 := @dynamic{...} // type from the template definition<br />
template MyRec mw_t2 := {<br />
&#160;&#160;&#160;field1 := ?<br />
&#160;&#160;&#160;field2 := @dynamic {...} // typed according to MyRec.field2 definition<br />
}<br />
p.receive(MyType:@dynamic {...}); // using inline type<br />
f_func(@dynamic {...}); // using function parameter type			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013346)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-10-2015 11:06&#160;&#160;&#160;
				<br />(edited on:&#32;01-10-2015 11:08)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I don't think that your restriction b. is a good idea as in general it can only be checked at runtime (can only be statically checked if the @dynamic template is actually part of the start-statement). Runtime-checks always introduce inefficiency during execution and also have the drawback that often standardization-bodies do not execute their tests and thus errors come to light only much later and it takes a lot of time until they are officially fixed.<br />
<br />
The restrictions I proposed are easily checked statically (at compile-time), even though they introduce some inconvenience to the usage (though not much, you could easily declare all the variables-to-be-used as const from the beginning and then simply initialize with the computed value directly). <br />
<br />
Otherwise, I would rather opt for the copy-semantics, i.e. <br />
<br />
if the variables/parameters (not parameters of the enclosing parameterized template) V1 ... Vn which are not declared but used in the @dynamic B body B have the types T1 ... Tn respectively, the semantics of @dynamic B is the same as t(V1, ..., Vn) where t is an implicit generic template t(T1 V1, ..., Tn Vn) := @dynamic B (with this semantic trick a copy of each variable at the time of template instantiation is used in B).<br />
<br />
The frontend-issue I mentioned is more the problem that suddenly the value-keyword can be used as an identifier in a certain context and it is context-dependent whether it shall be interpreted as a keyword or as an identifier. It's not an unsolvable problem, but it is tricky.<br />
<br />
The type of the 'value' keyword, of course, is always the type of the whole dynamic template, so that type always must be known, either by the inline-template-type-prefix or because the template is used in a context whose type is known.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0013465)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-11-2015 11:56&#160;&#160;&#160;
				<br />(edited on:&#32;03-11-2015 11:59)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				To be part of the new extension on advanced matching mechanisms.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014081)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-08-2016 16:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added main section and BNF changes.<br />
<br />
Please review.<br />
<br />
Still missing: TCI changes.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014087)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2016 09:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				refined the restriction on in parameters to be more airtight			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014103)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2016 11:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Tomas: Can you proofread the text and add a section on TCI changes if needed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014157)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-08-2016 15:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Minor changes made (shorted name of the matching mechanism: dynamic matching function -&gt; dynamic matching, qualified function name), assigned to Axel for proofreading.<br />
<br />
TRI and TCI will be handled separately in its own CR <a href="/mantis/view.php?id=7494" title="[closed] TRI and TCI extensions for advanced matching" class="resolved">0007494</a>.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0014188)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-08-2016 15:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				modified (naming conventions, font corrections, additional comment in example) proposal can be used for the final draft			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
