<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:18 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006698: Missing functionality to cast &quot;template&quot; to &quot;template (present)&quot; - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006698</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">06-03-2014 10:58</td><td class="print">19-06-2014 17:11</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Wolfgang Seka</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">urgent</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.2 (interim 2014)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.2 (interim 2014)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">ES 201 873-1 15.10</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;MCC160 - Wolfgang    </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006698: Missing functionality to cast &quot;template&quot; to &quot;template (present)&quot;</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">With valueof a template (especially with restriction &quot;template (omit)&quot; can be casted to a value (what serves &quot;template (value)&quot; as well).<br />
<br />
But there is no way make a &quot;template (present)&quot; out of a &quot;template&quot; in case it is know that the template is present.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">This issue is related to 6697</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">06-03-2014 10:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">08-04-2014 08:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">08-04-2014 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">08-04-2014 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-04-2014 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">08-04-2014 09:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">08-04-2014 09:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011949</td><td class="print"></td></tr><tr class="print"><td class="print">08-04-2014 13:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011959</td><td class="print"></td></tr><tr class="print"><td class="print">08-04-2014 15:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0011962</td><td class="print"></td></tr><tr class="print"><td class="print">08-04-2014 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011964</td><td class="print"></td></tr><tr class="print"><td class="print">09-04-2014 09:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0011966</td><td class="print"></td></tr><tr class="print"><td class="print">09-04-2014 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011970</td><td class="print"></td></tr><tr class="print"><td class="print">09-04-2014 12:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; urgent</td></tr><tr class="print"><td class="print">10-04-2014 09:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011984</td><td class="print"></td></tr><tr class="print"><td class="print">10-04-2014 09:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">urgent =&gt; normal</td></tr><tr class="print"><td class="print">17-06-2014 09:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; urgent</td></tr><tr class="print"><td class="print">17-06-2014 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012099</td><td class="print"></td></tr><tr class="print"><td class="print">17-06-2014 15:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012108</td><td class="print"></td></tr><tr class="print"><td class="print">17-06-2014 15:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.7.1 (published 2015-06) =&gt; v4.6.2 (interim 2014)</td></tr><tr class="print"><td class="print">17-06-2014 16:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0012112</td><td class="print"></td></tr><tr class="print"><td class="print">18-06-2014 07:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012114</td><td class="print"></td></tr><tr class="print"><td class="print">18-06-2014 08:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0012116</td><td class="print"></td></tr><tr class="print"><td class="print">18-06-2014 14:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0012128</td><td class="print"></td></tr><tr class="print"><td class="print">18-06-2014 16:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0012133</td><td class="print"></td></tr><tr class="print"><td class="print">19-06-2014 15:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012151</td><td class="print"></td></tr><tr class="print"><td class="print">19-06-2014 15:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0012151</td><td class="print">bug_revision_view_page.php?bugnote_id=12151#r45</td></tr><tr class="print"><td class="print">19-06-2014 15:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">19-06-2014 15:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">19-06-2014 15:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.2 (interim 2014)</td></tr><tr class="print"><td class="print">19-06-2014 15:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0012151</td><td class="print">bug_revision_view_page.php?bugnote_id=12151#r46</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011949)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-04-2014 09:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The purpose and the expected functionality to be clarified with Wolfgang.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011959)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-04-2014 13:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Assigning from an unrestricted template to a restricted one is allowed and should not cause any problem if all restriction requirements are met. No casting operation (similar to valueof) is necessary in this case. So e.g. the following code should work without a problem:<br />
<br />
type record R {<br />
&#160;&#160;integer field1,<br />
&#160;&#160;integer field2<br />
}<br />
...<br />
var template R vm_unrestricted := {<br />
&#160;&#160;field1 := (0..10),<br />
&#160;&#160;field2 := ?<br />
}<br />
var template(present) R vm_present := vm_unrestricted;<br />
<br />
Could you please provide a code example that causes problems? Or would you like to have an similar example as above or a note explaining this functionality in the core language specification?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011962)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-04-2014 15:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This would an improvement:<br />
<br />
when we have e.g.<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;template (present) SomeType cr_AnyTemplate := { ... };<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function f_MyFunction(template SomeType p_AnyOrOmitTemplate)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var template (present) SomeType v_AnyTemplate;<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (ispresent(p_AnyOrOmitTemplate)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;v_AnyTemplate := p_AnyOrOmitTemplate;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;} else {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;v_AnyTemplate := cr_AnyTemplate;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
currently at least one compiler raises a warning because of the potential risk of a runtime error. In general I appreciate that kind of warning as sometimes it really helps to correct issues in the implementation.<br />
But in cases like above (and we have several of them) we always need to check that the code is correct as it is. Therefore - and for completeness - we would consider it as improvement when we can explicitly says &quot;we know what we are doing - we have checked that the template is really there&quot; so that we don't get warnings anymore (but we still get warnings in cases where it is unintended)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011964)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-04-2014 17:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The current position of the STF 478 is that it would not be very efficient if the TTCN-3 language standard provided a standardized (casting) solution for each situation where TTCN-3 tools might generate a warning. It would make the language even more complicated than it is right now. The valueof operand is an exception to this rule, because conversion from values to template is necessary as certain operations are not permitted for templates.<br />
<br />
However, it would be possible to introduce a generic solution for suppressing warnings, e.g. in the following statement. We were thinking of a special comment format, but it might have other form (that will be decided in further discussion). But before we go on with that, we would like to know your opinion. In your case the code would look like:<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function f_MyFunction(template SomeType p_AnyOrOmitTemplate)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var template (present) SomeType v_AnyTemplate;<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (ispresent(p_AnyOrOmitTemplate)) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<a href="mailto://@nowarn">//@nowarn</a><br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;v_AnyTemplate := p_AnyOrOmitTemplate;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;} else {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;v_AnyTemplate := cr_AnyTemplate;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011966)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-04-2014 09:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have no strong opinion about whether or not it is efficient to cast less restricted templates to stronger restricted ones - even though it would enable tools give better information a compile time.<br />
<br />
That &quot;@nowarn&quot; pragma could be an option ...<br />
<br />
But - where to place it: intuitively I would expect it in that line for which no warning shall be issues. But that is different from your example.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011970)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-04-2014 11:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Testing Tech agrees that this would be a very useful feature. We actually were thinking about raising the same CR (something like presentof()). <br />
<br />
Of course, the nowarn annotations could also be a way to reduce the number of warnings.<br />
<br />
Still another way to go would be an explicit cast operator which could be useful in multiple occasions of such problems.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011984)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-04-2014 09:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion: should not go into the interim version. The real value and implications of a cast operation to be clarified.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012099)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-06-2014 10:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion:<br />
- warning control should be at the tool level; putting it into the language could spoil readability; warning control could be put into tool-specific extension attributes<br />
examples:<br />
function f() {v_AnyTemplate := v_AnyOrOmitTemplate} with { extension &quot;nowarning&quot; }<br />
function f() {<br />
v_AnyTemplate := v_AnyOrOmitTemplate;<br />
{v_AnyTemplate1 := v_AnyOrOmitTemplate1} with { extension &quot;warning&quot; }<br />
} with { extension &quot;nowarning&quot; }			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012108)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-06-2014 15:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Wolfgang, the conclusion we have reached so far is that it is rather a tool issue than a TTCN-3 language problem and it should be discussed on the 3GPP meeting with tool vendors. As the TTCN-3 language standard doesn't require or recommend to generate a warning in the described case, it is not possible to define a mechanism that would suppress such a warning. In the previous György's comment, you can find a possible solution of TTCN-3 complient (but still tool-dependent) warning suppression mechanism.<br />
<br />
Could you please inform us if such a solution is suitable for you so that we can close the CR? Of course, if the proposal is not fine with you, please send us your objections.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012112)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-06-2014 16:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I'm happy with György's proposal but wonder how it can be specified to be common for all tools:<br />
I assume when a tool does not understand the extension it shall just ignore it;<br />
but when a tool supports suppression of warnings somehow it shall be standardised that &quot;warning&quot;/&quot;nowarning&quot; are at least one common way to control warnings from within TTCN-3.<br />
What we definitely don't want is that different tools require different extensions.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012114)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-06-2014 07:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Unknown extensions should be indeed ignored by the TTCN-3 tools. If you wish to have a standardized solution for your project, I think the easiest way is to describe all necessary extensions in your project requirements and discuss support questions with representatives of tool vendors.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012116)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-06-2014 08:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;... describe all necessary extensions in your project requirements and discuss support questions with representatives of tool vendors&quot;<br />
<br />
That is exactly what I'm not happy with: We don't want to have a project or tool vendor specific solution for this case. <br />
<br />
Please note that I'm still not convinced that this is not a language issue; nevertheless I could live with a solution on tool level when it is standardised.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012128)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-06-2014 14:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I see. We can specify a standardized solution for you, but I am not sure if we can publish it as a part of TTCN-3 standards. Would an unpublished, i.e. not binding specification be enough for you or would you prefer an extension package?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012133)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-06-2014 16:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				After some internal discussion with Olivier we have the common opinion that there shall be some official specification, e.g. for standard extensions.<br />
These standard extensions can be put to some annex. Personally I think that it is sufficient to keep that informative but it would make clear for all tools and projects that when a tool supports suppression of warnings how this has to be expressed in TTCN.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012151)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-06-2014 15:25&#160;&#160;&#160;
				<br />(edited on:&#32;19-06-2014 15:32)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF decision: STF cannot decide to produce a new part of TTCN-3 (extension package) on its own, TC MTS shall approve a NWI for this. In the STF's oppinion it should be an EG or TR document, rather than an extension package.<br />
We can report the outcome of this CR to TC MTS, but we cannot propose the NWI.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
