<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:16:49 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006691: Port visibility in compile time in connection operations - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006691</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">21-02-2014 07:41</td><td class="print">06-01-2015 19:15</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">21.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006691: Port visibility in compile time in connection operations</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">With the introduction of mtc and system clauses in 4.6.1, it is possible to achieve that all component references in connection operations are strongly typed. However, the current specification doesn't actually say that this strong typing influences port references used in communication operations in any way and it is not obvious whether such port references shall be resolved according to the strong typing rules in compilation time or in runtime using the real component instance. The same problem was present in earlier specifications too, but then it only concerned component variables and reference to self.<br />
<br />
Let's demonstrate it on the example:<br />
<br />
type port P message { inout integer; }<br />
type component C1 { port P p1; }<br />
type component C2 { port P p1, p2; }<br />
<br />
testcase TC runs on C1 system C1<br />
{<br />
&#160;&#160;var C1 v_ptc := C2.create; // valid assignment: C2 is compatible in C1<br />
&#160;&#160;// In the following statement, v_ptc:p2 is not visible according to strong<br />
&#160;&#160;// typing rules, but the real instance contains the port p2. Static check<br />
&#160;&#160;// made in compilation time should print an error, but runtime check would<br />
&#160;&#160;// succeed<br />
&#160;&#160;connect(self:p1, v_ptc:p2); <br />
}<br />
<br />
In strongly typed languages, static checks are typically made in these cases leading to compilation errors. In order to prevent it, it is necessary to use explicit casting. TTCN-3 doesn't have any casting concept, but it is possible to use alternative approaches, such as assignment to a temporary variable or  typing on the function level using runs on, mtc and system clauses. For this reason, I suggest to introduce strong typing rules for situations when the component type is known by adding the following rule to the section 21.1.1 and 21.1.2:<br />
<br />
If the type of the component referenced in a connection operation is known (either when the component reference is a variable or value returned from a function or the type is defined the runs on, mtc or system clause of the calling function), the referenced port declaration shall be present in this component type.<br />
<br />
It would be also beneficial to add an example to demonstrate this rule. <br />
<br />
For test suites with untyped mtc and system, everything would remain the same, because only runtime resolution is possible in these cases. If the proposed strong typing rule is not acceptable, the core language specification should still say that the port reference are related to the actual instance. Otherwise there will be different interpretations by tool vendors leading to real test suites portability issues.<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR6691_update_proposal.docx (25,754) <span class="italic">10-04-2014 13:49</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3001&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR6691_v2.docx (27,148) <span class="italic">07-10-2014 15:18</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3100&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR6691_v3.docx (21,601) <span class="italic">07-10-2014 15:29</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3101&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">21-02-2014 07:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">07-04-2014 15:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011944</td><td class="print"></td></tr><tr class="print"><td class="print">07-04-2014 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">07-04-2014 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-04-2014 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">10-04-2014 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR6691_update_proposal.docx</td><td class="print"></td></tr><tr class="print"><td class="print">10-04-2014 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">10-04-2014 13:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0012006</td><td class="print"></td></tr><tr class="print"><td class="print">10-04-2014 13:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">06-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">07-10-2014 15:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR6691_v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR6691_v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">07-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">07-10-2014 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">06-01-2015 19:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012659</td><td class="print"></td></tr><tr class="print"><td class="print">06-01-2015 19:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">06-01-2015 19:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.7.1 (published 2015-06)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011944)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-04-2014 15:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				stf478, 2014-04-07: type-restriction based limitation applies, i.e. the above connect example shall produce an error. Standard has to be checked, if it is unambiguous from the text and amend if needed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012006)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-04-2014 13:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Problem: assignments to component instance may cause non-visible ports within components<br />
<br />
Approach: existing port identifiers that are not visible could not be detected at compile time and should not be used in connection statements			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012659)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-01-2015 19:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft V4.6.3			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
