<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:37 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006491: At least some compiler generate a runtime error when a function returns an unititialised variable even in cases when the result - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006491</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">27-03-2013 18:55</td><td class="print">29-08-2013 07:56</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Wolfgang Seka</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">e.g. 11.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">MCC160 - Wolfgang</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006491: At least some compiler generate a runtime error when a function returns an unititialised variable even in cases when the result</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">There are cases where e.g. due to maintenance on existing TTCN-3 code a function is enhanced to return a value just for special cases, i.e. a function which has not had a return value before gets a return statement which is needed for some particular case. <br />
Now it may happen that the function is just changed for the particular case when the return value is expected but for the other cases it e.g. returns an unitialised variable.<br />
From a user's point of view that would not harm as in these cases the caller of the function does not evaluate the functions's result at all.<br />
Nevertheless acc. to the restrictions in clause 11.1 of part 1 this is not allowed.<br />
BUT - it seems that compilers cannot find that a compile time (or at least not for all cases).<br />
But since some compilers are &quot;improved&quot; now to check this formal correctness at runtime, errors occur at runtime even though from a user's perspective there is no error.<br />
As there is no way to detect that kind of problems before it comes to the runtime error and the code is even logically correct these errors are very costly.<br />
<br />
=&gt; either the restrictions regarding the return statements shall be reduced to allow returning uninitialised variables as long as they are not used by the caller or other proposals are requested about how these kind of problems can be avoided.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">MCC160 would like to participate on any discussions about this topic.</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6491.doc (164,352) <span class="italic">28-08-2013 13:51</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2869&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">27-03-2013 18:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">27-03-2013 18:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; e.g. 11.1</td></tr><tr class="print"><td class="print">27-03-2013 18:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; MCC160 - Wolfgang</td></tr><tr class="print"><td class="print">05-04-2013 09:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011408</td><td class="print"></td></tr><tr class="print"><td class="print">05-04-2013 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0011409</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2013 14:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">08-07-2013 14:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-07-2013 14:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">08-07-2013 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">10-07-2013 19:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">11-07-2013 09:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">12-07-2013 08:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011566</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2013 09:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">12-07-2013 09:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">15-07-2013 10:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0011580</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2013 14:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">27-08-2013 14:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">27-08-2013 14:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011609</td><td class="print"></td></tr><tr class="print"><td class="print">27-08-2013 14:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0011609</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 13:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR6491.doc</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011624</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">28-08-2013 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">29-08-2013 07:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011630</td><td class="print"></td></tr><tr class="print"><td class="print">29-08-2013 07:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">29-08-2013 07:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">29-08-2013 07:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">29-08-2013 07:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011408)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-04-2013 09:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As I said in the meeting, I would opt for lifting the restriction on return statements since the assignment of an uninitialized value to a variable will catch such a behavior as well. It should be clear, though that this can lead to the situation where the result of a function is used directly as an actual parameter (where uninitialized values are allowed) of another function which then could lead to a runtime-error very far away from the error-cause. This makes the error-cause hard to locate, which is very costly, as well. Thus, there is no ideal solution for this problem, it has to be decided which scenario is more probable and thus more costly.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011409)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-04-2013 10:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As already mentioned in the earlier discussions - it is up to tools whether/how to provide the user with additional information and warnings at runtime and how to configure that; it is up to users whether to make use of this information and to configure the runtime environment accordingly. But the core language as such shall be independent of this and in particular it shall not mandate generation of runtime errors where - from a user's point of view - there is no problem at all.<br />
Furthermore in this context the argumentation &quot;... This makes the error-cause hard to locate ...&quot; is not applicable as it is a tool issue how to verify and debug the code.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011566)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2013 08:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				After a lengthy discussion, the STF still thinks that the dangers of lifting this restriction outweigh the benefits the STF160 would gain.<br />
<br />
In some cases it is possible to check statically, if a return value is initialized or not (after a potentially very costly analysis), but in lots of cases it can only be determined at runtime. Other languages solve this problem by restricting the language even further, so that the data-flow analysis becomes feasible; but then they forbid scenarios statically (the maybe-cases) some of which would never be a problem at runtime. Thus, they force the user - without specific necessity - to write more complicated code. This requirement in TTCN-3 is more implicit but still there.<br />
<br />
&#160;<br />
<br />
Also, during the discussion, it was strongly opposed to make the semantic rules of the return statement context-dependent, i.e. depending on the place the given function is called. This would be a wrong language design.<br />
<br />
The instruments to solve similar problems when a function is extended are given by the language itself, for instance by the isbound() predefined function. It can be used to check the to-be-returned variable before returning it and then return a dummy value in the case it is not initialized. Another way of preventing such errors is to use unit-testing for functions or to impose a coding style that initializes all variables at declaration.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011580)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-07-2013 10:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Mail set to stf460 (12 July 2013 09:11):<br />
<br />
&quot;I've seen the note added to 6491 in I don't think that it is the right decision and I think from a user's point of view it is not acceptable:<br />
<br />
You are shifting tool problems from the tooling side to the user's side: There is no reason why cannot raise a warning at runtime (but that is a tool issue) but by raising a runtime the problem is definitely at the user's side.<br />
&#160;<br />
Again please note that the issues causing problems are not visible for the user when writing the code therefore the user will not use any &quot;instruments by the language itself&quot; until there is a runtime error.<br />
<br />
I hope that this is NOT a final decision.&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011609)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-08-2013 14:33&#160;&#160;&#160;
				<br />(edited on:&#32;27-08-2013 14:34)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2013-08-27: we should allow returning uninitialized value by a function, but this shall not be assigned to a variable or used in expression, ( but can be passed as parameter where uninitialized actual parameter is allowed)<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011624)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2013 13:52&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				added proposal, simply lessened the restriction for use of uninitialized variables to allow return statements.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011630)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-08-2013 07:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
