<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:02 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006429: modifies of 'record of' fields still seems to be ambiguous - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006429</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">27-02-2013 15:52</td><td class="print">04-01-2015 20:06</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">urgent</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.7.1 (published 2015-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Section 15.5.</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006429: modifies of 'record of' fields still seems to be ambiguous</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Having a record type with a record of field<br />
<br />
type record R {<br />
&#160;&#160;record of record {<br />
&#160;&#160;&#160;&#160;integer a,<br />
&#160;&#160;&#160;&#160;integer b<br />
&#160;&#160;} list<br />
}<br />
<br />
and a template of that type<br />
<br />
template R r1 := {<br />
&#160;&#160;list := { <br />
&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 1,<br />
&#160;&#160;&#160;&#160;&#160;&#160;b := 2<br />
&#160;&#160;&#160;&#160;},<br />
&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 3,<br />
&#160;&#160;&#160;&#160;&#160;&#160;b := 4<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
the question arises what the meaning of the following modified template is:<br />
<br />
template R r2 modifies r1 := {<br />
&#160;&#160;list := { <br />
&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 0<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
Because the standard says that matching mechanisms in fields are replaced (unless inside records), I think the correct interpretation of this would be<br />
error or partially defined template, as the { { a := 0 } } tries to replace the whole { { a := 1, b := 2 }, { a := 3, b := 4 } } list (and because b is not optional).<br />
<br />
To get the desired result of just replacing the a-field in element 0, the correct syntax would be <br />
<br />
template R r2 modifies r1 := {<br />
&#160;&#160;list := { <br />
&#160;&#160;&#160;&#160;[0] := { <br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 0<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
Unfortunately, the standard only &quot;allows&quot; this with a &quot;may&quot; clause but does not explicitly state that this is the only way of doing this, thus making people think that using partially defined list-notation to partially modify some elements of the original would also be okay.<br />
<br />
But, if the replacement-syntax also is interpreted as an by-element-modification syntax (as some people seem to interpret the standard), then<br />
there is no possibility of writing down a modification of the whole list-field with a totally different list that is shorter than the original.<br />
<br />
If the replacement is equally long or longer, there is of course no problem as then all existing fields are overwritten anyway. But how can one get rid of superfluous elements at the end? In my opinion, this would not be possible, if the list notation can be used for modification instead of replacement.<br />
<br />
If allowing the list notation for modification, then it should be clarified that the length of the resulting list is the length of the list notation in the modifying template (i.e. all trailing unchanged elements that shall be kept in the list need to be specified with the unchanged symbol explicitly).<br />
<br />
Then, we would have a clear distinction between<br />
<br />
template R r2 modifies r1 := {<br />
&#160;&#160;list := { <br />
&#160;&#160;&#160;&#160;{<br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 0<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
and <br />
<br />
template R r3 modified r1 := {<br />
&#160;&#160;list := { <br />
&#160;&#160;&#160;&#160;{ <br />
&#160;&#160;&#160;&#160;&#160;&#160;a := 0<br />
&#160;&#160;&#160;&#160;},<br />
&#160;&#160;&#160;&#160;-<br />
&#160;&#160;}<br />
}<br />
<br />
The r3 template would keep the second element of the list, the r2 template would delete it. Both would modify the first element.<br />
<br />
This solution would be especially beneficial as it seems to be consistent with the record-of-modification-interpretation of the standard people have and thus would not create backward compatibility issues with the tools employing this interpretation. Only the tools not accepting this interpretation at the moment would need to be changed to allow it.<br />
&#160;&#160;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">The problem came up in STF 160 in the context of the LTE test suite.</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006411</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">Example to clarify Modified Template semantics&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;draft-res-6429.docx (25,579) <span class="italic">07-10-2014 11:21</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3094&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;draft-res-6429-V2.docx (20,735) <span class="italic">08-10-2014 10:58</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3108&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">27-02-2013 15:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">27-02-2013 15:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; Section 15.5.</td></tr><tr class="print"><td class="print">27-02-2013 15:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">08-07-2013 15:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-07-2013 15:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">08-07-2013 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Relationship added</td><td class="print">related to 0006411</td></tr><tr class="print"><td class="print">08-07-2013 18:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">08-07-2013 18:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">26-08-2013 11:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011590</td><td class="print"></td></tr><tr class="print"><td class="print">26-08-2013 13:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0011595</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 10:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011617</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 10:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0011618</td><td class="print"></td></tr><tr class="print"><td class="print">28-08-2013 10:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">28-08-2013 10:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">28-08-2013 10:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; v4.6.1 (published 2014-06)</td></tr><tr class="print"><td class="print">19-06-2014 14:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">19-06-2014 14:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">closed =&gt; assigned</td></tr><tr class="print"><td class="print">20-06-2014 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Product Version</td><td class="print"> =&gt; v4.5.1 (published 2013-04)</td></tr><tr class="print"><td class="print">20-06-2014 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">v4.6.1 (published 2014-06) =&gt; v4.7.1 (published 2015-06)</td></tr><tr class="print"><td class="print">27-06-2014 13:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; urgent</td></tr><tr class="print"><td class="print">07-10-2014 11:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: draft-res-6429.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 11:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0012251</td><td class="print"></td></tr><tr class="print"><td class="print">07-10-2014 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-10-2014 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">08-10-2014 07:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">08-10-2014 10:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: draft-res-6429-V2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 10:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0012274</td><td class="print"></td></tr><tr class="print"><td class="print">08-10-2014 10:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">08-10-2014 10:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">08-10-2014 10:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">04-01-2015 20:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0012608</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2015 20:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">04-01-2015 20:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print">v4.6.1 (published 2014-06) =&gt; v4.7.1 (published 2015-06)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011590)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-08-2013 11:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think the example first_r2 is more tricky: I agree, that a complete record_of  (i.e. not using the index notation) shall replace the complete record_of of the parent. But the first element is a record, where a:=0 replaces field &quot;a&quot; of the parent, but field b remains unchanged. Hence first_r2 should be {{a:=0, b:=2}}. Otherwise we are in conflict with the general rule of modifying records.<br />
<br />
To avoid split the discussion over the two related CRs (6411 and 6429), I switch to 6411 now and let further discuss further the topic at that CR.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011595)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-08-2013 13:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Isn't that exactly what I have proposed?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011617)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2013 10:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In that case we are on the same side. Anyway we have agreed at the STF discussion yesterday (see note to CR6411) :-)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011618)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-08-2013 10:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This CR is closed, because it is merged with CR6411, pls. find the discussion and resolution at that CR. 			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012251)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-10-2014 11:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				clarifications added regarding list notation for modification, following the &quot;solution&quot; proposed by Jacob			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012274)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-10-2014 10:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				changed cp. to cf.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0012608)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-01-2015 20:06&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to draft V4.6.3			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
