<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:59 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006088: superset/subset/permutation/complement should also be possible with dynamic lists - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006088</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">16-05-2012 12:28</td><td class="print">09-08-2012 13:57</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">B.1.2.2, B.1.2.6, B.1.2.7</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006088: superset/subset/permutation/complement should also be possible with dynamic lists</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">At the moment, the superset/subset constructions are very restricted in their usefulness as the number of different templates, i.e. the size of the set to be matched against, given to them need to be known already statically. <br />
<br />
However, there are situations where the set to be matched against can only be determined dynamically during the course of a testcase. For this, in current TTCN-3, complex for-if-match constructions need to be used to replace simple subset/superset expressions to arrive at the same semantic result.<br />
<br />
While it is possible to extract such matching constructs into functions, these have the drawbacks that they cannot be used as matching mechanisms and also need to be type-safe (so they need to be redefined for every set element type or using generics).<br />
<br />
To amend these drawbacks, the following construct could be introduced:<br />
<br />
subset &lt;set_of_elements&gt;<br />
<br />
where &lt;set_of_elements&gt; is a list value or template (i.e. of a record of or set of type of the element type of the subset construct).<br />
<br />
Examples:<br />
<br />
subset { 1, 2, 3 } is the same as subset (1, 2, 3)<br />
<br />
type set of integer int_list;<br />
<br />
function is_subset(int_list numbers1, template int_list numbers2) return boolean {<br />
&#160;&#160;return match(numbers1, subset numbers2);<br />
}<br />
<br />
function is_element(integer num, int_list numbers) return boolean {<br />
&#160;&#160;&#160;return match({num}, subset numbers2);<br />
}<br />
<br />
function equals(int_list numbers1, int_list numbers2) return boolean {<br />
&#160;&#160;return <br />
&#160;&#160;&#160;&#160;match(numbers1, subset numbers2) and <br />
&#160;&#160;&#160;&#160;match(numbers1, superset numbers2);<br />
}<br />
<br />
Restrictions:<br />
<br />
If a template is given to the subset/superset matching mechanism as argument, the template shall not resolve to the matching mechanisms Any, complement, subset, superset (basically, only an actual list of templates is allowed).<br />
<br />
The matching mechanism AnyElementsOrNone directly inside the set-of template given to subset/superset is not allowed.<br />
<br />
For consistency's sake, all similar constructions (i.e. permutation/complement, the 'from' clause in receive statements and the 'to' clause in send statements) should also allow such dynamic list templates. </td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006165</td><td class="print">closed&#160;</td><td class="print">&#160;</td><td class="print">Add recof2setof predefined function&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088.doc (80,384) <span class="italic">11-07-2012 09:08</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2661&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v2.doc (118,784) <span class="italic">11-07-2012 15:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2675&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v3.doc (141,312) <span class="italic">12-07-2012 09:14</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2682&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v4.doc (146,944) <span class="italic">12-07-2012 12:02</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2691&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v5.doc (147,456) <span class="italic">12-07-2012 17:38</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2694&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v6.doc (130,048) <span class="italic">12-07-2012 18:01</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2696&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v7.doc (137,216) <span class="italic">13-07-2012 15:22</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2703&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_6088_v8doc.doc (144,896) <span class="italic">09-08-2012 13:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2713&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">16-05-2012 12:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-05-2012 12:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; B.1.2.2, B.1.2.6, B.1.2.7</td></tr><tr class="print"><td class="print">16-05-2012 12:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">09-07-2012 16:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">09-07-2012 16:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010724</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010743</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">10-07-2012 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-07-2012 11:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">10-07-2012 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Relationship added</td><td class="print">related to 0006165</td></tr><tr class="print"><td class="print">10-07-2012 12:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010750</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 15:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010771</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 15:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">10-07-2012 18:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010773</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR_6088.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 09:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010789</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 09:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">11-07-2012 10:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010824</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0010827</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">11-07-2012 11:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010829</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 14:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010836</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 15:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR_6088_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 15:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010839</td><td class="print"></td></tr><tr class="print"><td class="print">11-07-2012 16:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">12-07-2012 09:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_6088_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 09:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010857</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 09:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010857</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010872</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 11:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010873</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 12:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010879</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 12:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_6088_v4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 12:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010882</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 14:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010885</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 14:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010885</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010890</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010899</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 17:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010902</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 17:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_6088_v5.doc</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 17:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010902</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 17:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010902</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 18:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR_6088_v6.doc</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 18:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010904</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 18:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010902</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 10:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010909</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010912</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010912</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR_6088_v7.doc</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 15:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010933</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 15:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">13-07-2012 15:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">13-07-2012 15:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">09-08-2012 13:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011003</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 13:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR_6088_v8doc.doc</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; assigned</td></tr><tr class="print"><td class="print">09-08-2012 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">09-08-2012 13:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011004</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 13:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011005</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 13:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">09-08-2012 13:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011008</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 13:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">09-08-2012 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010724)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-07-2012 16:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In general I agree. As subset/superset can be used for set ofs, permutation for record ofs, complement to any type, the simple syntax subset mytemplate (if e.g. mytemplate is a record of) may cause confusions. I propose to identify at the syntactical level that this construct is using only the elements of the argument, e.g.<br />
<br />
subset all from mytemplate;<br />
subset (5, all from mytemplate, 7);<br />
permutation (3, all from mytemplate);<br />
<br />
A little bit longer syntactically but more readable and more clearly reflects the intention.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010743)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 11:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2012-07-10:<br />
Proposal agreed in principle, work out a proposed text.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010750)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 12:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think the &quot;all&quot; is confusing in this construct, as in a subset, only some of the elements from the list should be in the matching template.<br />
<br />
Thus, I propose either to take only the from, i.e. <br />
<br />
subset from X, superset from X (would be mz favourite, also shorter)<br />
<br />
or <br />
<br />
subset any from X / superset all from X<br />
<br />
The additional mix-syntax is unnecessary, as it can easily be done by using<br />
the &amp; operator, i.e.<br />
<br />
subset from { 5, 7 } &amp; mytemplate<br />
<br />
permutation from { 3 } &amp; mytemplate			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010771)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 15:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				actually &quot;all&quot; means that all elements of the referenced template is used in the subset/superset etc. for example:<br />
type record of integer ROI;<br />
template ROI t_roi := { 1,2,3}<br />
<br />
template SOI t_roi:= subset all from t_roi; //is equivalent to subset (1,2,3), i.e. all elements of t_roi became elements of t_soi.<br />
<br />
this will match of course values {1}, {1,2}... etc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010773)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 18:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I understand, but I think it is not intuitive language-wise and therefore confusing. Using only the 'from', less so - at least to me.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010789)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 09:20&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I added a draft of core language specification changes. From the number of proposals we picked the one that uses the &quot;all from&quot; inside parentheses, e.g. subset(all from t1, 1, 2). There are several reasons for this solution:<br />
1. The syntax remains very similar to the original one<br />
2. It can be used for template lists too, e.g.: (1, 2, all from t2)<br />
3. It has a good readability meaning &quot;include all elements from the source template&quot;<br />
4. We don't have to deal with the problem whether &quot;from&quot; should be preceded by any, all or nothing in the proposed shorthand form of the notation.<br />
<br />
--&gt; assigned to Jens for review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010824)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 10:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I actually cannot think of a use case where the mixed notation would be necessary. In my experience either the whole dynamic list is to be used as the basis for subset/superset or a fixed list (as we can do now).<br />
<br />
If the mixed notation shall be used, then I would opt for 'all X' instead of 'all from X', as it is shorter and has the same intuition.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010827)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 11:14&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				For me &quot;all from&quot; is as expressive as &quot;all&quot;. However, in any case the meaning of &quot;all from&quot; or &quot;all&quot; needs to be explained informally in Clause 15.7.2. Apart from this, I am fine with the text.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010829)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 11:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In the examples for subset/superset, the paranthesis is missing, though the syntax allows the construct only with paranthesis.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010836)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 14:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				1) Actually one may want to compose a list from more than one list variables. Also, it is quite possible to have a mixed case, when some of the elements are static (e.g. IDs assigned by the user are known in beforehand) and some are dynamic (IDs assigned by the network). So, the possibility to refer to the elements of a list inside a () is useful.<br />
<br />
2) Add also permutation to the resolution.<br />
<br />
3) &quot;all t_mytemplate&quot;  is not expressive to me at all, it would not be intuitive for the users. We should go either for &quot;all from&quot; or &quot;from&quot; to have an intuitive syntax.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010839)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-07-2012 15:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I made several changes according to your requests:<br />
1. The chapter on permutations was added<br />
2. I added a note to the chapter 15.7.2 explaining the basic principle of the &quot;all from&quot; clause, but the reader still has to refer to Annex B to find out all the details. I hope it is fine.<br />
3. I switched on change tracker<br />
4. I added parenthesis to the superset and subset examples<br />
<br />
There's two changes in the BNF too. Superset, subset and template list can contain one element only if it is all from. And complemented list template BNF was accidentally left unchanged.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010857)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 09:15&#160;&#160;&#160;
				<br />(edited on:&#32;12-07-2012 09:26)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have made some editorial changes in CR_6088_v3.doc to better express that individual elements and all from references can be mixed and some other minor editorials.<br />
<br />
Some restrictions could need further considerations. For example, permutation may contain AnyElementsOrNone, even several of them (actually, it makes no difference if there is a single or multiple *-s is/are within a permutation), it is not obvious for me why it cannot be included by referencing from other record/set of templates.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010872)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 11:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;Superset, subset and template list can contain one element only if it is all from.&quot;<br />
<br />
Why? What's wrong with subset (X), superset (X) ?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010873)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 11:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;Some restrictions could need further considerations. For example, permutation may contain AnyElementsOrNone, even several of them (actually, it makes no difference if there is a single or multiple *-s is/are within a permutation), it is not obvious for me why it cannot be included by referencing from other record/set of templates.<br />
&quot;<br />
<br />
What do you mean? That a record of containing a permutation shall be allowed as a reference referred to be the all-from construct?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010879)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 12:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				See CR_6088_v4.doc.<br />
<br />
Regarding the &quot;can contain one element only if it is all from&quot; question, do you refer to the TemplateList BNF productions?<br />
It seems to me that this also could be simplified to <br />
<br />
TemplateListItem {&quot;,&quot; TemplateListItem }<br />
but it is not changed in the draft CR_6088_v4.doc. Let the others also look at this.<br />
<br />
Regarding the restrictions, actually I mean that we have had restrictions for the individual elements in the description part and now restrictions for the elements brough in by referencing a template has been added to the new Restrictions paragraph. But actually the same restriction apply for both, the mechanisms, how a member got inside a subset/superset/permutation etc. is unimportant. The more, restrictions shall be writen in one place only to avoid possible inconsistencies.<br />
<br />
Therefore:<br />
- existing restrictions I have moved to the Restrictions paragraph<br />
- applied the current constrains for the members to the elements referenced by the all from contructs too (in one Restirictions item); actually, for template list and complemented list this means that there is no restriction of the members as there was no restriction before.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010882)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 12:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The problem is that the mechanism how items get into the target template is actually important. There are several symbols that can appear only inside record of values such as AnyElementsOrNone or permutation. These symbols were explicitely forbidden in the argument of the &quot;all from&quot; clause for these reasons:<br />
1. AnyElementsOrNone: because it is not possible to reasonably transform it into a single element template as it represents a group of elements in the record of template.<br />
2. Permutation: because it is a matching symbol for several elements and because of consistency with other rules that don't allow access to items inside permutation.<br />
<br />
Proposal: in addition to general restrictions on the set of symbols that can/cannot appear in the constructed template, there could be an additional restriction saying that the template in the all from clause cannot contain AnyElementsOrNone and permutation. <br />
<br />
If the proposal is not accepted, it should be said how is AnyElementsOrNone interpretted, because it is not the same as AnyValueOrNone. Additionally, the restriction b in B.1.2.1 and B.1.2.2 should be changed because it referers to the deleted restriction c.<br />
<br />
Regarding the subset and superset template:<br />
The rules are taken from the current BNF, which doesn't allow to construct subset and superset with one item. I agree that it is quite strange and should be changed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010885)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 14:13&#160;&#160;&#160;
				<br />(edited on:&#32;12-07-2012 14:14)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TomÃ¡Å¡, let's separate your comment to two parts:<br />
1) regarding the matching mechanisms bound to a type, your comment is partly correct: subset/superset should be disallowed if the referencing type is a record of. However, a permutation is practically converting a record of into a set of. So, referencing a permutation from a set of could be allowed without any problems, just the rules has to be specified (&quot;lift over&quot; just the elements of a permutation into the set of). But if this is considered to be too complicated, I can leave with disallowing this as well.<br />
<br />
But I don't see a problem in the non-cross-type cases, e.g. permutation is allowed for record of (complemented) lists:<br />
({permutattion (1,2,3)},{4,5,6}) <br />
<br />
why the user should not be able to construct the same like<br />
template MyrecOf t_MyrecOf := {permutation(1,2,3)}<br />
template MyrecOf t_MyrecOf2 := (all from t_MyrecOf, {4,5,6})<br />
<br />
2) AnyElementsOrNone<br />
Seems we have a terminological issue here.<br />
- In subset and superset AnyValueOrNone are forbidden, obviously this is converted to forbidding AnyElementsOrNone in case of all from references. So, I think this is just an editorial work to do (I mean there is no new restriction is introduced).<br />
- In template (complemented) lists AnyValueOrNone is allowed, so an AnyElementOrNone within a referenced record of or set of is implcitly transformed to AnyValueOrNone. This should be written in the text but I cannot see a technical reason to forbid this.<br />
- Referencing a record/set of with AnyElementsOrNone from within a permutation shouldn't be a problem as AnyElementsOrNone is also allowed in permutation.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010890)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 15:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				GyÃ¶rgy,<br />
<br />
I am afraid i cannot agree with the conclusions you made. The &quot;all from&quot; notation is used for moving individual elements, not the whole template into the target. Let's take the example you wrote, but without the permutation mark:<br />
template MyrecOf t_MyrecOf := { 1,2,3 };<br />
The &quot;all from&quot; shall be used to create a template of the member type (integer) of the value in the argument and not a template of the same type (MyrecOf):<br />
template integer t_int := (all from t_MyrecOf, 4, 5, 6);<br />
<br />
In the example you described, you define a template of the same record of type. The result you wanted to get can be easily achieved without the &quot;all from&quot; clause:<br />
template MyrecOf t_MyrecOf := {permutation(1,2,3)};<br />
template MyrecOf t_MyrecOf2 := (t_MyrecOf, {4,5,6}); // produces ({permutation(1,2,3)}, {4,5,6})<br />
<br />
I hope that we can agree that the &quot;all from&quot; clause produces a set of items of the member type. The problem with the permutation is that it is a matching mechanisms that is rather related to the enclosing record of than to the elements itself. So the issue is how to get those individual elements from there?<br />
<br />
Having: <br />
template MyrecOf t_MyrecOf := {permutation(1,2,3)};<br />
template integer t_int := (all from(t_MyrecOf), 4, 5, 6);<br />
the possible results would be either:<br />
(permutation(1,2,3), 4, 5, 6) // if we consider the whole permutation is a single item<br />
or <br />
(1, 2, 3, 4, 5, 6)<br />
<br />
I don't like either. The first one is both semantically and syntactically incorrect so it would produce an error anyway. The second one produces a correct template, but it would require additional rules describing that the permutation envelope has to be dropped when &quot;all from&quot; is used. Besides, who would use such rules? What would be a practical application of such a feature? I find it much simpler to forbid permutations in these cases.<br />
<br />
The situation with AnyElementsOrNone is a little bit more complicated. You suggest that it shall be transformed into AnyValueOrNone. I don't think it is consistent with the rest of the specification, because no such transformation is actually currently defined and allowed. Besides, there are hidden problems when transforming the element in its literal form. Consider this:<br />
<br />
type record of charstring RoC;<br />
template RoC t_roc := {&quot;abc&quot;, * length(2)};<br />
template charstring t_c := (all from t_roc);<br />
<br />
It would produce (&quot;abc&quot;, * length(2)). In this case, the original meaning was altered. In the first template, * length(2) means two strings of any length and in the second one, it means any string with length two or omitted value. The situation would be even worse in case of integers, where * length(2) would be semantically incorrect as a length restriction cannot be applied to an integer template. This might be of course fixed by an additional rule saying that the length attribute shall be dropped during this transformation. <br />
<br />
In addition to that, AnyValueOrNone is forbidden for subsets and supersets. Complement templates containing it would not match anything. It might find a good use in permutation though, but this produces another problem, because in this case the transformation AnyElementsOrNone -&gt; AnyValueOrNone is not necessary. For these reasons, I would prefer if AnyElementsOrNone remained forbidden in the argument of the &quot;all from&quot; clause.<br />
<br />
If both permutations and AnyElementsOrNone were not allowed in the record of values used in the &quot;all from&quot; clause, we would have a nice uniform rule for all places, where the clause can be used.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010899)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 16:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree with TomÃ¡Å¡ assessment. <br />
<br />
Allowing permutation or AnyElmementsOrNone inside the referenced template introduces uncertainties. As long as no one really needs this feature, it should be forbidden to avoid confusion.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010902)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 17:37&#160;&#160;&#160;
				<br />(edited on:&#32;12-07-2012 18:05)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK, I have got now where my misunderstanding was. Your explanation is correct, and the original restrictions were also correct, with one exception; we should consider one important case.<br />
Let's define a message template like:<br />
template MyRec t_message := {<br />
&#160;&#160;iD := 1,<br />
&#160;&#160;iEList := {  //record of record, used to check the first two IEs, the rest is unimportant<br />
&#160;&#160;&#160;&#160;{iEID := 1, IEvalue := &quot;Tinky-Winky&quot;},<br />
&#160;&#160;&#160;&#160;{ iE2 := 2, IEvalue := &quot;Poo&quot;},<br />
&#160;&#160;&#160;&#160;* }<br />
}<br />
and the user wants to use this to define another template for the IEList where the order of the elements is arbitrary, because the SUT may send them in different orders:<br />
template MyRec.iEList t_IEList_unordered := { permutation (all from t_message.iEList)}<br />
<br />
Actually, this is the use case our users need to solve (this was the reason for CR 6165). If disallowing AnyElementsOrNone when all from is used inside a permutation, this use case whould be not be possible, while there is no technical reason for disallowing it. So, in this case, we have a user need that shall overwhelm simplicity and uniformity.<br />
<br />
Except this one open issue is remaining: is there a specific reason, why TemplateList is not changed simply to<br />
TemplateList := &quot;(&quot; (TemplateListItem {&quot;,&quot; TemplateListItem}+ )<br />
?<br />
<br />
In principle the order of &quot;direct&quot; elements and elements referenced by all from clauses should be a user's choice.<br />
<br />
Pls. check CR_6088_v5.doc that I corrected according to the above, except the BNF that I haven't changed.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010904)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 18:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have no problem with referencing AnyElementsOrNone in permutation, so this is fine for me. Maybe we should add an expample to the draft too.<br />
<br />
Regarding the BNF: I think the problem occurs because both superset and subset rules refer to the rules for template list. Currently the BNF allows 2+ elements in template lists, because if a single element were allowed, it would lead to conflicts with an expression inside parentheses. Notice that &quot;all from&quot; doesn't suffer from this conflict (and for that reason, 1 element only is allowed). I think the best way to resolve it is to share the BNF rules for the part in parentheses with complemented template list. I modified the draft this way. Please check if it is fine.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010909)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 10:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I also agree that for permutation it makes sense. For subset or superset, though, it seems pointless or confusing.<br />
<br />
The subset of an infinite set is any set, so that makes no sense. And the superset of a possibly infinite set is what? <br />
<br />
So, basically, we should strive for something like: the same restrictions that apply to the direct elements of a matching mechanism construction must also apply to the elements of the template referred to by the all from-construct in such a construction.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010912)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 11:00&#160;&#160;&#160;
				<br />(edited on:&#32;13-07-2012 11:07)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Technically is fine with me, I have some editorials (to CR_6088_v6.doc):<br />
-------<br />
1.A ListOfTemplates  -&gt; 1. ListOfTemplates<br />
-------<br />
9.PermutationList ::= &quot;(&quot; PermutationListItem {&quot;,&quot; PermutationListItem} &quot;)&quot; <br />
PermutationListItem ::= (TemplateBody | AllElementsFrom)<br />
<br />
could be simplified to<br />
9.PermutationList ::= &quot;(&quot; TemplateListItem {&quot;,&quot; TemplateListItem } &quot;)&quot; <br />
(some time ago we have decided to simplify the BNF by removing transitional &quot;purpose-specific&quot; productions like<br />
TemplateIdentifier := Identifier)<br />
---------<br />
TemplateList would be used in MatchingSymbol only, where it could be replaced by ListOfTemplates as well and the production TemplateList could simply be deleted<br />
---------<br />
wording of item b) in clauses B.1.2.6, B.1.2.7 and B1.3.3 [actually, in B.1.2.7 and B.1.3.3 item ID to be corrected from a) to b)] could be simplified (rext below is given for B.1.2.6, the other clauses could use the same schema)<br />
from<br />
b) The member type of the set of type associated with the superset template and the member type of the record of or set of type associated with the template in the all from claused shall be compatible.<br />
to<br />
b) The member type of the set of associated with the superset template and the member type of the template in the all from clause shall be compatible.<br />
---------<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010933)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 15:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I made the requested changes and corrected a couple of typos. There's only one minor difference compared to GyÃ¶rgy's last editorial proposals. I simplified the rule for permutation in a slightly different way. It uses the same style as complement, subset and superset now:<br />
--&gt;<br />
7.PermutationMatch ::= PermutationKeyword ListOfTemplates			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011003)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2012 13:39&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Streamlining the BNF and some editorial changes: v8			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011004)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2012 13:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011005)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2012 13:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I am OK with the latest changes.<br />
Assigned to Ina for implementation.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011008)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2012 13:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
