<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:58 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0006016: Ambiguous rules for matching symbols for optional fields - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0006016</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">09-03-2012 10:11</td><td class="print">10-08-2012 11:17</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Tomas Urban</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.7</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Elvior</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0006016: Ambiguous rules for matching symbols for optional fields</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The core language specification v. 4.3.1 contains ambiguous rules for the following matching symbols: any value or none, omit and for the ifpresent attribute.<br />
<br />
The table 11 in chapter 15.7. states that the symbols &quot;can be assigned to templates, however when used shall be applied to optional fields of record and set types&quot;. Similar rules are provided in the annex B:<br />
B.1.2.4 Any value or none: &quot;It can be used on values of all types, provided that the template field is declared as optional&quot;<br />
B.1.2.8 Omitting optional fields: &quot;It can be assigned to templates, but shall only be used in fields of record and set types provided that the fields are optional.&quot;<br />
B.1.4.2 The IfPresent indicator: &quot;This attribute may be used with all the matching mechanisms, provided this field is declared as optional.&quot;<br />
<br />
These rules obviously forbid using the above mentioned matching symbols in any template which is not an optional record or set field. The question is, what the word &quot;use&quot; stands for. The might be two different interpretations:<br />
1. &quot;Use&quot; means any kind of operation with the template, including assignment. (e.g. the rule in B.1.2.4 seems to suggest that)<br />
2. &quot;Use&quot; means only matching operations, i.e. it is legal to assign the symbol to any template, but if the template is used for matching and it does not fulfil the criteria of being applied to an optional field, it produces an error:<br />
<br />
type record R { integer field1 optional }<br />
testcase TC() runs on C<br />
{<br />
&#160;&#160;template integer vt_1 := *;<br />
&#160;&#160;p1.receive(R:{ field1 := vt_1 }; // legal<br />
&#160;&#160;p1.receive(vt_1); // illegal<br />
}<br />
<br />
The rules specified in the chapter 15.8 seem to use the latter interpretation, because otherwise (using the former interpretation) the template(omit) restriction would make no sense (it would never be possible that the whole template resolves to omit). There are also several examples that allow assigmnent of the above mentioned matching mechanisms to a target that isn't an optional record or set field, e.g.:<br />
// Example from chapter 15.8<br />
template(omit) ExampleType exampleOmit := omit;<br />
// Example 1 in 5.4.1.2<br />
template MyMessageType MyTemplate (template integer MyFormalParam):=<br />
{ ... }<br />
pco1.receive(MyTemplate(omit));<br />
<br />
<br />
Proposal:<br />
I suggest the rules for handling the above mentioned matching mechanisms should be generalized in a dedicated chapter and made more detailed. The current rules (15.7 table 11, B.1.2.4, B.1.2.8 and B.1.4.2) shall be replaced with a reference to this chapter. The chapter shall contain the following rules:<br />
<br />
15.7.5 Matching mechanisms for optional fields<br />
This chapter specifies rules for the following mechanisms: omit, any value or none and ifpresent. The rules apply also to value lists and complemented value lists containing omit, any value or none or ifpresent on any level of nesting.<br />
<br />
The matching mechanisms for optional fields can be assigned only to templates, template variables, template parameters or optional fields of record or set templates. An error shall be produced when these matching mechanisms are assigned to a field of a record of, set of, array, union or anytype template or when used inside a subset or superset.<br />
<br />
The matching mechanisms for optional fields can be used for matching only if they are assigned to optional fields of a record or set template.<br />
<br />
Example 1:<br />
type record R<br />
{<br />
&#160;&#160;integer field1,<br />
&#160;&#160;integer field2 optional<br />
}<br />
<br />
type record of integer RI;<br />
<br />
type union U<br />
{<br />
&#160;&#160;&#160;integer option1,<br />
&#160;&#160;&#160;charstring option2<br />
}<br />
template R t_1 (template integer p_1) :=<br />
{<br />
&#160;&#160;field1 := 1,<br />
&#160;&#160;field2 := p_1<br />
}<br />
...<br />
template R t_2<br />
{<br />
&#160;&#160;field1 := 2,<br />
&#160;&#160;field2 := 1 ifpresent // legal: field2 is an optional record field<br />
}<br />
var template integer vt_1 := *; // legal: vt_1 is a template variable<br />
var template RI vt_2 := {1, * }; // legal: * literal is interpretted as<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// AnyElementOrNone<br />
vt_2 := {1, vt_1}; // illegal: AnyValueOrNone assigned to a record of<br />
template U t_3 := { option1 := 5 ifpresent } // illegal: ifpresent assigned to <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// a union field<br />
template integer t_4 := (1, 2, omit); // legal: AnyValueOrNone used in a value <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// list; the same as (1, 2) ifpresent<br />
<br />
p1.receive(t_1(omit)); // legal: omit used as a template parameter and the<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// parameter is assigned to an optional field. Omit is<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// then used for matching the optional field value.<br />
p1.receive(vt_1); // illegal: vt_1 (containing AnyValueOrNone) is not an<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// optional record field, but it is used for matching<br />
<br />
<br />
Compared to the current specification, the suggested rules don't give any room for different interpretations, provide comprehensive and logical functionality and they are in line with other clauses (especially 15.8) and examples.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6016_resolution_v1.doc (254,464) <span class="italic">07-08-2012 11:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2707&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6016_resolution_v2.doc (191,488) <span class="italic">09-08-2012 17:28</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2714&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR6016_resolution_v3.doc (200,704) <span class="italic">10-08-2012 11:17</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2717&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">09-03-2012 10:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">09-03-2012 10:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 15.7</td></tr><tr class="print"><td class="print">09-03-2012 10:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Elvior</td></tr><tr class="print"><td class="print">16-05-2012 10:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010626</td><td class="print"></td></tr><tr class="print"><td class="print">04-07-2012 09:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010668</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2012 16:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">Part 09: Using XML with TTCN-3 =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">10-07-2012 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010746</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">10-07-2012 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-07-2012 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">13-07-2012 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010924</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2012 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">06-08-2012 10:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0010962</td><td class="print"></td></tr><tr class="print"><td class="print">06-08-2012 10:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-08-2012 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR6016_resolution_v1.doc</td><td class="print"></td></tr><tr class="print"><td class="print">07-08-2012 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010982</td><td class="print"></td></tr><tr class="print"><td class="print">07-08-2012 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010983</td><td class="print"></td></tr><tr class="print"><td class="print">07-08-2012 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010984</td><td class="print"></td></tr><tr class="print"><td class="print">07-08-2012 11:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">09-08-2012 17:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR6016_resolution_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 17:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011013</td><td class="print"></td></tr><tr class="print"><td class="print">09-08-2012 17:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">10-08-2012 10:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Deleted: 0010984</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2012 10:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Deleted: 0010983</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2012 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR6016_resolution_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2012 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011021</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2012 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">10-08-2012 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">10-08-2012 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010626)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-05-2012 10:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In principal I agree (though I think the same rules already are true in the current standard), but I would say that the following sentence<br />
<br />
&quot;The matching mechanisms for optional fields can be used for matching only if they are assigned to optional fields of a record or set template.&quot; <br />
<br />
should be amended with &quot;or if they are used as second argument to the match() operation when the first argument is an optional record or set field.&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010668)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-07-2012 09:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Could anyone move this issue to the core language category?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010746)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 12:13&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2012-07-10:<br />
Check the issue and the proposal.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010924)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2012 13:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Let separate the technical side from the question, how to handle the solution in the standard's text. So, let see the technical question, where *, omit and ifpresent are allowed?<br />
<br />
I agree, that this question is somewhat umbigous today.<br />
<br />
As all your examples are correct, I suppose that we have a common understanding. Our understanding is that it is not an assignment vs. matching question but rather an top-level-assignment vs. field assignment vs. matching question.<br />
<br />
So,<br />
- at the TOP level, they are allowed to be assigned to any template (template, template var, template par) independent of the type of the template. This also includes template lists and complement lists. But not allowed in subsets and supersets, but this is defined unambiguously.<br />
Let's borrow one of your examples:<br />
type union U {<br />
&#160;&#160;&#160;integer option1,<br />
&#160;&#160;&#160;charstring option2<br />
}<br />
template U t_u := *; // is legal<br />
<br />
- at the field level, they are allowed to be assigned to optional fields of record and sets only, as in your example:<br />
template U t_3 := { option1 := 5 ifpresent } // illegal<br />
<br />
&#160;or another example:<br />
template R t_1 (template integer p_1) := { field1 := 1, field2 := *} //OK<br />
template R t_1 (template integer p_1) := { field1 := *, field2 := 2} //NOK<br />
<br />
- at the time of matching (receiving or the match operation), they can be used in optional fields of records and sets only; i.e.<br />
p.receive (t_u) //shall cause an error<br />
<br />
<br />
The another question is, how to specify these rules in the standard's text.<br />
Today, we have two places in the standard, where matching mechanisms are specified: clause 15.7 an Annex B. Clause 15.7 in principle contains just a basic information and a reference to Annex B. So, we shouldn't put the above rules there, to avoid inconsistencies with Anex B (that we may have even today). It's better to keep all major rules in Annex B. But Annex B is structured according to the matching mechanisms and this is correct, if someone is searches for rules on how to use an *, he/she should find it in one place. So, what I propose to add the text clarifying the rules for each concerned matching mechanism to its own existing clause, even if this is partly  a copy-paste work.<br />
<br />
Before going on I would like to know your opinion, if the above is OK, I can continue with proposing a text.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010962)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-08-2012 10:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think the proposed solution is very good. Since you volunteered to write the text, I will reassign the CR to you.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010982)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-08-2012 11:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Propoaed resolution is uploaded in file CR6016_resolution_v1.doc. Pls. review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011013)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-08-2012 17:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree with the resolution. I only change one word in three place to use the same wording as in the rest of the document.<br />
Assigned to Ina for implementation.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011021)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-08-2012 11:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				as proposed with editorial changes			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
