<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:03 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005986: Invalid TCI interface for octetstring - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005986</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Technical</td><td class="print">public</td><td class="print">16-12-2011 16:22</td><td class="print">12-07-2012 16:13</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Mateusz Pusz</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">10.5.3.9-10</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Mateusz Pusz/freettcn</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005986: Invalid TCI interface for octetstring</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">That issue is a follow up of <a href="/mantis/view.php?id=5945" title="[closed] Missing types in TCI C++ mappings" class="resolved">0005945</a> and exactly that part:<br />
&quot;Tchar is not defined in the standard too and it is used in OctetstringValue and HexstringValue interfaces (10.5.3.9-10).&quot;<br />
<br />
It seems that Tchar is not a good solution here and should be removed from the specification. Here is why...<br />
<br />
Lets assume:<br />
<br />
var hexstring string1;<br />
string1 := '1234'H;<br />
string1[1] := '1'H;     // is valid and will end up with '1134'H;<br />
<br />
ORG_ETSI_TTCN3_TCI::HexstringValue::setHex(1, '1');   // is valid and will end up again with '1134'H;<br />
<br />
Now lets look at another type:<br />
<br />
var octetstring string2;<br />
string2 := '1234'O;<br />
string2[1] := '11'O;     // is valid and will end up with '1211'O;<br />
<br />
// but how TCI should behave?<br />
// we cannot pass<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(1, '11');   // &lt;---- compilation error<br />
<br />
// maybe index of a TTCN type should not be equal to index of TCI type?<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(2, '1');<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(3, '1');  // but that is not he best idea<br />
// and of course getOctet() has to use the same indices<br />
<br />
// or maybe Tchar should be treated as an integer and not a char<br />
ORG_ETSI_TTCN3_TCI::OctetstringValue::setOctet(1, 0x11);<br />
// but in such a case hexstring should also be modfied to work like that:<br />
ORG_ETSI_TTCN3_TCI::HexstringValue::setHex(1, 0x01);<br />
// also getOctet() and getHex() should return similar values<br />
<br />
From current TCI definition it is not possible to understand what the standard really means here.<br />
<br />
It would be much better to use Tinteger value here because it is directly suggesting the usage scenario. In such a case Tchar type is not needed anywhere and should be removed from the standard.<br />
<br />
Alternatively Tchar can be renamed to Tbyte. The same underlying (1 byte long) type will be used, but it will provide totally different meaning suggesting usage of integral values instead of characters. In such a case TCI interface description should be extended with exact information how to use it.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">See also no.3 here <a href="http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393">http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393.</a> [<a href="http://list.etsi.org/scripts/wa.exe?A2=ind1110&amp;L=ttcn3&amp;T=0&amp;P=393" target="_blank">^</a>]</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">16-12-2011 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz Pusz</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2011 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz Pusz</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 10.5.3.9-10</td></tr><tr class="print"><td class="print">16-12-2011 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=121">Mateusz Pusz</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Mateusz Pusz/freettcn</td></tr><tr class="print"><td class="print">09-07-2012 16:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control Interface</td></tr><tr class="print"><td class="print">10-07-2012 18:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010777</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 18:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">10-07-2012 18:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-07-2012 18:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">12-07-2012 16:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010895</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2012 16:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">12-07-2012 16:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010777)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 18:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2012-07-10: to be checked			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010895)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 16:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TChar is used in TCI for BitString, HexString, and OctetString in getBit, getHex, and getOctet to return the bit, hex, and octet at a given position as a character.<br />
<br />
It is NOT used to set a bit, octet, or hex respectively. For that, integer is used instead - see setBit, setOctet, and setHex.<br />
<br />
Hence, the examples given above work differently, but will work if the operations are used as defined.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
