<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:17:46 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005981: TLI does currently not represent the p.check operation appropriately - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005981</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Technical</td><td class="print">public</td><td class="print">06-12-2011 14:36</td><td class="print">20-12-2012 15:05</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Thilo Lauer</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">feature</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print-category">Fixed in Version</td><td class="print">v4.5.1 (published 2013-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">7.3.4.1.19, 7.3.4.1.20, 7.3.4.1.31, 7.3.4.1.32, 7.3.4.1.43, 7.3.4.1.44, 7.3.4.1.55, 7.3.4.1.56</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Devoteam Danet - Thilo Lauer</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005981: TLI does currently not represent the p.check operation appropriately</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Currently there is no distinction in TLI between<br />
<br />
&#160;&#160;p.receive(...)  and p.check(receive(...))<br />
&#160;&#160;p.getcall(...)  and p.check(getcall(...))<br />
&#160;&#160;p.getreply(...) and p.check(getreply(...))<br />
&#160;&#160;p.catch(...)    and p.check(catch(...))<br />
<br />
For now these p.check(...) events have to be logged in TLI by:<br />
<br />
&#160;&#160;tliMReceive_m/c, <br />
&#160;&#160;tliPrGetCall_m/c, <br />
&#160;&#160;tliPrGetReply_m/c, <br />
&#160;&#160;tliPrCatch_m/c<br />
<br />
but this does not indicate in the TLI-Log that the message itself remains in the port queue. This could be an important detail for interpreting the TLI-log.<br />
&#160;<br />
For <br />
<br />
&#160;&#160;MyPort.check;<br />
&#160;&#160;MyPort.check(from MyPartner);<br />
&#160;&#160;MyPort.check(-&gt; sender MySenderVar);<br />
&#160;&#160;any port.check;<br />
<br />
a TLI log-mapping to e.g.:<br />
<br />
&#160;&#160;tliMReceive_m/c, <br />
<br />
would be very misleading in my opinion.<br />
<br />
My suggested solution would be to define the TLI-functions below<br />
<br />
&#160;&#160;tliMCheckReceive_m/c, <br />
&#160;&#160;tliPrCheckGetCall_m/c, <br />
&#160;&#160;tliPrCheckGetReply_m/c, <br />
&#160;&#160;tliPrCheckCatch_m/c<br />
<br />
completely identical to tliMReceive_m/c ... tliPrCatch_m/c except for the function's names. <br />
[An alternative solution could be here to add a &quot;check&quot; flag as parameter to tliMReceive_m/c ... tliPrCatch_m/c as well as to the XML-representation of the logged event]<br />
<br />
For <br />
<br />
&#160;&#160;MyPort.check;<br />
&#160;&#160;MyPort.check(from MyPartner);<br />
&#160;&#160;MyPort.check(-&gt; sender MySenderVar);<br />
&#160;&#160;any port.check;<br />
<br />
I would suggest to define a new TLI-function here, named e.g.:<br />
<br />
&#160;&#160;tliCheck(...)<br />
<br />
to indicate this event in the log.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0006600</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">Missing data in TLI check operations&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR5981_v1.docx (59,994) <span class="italic">14-12-2012 11:08</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2783&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR5981_v2.docx (81,665) <span class="italic">14-12-2012 13:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2785&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR5981_v3.docx (110,191) <span class="italic">20-12-2012 15:04</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2792&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">06-12-2011 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">06-12-2011 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 7.3.4.1.19, 7.3.4.1.20, 7.3.4.1.31, 7.3.4.1.32, 7.3.4.1.43, 7.3.4.1.44, 7.3.4.1.55, 7.3.4.1.56</td></tr><tr class="print"><td class="print">06-12-2011 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Devoteam Danet - Thilo Lauer</td></tr><tr class="print"><td class="print">10-07-2012 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010763</td><td class="print"></td></tr><tr class="print"><td class="print">10-07-2012 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">10-07-2012 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">10-07-2012 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">12-07-2012 15:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010888</td><td class="print"></td></tr><tr class="print"><td class="print">10-08-2012 13:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011031</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011271</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5981_v1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">14-12-2012 13:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR5981_v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 13:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0011281</td><td class="print"></td></tr><tr class="print"><td class="print">14-12-2012 13:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">20-12-2012 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5981_v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2012 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0011301</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2012 15:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">20-12-2012 15:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">20-12-2012 15:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.5.1</td></tr><tr class="print"><td class="print">26-08-2013 13:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0006600</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010763)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-07-2012 14:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 2012-07-10: the issue exists, propose a solution.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010888)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2012 15:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The cleanest solution would be to define tliCheck that can take the logs of the different receiving operations. However, that would require to introduce a ReceivingOp Types for parameters to tliCheck. That is considered to be an overkill as basically all the structures in tliMCheckReceive_m/c, tliPrCheckGetCall_m/c, tliPrCheckGetReply_m/c, and tliPrCheckCatch_m/c would have to be repeated. <br />
<br />
Another solution would be to add a check flag to all these operations. However, that would be a non-backward-compatible change to the interface.<br />
<br />
There are two lightweight approaches:<br />
<br />
1. define tliCheck just indicating a check operation that is to be followed ba a log of the log operation of the enclosed receiving operation (this is a work around for the new check logging operation proposal)<br />
<br />
2. define the additional &quot;am&quot; parameter that is present in any logging operation to represent the check operation when loggin the enclosed receiving operation (this is a work around for the check tag proposal)<br />
<br />
The issue needs to be discussed in the STF			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011031)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-08-2012 13:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Discussion in the STF: develop option 2			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011271)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2012 11:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The proposal is defined as by reusing the Detected operations of TLI and defining 8 new operations for Checked:<br />
<br />
tliMChecked_m<br />
tliMChecked_c<br />
tliPrGetCallChecked_m<br />
tliPrGetCallChecked_c<br />
tliPrGetReplyChecked_m<br />
tliPrGetReplyChecked_c<br />
tliPrCatchChecked_m<br />
tliPrCatchChecked_c <br />
<br />
Please check			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011281)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-12-2012 13:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I added four new operations: two of them for successful check any operations and two for logging mismatches in check any operations (in case addresses/components don't match).<br />
<br />
I also noticed the schema definitions in the Annex B don't contain the definitions from part 11.4.2.1, but that is probably intentional (so that there's no duplicated text in the draft)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0011301)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-12-2012 15:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added the IDL definitions to Annex A in v3.<br />
Implemented v3.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
