<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:30 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005899: Clarification for partially initialised array - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005899</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">17-06-2011 11:45</td><td class="print">17-07-2011 05:59</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Wolfgang Seka</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.2 (interim 2011)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.2 (interim 2011)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">201 873-1 cl. 6.2.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">stf160 - Wolfgang</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005899: Clarification for partially initialised array</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Initialisation of &quot;record of&quot; is described in the core language in cl. 6.2.3. <br />
Regarding uninitialised elements the core language says <br />
&quot;Undefined elements are permitted only in transient states (while the value remains invisible). Sending a record of or set of value with undefined elements shall cause a dynamic testcase error.&quot;<br />
But seems not to be clearly specified what is meant with &quot;transient states&quot; or with the visibility of the value/element. <br />
E.g. Assume we have a function initialing some array i.e. the function returns a &quot;record of&quot;. <br />
In this case at least one compiler raises a run-time error even though there is no access to any of the uninitialised fields:<br />
&#160;&#160;v_MyArray := f_MyArray_PartialInit();    // =&gt; runtime error</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">Note:<br />
If the above example would be not correct acc. the core language, from a users point of view there shall be a compilation error rather than a run-time error<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5899_resolution.doc (41,984) <span class="italic">01-07-2011 13:24</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2546&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5899_resolution_v2.doc (56,832) <span class="italic">01-07-2011 16:47</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2554&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5899_resolution_v3.doc (57,344) <span class="italic">04-07-2011 14:46</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2557&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">17-06-2011 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">17-06-2011 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 201 873-1 cl. 6.2.3</td></tr><tr class="print"><td class="print">17-06-2011 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; stf160 - Wolfgang</td></tr><tr class="print"><td class="print">22-06-2011 16:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">28-06-2011 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010130</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2011 09:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010134</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2011 09:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Severity</td><td class="print">block =&gt; major</td></tr><tr class="print"><td class="print">30-06-2011 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010154</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2011 11:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010154</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2011 11:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">30-06-2011 11:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">30-06-2011 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010154</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 13:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5899_resolution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 13:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010175</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 13:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-07-2011 16:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010190</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 16:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5899_resolution_v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 16:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0010190</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 16:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">04-07-2011 10:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010205</td><td class="print"></td></tr><tr class="print"><td class="print">04-07-2011 14:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010207</td><td class="print"></td></tr><tr class="print"><td class="print">04-07-2011 14:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5899_resolution_v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">04-07-2011 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010208</td><td class="print"></td></tr><tr class="print"><td class="print">05-07-2011 09:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010209</td><td class="print"></td></tr><tr class="print"><td class="print">05-07-2011 12:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010210</td><td class="print"></td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.2 (interim)</td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010211</td><td class="print"></td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">05-07-2011 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">05-07-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">05-07-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; resolved</td></tr><tr class="print"><td class="print">05-07-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">05-07-2011 14:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.2 (interim)</td></tr><tr class="print"><td class="print">17-07-2011 05:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0010223</td><td class="print"></td></tr><tr class="print"><td class="print">17-07-2011 05:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010130)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-06-2011 10:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In a variable assignment there is an access to the uninitialized fields. When assigning the fields to the variable v_MyArray, each element must be copied. Therefore, it must be initialized. <br />
<br />
There cannot be a compilation error because this cannot be checked at compile-time as the compiler cannot know in general what f_MyArray_PartialInit() does. So, it can at most generate a warning, but basically this warning would then have to be generated for almost all assignments of structured variables and thus would not be helpful. (Same problem as with index-checking).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010134)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2011 09:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It is not defined anywhere, that assigning a record of means copying of all elements one-by-one. This is just one - inefficient - way of doing that. Another way, e.g. to assign the pointer of the array returned by the function to the pointer of the variable. But this is just a side comment.<br />
<br />
More importantly, I'm always in favor of checking whatever possible compile time. But once this case cannot be checked compile time, what is the sense of this restriction? This is just decreases usability and the only &quot;benefit&quot; is that completeness shall be checked before each assignment, instead of checking this once, before sending the value (or entering a library public function, depending of the use case).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010154)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2011 11:14&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2011 14:36)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Result of STF430's discussion on 30.06.2001:<br />
Allow<br />
-assigning not fully initialized structured values<br />
-passing not fully initialized structured values as in parameter (inout and out are already allowed)<br />
-returning not fully initialized structured values<br />
-concatenate, rotate and shift not fully initialized structured values<br />
<br />
The standard'd text shall be checked as this issue is handled at several places, so small text changes will be needed at several places; the whole text has to be checked for consistency.<br />
<br />
Submit a CR to extend isvalue: return true if parameter is completely initialized and contains a value, return false in all other cases (e.g. for non-accessible fields or uninitialized parameter). Also ispresent and ischosen should be consistent with this.<br />
<br />
Submit a CR on isbound.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010175)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2011 13:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				uploaded CR5899_resolution.doc, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010190)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2011 16:47&#160;&#160;&#160;
				<br />(edited on:&#32;01-07-2011 16:48)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think that we agreed that uninitialized stuff cannot be returned as this would be a workaround to make already initialized stuff uninitialized again. This could be problematic both from the consistency and implementation point of view.<br />
Otherwise OK, some editorial changes, see CR5899_resolution_v2.doc. Pls. check.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010205)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-07-2011 10:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				How would uninitializing stuff be possible when returning it is possible but assignment of the returned stuff is not possible?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010207)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-07-2011 14:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jacob,<br />
<br />
seems that we are saying the same. I have written earlier: &quot;I think that we agreed that uninitialized stuff cannot be returned&quot;, thus returning uninitialized stuff shall NOT be allowed - we both claiming this. Ok, I can see, it has been corrected in the value variables clause but not in the template variable clause. I have corrected this, see text in CR5899_resolution_v3.doc for final review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010208)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-07-2011 17:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				No, we are not in agreement on this. We decided that returning uninitialized is not harmful in itself. If the function returns something which is then not used, why should that be an error. Thus, our philosophy was: only disallow that which can lead to an error. I.e. the assignment. Therefore, I restricted rhs of assignment to partially initialized. Sure, in most cases the effect is the same, but I would rather check this at runtime at the places of assignment than at all return-statements.<br />
<br />
small example:<br />
<br />
function f() return integer { var integer i; return i }<br />
function g(integer x) { // does nothing with x }<br />
<br />
why should g(f()) be an error?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010209)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-07-2011 09:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jacob,<br />
<br />
Because of consistency, not to have different rules for &quot;all&quot; the cases. Assignment lhs of assignment and a formal parameter are analogous things. In a similar way, rhs of the assignment, actual parameters and return values are also analugue things. Therefore the rules shall be the same at least for these categories not to overcomplicate the language for nothing.<br />
<br />
I haven't heard any use case for that and no one requested such feature. So, we would solve a null problem, complicate the tools but adding again a specific rule ... that we should avoid.<br />
<br />
Btw. not returning uninitialized value/template can be checked compile time with a limited effort, at least for the most usual cases (let me say 99%). Checking the assignment is really possible in runtime only - at least with reasonable effort.<br />
<br />
So, you can see, the reasons are mainly not technical but rather usability issues.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010210)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-07-2011 12:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010211)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-07-2011 14:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As in CR5899_resolution_v3.doc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010223)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-07-2011 05:59&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Basically implemented as proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
