<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:10 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005810: Blocking configuration operation on PTC - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Ext Pack: Config &amp; Deployment Support (ES 202 781)</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005810</td><td class="print">Ext Pack: Config &amp; Deployment Support (ES 202 781)</td><td class="print">New Feature</td><td class="print">public</td><td class="print">24-11-2010 17:12</td><td class="print">04-06-2012 06:08</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Elisabet Wahlgren</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">low</td><td class="print-category">Severity</td><td class="print">feature</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">no change required</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">21, Configuration operations</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;&#160;&#160;&#160;&#160;Ericsson AB - Elisabet Wahlgren</td></tr><tr class="print"><td class="print-category">TS version</td><td class="print" colspan="4"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005810: Blocking configuration operation on PTC</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The project I am working in currently uses TTCN-3 in a way that requires PTC configuration to be done in a serial manner (yes, I know the abbreviation PTC stands for Parallel Test Component, but parallel execution is rarely used in our current project). The code is literally littered with statement sequences of the form<br />
<br />
componentRef.start(function());<br />
componentRef.done;<br />
<br />
in such amounts that I began searching for a blocking function execution operation, perhaps &quot;execute&quot;, so that the required functionality could be expressed as<br />
<br />
componentRef.execute(function());<br />
<br />
which would improve readability a lot. <br />
<br />
Our test environment involves a rather large number of component types for handling all the protocols that our SUT is using, and there is a lot of code written using the current component and data type structures.  <br />
<br />
Is this abuse of TTCN-3? Or might there be rationales for introducing a blocking configuration operation?<br />
&#160;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5810.doc (1,989,120) <span class="italic">01-12-2010 13:59</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2457&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;example_code_from_CR_submitter.zip (2,045) <span class="italic">29-06-2011 14:07</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2523&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/generic.gif" alt="?" />&#160;CHCR_TRAF_RestartTestcases.ttcn (146,545) <span class="italic">20-07-2011 17:26</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2562&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">24-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">24-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 21, Configuration operations</td></tr><tr class="print"><td class="print">24-11-2010 17:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt;      Ericsson AB - Elisabet Wahlgren</td></tr><tr class="print"><td class="print">29-11-2010 15:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009831</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 09:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Ext Pack: Config &amp; Deployment Support (ES 202 781)</td></tr><tr class="print"><td class="print">30-11-2010 17:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009869</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 17:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">30-11-2010 17:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">30-11-2010 17:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">Ext Pack: Config &amp; Deployment Support (ES 202 781) =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">01-12-2010 13:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5810.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Deleted: CR5810.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR5810.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 14:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009897</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 14:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">03-12-2010 11:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.2 (interim)</td></tr><tr class="print"><td class="print">03-12-2010 12:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009936</td><td class="print"></td></tr><tr class="print"><td class="print">03-12-2010 15:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0009938</td><td class="print"></td></tr><tr class="print"><td class="print">03-12-2010 15:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Edited: 0009938</td><td class="print"></td></tr><tr class="print"><td class="print">03-12-2010 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009939</td><td class="print"></td></tr><tr class="print"><td class="print">03-12-2010 15:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Deleted: 0009938</td><td class="print"></td></tr><tr class="print"><td class="print">24-05-2011 19:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; low</td></tr><tr class="print"><td class="print">25-05-2011 13:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010049</td><td class="print"></td></tr><tr class="print"><td class="print">27-05-2011 13:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010101</td><td class="print"></td></tr><tr class="print"><td class="print">27-05-2011 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010102</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2011 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">29-06-2011 14:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010144</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2011 14:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: example_code_from_CR_submitter.zip</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 13:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010177</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2011 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">18-07-2011 16:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010228</td><td class="print"></td></tr><tr class="print"><td class="print">19-07-2011 11:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010229</td><td class="print"></td></tr><tr class="print"><td class="print">20-07-2011 17:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">File Added: CHCR_TRAF_RestartTestcases.ttcn</td><td class="print"></td></tr><tr class="print"><td class="print">20-07-2011 17:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010230</td><td class="print"></td></tr><tr class="print"><td class="print">21-07-2011 10:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0010231</td><td class="print"></td></tr><tr class="print"><td class="print">28-07-2011 10:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010232</td><td class="print"></td></tr><tr class="print"><td class="print">28-07-2011 11:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Edited: 0010232</td><td class="print"></td></tr><tr class="print"><td class="print">27-09-2011 14:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print">Edition 4.3.2 (interim) =&gt; Edition 4.4.1</td></tr><tr class="print"><td class="print">30-11-2011 10:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010424</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 11:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010438</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 13:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010442</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 14:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a></td><td class="print">Note Added: 0010446</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">30-11-2011 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0010450</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2011 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; no change required</td></tr><tr class="print"><td class="print">30-11-2011 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.4.1</td></tr><tr class="print"><td class="print">04-06-2012 06:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">Part 01: TTCN-3 Core Language =&gt; Ext Pack: Config &amp; Deployment Support (ES 202 781)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009831)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-11-2010 15:29&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The proposal has merit. Especially, for this construct the restriction that the started function may have no out-parameters can be lifted as then it is clear when exactly these variables get their new values. The ptc-execute could also have the return value of the executed function as its result.<br />
<br />
Thus, if you had:<br />
<br />
function f(inout integer x) runs on C return integer {<br />
&#160;&#160;x := ...;<br />
&#160;&#160;return ...;<br />
} <br />
&#160;&#160;<br />
then you could do:<br />
<br />
var C ptc := C.create alive; <br />
...<br />
var integer x, y;<br />
...<br />
x := ptc.execute(f(y));			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009869)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2010 17:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion 30-11-2010: make sense also to allow inout parameters (passing back the parameter value when the called function is finished). Text to be proposed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009897)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 14:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				please proofread and add operational semantics			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009936)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-12-2010 12:38&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				On the discussion of the CR and the resolution proposal from J. Wieland: <br />
<br />
I (Jens) am sorry, but the CR and the resolution do somehow not fit.<br />
<br />
The CR asks for some sort of shorthand for<br />
<br />
componentRef.start(function());<br />
componentRef.done;<br />
<br />
Even this CR needs further information: Shall a default be activated in the background, e.g., to supervise the test execution by means of a test case timer?<br />
<br />
Jacob's proposal introduces an execute PTC operation<br />
- with time supervision and<br />
- with inout parameters.<br />
<br />
First of all, if a default is activated in the background, the solution will not match the intention of the CR.<br />
<br />
Inout parameters seems to force the strange restriction that the component started by an execute PTC-operation can only be stopped by itself but not be stopped by any other component, even not by the MTC.<br />
<br />
If it is stopped by some other component or the time supervision exceeded, the test run will end with a test case error.<br />
<br />
I (Jens) doubt that such a behaviour really is wanted by the CR and that we really want such a behaviour ...<br />
<br />
Personally, I (Jens) am against inout parameters for a special case only that in addition implies a very severe runtime restriction (i.e., the component can only be stopped by itself). If we want to have inout-parameters, this should be bound to the start operation itself.<br />
<br />
My (Jens) proposal is to ask for some clarification first and then to look into Jacob's proposal again.<br />
<br />
Answer from Jacob:<br />
<br />
I (Jacob) also think that we need more information regarding the context of the intended statement, i.e. are there default alternatives active or not, is it desired that execution in the starting component continues even if componentRef is stopped before finishing, etc.<br />
<br />
The semantics I (Jacob) assigned in my proposal is basically the same semantics as that of the existing execute statement for test cases. Of course, there you don't have the possibility that a testcase can be stopped from another control part.<br />
<br />
Either way, if you take my proposal or simply go with the just-syntactic-sugar route, both is fine with me. Allowing effect of out parameters in the syntactic-sugar variant would of course be inconsistent with the normal start statement.<br />
<br />
Overall summary:<br />
<br />
The STF will ask for further information before reconsidering the proposal from Jacob. The resolution of this CR is shifted to the next year (or new STF).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009939)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-12-2010 15:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Dear Elisabet Wahlgren,<br />
sorry, Mantis is not an open discussion forum and I will not start a discussion about the CR here. Mantis shall only reflect the status of the CRs. The request for further information as well as further discussion will be done offline via Email. However, I do not have your Email. Please do me a favour and send me an Email to <a href="mailto:grabowski@informatik.uni-goettingen.de">grabowski@informatik.uni-goettingen.de</a><br />
Best regards<br />
Jens Grabowski			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010049)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-05-2011 13:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				From the example that was given to the STF, it seems clear that not the <br />
pattern<br />
<br />
p.start(...)<br />
p.done;<br />
<br />
is really the problem that makes the code 'littered' (I would rather say, unreadable), but the use of indexed/dotted notation expressions over and over again.<br />
<br />
The usual approach to this problem would be to extract the re-used common (lengthy) sub-expressions of the statements into variables and then use these<br />
variables instead. If the expressions are used are lvalues, <br />
this refactoring needs to be done by introducing a new function with out/inout parameters (which are instantiated with the lengthy lvalue-expressions when calling that function). <br />
<br />
For example:<br />
<br />
vg_iscSessions[p_index.iscInit].componentRef.start(ISCv2_SessionFunctions.f_<br />
s_isc_INVITE(vg_continue,<br />
vg_iscSessions[p_index.iscInit].dialogList[p_index.iscInitDialog],<br />
vl_sdpInvite, p_parInvite.addHeaderInviteSend, -,<br />
p_parInvite.deleteHeaderInviteSend));<br />
<br />
f_cto_waitForReturnResult({ctIsc :=<br />
vg_iscSessions[p_index.iscInit].componentRef}, vg_continue);<br />
<br />
vg_iscSessions[p_index.iscInit].componentRef.start(ISCv2_SessionFunctions.f_<br />
r_isc_100Trying(vg_continue,<br />
vg_iscSessions[p_index.iscInit].dialogList[p_index.iscInitDialog],<br />
p_par100.addHeader, -, -, p_par100.deleteHeader));<br />
f_cto_waitForReturnResult({ctIsc :=<br />
vg_iscSessions[p_index.iscInit].componentRef}, vg_continue);<br />
<br />
Would be rewritten to:<br />
<br />
var ... componentRef := vg_iscSessions[p_index.iscInit].componentRef;<br />
var ... dialogList :=  <br />
&#160;&#160;vg_iscSessions[p_index.iscInit].dialogList[p_index.iscInitDialog];<br />
var ... wrappedComponentRef := {ctIsc := componentRef}<br />
<br />
componentRef.start(ISCv2_SessionFunctions.f_s_isc_INVITE(vg_continue,<br />
&#160;&#160;dialogList, vl_sdpInvite, p_parInvite.addHeaderInviteSend, -,<br />
&#160;&#160;p_parInvite.deleteHeaderInviteSend));<br />
f_cto_waitForReturnResult(wrappedComponentRef, vg_continue);<br />
<br />
componentRef.start(ISCv2_SessionFunctions.f_r_isc_100Trying(vg_continue,<br />
&#160;&#160;dialogList, p_par100.addHeader, -, -, p_par100.deleteHeader));<br />
f_cto_waitForReturnResult(wrappedComponentRef, vg_continue);			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010101)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-05-2011 13:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thanks for supporting the view of our code as littered on the verge of unreadability! But we seem to need even more brilliant advice to do away with our quest for an &quot;execute&quot; operation, the lack of which seems to add an orthogonal degree of obfuscation to TTCN-3 code. What would you do with the following function:<br />
<br />
function f_auto_configureCharging()<br />
runs on DEFAULT_MTC_CT<br />
{<br />
&#160;&#160;vg_dn := &quot;MtasCharging=0,applicationName=MtasFunction&quot; &amp; &quot;,nodeName=jambala&quot;;<br />
&#160;&#160;// Offline Orig Node Level<br />
&#160;&#160;vg_ldap.start(f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingOriginatingOffline&quot;,&quot;0&quot;,compareTrue));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_setMtasChargingParameter(&quot;mtasChargingOriginatingOffline&quot;,&quot;1&quot;));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;// Online Orig Node Level<br />
&#160;&#160;vg_ldap.start(f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingOriginatingOnline&quot;,&quot;0&quot;,compareTrue));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_setMtasChargingParameter(&quot;mtasChargingOriginatingOnline&quot;,&quot;1&quot;));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;// Offline Term Node Level<br />
&#160;&#160;vg_ldap.start(f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingTerminatingOffline&quot;,&quot;0&quot;,compareTrue));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_setMtasChargingParameter(&quot;mtasChargingTerminatingOffline&quot;,&quot;1&quot;));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;// Online Term Node Level<br />
&#160;&#160;vg_ldap.start(f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingTerminatingOnline&quot;,&quot;0&quot;,compareTrue));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_setMtasChargingParameter(&quot;mtasChargingTerminatingOnline&quot;,&quot;1&quot;));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_removeChargingDeactDests());<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f_gen_setMtasChargingParameter(&quot;mtasChargingDefaultCdfAddress&quot;,SIP_CommonDefinitions.tsp_ccfRealm1));<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;// Charging Profile - &quot;Charging&quot;<br />
&#160;&#160;vg_ldap.start(f_gen_addMtasChargingProf(&quot;Charging&quot;,&quot;3&quot;,&quot;3&quot;,false,false,true)); // offline/online enabled<br />
&#160;&#160;vg_ldap.done;<br />
}<br />
<br />
<br />
11 lines too many here? We have tens of thousands of those.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010102)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-05-2011 13:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We still think that you are mainly choosing the wrong approach here.<br />
<br />
First of all, if you have repetitive code, you should put it in a separate function. This way you would get rid of almost half your 11 lines.<br />
<br />
function f_...()<br />
runs on DEFAULT_MTC_CT<br />
{<br />
vg_ldap.start(f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingOriginatingOffline&quot;,&quot;0&quot;,compareTrue));<br />
&#160;&#160;vg_ldap.done;<br />
}<br />
<br />
Also, if you only have single-threaded calls on the same ptc, why then not define the function as running on the PTC and simply call the functions one after the other. There you have a blocking operation and you get rid of the pattern.<br />
<br />
In your example, this would look like this:<br />
<br />
function f_auto_configureCharging()<br />
runs on DEFAULT_MTC_CT<br />
{<br />
&#160;&#160;vg_dn := &quot;MtasCharging=0,applicationName=MtasFunction&quot; &amp; &quot;,nodeName=jambala&quot;;<br />
&#160;&#160;// Offline Orig Node Level<br />
&#160;&#160;vg_ldap.start(configure(...)) // to transmit the correct variable values to the ptc.<br />
&#160;&#160;vg_ldap.done;<br />
&#160;&#160;vg_ldap.start(f());<br />
}<br />
<br />
function f() runs on &lt;PtcType&gt; {<br />
&#160;&#160;f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingOriginatingOffline&quot;,&quot;0&quot;,compareTrue);<br />
&#160;&#160;f_gen_setMtasChargingParameter(&quot;mtasChargingOriginatingOffline&quot;,&quot;1&quot;);<br />
&#160;&#160;// Online Orig Node Level<br />
&#160;&#160;f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingOriginatingOnline&quot;,&quot;0&quot;,compareTrue);<br />
&#160;&#160;f_gen_setMtasChargingParameter(&quot;mtasChargingOriginatingOnline&quot;,&quot;1&quot;);<br />
&#160;&#160;// Offline Term Node Level<br />
&#160;&#160;f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingTerminatingOffline&quot;,&quot;0&quot;,compareTrue);<br />
&#160;&#160;f_gen_setMtasChargingParameter(&quot;mtasChargingTerminatingOffline&quot;,&quot;1&quot;);<br />
&#160;&#160;// Online Term Node Level<br />
&#160;&#160;f_gen_LdapCheckValue(vg_dn,&quot;mtasChargingTerminatingOnline&quot;,&quot;0&quot;,compareTrue);<br />
&#160;&#160;f_gen_setMtasChargingParameter(&quot;mtasChargingTerminatingOnline&quot;,&quot;1&quot;);<br />
&#160;&#160;f_gen_removeChargingDeactDests();<br />
<br />
&#160;&#160;f_gen_setMtasChargingParameter(&quot;mtasChargingDefaultCdfAddress&quot;,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;SIP_CommonDefinitions.tsp_ccfRealm1);<br />
&#160;&#160;// Charging Profile - &quot;Charging&quot;<br />
&#160;&#160;f_gen_addMtasChargingProf(&quot;Charging&quot;,&quot;3&quot;,&quot;3&quot;,false,false,true);<br />
&#160;&#160;// offline/online enabled<br />
}<br />
<br />
I agree with Jens Grabowski, though, that further discussions should be done by mail. <br />
Just write to <a href="mailto:stf430@etsi.org">stf430@etsi.org</a> or <a href="mailto:wieland@testingtech.com">wieland@testingtech.com</a> or to Jens Grabowski (address above)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010144)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2011 14:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As agreed during the STF discussion, the problem can be solved by the language instruments existing today: functions started on the different &quot;PTC&quot; types, with runs on clauses using the relevant PTC type are defined today; the MTC type can be defined as extending all PTC component types; thus, all functions started on a PTC today could also be simply called on the MTC and using the relevant &quot;subpart&quot; of the MTC only. This allows compile time checking of the called functions (as all of them do have the needed runs on clause), would solve the problem of returning a value and would result even a simpler syntax than proposed in the example code.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010177)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2011 13:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Since you've explained it already fully and the resulting code would not look different from sweetercode.txt or like function f() in my last comment, I don't know what to do here anymore.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010228)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2011 16:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thank you for your suggestions for usage of existing language instruments. <br />
<br />
However, declaring an MTC incorporating all PTC variables would seem to preclude the possibility of requesting parallel execution of functions on components. As stated in my original request, we use it rarely (currently), but it is needed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010229)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				19-07-2011 11:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We cannot imagine a setting with your highly restricted testing-style (where, as I understood it, the code flow shall reflect the test flow, basically) where you would need a ptc which is also a member of this flow. Of course, you can still have any number of ptcs beside the MTC which are not part of the flow, but with the known drawbacks of explicit synchronization.<br />
<br />
Since you yourself already are saying that you use this only rarely, it should not be a problem to then use one of the other suggested workarounds (or even the start/done pairing) in those rare places as well.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010230)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-07-2011 17:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				A real-world example of our (ab)use of the TTCN-3 language was just uploaded to your site. For example, testcase TC_CHCR_DYN0030 orders parallel execution of a function on two test components of a type, ISC session component simulating a SIP call end, that we most often use in serial execution. The testcase causes an application process to die in mid-call, which is intended to result in BYE messages sent to both call ends, and where the order in which they receive this BYE message is not important. <br />
<br />
Using PTCs, even if they were used only for serial execution, enables data access restriction (cf private class variables) that decreases the risk of undesired interferences. Your recommendation to include all variables required in the MTC instead makes all data globally accessible, which I believe is not always to be desired. Some programming languages nowadays pride themselves by not allowing global variables at all! However, I believe you do require them, but trying to minimize them is wise.<br />
<br />
Your alternative suggestion to declare two-line functions to avoid the start-done sequence I also believe many programmers would hold counter to good coding style. Reasonable function lengths - not too small, not too lengthy - has been shown to correlate with readability and maintainability - conducive to quality.<br />
<br />
So, what is the views of the TTCN-3 core language group on coding styles? Is this important in any respect for language usability and code maintainability?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010231)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				21-07-2011 10:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The problem here, I think, is that you are confusing different concepts. <br />
It seems that you view a 'component' in TTCN-3 like an 'object' in an object-oriented language while in actuality it is more on the lines of a 'thread' in an imperative one and pretty much works the same way (i.e. you have to join it explicitely and somehow use communication/synchronization mechanisms to get results from it and have to deal with it not finishing etc.).<br />
<br />
Your argument about the visibility of variables is void, since, if you continue to declare your functions to work only on a certain kind of component and then let the MTC (or other driving component) extend the different component types, the function still can only access those fields defined for its component type. This way, you get the best of both worlds. The only drawback is that you cannot have different component variables of the same name anymore, but that could be seen as a bad style anyway.<br />
<br />
Basically, you can define your 'component'-functions pretty much the same way as before, but only have to define the 'driving' function differently. And, as I said, if using ptcs is the exception instead of the rule (as you have stated more than once), then using start/done in those few places cannot hurt. Also, it is not bad style, it is just explicit which is true for most things in TTCN-3. Also, if you want to receive different messages in any order, you could also use the interleave-construct instead of ptcs, again alleviating the need for ptcs.<br />
<br />
To my knowledge, TTCN-3 is not designed in a way that you can write down things as short as possible, often opting for the more explicit way. I think it was deemed that this would yield more understandable code as implicit knowledge would not be necessary to understand it - leaving nothing open to interpretation - which is good practice when writing down standardized test suites, I guess.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010232)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-07-2011 10:24&#160;&#160;&#160;
				<br />(edited on:&#32;28-07-2011 11:06)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It seems my code examples have not been conducive to clarifying the data structures we are using to model our test environment. We use not just one instance of a component type â€“ in which case your suggestion to define an MTC extending all component types ever used would work fine- but in the general case we use an array of for example ISC session components, to model a varying number of participants in the many call scenarios handled by a Multimedia Application Server, as well as for example SDP data arrays per each ISC session component. I would upload some definition files if you require more clarification as to our data structure needs, or perhaps the above, together with the code examples already given, are enough to trigger your structural imagination. So, your suggestion is no solution for us. We really need these data array structures to be able to write general code.<br />
<br />
My confusion as regards the concept of component in TTCN-3 may not be overwhelming. I am not alone in viewing the function of a component as a way to enable data isolation, as well as a means of threaded execution for simulation of parallel component interaction with a SUT. Yes, as stated already in my initial CR entry, I realize the â€œabnormalityâ€ of using a concept, introduced to enable simulation of parallel execution, for serial execution. But doesTTCN-3 provides other means of data isolation than use of different component types?<br />
<br />
Your suggest that providing only â€œthe more explicit wayâ€ of defining operations is preferable in a language used to write standardized test suites (I donâ€™t know if our test suites can be described as â€œstandardizedâ€ â€“ is this important?). I think you disregard the fact that the creation and maintenance of a collection of test suites for a reasonably complex product is in fact a large scale programming project, in grave need of good language constructs to be able to produce readable and maintainable test code. <br />
<br />
I do not today realize for what more narrow purposes TTCN-3 was created. It seems we may have chosen the wrong tool for our type of automated testing. I think originally it was considered an advantage to use the same tool as other testing instances, to benefit from concerted efforts for creating common test port types, etc. But a general purpose programming language with proven useful constructs would probably serve us better â€“ what do you think?<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010424)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 10:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				As a compromise solution, a blocking start could be discussed, where the blocking nature is explicitly identified:<br />
MyNewPTC.start(MyFirstBehaviour(),block);<br />
<br />
it could also be allowed to write<br />
MyNewPTC.start(MyFirstBehaviour(),noblock);<br />
where &quot;noblock&quot; would be the default.<br />
<br />
The disadvantage is that block would be a new keyword, but I couldn't find a suitable existing keyword.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010438)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 11:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thank you for your attention to this matter.<br />
<br />
You have probably already discussed and rejected the existing &quot;execute&quot; keyword (to be exclusively used for testcases?). <br />
<br />
If you are introducing new keywords anyway, would you consider &quot;exec&quot;?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010442)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 13:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The point is that if there will be two different ways of starting PTC behaviour, it shall be visible explicitly, which one is blocking and which one is non-blocking. Nor execute, neither exec hints this information, thus most of the users would simply confuse the semantics of the two operations. For this reason, none of them would be a good solution.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010446)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=658">Elisabet Wahlgren</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 14:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Thank you for the explanation. This view of the abilities of the TTCN-3 user community is rather depressing. <br />
<br />
Has TTCN-3 really been designed for users without any learning capacities? Could then a user really be expected to understand the need for the &quot;execute&quot; keyword in connection with running (I will not use the e-word) a testcase? What about execution &quot;on components&quot; per se - why would this be possible to understand? How come a TTCN-3 user is expected to understand the alt/altstep functionality - very special constructs for alternative execution paths that would seem to require some form of abstract thinking. <br />
<br />
I am very surprised by the suggestion that it would be too advanced, causing confusion, to be required to distinguish between blocking and non-blocking function execution on components by using different keywords. And, after all, exec() is a rather common method of function execution in a lot of code circumstances (system calls from scripts or other programming languages, C, Erlang, etc), and for someone completely new to programming, who would have to learn a lot starting to use TTCN-3 anyway, it would be good to understand some more about execution alternatives.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0010450)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2011 16:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF decision 30-11-2011: don't change the standard as the use case can be solved using existing language features in several ways. Introducing a new keyword (and a new syntax and semantics) or re-using execute() would be inappropriate and complicate the language unnecessary.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
