<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:00 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005553: Interpretation of import mechanism - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005553</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">10-06-2010 12:34</td><td class="print">22-07-2010 12:57</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Wolfgang Seka</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.2.2 (interim 2010)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">8.2.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">MCC160</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005553: Interpretation of import mechanism</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">There seem to be different interpretations of the import mechanism as defined in cl. 8.2.3 of part 1. That results in the problem, that some compilers require additional import statements but on the other hand according to quality checks these import statements are not necessary.<br />
=&gt; it shall be evaluated whether cl. 8.2.3 needs clarification and which mechanism is intended.<br />
There is an example in the &quot;Additional Information&quot; illustrating the problem.<br />
<br />
Note: out of six compilers three of them follow one interpretation and the other three follow the other interpretation.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">The following example shows in principle the problem we have in the LTE conformance test suite (note that there may be further similar problems).<br />
<br />
Example:<br />
ModuleA:  type enumerated MyEnum_Type {valueX, valueY};<br />
ModuleB:  modulepar {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MyEnum_Type px_MyModulePar := valueX;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
ModuleC:  ...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;if (px_MyModulePar == valueY) { ...}<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
<br />
Question: Does ModuleC need to import ModuleA to know about valueX and valueY ??<br />
<br />
Reference: an argument that this import is not necessary can be restriction e) of cl. 8.2.3.1 - but the whole clause is hard to understand.</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005834</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">Enumeration values are of local scope - example is to be corrected&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5553_resolution.doc (143,872) <span class="italic">29-06-2010 18:52</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2383&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5553_resolution v2.doc (165,888) <span class="italic">01-07-2010 14:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2394&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5553_resolution v3.doc (168,448) <span class="italic">02-07-2010 11:31</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2400&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5553_resolution v4.doc (171,520) <span class="italic">12-07-2010 16:27</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2407&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5553_resolution v5.doc (171,520) <span class="italic">13-07-2010 11:43</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2408&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">10-06-2010 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">10-06-2010 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 8.2.3</td></tr><tr class="print"><td class="print">10-06-2010 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; MCC160</td></tr><tr class="print"><td class="print">28-06-2010 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">28-06-2010 16:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">29-06-2010 10:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009396</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 10:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">29-06-2010 10:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">29-06-2010 16:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 16:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 16:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 16:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009415</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 17:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 18:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 18:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009419</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 18:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 18:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009418</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009425</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009426</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009426</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009426</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009426</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">30-06-2010 11:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">30-06-2010 12:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009428</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 12:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0009428</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 12:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0009428</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 12:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009429</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 14:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009431</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 14:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009432</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009431</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 15:00</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009433</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009437</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009445</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 12:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-07-2010 14:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 14:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009450</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 14:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">02-07-2010 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009461</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">02-07-2010 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">02-07-2010 09:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">02-07-2010 09:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">02-07-2010 09:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">02-07-2010 09:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">02-07-2010 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">02-07-2010 09:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">02-07-2010 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">02-07-2010 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">02-07-2010 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009465</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">02-07-2010 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">02-07-2010 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009467</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009468</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 12:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009471</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 12:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">02-07-2010 12:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">07-07-2010 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; feedback</td></tr><tr class="print"><td class="print">07-07-2010 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009481</td><td class="print"></td></tr><tr class="print"><td class="print">07-07-2010 09:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">07-07-2010 09:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">12-07-2010 16:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution v4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2010 16:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009514</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2010 16:29</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009514</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2010 16:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009514</td><td class="print"></td></tr><tr class="print"><td class="print">12-07-2010 16:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">12-07-2010 16:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009514</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 11:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009516</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 11:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009516</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 11:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution v5.doc</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 11:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009519</td><td class="print"></td></tr><tr class="print"><td class="print">14-07-2010 10:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">14-07-2010 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">14-07-2010 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.2.2 (not yet published)</td></tr><tr class="print"><td class="print">14-07-2010 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">22-07-2010 12:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009559</td><td class="print"></td></tr><tr class="print"><td class="print">22-07-2010 12:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">30-11-2010 15:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0005834</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009396)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 10:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Clarify the issue with Wolfgang.<br />
Analyze possible ambiguity of the current text.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009415)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 16:37&#160;&#160;&#160;
				<br />(edited on:&#32;29-06-2010 17:22)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Let complete and extend the example:<br />
module A {<br />
&#160;&#160;type enumerated MyEnum_Type {valueX, valueY}<br />
&#160;&#160;type record MyRec { integer a, integer b }<br />
&#160;&#160;type component MyComp { var MyRec v_Rec := { a := 5 } }<br />
}<br />
<br />
module B {<br />
&#160;&#160;import from A all;<br />
&#160;&#160;modulepar MyEnum_Type px_MyModulePar := valueY;<br />
&#160;&#160;type component MyCompUser extends MyComp {}<br />
}<br />
<br />
module C {<br />
&#160;&#160;import from B all;<br />
//but some tools also requiring one of this:<br />
// import from A all; //or<br />
// import from B { import all }<br />
&#160;&#160;testcase TC() runs on MyCompUser {<br />
&#160;&#160;&#160;&#160;if (px_MyModulePar == valueY) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;log (&quot;name valueY is know in C without explicit import&quot;);<br />
&#160;&#160;&#160;&#160;&#160;&#160;setverdict(pass)<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;if (v_Rec.a == 5) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;v_Rec.b := v_Rec.a;<br />
&#160;&#160;&#160;&#160;&#160;&#160;log (&quot;Both the variable name v_Rec and the record field names are known in C without explicit import&quot;, v_Rec);<br />
&#160;&#160;&#160;&#160;&#160;&#160;setverdict (pass)<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
&#160;&#160;control {<br />
&#160;&#160;&#160;&#160;execute (TC())<br />
&#160;&#160;}<br />
}<br />
<br />
The solution shall be consistent for both (and all similar) cases.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009418)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 17:06&#160;&#160;&#160;
				<br />(edited on:&#32;29-06-2010 18:53)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The standard currently specifies<br />
in clause 8.2.3.1:<br />
<br />
in Table 8: what are the local definitions of different importable definitions. Enumeration values are explicitly mentioned as local definitions of the enumerated type.<br />
<br />
in Restrictions:<br />
c)	A definition is imported together with its name and all local definitions.<br />
NOTE 5:	A local definition, e.g. a field name of a user-defined record type, has only meaning in the context of the definitions in which it is defined, e.g. a field name of a record type can only be used to access a field of the record type and not outside this context.<br />
d)	A definition is imported together with all information of referenced definitions that are necessary for the usage of the imported definition, independent of the visibility of the referenced definitions (see clause 8.2.5).<br />
NOTE 6:	If a module A imports a definition from module B that uses a type reference defined in module C, the corresponding information necessary for the usage of that type is automatically imported into module A. Identifiers of referenced definitions are not automatically imported.<br />
<br />
------------------------------------end quotation-------------------------<br />
My conclusion from the above is that the standard is clear enough: in module C of the example above no direct import from module A is needed to use the value valueY in the context of the module parameter px_MyModulePar.<br />
<br />
But adding the example to the standard would not harm.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009419)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 18:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				See proposed resolution in CR5553_resolution.doc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009425)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 11:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I completely DISAGREE!<br />
<br />
The sentence <br />
&quot;A definition is imported together with all information of referenced definitions that are necessary for the usage of the imported definition, independent of the visibility of the referenced definitions (see clause 8.2.5).&quot; might imply what you mean, but since 'usage of the imported definition' is not clearly defined, it might also not.<br />
<br />
Since it is not necessary to know valueX so that px_MyModulePar can be used in a lot of cases, I don't think that the above sentence applies here.<br />
<br />
So, either it must be more clearly defined what 'necessary for the usage of the imported definition', especially for entities of enumerated types, means or the standard is ambiguous and so, of course, the tools can interpret this sentence however they want. All examples unfortunately focus only on field names necessary to write down values of structured types, so this does not help in clearing this up.<br />
<br />
In my interpretation, the enumerated type should be directly (or via import import) imported so that its enumerated values are known in the importing module.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009426)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 11:44&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2010 11:46)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jacob,<br />
<br />
Your comment is off target. The quoted sentence is about referenced definitions. What are they? e.g. in case of a record type:<br />
module A {<br />
&#160;&#160;type record MyRec { MyUnion u, MySetOf s }<br />
}<br />
the type definitions MyUnion and MySetOf are referenced from MyRec but they are not needed to assign a value to an instance of MyRec. e.g.<br />
module B {<br />
&#160;&#160;import from A { type MyRec }<br />
&#160;&#160;const MyRec c_MyRec := { u := { somechoice := 5 }, {} }<br />
}<br />
<br />
Enumerated types do reference nothing, they just do define the value set of the type. This is given explicitly in Table 8:<br />
<br />
.....................local defs_.............referenced defs<br />
enumerated......concrete values.........-<br />
struct. type....field names.............field types<br />
....................nested type defs<br />
<br />
So, I  think my conclusion on what the standard specifies today is correct.<br />
<br />
Btw. I think it is clear and also Wolfgang's example shows that the allowed values of a type are necessary to use of the instance of that type.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009428)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 12:13&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2010 12:20)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Yes, there are SOME usages, where the value needs to be known (i.e. those are those, where the value should be imported explicitly via importing its type), but there are also lots of usages, where the values do not need to be known: usage as parameter, usage as assignment, usage as comparison with another (non-enum-value) expression, etc. etc.<br />
<br />
So, NO, it is not clear that the implicit import of the values of the type of an enum-modulepar is necessary for the usage of that modulepar.<br />
<br />
Also, my comment was NOT off target. The imported definition was the modulepar. This definition references the enum type. The implicit information necessary for the usage of that referenced enum type would be the enum values defined by that type.<br />
<br />
To illustrate my interpretation, take the following example:<br />
<br />
module A {<br />
&#160;&#160;type enumerated E { a, b }<br />
&#160;&#160;function f(E x) { ... }<br />
}<br />
<br />
module B {<br />
&#160;&#160;import from A { type E }<br />
&#160;&#160;modulepar E b;<br />
}<br />
<br />
module C {<br />
&#160;&#160;import from A { function f }<br />
&#160;&#160;import from B { modulepar b }<br />
<br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;f(b); // If the implicit-import-of-enum-values interpretation is used<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// this should be ambiguous (A.b vs. B.b), <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// even though everything used is apparently<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// explicitly imported<br />
&#160;&#160;}<br />
}<br />
<br />
This example shows how confusing such implicit imports can be. If it is not possible to avoid name-clashes even in cases where everything is imported explicitly, I don't think that speaks for a good language design.<br />
<br />
Therefore, I stand by my opinion that the local names of enumerated values should only be known, if their type is EXPLICITLY imported. That way, no such confusion can arise.<br />
<br />
If you are about to argue that that would be different than for really structured types (record/union/set), then I would argue that there, the names are only usable locally (in a field-assignment context or in a field reference) so there can be no nameclashes with other imported identifiers like for enumerated values.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009429)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 12:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Since I don't want to appear all destructive, I will propose a constructive solution to the problem posed by implict imports, as well:<br />
<br />
If an enum-value name (and those are the only ones that cause such nameclash-problem) is imported explicitly and implicitly, the identifier shall be resolved using the explicit import in favor of the implicit import. <br />
<br />
Thereby, it is possible for the user to control (via explicit imports) which names should be unambiguous in their module. <br />
<br />
Such a sentence would need to be added to the definition of the import statement.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009431)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 14:27&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2010 14:54)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jacob,<br />
<br />
OK let's take a cold start. When we talk about &quot;transitive import&quot; like in the case<br />
module A defines type -&gt; module B defines value -&gt; module C uses the value;<br />
you are right, the value imported to module C will have a referenced definition, as you correctly wrote &quot;The imported definition was the modulepar. This definition references the enum type. The implicit information necessary for the usage of that referenced enum type would be the enum values defined by that type.&quot;<br />
<br />
But I don't understand why in this concrete case the enumeration values should not be imported. As I quoted above,<br />
&quot;d) A definition is imported together with all information of referenced definitions that are necessary for the usage of the imported definition, independent of the visibility of the referenced definitions (see clause 8.2.5).<br />
NOTE 6: If a module A imports a definition from module B that uses a type reference defined in module C, the corresponding information necessary for the usage of that type is automatically imported into module A. Identifiers of referenced definitions are not automatically imported.&quot;<br />
In the note exactly the case we are talking about is described. So, I do not understand, where is the ambiguity?<br />
<br />
Can the equality   if (px_MyModulePar == valueY)   be executed (or even checked) without knowing the values of the type? I don't think so. So, at least in this concrete case, into this concrete module C the module parameter shall be imported together with the &quot;information necessary for the usage of a referenced definition&quot;; if it is not done like this, the concrete tool in this concrete case fails to comply with the standard.<br />
<br />
Pls. note, that enumeration values ARE NOT GLOBAL NAMES. They have meaning in the context of the given enumerated type only. This is true even if they impose some restriction on global names. So, e.g. in the case<br />
module A {<br />
&#160;&#160;type enumerated Enum { e1, e2 }<br />
}<br />
module B {<br />
&#160;&#160;import from A all;<br />
&#160;&#160;const integer e1 := 1;<br />
&#160;&#160;const integer e2 := e1;<br />
}<br />
no name clash occur as in module B the name e1 and e2 are used in the context of the integer type! This is defined unambiguously in $6.2.4: &quot;Enumeration identifiers shall be unique within the enumerated type (but do not have to be globally unique) and are consequently visible within the context of the given type only.&quot;<br />
<br />
<br />
I don't understand why are you writing that &quot;If it is not possible to avoid name-clashes even in cases where everything is imported explicitly, I don't think that speaks for a good language design.&quot; ? In TTCN-3 it is possible to avoid name clashes by using the qualified names. It is also unclear to me how an explicit import statement would help solving name clashes. The rules today are not importing the name &quot;Enum&quot; in the example above. 1 name less in module B. But users tend to like short code lines, so they are practically always using the import all option. And this results importing a lots of names that are not referenced at all in the importing module. So, your proposal would be very unpractical, not giving any advantage, but causing a lots of unnecessary extra (potential) name clashes.<br />
<br />
And one more point. Changing the standard would raise a huge backward compatibility problem. Users of tools working according to the standard, i.e. not requiring import from A in module C, have no import statements in their codes. Therefore changing the standard would be an issue for them. Users of the tools requiring the extra import statement will not notice anything if the tool &quot;below them&quot; changes to the standard behaviour. So, for them there is no compatibility problem.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009432)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 14:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				My comment posted at 13:27 responded to Jacob's comment posted at 11:13. While writing a comment, no new contributions can be seen.<br />
<br />
Jacob, could you pls. elaborate more on your proposal, probably an example would help to understand it.<br />
<br />
Have you noticed the sentence(s) in the proposal saying, that names of the values take precedence over global definition names?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009433)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 15:00&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&gt; Jacob, could you pls. elaborate more on your proposal, probably an example would help to understand it.<br />
<br />
I'll give a few examples:<br />
<br />
module A {<br />
&#160;type enumerated E { a, b }<br />
&#160;function f(E x) { ... }<br />
}<br />
<br />
module B {<br />
&#160;&#160;import from A { function f }<br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;f(a); // =&gt; f(A.a) because of implicit import and parameter context<br />
&#160;&#160;}<br />
}<br />
<br />
module C {<br />
&#160;&#160;import from A { type E }<br />
&#160;&#160;modulepar E b, x;<br />
}<br />
<br />
module D { <br />
&#160;&#160;import from C { modulepar x, b }<br />
&#160;&#160;type enumerated E2 { a, b }<br />
<br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;if (x == a) { // works (C.x == A.a)<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;if (x == b) { // works (C.x == C.b)<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;if (a == b) { // works (A.a == C.b) (there is no context suggesting E2)<br />
&#160;&#160;&#160;&#160;} <br />
&#160;&#160;}<br />
}<br />
<br />
module F {<br />
&#160;&#160;import from A { function f }<br />
&#160;&#160;import from C { modulepar b }<br />
<br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;f(b); // =&gt; f(C.b) because of explicit import<br />
&#160;&#160;&#160;&#160;if (b == a) { // =&gt; (C.b == A.a) because of explicit import<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
&gt; Have you noticed the sentence(s) in the proposal saying, that names of the values take precedence over global definition names?<br />
<br />
Yes, and I'm more in favor of the other way around, if the enumerated type is the same. <br />
<br />
On account of the backward compatibility issue for the tools that up-to-now interpreted the enum values without explicit import of the enum types, you are right. But, I think my new proposal addresses this issue adequately.<br />
<br />
On the question of disambiguation by the user: There are always two ways to resolve name-clashes (at least, there should be): fewer imports (i.e. explicit imports) or use of qualified names. Since using the qualified names at a thousand places is probably more unacceptable than changing one import statement (to exclude an enumerated type whose values I don't want to use explicitly), I think that the users will rather use the latter than the former, even though the former is always more robust against later changes.<br />
<br />
But, if a testsuite opts for the non-lazy approach of using explicit imports, they should be able to control via these imports how the unqualified names shall be resolved. Otherwise, the explicit import is a feature that nobody needs because if it does not help in disambiguation, what is it good for?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009437)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 17:39&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2010 17:46)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK, we are closer now. Let's look at your examples:<br />
module D { <br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;if (x == a) { // works (C.x == A.a)<br />
//Gy: I agree<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;if (x == b) { // works (C.x == C.b)<br />
/*Gy: how to compare x with value b of E1? As value b is not a global name, cannot be prefixed. The only way to distinguish them unambiguously is to use the local value without prefix and the global name with an explicit prefix, i.e. x == C.b. This is also more consistent with the previous case, where the name a (without prefix) means the local name. Think about the writer of module D, importing all from module C (this is a usual way of importing), later someone adds a definition with name b to module C and suddenly &quot;by magic&quot; and, mainly without any notification, the behaviour of module D changes! Think about the tester debugging, why his regression test changed verdict from one day to another :(( */<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;if (a == b) { // works (A.a == C.b) (there is no context suggesting E2)<br />
// Gy: I agree<br />
&#160;&#160;&#160;&#160;} <br />
&#160;&#160;}<br />
}<br />
<br />
module F {<br />
&#160;&#160;function g() {<br />
&#160;&#160;&#160;&#160;f(b); // =&gt; f(C.b) because of explicit import<br />
/* Gy: don't agree, the formal parameter of f is of type E that creates the context. The same backward compatibility problem exists as with the x==b example above */<br />
&#160;&#160;&#160;&#160;if (b == a) { // =&gt; (C.b == A.a) because of explicit import<br />
// Gy: I agree<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009445)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2010 11:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				If it is true that the enum-value-names cannot be prefixed by the module-name of the module that introduced them (which is another weakness in the whole proposal in my opinion), then of course, you are right that they must have precedence if the context can be clearly determined as an enumerated type as otherwise, they cannot be used in a context that also imports/declares the same name (with the same type).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009450)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2010 14:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				More detailed clarification on the type context is added to CR5553_resolution v2.doc and a few more examples.<br />
<br />
Pls. cross-check it.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009461)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 09:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				proofreading OK			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009465)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 10:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have one more problem: backward compatibility the other way around.<br />
<br />
There will be a lot of test-suites that used the interpretation of our tool that the enum-value-names are (kind of) global names introduced by the module where they are declared and therefore can be prefixed with the module name for disambiguation purposes.<br />
<br />
For backward compatibility of these test-suites it would be good if such qualified names would still be explicitly allowed (maybe as a deprecated feature so the tools can warn the users that this is not a wanted feature anymore).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009467)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 11:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Good point, I will add this as a deprecated feature.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009468)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 11:32&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Added to CR5553_resolution v3.doc, pls. review.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009471)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 12:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				OK by me.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009481)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-07-2010 09:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Request from Andrus Lehtmets (Elvior): Add following note:<br />
<br />
&quot;NOTE 7: If a module B imports a value or template or parameter of an<br />
enumerated type from module A, the enumerated values of this type<br />
including identifiers are automatically imported to module B.&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009514)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-07-2010 16:29&#160;&#160;&#160;
				<br />(edited on:&#32;12-07-2010 16:31)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR5553_resolution v4.doc:<br />
The proposed note is re-worded and added to existing Note 6 as a new paragraph (but with unchanged technical content). Pls. proof-read.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009516)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2010 11:42&#160;&#160;&#160;
				<br />(edited on:&#32;13-07-2010 11:43)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;Implicit&quot; (importing) and a sentence on use of the values are added to the new paragraph of the note. Pls. proof-read, if OK, set to resolved and assign to Ina.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009519)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2010 11:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think this is now sufficiently clear (together with the examples)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009559)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-07-2010 12:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				small editorials			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
