<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:43 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005513: resolution of CR5092 contains bogus examples for charstring - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005513</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">14-04-2010 15:24</td><td class="print">15-12-2010 00:41</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">high</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">7.1.2</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Jacob Wieland</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005513: resolution of CR5092 contains bogus examples for charstring</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In the CR 5092, there are several misleading (or WRONG?) examples concerning concatenation of charstring templates. While mapping * length(N) to a repetition of N ? makes sense in the context of octetstring, hexstring and bitstring types (because there ? has a special meaning already), it does NOT make sense in the context of charstring, as there the character ? is just another character with no special meaning. The only context where that is the case are charstring patterns.<br />
<br />
Thus, either the examples are wrong for charstring or it should be explained that concatenating a normal charstring value (template) with a length-template should result in a charstring pattern template (if that is the intention), i.e. all special characters in the charstring value template need to be quoted.<br />
<br />
I.e. '&quot;a*?&quot; &amp; * length(2)' would result in a template equivalent to <br />
the charstring template expression 'pattern &quot;a\*\???&quot;'<br />
<br />
Interpreting this as the template &quot;a*???&quot; (without pattern) would not make much sense as that would only match the value &quot;a*???&quot; which is totally different from the meaning in the other string types and thus would be totally confusing for the user.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">This should actually be a note added to CR5092, but since I was told not to reopen closed CRs, I'm submitting a new one.</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005092</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></span>&#160;</td><td class="print">String concatination is not possible for string templates&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005809</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">CL chapter 15.11 Concatenating templates of string and list types is not supported by BNF&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005828</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">STF409 comment on [Part 1: TTCN-3 Core Language /Annex B.1.5.2 ]: syntactical ambiguity&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v2.doc (86,528) <span class="italic">30-06-2010 15:52</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2388&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v3.doc (93,184) <span class="italic">01-07-2010 18:01</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2399&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v4.doc (91,648) <span class="italic">02-07-2010 13:44</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2402&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v5.doc (90,112) <span class="italic">13-07-2010 11:58</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2409&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v6.doc (90,112) <span class="italic">14-07-2010 11:47</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2410&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v7.doc (91,648) <span class="italic">22-07-2010 12:58</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2412&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution v8.doc (91,136) <span class="italic">01-12-2010 10:10</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2448&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR5513_resolution_v9.doc (91,648) <span class="italic">01-12-2010 10:10</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2449&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">14-04-2010 15:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">14-04-2010 15:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 7.1.2</td></tr><tr class="print"><td class="print">14-04-2010 15:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Jacob Wieland</td></tr><tr class="print"><td class="print">14-04-2010 15:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005092</td></tr><tr class="print"><td class="print">28-06-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">28-06-2010 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">29-06-2010 10:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">29-06-2010 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009399</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">29-06-2010 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009399</td><td class="print"></td></tr><tr class="print"><td class="print">29-06-2010 12:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009405</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 08:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5553_resolution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 08:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009420</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 10:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009423</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 13:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009430</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 15:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009434</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR5553_resolution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 15:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution v2.doc</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 15:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">30-06-2010 15:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009434</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 17:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009436</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 16:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009456</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 16:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009456</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 18:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution v3.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 18:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009459</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 09:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">02-07-2010 09:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009460</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009466</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Benjamin Zeiss</td></tr><tr class="print"><td class="print">02-07-2010 11:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009470</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 12:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009472</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 12:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009473</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 13:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009472</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 13:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009472</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 13:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009472</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 13:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution v4.doc</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 13:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009474</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 14:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009477</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2010 15:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Note Added: 0009483</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2010 15:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a></td><td class="print">Assigned To</td><td class="print">Benjamin Zeiss =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">13-07-2010 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009520</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 11:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution v5.doc</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2010 17:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009520</td><td class="print"></td></tr><tr class="print"><td class="print">14-07-2010 10:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009522</td><td class="print"></td></tr><tr class="print"><td class="print">14-07-2010 11:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution v6.doc</td><td class="print"></td></tr><tr class="print"><td class="print">14-07-2010 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009523</td><td class="print"></td></tr><tr class="print"><td class="print">14-07-2010 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">14-07-2010 11:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">22-07-2010 12:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5513_resolution v7.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-07-2010 13:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009560</td><td class="print"></td></tr><tr class="print"><td class="print">22-07-2010 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">22-07-2010 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.2.2 (not yet published)</td></tr><tr class="print"><td class="print">29-11-2010 12:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">closed =&gt; feedback</td></tr><tr class="print"><td class="print">29-11-2010 12:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">29-11-2010 12:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009826</td><td class="print"></td></tr><tr class="print"><td class="print">29-11-2010 13:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005808</td></tr><tr class="print"><td class="print">29-11-2010 13:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship deleted</td><td class="print">related to 0005808</td></tr><tr class="print"><td class="print">29-11-2010 13:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005809</td></tr><tr class="print"><td class="print">29-11-2010 13:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009829</td><td class="print"></td></tr><tr class="print"><td class="print">29-11-2010 15:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005828</td></tr><tr class="print"><td class="print">29-11-2010 16:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0009829</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 11:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5513_resolution v8.doc</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 11:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009840</td><td class="print"></td></tr><tr class="print"><td class="print">30-11-2010 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">30-11-2010 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">30-11-2010 11:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-12-2010 09:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009872</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 09:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR5513_resolution_v9.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 09:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">01-12-2010 09:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">01-12-2010 09:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">01-12-2010 09:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Fixed in Version</td><td class="print">Edition 4.2.2 (not yet published) =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">01-12-2010 10:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Deleted: CR5513_resolution v8.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Deleted: CR5513_resolution_v9.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5513_resolution v8.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR5513_resolution_v9.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009878</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 15:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">15-12-2010 00:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009978</td><td class="print"></td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009399)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 10:54&#160;&#160;&#160;
				<br />(edited on:&#32;29-06-2010 10:55)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Agreed in principle, examples are incorrect, concatenating * length(2) to specific charstring values shall be disallowed; create proposed text.<br />
Target: interim version!<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009405)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-06-2010 12:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In principle, I don't think it should be disallowed to concatenate different charstring templates to get a new template in general.<br />
<br />
I.e. if t1 and t2 are valid charstring template expressions, then t1 &amp; t2 should match a charstring value v, if there exists a concatenation v1 &amp; v2 == v so that t1 matches v1 and t2 matches v2. The same extension can be added to the other string types, as well.<br />
<br />
But, for the interim version, I think that forbidding concatenation on charstring templates is the right way to go.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009420)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 08:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Proposed resolution is uploaded in CR5513_resolution.doc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009423)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 10:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have a few other (major) criticisms to this proposal:<br />
<br />
1) The BNF does not allow expressions like A &amp; * length(N) because length(N) is only derivable from ExtraMatchingAttributes, which is at the end of TemplateBody which cannot be derived from MulExpression (which is both the left and the right side of AddExpression where &amp; is the operator.<br />
<br />
=&gt; Thus, the Examples have to be changed putting () around the * length(N) part.<br />
(I don' think that the grammar should be changed to accommodate the present examples as that would open up a major can of worms)<br />
<br />
2) I think that * length(N) in concatenations should rather be ? length(N)<br />
This is because ? and ? length(N) are already valid string matching mechanisms while * is only a valid matching mechanism for an optional field, also matching omit. Since in a concatenation, we are not dealing with fields and we are not really inside values (where * has a different semantics), using * (while not being totally wrong no omit can occur anyway) is misleading. Also, the ? length(N) is forbidden explicitly by the text which I think is totally wrong.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009430)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 13:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I think the attached file is supposed to be in a different CR			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009434)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 15:50&#160;&#160;&#160;
				<br />(edited on:&#32;30-06-2010 15:53)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Good points. See updated proposal in CR5513_resolution v2.doc.<br />
<br />
I have added the BNF and allowed both ? length (N) and * length (N). I see no reason to restrict the syntax only for one of them, though they mean the same. Clause B.1.4.1 allows length for both, to be more restrictive here would be seen by the user as further exception rule. Also more convenient for the user when e.g. changing already existing * to something concatenated.<br />
<br />
Pls. review.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009436)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 17:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Sorry, but the changes to the BNF do not work.<br />
<br />
As far as I can see, the concatenated template cannot begin with ? length(N), i.e. there is no derivation for <br />
<br />
? length(N) &amp; 'aa'O<br />
<br />
Why should this be?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009456)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2010 16:17&#160;&#160;&#160;
				<br />(edited on:&#32;01-07-2010 16:18)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Need not, just the BNF proposal is not complete enough. I will update.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009459)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2010 18:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Pls. find the updated BNF proposal in CR5513_resolution v3.doc. To identify the additions, they are marked with yellow background as the BNF itself contains blue underlined font.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009460)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 09:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Ina, pls. cross-check!			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009466)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 11:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Contentwise it looks ok - Benjamin, could you however please check that there is no reduce conflict.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009470)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 11:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This proposal is better, but it has a different problem.<br />
<br />
The grammar now is ambiguous because SimpleSpec can be followed by ExtraMatchingAttributes which also can derive to LengthMatch,<br />
<br />
so, in TemplateBody expressions like<br />
<br />
'aa'O &amp; ? length(10)<br />
<br />
it needs to be clarified if the length(10) is the LengthMatch of MatchingSymbol or TemplateBody.<br />
<br />
I think it should be the former, but this needs to be clarified in the static semantics, i.e. by enforcing the LengthMatch for AnyValue and AnyValueOrOmit in concatenations. Thereby, it is clear that the length directly after ? must be part of the MatchingSymbol.<br />
<br />
Thus, I propose the following:<br />
<br />
/* STATIC SEMANTIC â€“ LengthMatch must be used when MatchingSymbol is used in fractions of a concatenated string, otherwise it shall only be used inside list templates (see clause 15.11). In both cases, the Complement, ValueOrAttribList, Range, BitStringMatch, HexStringMatch, OctetStringMatch, CharStringMatch, SubsetMatch and SupersetMatch productions shall not be used.<br />
*/			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009472)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 12:40&#160;&#160;&#160;
				<br />(edited on:&#32;02-07-2010 13:38)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Within simple list templates the length from the path TemplateBody -&gt; ArrayValueOrAttrib -&gt; ArrayElementSpecList -&gt; ArrayElementSpec -&gt; TemplateBody  is used, thus this newly added length shall be used with concatenation ONLY. But I agree that in case of concatenation length shall be mandatory.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009473)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 12:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				All the better, then change the text to: <br />
<br />
/* STATIC SEMANTIC â€“ LengthMatch must be used when MatchingSymbol is used in fractions of a concatenated string. In that case, the Complement, ValueOrAttribList, Range, BitStringMatch, HexStringMatch, OctetStringMatch, CharStringMatch, SubsetMatch and SupersetMatch productions shall not be used.<br />
*/			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009474)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 13:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR5513_resolution v4.doc: only updates in BNF. One more static rule is added to TemplateBody to exclude e.g.<br />
'01'B &amp; ? length(2) length (3).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009477)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 14:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Why, why, why???<br />
<br />
The overall length restriction also makes sense in situations where there are * wildcards inside the string-templates:<br />
<br />
'aa*bb'O &amp; ? length(1 .. 10) length(3 .. 40)<br />
<br />
So, I don't think that the restriction is necessary, move to strike.<br />
<br />
With the static semantic at the MatchingSymbol, the grammar is unambiguous in case that only one length() is provided (if it ends with ?/* length, then it is the inner length, if it ends with a different expression, it is the outer length) and it is also unambiguous if it ends with ?/* length() length()			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009483)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=510">Benjamin Zeiss</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-07-2010 15:14&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Looking for shift-reduce and reduce-reduce conflicts by hand is obviously not an easy task ;-) Anyhow, here is what I tried in my limited time since last week: <br />
<br />
I took the 4.2.1 grammar and converted the EBNF model to a BNF model. From that, I wrote a template that converted the grammar to an input grammar of the LALR GOLD parser which is a pretty nice tool to debug and browse LALR states. Due to the way I converted the grammar, there were already numerous conflicts (but that exist mostly due to the transformation). When ignoring them and incorporating the changes from this CR, I was able to rewrite both EBNF changes to BNF so that they did not produce any new conflicts. So from that, I more or less conclude that the changes should be reasonably safe. I will definately fiddle around with this a little more to see whether I can resolve the problems with the transformation conflicts or at least a number of them. Unfortunately, my time to work on this in this week has run out and Gyorgy asked me to reassign the CR to Ina in this week when I'm done. So this is what I'm doing now.<br />
<br />
It would probably be worthwhile to go through the sr/rr conflicts again when I have the grammar conversion in a state that doesn't produce as many initial conflicts.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009520)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2010 11:58&#160;&#160;&#160;
				<br />(edited on:&#32;13-07-2010 17:03)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&quot;Why, why, why???<br />
The overall length restriction also makes sense in situations where there are * wildcards inside the string-templates:<br />
<br />
'aa*bb'O &amp; ? length(1 .. 10) length(3 .. 40)&quot;<br />
<br />
It may look a little bit confusing for the user but I admit, this does not seem to be sufficient to forbid this. So, it is OK to remove the new static rule from Templatebody. Done in CR5513_resolution v5.doc.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009522)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-07-2010 10:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The only thing wrong in v5 is the following example:<br />
<br />
template RecofInt t_MyRecofInt := { 1, 2 } &amp; { ? length(2), 3, 4 };<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// results the template {1, 2, ?, ?, 3, 4 }<br />
<br />
This should be:<br />
<br />
template RecofInt t_MyRecofInt := { 1, 2 } &amp; ? length(2) &amp; { 3, 4 };<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// results the template {1, 2, ?, ?, 3, 4 }<br />
<br />
Otherwise, it is ok.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009523)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-07-2010 11:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This is a typo in the example, it was changed unintentionally, the original intention was:<br />
template RecofInt t_MyRecofInt := { 1, 2 } &amp; { * length(2), 3, 4 };<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// results the template {1, 2, ?, ?, 3, 4 } <br />
<br />
It is corrected in CR5513_resolution v6.doc.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009560)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-07-2010 13:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				small editorials, also in examples			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009826)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-11-2010 12:57&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The LengthMatch for Any and AnyOrOmit in the rule for MatchingSymbol in the BNF should be restricted to contain no optional upper bound (to be consistent with the text).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009829)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				29-11-2010 13:49&#160;&#160;&#160;
				<br />(edited on:&#32;29-11-2010 16:04)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				There is an ambiguity problem with the proposal:<br />
<br />
If SingleExpression derives &quot;X &amp; Y&quot;, but also only &quot;X&quot; or &quot;Y&quot; and <br />
SingleValueOrAttrib derives SingleExpression, we have two ways <br />
of deriving &quot;X &amp; Y&quot; from SimpleSpec.<br />
<br />
Also, there is another ambiguity with CharStringMatch which can also contain &quot;&amp;&quot;.<br />
<br />
Therefore, we should change the grammar in the following manner:<br />
<br />
SimpleSpec ::= SingleExpression [&quot;&amp;&quot; SimpleTemplateSpec]<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;| SimpleTemplateSpec<br />
<br />
SimpleTemplateSpec ::= CharStringMatch <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;| SingleTemplateExpression [&quot;&amp;&quot; SimpleSpec] <br />
<br />
SingleTemplateExpression ::= MatchingSymbol<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;| ( TemplateRefWithParList [ExtendedFieldReference] )<br />
<br />
MatchingSymbol ::= <br />
&#160;&#160;Complement |<br />
&#160;&#160;AnyValue |<br />
&#160;&#160;AnyOrOmit |<br />
&#160;&#160;ValueOrAttribList |<br />
&#160;&#160;Range |<br />
&#160;&#160;BitStringMatch |<br />
&#160;&#160;HexStringMatch |<br />
&#160;&#160;OctetStringMatch |<br />
&#160;&#160;SubsetMatch |<br />
&#160;&#160;SupersetMatch<br />
<br />
This basically resolves the ambiguity in favor of INNER &amp; operators in case there is a shift/reduce conflict.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009840)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-11-2010 11:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Updated the resolution (v8) acc. to Jacobs feedback - please check			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009872)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 09:16&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				First example corrected (&quot;*&quot; was missing in the middle template to be concatenated). See in CR5513_resolution v9.doc			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009878)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 10:11&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Fixed BNF issue on WildcardLengthMatch			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009978)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-12-2010 00:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				One last correction for WildcardLengthMatch:<br />
<br />
128. WildcardLengthMatch ::= LengthKeyword &quot;(&quot; ConstantExpression &quot;)&quot;			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
