<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:23 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005393: Follow-up: 0005291: BNF - friend definitions should have no visibility - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005393</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Editorial</td><td class="print">public</td><td class="print">13-10-2009 16:01</td><td class="print">08-12-2009 18:28</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Philip Makedonski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v4.1.1 (published 2009-06)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print-category">Fixed in Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">A.1.6.1.0 General, Multiple</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">University of GÃ¶ttingen  </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005393: Follow-up: 0005291: BNF - friend definitions should have no visibility</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Since I cannot reopen a closed issue, this issue is related to issue <a href="/mantis/view.php?id=5291" title="[closed] BNF - friend definitions should have no visibility" class="resolved">0005291</a> and the visibility problems with friend modules, import statements and groups:<br />
<br />
<br />
(original text by Gyorgy Rethy, my comments in the bottom)<br />
<br />
The current BNF allows visibility for friend definitions, while the textual part (clause 8.2.4) does not:<br />
8.2.4 Definition of friend modules<br />
&#160;&#160;Syntactical Structure<br />
&#160;&#160;friend module ModuleIdentifier { &quot;,&quot; ModuleIdentifier } &quot;;&quot;<br />
<br />
On the other hand side clause 8.2.5 says &quot;(top level definitions) They are by default public except for imported definitions which are by default private.&quot;<br />
<br />
Thus friend definitions, according to $8.2.5, should be public. But, in fact, they have meaning for the given module only and they are not importable; hence, as a matter of fact, they are always private.<br />
-------------------<br />
Two solutions are possible:<br />
1) (preferred) Make the private keyword mandatory in $8.2.4:<br />
Syntactical Structure<br />
&#160;&#160;private friend module ModuleIdentifier { &quot;,&quot; ModuleIdentifier } &quot;;&quot;<br />
<br />
2) Modify the text in $8.2.5:<br />
&quot;They are by default public except for imported definitions and friend definitions which are by default private.<br />
...<br />
The visibility of imported definitions and friend definitions are by default always private. All other module definitions are by default public.&quot;<br />
-------------<br />
Solution 1), though would introduce a mandatory syntax, which is optional for other definitions, is the preferred one, as solution 2) would introduce a new exception; users looking at a friend definitions without a visibility keyword could think that friend lists are also imported.<br />
<br />
======================================================<br />
<br />
(commment by Ina Schieferdecker)<br />
<br />
In analogy to groups, which can be public only, a solution can be:<br />
<br />
[ private ] friend module ModuleIdentifier { &quot;,&quot; ModuleIdentifier } &quot;;&quot;<br />
<br />
Adding a restriction:<br />
<br />
In addition to the general static rules of TTCN 3 given in clause 5, the following restrictions apply:<br />
<br />
a) Only private visibility can be defined for friend definitions as they are always private.<br />
<br />
And extending 8.2.5 accordingly:<br />
<br />
Top-level module definitions and import statements have a visibility, which can be explicitly set. They are by default public except for imported and friend definitions. Import definitions are by default private. Friend definitions are private only. Group definitions are public only.<br />
<br />
======================================================<br />
<br />
(my comments)<br />
<br />
...and confusion ensues...<br />
<br />
Why does the description as &quot;by default&quot; keep being brought up in the context of import and friend definitions? The standard currently says &quot;private only&quot; and &quot;always private&quot; for imports and &quot;public only&quot; and &quot;always public&quot; for groups. What would &quot;private by default&quot; suggest in this context? That they can eventually be made friend or public?!<br />
<br />
I'd keep the wording consistent to avoid further confusion - either &quot;public only&quot; or &quot;always public&quot; in all instances, but adding &quot;by default&quot; to the mix is going to far if by that one of the former expressions is meant.. that is if I am not missing some part of the discussion..<br />
<br />
So to spell it out: Multiple adaptations will be necessary in text, to cover all the instances, but briefly:<br />
<br />
&quot;Import and friend definitions cannot be imported and thus can be private only, group definitions can be public only. All other importable definitions are public by default.&quot; <br />
<br />
This would reflect the default visibility settings (in the case that the syntax is not changed so as to require that imports and friends are explicitly declared as private, although it will be necessary sooner or later). <br />
<br />
In any case, one proposal for the syntax will therefore be:<br />
<br />
{<br />
&#160;(<br />
&#160;&#160;( [ &quot;private&quot; ]<br />
&#160;&#160;&#160;&#160;( ImportDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;FriendDef <br />
&#160;&#160;&#160;&#160;)<br />
&#160;&#160;) <br />
&#160;|<br />
&#160;&#160;( [ &quot;public&quot; ]<br />
&#160;&#160;&#160;&#160;GroupDef<br />
&#160;&#160;) <br />
&#160;|<br />
&#160;&#160;( [ Visibility ] (<br />
&#160;&#160;&#160;&#160;&#160;&#160;TypeDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;ConstDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;TemplateDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;ModuleParDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;FunctionDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;SignatureDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;TestcaseDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;AltstepDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;ExtFunctionDef<br />
&#160;&#160;) <br />
&#160;) <br />
&#160;[ WithStatement ]<br />
&#160;[ &quot;;&quot; ]<br />
}+<br />
<br />
, where the optionality of the &quot;private&quot; and &quot;public&quot; visibility modifiers may be dropped.<br />
<br />
Changes have to be propagated accordingly to all the relevant sections.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">13-10-2009 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=520">Philip Makedonski</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">13-10-2009 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=520">Philip Makedonski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">13-10-2009 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=520">Philip Makedonski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">13-10-2009 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=520">Philip Makedonski</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; A.1.6.1.0 General, Multiple</td></tr><tr class="print"><td class="print">13-10-2009 16:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=520">Philip Makedonski</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; University of GÃ¶ttingen  </td></tr><tr class="print"><td class="print">07-12-2009 14:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">08-12-2009 18:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009107</td><td class="print"></td></tr><tr class="print"><td class="print">08-12-2009 18:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009108</td><td class="print"></td></tr><tr class="print"><td class="print">08-12-2009 18:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">08-12-2009 18:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">08-12-2009 18:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">08-12-2009 18:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009107)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-12-2009 18:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In version 4.1.3, the import of imports has been introduced. Therefore it is required that import statements can be made visible - in order to enable their imports. They are private by default, which means that whenever no visibility is given the import statement is a private one. By giving a visibility explicitly, the visibility of imports can be overwritten.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009108)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-12-2009 18:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It was agreed to make the various cases for visibility explicit in the BNF:<br />
<br />
ModuleDefinition ::= ( ([Visibility] <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;( TypeDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ConstDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TemplateDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ModuleParDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;FunctionDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;SignatureDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestcaseDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;AltstepDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ImportDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ExtFunctionDef |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ExtConstDef )<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;) |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;([&quot;public&quot;] GroupDef ) |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;([&quot;private&quot;] FriendModuleDef )<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;) [WithStatement]			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
