<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:08 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0005220: TCI C++ Mapping Issues - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 06: TTCN-3 Control Interface</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0005220</td><td class="print">Part 06: TTCN-3 Control Interface</td><td class="print">Clarification</td><td class="print">public</td><td class="print">02-06-2009 14:44</td><td class="print">18-03-2010 07:40</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print-category">Fixed in Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">TCI C++ mapping clause</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">INRIA, France</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0005220: TCI C++ Mapping Issues</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">1. The C++ mapping introduced in this new version of the interface uses <br />
design conventions that are Java-like and are not easily interoperable <br />
with the C++ standard libraries.<br />
eg:<br />
<br />
&gt; class TciModuleIdList {<br />
&gt; public:<br />
&gt; virtual ~TciModuleIdList();<br />
&gt; virtual Tsize size () const =0;<br />
&gt; virtual Tboolean isEmpty () const =0;<br />
--&gt; should be virtual Tboolean empty() const =0;<br />
<br />
&gt; virtual const std::vector&lt; const TciModuleId * &gt; &amp; getComponents () <br />
&gt; const =0;<br />
--&gt; this puts too much design constaints on the implementation of the interface<br />
&#160;&#160;&#160;&#160;(especially the TciModuleId needs to be stored in a vector of pointers)<br />
<br />
&gt; virtual const TciModuleId &amp;get (Tsize p_index) const =0;<br />
--&gt; should be :<br />
&#160;&#160;&#160;&#160;virtual const TciModuleId &amp;at (Tsize p_index) const =0;<br />
&#160;&#160;&#160;&#160;virtual const TciModuleId operator[] (Tsize p_index) const =0;<br />
<br />
&gt; virtual void clear ()=0;<br />
&gt; virtual void add (const TciModuleId &amp;comp)=0;<br />
--&gt; should be :<br />
&#160;&#160;&#160;&#160;virtual void push_back (const TciModuleId &amp;comp)=0;<br />
<br />
&gt; virtual Tboolean equals (const TciModuleIdList &amp;midList) const =0;<br />
--&gt; should be :<br />
&#160;&#160;&#160;&#160;virtual Tboolean operator== (const TciModuleIdList &amp;midList) const =0;<br />
<br />
&gt; virtual TciModuleIdList * cloneModuleIdList () const =0;<br />
--&gt; should be : virtual TciModuleIdList * clone () const =0;<br />
<br />
&gt; virtual Tboolean operator&lt; (const TciModuleIdList &amp;midList) const =0;<br />
&gt; }<br />
<br />
2. Section 10.5 is self-contradictory<br />
&gt; Pure virtual classes have been used, following the concept of an interface.<br />
&gt; The Standard Template Library (STL) has been used as it is a standardized<br />
&gt; way of using container classes, and iterators, such as lists. All classes<br />
&gt; define the operator &quot;&lt;&quot; for easy insertion in STL containers.<br />
<br />
The STL containers require that the contained class is <br />
copy-constructible. However the classes in the C++ mapping are not <br />
copy-constructible (the are abstract base classes containing pure <br />
virtual functions), therefore they cannot be used in STL containers.<br />
Moreover, some STL containers require the operator '==' instead of '&lt;' <br />
(eg: unordered_set and unordered_map)<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;es_20187306v040102.zip (1,317,758) <span class="italic">18-03-2010 07:40</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2340&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">02-06-2009 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">02-06-2009 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">02-06-2009 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">02-06-2009 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; TCI C++ mapping clause</td></tr><tr class="print"><td class="print">02-06-2009 14:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; INRIA, France</td></tr><tr class="print"><td class="print">05-06-2009 11:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a></td><td class="print">Note Added: 0008724</td><td class="print"></td></tr><tr class="print"><td class="print">05-06-2009 11:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a></td><td class="print">Note Added: 0008725</td><td class="print"></td></tr><tr class="print"><td class="print">08-06-2009 13:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=552">JesÃºs DomÃ­nguez</a></td><td class="print">Note Added: 0008730</td><td class="print"></td></tr><tr class="print"><td class="print">10-06-2009 18:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a></td><td class="print">Note Added: 0008738</td><td class="print"></td></tr><tr class="print"><td class="print">15-06-2009 14:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=556">Raul Alfonso</a></td><td class="print">Note Added: 0008770</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2009 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 06: TTCN-3 Control Interface</td></tr><tr class="print"><td class="print">30-06-2009 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Category</td><td class="print">TCI =&gt; Clarification</td></tr><tr class="print"><td class="print">30-06-2009 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">06-07-2009 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a></td><td class="print">Note Added: 0008847</td><td class="print"></td></tr><tr class="print"><td class="print">06-07-2009 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a></td><td class="print">Note Edited: 0008847</td><td class="print"></td></tr><tr class="print"><td class="print">18-03-2010 07:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">18-03-2010 07:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">18-03-2010 07:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">18-03-2010 07:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: es_20187306v040102.zip</td><td class="print"></td></tr><tr class="print"><td class="print">18-03-2010 07:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008724)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-06-2009 11:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Here is a proposal for the replacement for the getComponents() function (and the similar function founds in other container classes)<br />
&gt; virtual const std::vector&lt; const TciModuleId * &gt; &amp; getComponents () const =0;<br />
<br />
As stated before, this function should be removed because it puts too much design constaints on the implementation of the interface (it mandates that the object stores the TciModuleId list in a vector of pointers).<br />
<br />
In order to provide similar features, all the interface classes that provide access to a list of elements should support the Range concept, i.e: provide the following definitions:<br />
<br />
&#160;&#160;&#160;&#160;typedef ##implementation_defined## const_iterator;<br />
&#160;&#160;&#160;&#160;const_iterator	begin() const;<br />
&#160;&#160;&#160;&#160;const_iterator	end()	const;<br />
<br />
&#160;&#160;&#160;&#160;The type of const_iterator is implementation defined. It shall comply with the InputIterator concept (<a href="http://www.cplusplus.com/reference/std/iterator/InputIterator/">http://www.cplusplus.com/reference/std/iterator/InputIterator/</a> [<a href="http://www.cplusplus.com/reference/std/iterator/InputIterator/" target="_blank">^</a>]) and the dereferencement operator shall return a const reference on the contained object.<br />
&#160;&#160;&#160;&#160;eg: - TciModuleList::const_iterator::operator*() shall return const TciModuleId&amp;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;- TciModuleList::const_iterator::operator-&gt;() shall return const TciModuleId*<br />
&#160;&#160;&#160;&#160;<br />
<br />
<br />
Supporting the range concept allows inspecting easily the content of the objects using itarators.<br />
&#160;&#160;&#160;&#160;eg. using the boost foreach library<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;#include &lt;boost/foreach.hpp&gt;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TciModuleIdList&amp; m_list;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BOOST_FOREACH (const TciModuleId&amp; id, m_list) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...		<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;eg. using the range-based loops in the upcoming version of the c++ standard  <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TciModuleIdList&amp; m_list;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (const TciModuleId&amp; id : m_list) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;...		<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008725)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-06-2009 11:52&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Regarding section 10.5, the following text should be removed (or possibly replaced with a paragraphe about the Range concept above if accepted):<br />
<br />
&gt; The Standard Template Library (STL) has been used as it is a standardized<br />
&gt; way of using container classes, and iterators, such as lists. All classes<br />
&gt; define the operator &quot;&lt;&quot; for easy insertion in STL containers<br />
<br />
<br />
The rationale for the deletion is that this paragraph is confusing since it is not possible to insert objects that are not copy-constructible into STL containers.<br />
<br />
[Actually this would be useable with a poiner container (eg. <a href="http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html">http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html</a> [<a href="http://www.boost.org/doc/libs/1_39_0/libs/ptr_container/doc/ptr_container.html" target="_blank">^</a>]). But since pointer containers are not yet standardised, I think it's better just not to mention it and remove the paragraph]			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008730)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=552">JesÃºs DomÃ­nguez</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-06-2009 13:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				After discussion on the phone with Anthony we understand the following things were agreed:<br />
<br />
- method &quot;isEmpty&quot; should be renamed to &quot;empty&quot;<br />
<br />
- method &quot;getComponents&quot; should be removed<br />
<br />
- method &quot;get&quot; to be changed to return a pointer (to use NULL if &quot;p_index&quot; is out of bounds)<br />
virtual const TciModuleId *get (Tsize p_index) const =0;<br />
<br />
- method &quot;add&quot; to be renamed to &quot;push_back&quot;<br />
<br />
- method &quot;equals&quot; to be substituted with operator &quot;==&quot; <br />
virtual Tboolean operator== (const TciModuleIdList &amp;midList) const =0;<br />
<br />
- method &quot;cloneXXX&quot; to be renamed to &quot;clone&quot;<br />
<br />
- section 10.5 to be changed to give a better explanation<br />
<br />
<br />
About the begin,end methods we don't agree with adding them. It was mentioned with the getComponents method that we should not add design constraints. But if we add the &quot;begin&quot;,&quot;end&quot; or more C++ standard library methods we will obly to implement them (they are pure virtual), making them exactly like the STL containers. Wouldn't it be easier in that case to make directly a typedef to an STL class?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008738)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-06-2009 18:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jesus,<br />
<br />
<br />
defining some iterators is not a design constraint is the sense that it does not dictate the internal structure of the class.<br />
<br />
<br />
For example to implement TciModuleIdList a developper will have to represent internally this module list. There are lots of different ways he may want to do that (depending on the internal design of his runtime system) for example:<br />
<br />
* by storing references to a TciModuleId base object<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;std::vector&lt;TciModuleId*&gt; mModuleIdList;	// -&gt; using a STL vector of pointers<br />
&#160;&#160;&#160;&#160;boost::ptr_vector&lt;TciModuleId&gt; mModuleIdList;	// -&gt; using a pointer container<br />
<br />
* by storing objects inherited from TciModuleId (eg. MyModuleId) <br />
&#160;&#160;&#160;&#160;std::vector&lt;MyModuleId&gt; mModuleIdList		// -&gt; using a STL vector of MyModuleId<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;std::vector&lt;MyModuleId*&gt; mModuleIdList;		// -&gt; using a STL vector of pointers<br />
&#160;&#160;&#160;&#160;boost::ptr_vector&lt;MyModuleId&gt; mModuleIdList;	// -&gt; using a pointer container<br />
<br />
* also if he's concerned by the execution speed, he may want no to use the default allocator so as to optimise memory allocations<br />
&#160;&#160;&#160;&#160;&#160;&#160;std::vector&lt;MyModuleId, boost::fast_pool_allocator&lt;MyModuleId&gt; &gt; mModuleIdList;<br />
<br />
This is the reason why the getComponent() function is a strong design constraint, because it forces the developer to store the list as a std::vector&lt;TciModuleId*&gt;<br />
<br />
<br />
By opposition the iterators can be flexibly defined regardless the internal design of the class, and they don't introduce any overhead in the execution.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008770)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=556">Raul Alfonso</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-06-2009 14:15&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Anthony,<br />
<br />
getComponents() or iterators (begin &amp; end) isnâ€™t the issue. Weâ€™re agreed with you about design restrictions in getComponents methods and defining some iterators isnâ€™t a design restriction, but we arenâ€™t agreed with you about add iterators (and begin and end methods) to the interface. Why? If these methods are included we are forcing to implement them and we think that the tci-inteface should only have methods to use in tci context, not in other context (stl algorithms). We use these objects with stl algorithms, but other implementations of these interfaces may not use the stl algorithms. We think that we shouldnâ€™t force to someone to implement this methods.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008847)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=261">Anthony Baire</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				06-07-2009 15:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				getComponents() puts a constraint on the internal design of the class: this affects the operation of the class as a whole. Adding iterators does not affect the internal design of the class but only its interfaces: other operations are not affected.<br />
<br />
<br />
Anyway, just removing getComponents() and not adding the iterators is an acceptable solution for us.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
