<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:30 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0004904: top-level templates and inline-templates of type default are not allowed - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0004904</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Clarification</td><td class="print">public</td><td class="print">23-02-2009 14:54</td><td class="print">13-07-2009 07:23</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Jacob Wieland - Spirent</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print-category">Fixed in Version</td><td class="print">v4.2.1 (published 2010-07)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.3, 15.4. 5.2</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technology (Jacob Wieland)</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0004904: top-level templates and inline-templates of type default are not allowed</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In the standard, it is explicitly forbidden to define templates of type 'default'.<br />
<br />
However, it is allowed to define constants, variables, even template variables (as I understand it), parameters and fields of type default.<br />
<br />
In the 3.4. version, it is even explicitly allowed to have parameters with default values of type default, even though only the default value 'null' is allowed. (This is also inconsistent, why should ? or other matching mechanisms not be allowed as default value for template parameters of default type?)<br />
<br />
Thus, it is possible to define a template of a record containing a default type field, but not a template of default type. <br />
<br />
I think this restriction is unnecessary, so I would propose to simply drop it from the standard. <br />
<br />
The other way to achieve consistency would be to forbid defaults also for constants and for everything that has to do with templates, i.e. it should not be possible to define templates of a type containing a default field.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/ppt.gif" alt="ppt" />&#160;CR4904_discussionInput_v2.ppt (37,888) <span class="italic">22-04-2009 15:48</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2111&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR4904_resolution_v1.zip (874,798) <span class="italic">09-07-2009 10:59</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2200&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR4904_resolution_v2.zip (908,192) <span class="italic">13-07-2009 07:22</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2214&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">23-02-2009 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">23-02-2009 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">23-02-2009 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">23-02-2009 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 15.3, 15.4. 5.2</td></tr><tr class="print"><td class="print">23-02-2009 14:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technology (Jacob Wieland)</td></tr><tr class="print"><td class="print">27-02-2009 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008205</td><td class="print"></td></tr><tr class="print"><td class="print">27-02-2009 13:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008206</td><td class="print"></td></tr><tr class="print"><td class="print">27-02-2009 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008207</td><td class="print"></td></tr><tr class="print"><td class="print">27-02-2009 14:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0008207</td><td class="print"></td></tr><tr class="print"><td class="print">28-02-2009 10:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008208</td><td class="print"></td></tr><tr class="print"><td class="print">03-03-2009 11:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008221</td><td class="print"></td></tr><tr class="print"><td class="print">10-03-2009 10:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">20-04-2009 11:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">21-04-2009 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: what can be of default type.doc</td><td class="print"></td></tr><tr class="print"><td class="print">21-04-2009 15:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: what can be of default type.doc</td><td class="print"></td></tr><tr class="print"><td class="print">21-04-2009 15:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: what can be of default type.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 11:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: what can be of default type.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 11:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR4904_discussionInput_v1.ppt</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 11:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008531</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 12:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008533</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 12:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Edited: 0008533</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 14:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR4904_discussionInput_v1.ppt</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 14:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR4904_discussionInput_v1.ppt</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 14:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008538</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 14:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008540</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 15:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008541</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 15:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR4904_discussionInput_v2.ppt</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 15:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008542</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 16:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008545</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 18:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008548</td><td class="print"></td></tr><tr class="print"><td class="print">22-04-2009 18:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Deleted: CR4904_discussionInput_v1.ppt</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2009 12:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0008552</td><td class="print"></td></tr><tr class="print"><td class="print">07-07-2009 08:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0008851</td><td class="print"></td></tr><tr class="print"><td class="print">08-07-2009 16:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Deleted: 0008851</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2009 10:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR4904_resolution_v1.zip</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2009 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0008881</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2009 11:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0008881</td><td class="print"></td></tr><tr class="print"><td class="print">09-07-2009 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">09-07-2009 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">13-07-2009 07:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR4904_resolution_v2.zip</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2009 07:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0008894</td><td class="print"></td></tr><tr class="print"><td class="print">13-07-2009 07:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">13-07-2009 07:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">13-07-2009 07:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008205)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-02-2009 10:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				default is not allowed for template variables: &quot;11.2	Template variables<br />
A TTCN-3 template variable stores templates.&quot;. I.e. in this respect, the same restriction apply to template variables as to templates (they do differ from templates only in the dynamics of defining the content).<br />
<br />
If you think about the use of defaults, if would make no sense to allow defaults for templates; default variables store handles of activated defaults, which has local significance only and loose sense outside of the given component. Hence, default values are not know when writing global definitions and cannot be sent outside of a component.<br />
<br />
If this is not specified clearly enough in the text, the explanation shall be made more clear.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008206)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-02-2009 13:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Then why allow template parameters of type default (and restrict their default value explicitly to only 'null'?) This seems inconsistent (or maybe it is just a copy/paste error?).<br />
<br />
Also, you forget that templates can not only be used for sending/receiving messages. They can also used locally with the 'match' operation or with the 'select' statement. In that respect, a template that enumerates certain activated defaults could be a valid template. <br />
<br />
An example:<br />
<br />
function deactivateIfMatches(default d, template default dt) {<br />
&#160;&#160;if (match(d, dt)) {<br />
&#160;&#160;&#160;&#160;&#160;deactivate(d);<br />
&#160;&#160;}<br />
}<br />
<br />
then suppose, you get passed a default parameter and you want to deactivate it only, if it is one of a list of defaults which you have stored in variables.<br />
<br />
deactivateIfMatches(d, (d1, d2, d3))<br />
<br />
The same could be true if you want to deactivate it unless it is one of the list:<br />
<br />
deactivateIfMatches(d, complement(d1, d2, d3))<br />
<br />
Of course, these scenarios may be far fetched, but if such things work for other data types, why should default be any different? I could understand a restriction that default values cannot be sent and therefore any receive operation using a template with defaults would make no sense, either. But, this should not be achieved by restricting the definition of templates of that type, but by restricting the communication statements.<br />
<br />
Sure, as globally, no default references are known, for global templates only the matching mechanisms which do not refer to any specific default instance are allowed (like ?, *, etc.), but, for generic or local templates, no such restriction is necessary.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008207)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				27-02-2009 13:59&#160;&#160;&#160;
				<br />(edited on:&#32;27-02-2009 14:01)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The user do not need a template for that. Even if default is allowed in templates, only concrete values and the AnyValue matching would be possible to use, as the concrete default values are not known. But using AnyValue is the same as a non-null value or isvalue. Thus, the same use case can be coded by more than one alternative ways, e.g.<br />
<br />
type record of default RD;<br />
function deactivateIfMatches(default d, RD rd) {<br />
&#160;&#160;for (var integer i := 0; i&lt;lengthof(rd); i:=i+1) {<br />
&#160;&#160;&#160;&#160;if (rd[i]==d) {deactivate(d)}<br />
&#160;&#160;}<br />
}<br />
<br />
<br />
But allowing defaults in templates is too dangerouos and I cannot see a real use case for it, i.e. a problem, which cannot be solved by coding techniques available today. The same is true to the other examples you mention.<br />
<br />
Inconsistencies, of course, shall be removed. This will be the task of the next language maintenance project.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008208)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				28-02-2009 10:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The problem I have with this is the following:<br />
<br />
If it is so &quot;dangerous&quot; do define templates of type default, then why is it not forbidden also to define templates of a structured type that contains a default type element somewhere? Either this must also be forbidden (as it is as &quot;dangerous&quot; as defining a top-level default type template), or the top-level template must be allowed. The reason, as I see it is, that it is of course USEFUL to have structured types that can also contain default fields (as your alternative implementation of my example shows). If it were also forbidden, it would not even be possible to implement such a scenario as I have described.<br />
<br />
Thus, since such a restriction would be impractical, I still think that simply forbidding all communication operations to use templates that contain a default value, which can easily be checked statically, would avert the &quot;danger&quot; that you are talking about, as well.<br />
<br />
The benefit of this approach is, of course, that the powerful and elegant matching mechanisms that exist in the language can be used for all types, and it is not necessary to use the &quot;cruder&quot; means of iterating over arrays or suchlike. <br />
<br />
The same arguments can also be applied to component types, of course.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008221)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-03-2009 11:04&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Component types do differ: component references are unique within the test system, while default references are unique within a test component only.<br />
<br />
I agree with you in that top-level default types and default fields shall be handled in the same way.<br />
<br />
For me it would be also fine to disallow any templates containing default (i.e. top-level or in embedded fields) in sending operations only.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008531)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 11:14&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The file CR4904_discussionInput_v1.ppt contains exactly what its name suggests: input for the discussion.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008533)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 12:16&#160;&#160;&#160;
				<br />(edited on:&#32;22-04-2009 12:17)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Somehow, the discussion input presentation seems to ignore most of the discussion which took place before and also negates the compromise that seemed to have been reached.<br />
<br />
The question remains: Why forbid elegant means of matching (via match/select opterations) for one data type that is allowed for all other data types? <br />
Every unnecessary restriction makes the language harder to use (no one can keep all the restrictions in mind) and also harder to compile (every restriction must be checked which slows down the compiler). Both these things make developing test suites more expensive as it will take more time.<br />
<br />
The danger that a component-local default reference is passed outside its scope can also be averted by restricting the means of passing such references to other scopes (i.e. communication operations, starting of ptcs, maybe external functions). <br />
The advantage of this approach is <br />
a) it is understandable (and thus easier to keep in mind as the arbitrary restriction on templates) <br />
b) it is consistent with the handling of other data types that are only used locally, <br />
c) it is as easy/hard to check as the other proposed restriction. <br />
Thus, I think it is a better approach as it has not all of the drawbacks and some advantages over the other while still achieving the same goal of averting the aforementioned danger.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008538)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 14:19&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Pls. don't mix up persnal view with an STF discussion.<br />
Could you give a concrete example on<br />
- how to create a meaningful default template?<br />
- exactly what matching could be used on it that cannot be solved by using existing operations on values?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008540)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 14:52&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				That is beside the point. It is not necessary that I provide an example. Please address the issues I have raised and do not simply dismiss them as personal opinon.<br />
<br />
Of course, everything can be done with value operations. That is true for all other types, as well and we allow templates there nonetheless to allow short-hand notations for complex predicates. If templates could only be used for communication, I would see your point, but since that is not the case, I think it is invalid.<br />
<br />
Since there is an elegant syntax (like value-list, complement, subset, superset, ?) which enables you to write down very complicated things in a relatively short way, why forbid users to USE this syntax for this special type and force them to write the complicated algorithms themselves if they actually need such a complicated check. If I were a TTCN-3 user, I would wonder about such idiosyncracies. Just because you and I cannot think of a meaningful real-world example doesn't mean that there isn't one. Why restrict the language unnecessarily? That is my question.<br />
<br />
You want to reach a certain goal to avoid programming errors, fine. There are two (proposed) ways to reach that goal. Your proposal restricts the language more than necessary for reaching the goal because it restricts valid possible applications of the template mechanism. My proposal restricts the language exactly as necessary to reach the goal because it still allows templates containing default values to be used by match operations or select constructs.  <br />
<br />
So, why is your proposal better? Shouldn't we keep the language as simple and flexible and usable as possible?			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008541)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 15:07&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi Jacob,<br />
what I meant on personal opinion is my sentence from 3rd of March: &quot;For me it would be also fine ...&quot; etc.<br />
<br />
Your notes/comments are taken into consideration properly.<br />
<br />
You wrote: &quot;It is not necessary that I provide an example.&quot;. As you are asking to change the language rules, a proper reason has to be provided. Either a use-case example that cannot be solved by the existing language features or the solution is over-complicated, or e.g. a language inconsistency issue. The reason you provided currently falls into the second category. So it can be solved both in the more strict or in the more loose directions. In TTCN-3 we prefer if more errors can be found compile time that hints the solution in the more strict direction.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008542)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 15:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In CR4904_discussionInput_v2.ppt: more analysis added on possible use of matching with defaults.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008545)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 16:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Okay, sorry for the misunderstanding. I don't think that every language feature must be motivated by a now-existing real-world use-case. The consistency of the language is much more important in my view.<br />
<br />
I don't think that it can be argued that in one proposal more can be checked at compile time than in the other.<br />
<br />
The proposal to restrict the communication statements to only templates not containing values/fields of default type can also be checked at compile time as the type of the sent template is always known. <br />
<br />
The only exception is the anytype type where the contents are not known. However, the same problem occurs as well in your more restrictive variant, i.e. if all templates are forbidden for types that are/contain values of type default, this can be circumvented by using anytype instead (and using the anytype to encapsulate a value of type default).<br />
<br />
This obviously can only be checked at runtime (in either version).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008548)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-04-2009 18:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF discussion on 22/April/2009:<br />
- the inconsistency raised by the CR exists in the standard;<br />
- template formal parameters, template variables and function template returns are not forbidden to be of default type but table 10 prevents to assign them any content (even specific value);<br />
- the proposal of the STF is to consistently forbid all template-kind language elements to be of default type;<br />
- ask the tool vendors if there is any problem with the prposed changes;<br />
- check if this restriction can be done in a single place in the standard instead of spreading t over several clauses;<br />
- in addition check, if sending/receiving default values is forbidden explicitly			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008552)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2009 12:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				For consistency's sake, if you want to forbid all templates for type default, then all templates for structured types that contain type default should also be forbidden.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008881)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-07-2009 11:02&#160;&#160;&#160;
				<br />(edited on:&#32;09-07-2009 11:06)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR4904_resolution_v1.doc:<br />
Resolution according to the CR resolution meeting decision. Not much text but spread almost all over Part-1. Therefore the whole Part-1 file is included, with modifications. To be checked.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0008894)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-07-2009 07:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				editorial corrections - see v2			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
