<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:20:27 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0002150: Encoder/Decoder Access - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0002150</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">15-10-2007 13:12</td><td class="print">25-04-2008 14:10</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Gyorgy Rethy</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print-category">Fixed in Version</td><td class="print">v3.4.1 (published 2008-09)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Annex C</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;&#160;&#160;&#160;&#160;</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0002150: Encoder/Decoder Access</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Although this can be done by using an external function, we prefer this to be added to the TTCN3 specification as a built in function.  This will provide compiler independency, reduce maintenance and reduce the number of external functions required.<br />
function msg_decode(in bitstring p_EncodedMsg, in anytype p_ExpectedType) return anytype<br />
&#160;&#160;&#160;Parameters:<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;p_EncodedMsg:       Bitstring of the message to be decoded<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;p_ExpectedType:     anytype having a dummy of the expected type assigned<br />
&#160;&#160;&#160;returns an anytype having the decoded message assigned <br />
&#160;&#160;&#160;(alternatively the 2nd parameter may be inout)<br />
<br />
function msg_encode(in anytype p_AnyType) return bitstring<br />
&#160;&#160;&#160;Parameters:<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;p_AnyType:           anytype having assigned the massage to be encoded <br />
&#160;&#160;&#160;returns bitstring of the encoded message<br />
<br />
Problem: <br />
Different compilers may handle assignments to/from anytype in mutually exclusive different ways<br />
<br />
Example:<br />
<br />
&#160;&#160;type record MyRecordType {<br />
&#160;&#160;&#160;&#160;integer Int,<br />
&#160;&#160;&#160;&#160;boolean Bool<br />
&#160;&#160;};<br />
<br />
&#160;&#160;function MyTest() {<br />
&#160;&#160;&#160;&#160;var bitstring var_Bitstring1 := '010101'B;<br />
&#160;&#160;&#160;&#160;var bitstring var_Bitstring2;<br />
&#160;&#160;&#160;&#160;var MyRecordType var_MyRecord;<br />
&#160;&#160;&#160;&#160;var anytype var_Any := {MyRecordType := var_MyRecord};<br />
&#160;&#160;&#160;&#160;<br />
&#160;&#160;&#160;&#160;var_Any := msg_decode(var_Bitstring1, var_Any);<br />
&#160;&#160;&#160;&#160;var_MyRecord := var_Any.MyRecordType;<br />
<br />
&#160;&#160;&#160;&#160;var_Bitstring2 := msg_encode({MyRecordType := var_MyRecord});<br />
&#160;&#160;}<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">Add the predefined functions below to TTCN-3 core language.<br />
<br />
NOTE:	Using bitstring type for encoded messages in 3GPP examples need clarification; all known message encodings are producing integer number of octets, in our practice never bitstring or hexstring was used to treat encoded messages.<br />
Simple message encoding<br />
msg_encode(in any type p_msg) return octetstring;<br />
msg_encode(in any type p_msg) return charstring;<br />
<br />
These predefined functions have one in value parameter, which shall contain the TTCN-3 value to be encoded. The encoded message is obtained in the return value of the function. This enables using this type of encoding function directly i.e. in sending operations or at the right hand side of assignments.<br />
<br />
NOTE:	Some encoded messages may contain universal charstring characters; these are stored on 1 to 4 charstring positions in the encoded message (depending on universal charstring character set and encoding). It is supposed that the encoding rule allows identifying these positions (for decoding).<br />
Please note the following:<br />
ï‚§	The type of the message encoding (e.g. binary, text, BER, PER etc.) is determined by the encode and variant attributes of the actual in parameterâ€™s type; therefore in case of ASN.1 types the encode and variant attributes shall be specified in the related import statement (in each TTCN-3 module where the predefine function is used).<br />
<br />
Fast message encoding<br />
msg_encode(in any type p_msg, out octetstring p_encMsg);<br />
msg_encode(in any type p_msg, out charstring p_encMsg);<br />
<br />
These predefined functions differ from the simple encode functions in that they have two value parameters: the first is an in parameter and it shall contain the TTCN-3 value to be encoded. The encoded message is returned in the second, out parameter of the function. These functions cannot directly be used i.e. in sending operations or right hand side of assignments, but allows higher runtime performance than the simple encoding functions.<br />
<br />
NOTE:	Some encoded messages may contain universal charstring characters; these are not handled separately as they also can be stored on 1 to 4 charstring positions (depending on universal charstring character set and encoding).<br />
Please note the following:<br />
ï‚§	The type of the message encoding (e.g. binary, text, BER, PER etc.) is determined by the encode and variant attributes of the actual in parameterâ€™s type; therefore in case of ASN.1 types the encode and variant attributes shall be specified in the related import statement (in each TTCN-3 module the predefine function is used).<br />
<br />
Simple message decoding<br />
msg_decode(in octetstring p_encMsg, in charstring p_type) return any type;<br />
msg_decode(in charstring p_encMsg, in charstring p_type) return any type;<br />
<br />
These predefined functions have two in value parameters: the first, p_encMsg shall be used to pass the encoded message to the function and the second, p_type denotes the type hypothesis, based on which message decoding is attempted. The decoded message is obtained in the return value of the function.<br />
<br />
NOTE:	Encoded messages containing universal charstring characters shall be converted to charstring values before calling this predefined function (i.e. universal charstring characters shall be stored on 1 to 4 charstring-s); it is supposed that the encoding rule allows identifying positions of universal charstring characters during decoding.<br />
Please note the following:<br />
ï‚§	The type of the message decoding (e.g. binary, text, BER, PER etc.) is determined by the encode and variant attributes of the type denoted by p_type; therefore in case of ASN.1 types the encode and variant attributes shall be specified in the related import statement (in each TTCN-3 module the predefine function is used).<br />
ï‚§	Message decoding failure results dynamic test case error (i.e. the REAL type of the message MUST be know apriori and p_encMsg MUST contain exactly one complete message).<br />
<br />
Fast message decoding<br />
msg_decode(in octetstring p_encMsg, out any type p_msg, in charstring p_type)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return integer;<br />
msg_decode(in charstring p_encMsg, out any type p_msg, in charstring p_type)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return integer;<br />
<br />
These predefined functions differ from simple decoding functions in that they have three value parameters and an integer return value. The first parameter, in parameter p_encMsg, shall be used to pass the encoded message to the function. The TTCN-3 value representing the decoded message is returned in second, out parameter p_msg. The third, in parameter p_type, denotes the type hypothesis, based on which message decoding is attempted. The returned integer value contains the result of the decoding as:<br />
â€¢	0 (OK). Decoding was successful; the result is stored in the out parameter. <br />
â€¢	1 (NOT_MY_TYPE). Decoding was unsuccessful because the input parameter does not contain a valid message of type p_type. The content of out parameter is undefined.<br />
NOTE: The error code is returned as an integer value for forward compatibility: it allows extending the list of error symptoms in the future. This is also aligns the return value type with the sliding message decoding predefined functions. <br />
<br />
NOTE:	Encoded messages containing universal charstring characters shall be converted to charstring before calling this predefined function (i.e. universal charstring characters shall be stored on 1 to 4 charstring-s); it is supposed that the encoding rule allows identifying positions of universal charstring characters.<br />
Please note the following:<br />
ï‚§	The type of the message decoding (e.g. binary, text, BER, PER etc.) is determined by the encode and variant attributes of the type denoted by p_type; therefore in case of ASN.1 types the encode and variant attributes shall be specified in the related import statement (in each TTCN-3 module the predefine function is used).<br />
ï‚§	Message decoding result shall always be checked, as in case of decode failure the content of p_msg is undefined and would cause dynamic test case error with high probability (or even worth, a false test result).<br />
<br />
Sliding message decoding<br />
msg_decode_slide(inout octetstring p_encMsg, out any type p_msg,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;in charstring p_type) return integer;<br />
msg_decode_slide (inout charstring p_encMsg, out any type p_msg<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;in charstring p_type) return integer;<br />
<br />
These predefined functions have three value parameters. The first, inout octetstring parameter p_encMsg shall be used to pass the encoded message to the function; when the function returns, it gives back the whole, part or nothing of the octetstring value passed to it in p_encMsg (see details below). The TTCN-3 value representing the decoded message is returned in the second, out parameter p_msg. The in value parameter p_type denotes the type hypothesis, based on which message decoding is attempted. The returned integer value contains the result of the decoding as:<br />
â€¢	0 (OK). Decoding was successful; the result is stored in the out parameter. The decoded message was removed from the beginning of the inout parameter p_encMsg. <br />
â€¢	1 (NOT_MY_TYPE). Decoding was unsuccessful because the inout parameter p_encMsg does not contain or start with a valid message of type denoted by p_type. The inout parameter p_encMsg remains unchanged. The content of out parameter p_msg is undefined. <br />
â€¢	2 (INCOMPLETE_MESSAGE). Decoding was unsuccessful because the input stream does not contain a complete message (i.e. the end of the message is missing). The inout parameter p_encMsg remains unchanged. The content of out parameter p_msg is undefined.<br />
<br />
NOTE:	Encoded messages containing universal charstring characters shall be converted to charstring before calling this predefined function (i.e. universal charstring characters shall be stored on 1 to 4 charstring-s); it is supposed that the encoding rule allows identifying positions of universal charstring characters.<br />
Please note the following:<br />
ï‚§	The type of the message decoding (e.g. binary, text, BER, PER etc.) is determined by the encode and variant attributes of the type denoted by p_type; therefore in case of ASN.1 types the encode and variant attributes shall be specified in the related import statement (in each TTCN-3 module the predefine function is used).<br />
ï‚§	Message decoding result shall always be checked as in case of failure the content of p_msg is undefined and would cause dynamic test case error with high probability (or even worth, a false test result).<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_solution.doc (631,808) <span class="italic">04-12-2007 16:22</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1200&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_Encoder_Decoder_access_solution_01.doc (498,176) <span class="italic">11-03-2008 09:28</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1366&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_Encoder_Decoder_access_solution_02.doc (501,248) <span class="italic">11-03-2008 17:46</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1368&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_Encoder_Decoder_access_solution_03.doc (469,504) <span class="italic">23-04-2008 16:43</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1442&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_Encoder_Decoder_access_solution_04.doc (448,512) <span class="italic">23-04-2008 19:26</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1449&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR_2150_Encoder_Decoder_access_solution_05.doc (448,000) <span class="italic">24-04-2008 17:26</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1455&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">15-10-2007 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">15-10-2007 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">15-10-2007 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">15-10-2007 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; Annex C</td></tr><tr class="print"><td class="print">15-10-2007 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt;      </td></tr><tr class="print"><td class="print">15-10-2007 13:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Additional Information Updated</td><td class="print"></td></tr><tr class="print"><td class="print">18-10-2007 13:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">18-10-2007 13:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 3.3.1 (not yet published)</td></tr><tr class="print"><td class="print">04-12-2007 16:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2150_solution.doc</td><td class="print"></td></tr><tr class="print"><td class="print">04-12-2007 16:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0004283</td><td class="print"></td></tr><tr class="print"><td class="print">07-12-2007 11:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 3.3.1 (not yet published) =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">07-12-2007 11:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0004419</td><td class="print"></td></tr><tr class="print"><td class="print">11-03-2008 09:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2150_Encoder_Decoder_access_solution_01.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-03-2008 09:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005195</td><td class="print"></td></tr><tr class="print"><td class="print">11-03-2008 17:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2150_Encoder_Decoder_access_solution_02.doc</td><td class="print"></td></tr><tr class="print"><td class="print">11-03-2008 17:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005203</td><td class="print"></td></tr><tr class="print"><td class="print">21-04-2008 08:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.1.1 (not yet published) =&gt; Edition 3.4.1 (not yet published)</td></tr><tr class="print"><td class="print">23-04-2008 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0005530</td><td class="print"></td></tr><tr class="print"><td class="print">23-04-2008 16:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Thomas DeiÃŸ</td></tr><tr class="print"><td class="print">23-04-2008 16:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR_2150_Encoder_Decoder_access_solution_03.doc</td><td class="print"></td></tr><tr class="print"><td class="print">23-04-2008 19:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2150_Encoder_Decoder_access_solution_04.doc</td><td class="print"></td></tr><tr class="print"><td class="print">23-04-2008 19:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005543</td><td class="print"></td></tr><tr class="print"><td class="print">23-04-2008 19:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Assigned To</td><td class="print">Thomas DeiÃŸ =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">24-04-2008 10:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0005548</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 10:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">24-04-2008 17:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">File Added: CR_2150_Encoder_Decoder_access_solution_05.doc</td><td class="print"></td></tr><tr class="print"><td class="print">24-04-2008 17:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a></td><td class="print">Note Added: 0005561</td><td class="print"></td></tr><tr class="print"><td class="print">25-04-2008 14:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">25-04-2008 14:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">25-04-2008 14:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 3.4.1 (not yet published)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0004283)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-12-2007 16:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				encode and decode builtin functions added as wrappers for the TCI functions encode and decode. Only bitstrings used as types for encoded values (agreed in 1st STF session).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0004419)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-12-2007 11:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This CR is not that urgent for 3GPP - external functions can be used instead.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005195)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-03-2008 09:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Solution proposal. Two predefined functions (names to be discussed), allow to retrieve amount of consumed bits in decoding. Otherwise close to the TCI functions encode/decode.<br />
<br />
For discussion of names: 'encode' is used already as keyword in the context of attributes. So far, the names of predefined functions have not been keywords.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005203)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-03-2008 17:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				STF349, Thomas: Solution proposal updated:<br />
- simple reference to TCI operations might not be sufficient, as the codecs might change throughout execution. For encode, refer to the time of executing the operation. for decode this is more problematic and not mentioned.<br />
- return value of decode changed be a return code instaed of the amount of bits consumed. <br />
- possibility that RTS might not raise an error when encoding or decoding mentioned. This is out of scope of the standard.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005530)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-04-2008 16:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In file CR_2150_Encoder_Decoder_access_solution_03.doc: as we discussed, I have copied the text to the newest standard version; hence I added comments to most of my changes (except trivial editorial). 			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005543)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-04-2008 19:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				clean up of the editorial changes.<br />
Name proposal: encvalue, decvalue<br />
2nd parameter of decvalue changed from out to inout. Otherwise there would be a successful function call, where an out parameter is undefined afterwards.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005548)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2008 10:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The version 04 (provided by Thomas) is reviewed by me; it is an agreed version between me and Thomas.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0005561)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=112">Thomas DeiÃŸ</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-04-2008 17:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				2nd parameter of decvalue changed to 'out' (instead 'inout').<br />
Definition in case of unsuccessful behaviour slightly revised.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
