<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:18:54 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0002105: address should also be bind to port type - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0002105</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">04-10-2007 18:10</td><td class="print">01-12-2010 14:37</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">tepelmann</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Ina Schieferdecker</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">low</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print-category">Fixed in Version</td><td class="print">v4.3.1 (published 2011-06)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">9.1</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Testing Technologies - Dirk Tepelmann</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0002105: address should also be bind to port type</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Currently the address is bound module-wise, however in my opinion it should also be possible to bind the address type to a port type declaration as the port type defines the communication.<br />
This enables the usage of different address types port-type-wise.<br />
<br />
type port PortTypeIdentifier message &quot;{&quot;<br />
{ ( in | out | inout ) ( all | { MessageType [ &quot;,&quot; ] }+ ) &quot;;&quot; }<br />
{ address { MessageType } &quot;;&quot; }<br />
&quot;}&quot; <br />
<br />
To reference the specific address type, the type should be retrievable via dotted notation based on the port type(similiar to the access of anonymous inline type definitions in structured types).<br />
<br />
var &lt;port type&gt;.address &lt;varIdentifier&gt; &quot;:=&quot; Expression<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">E.g.:<br />
<br />
type port P message { inout all; address integer; };<br />
type port Q message { inout all; address charstring; };<br />
<br />
function f() runs on C {<br />
&#160;&#160;var P.address addr0 := 0;<br />
<br />
&#160;&#160;p.send(AAA) to 0;<br />
&#160;&#160;p.send(AAA) to addr0;<br />
<br />
&#160;&#160;q.send(BBB) to &quot;127.0.0.1&quot;;<br />
}</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005417</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">Support of parametrized map/unmap operation for full dynamic mapping&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005588</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">Follow-up of CR2105 - Deprecating using addressing without explicit binding the addressing type to the port type&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0005923</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></span>&#160;</td><td class="print">BNF (rules 50 and 58) in appendix A and port type definition chapter 6.2.9 do not match&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR-2105-address-bound-to-port-type-Resolution-V1-081222.doc (189,440) <span class="italic">22-12-2008 12:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=1924&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR2105-Resolution-Jens-100630.zip (48,382) <span class="italic">30-06-2010 16:04</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2389&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/zip.gif" alt="zip" />&#160;CR2105-Resolution-Jens-100702.zip (49,161) <span class="italic">02-07-2010 11:32</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2401&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR2105-Resolution-101201.doc (300,032) <span class="italic">01-12-2010 10:16</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2451&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="doc" />&#160;CR2105-Resolution-101201a.doc (227,840) <span class="italic">01-12-2010 14:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=2458&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">04-10-2007 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">04-10-2007 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">04-10-2007 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">04-10-2007 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 9.1</td></tr><tr class="print"><td class="print">04-10-2007 18:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Testing Technologies - Dirk Tepelmann</td></tr><tr class="print"><td class="print">13-10-2007 18:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">17-10-2007 11:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0003655</td><td class="print"></td></tr><tr class="print"><td class="print">17-10-2007 11:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Category</td><td class="print">Technical =&gt; New Feature</td></tr><tr class="print"><td class="print">18-10-2007 13:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">18-10-2007 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 4.1.1 (not yet published)</td></tr><tr class="print"><td class="print">18-07-2008 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0006327</td><td class="print"></td></tr><tr class="print"><td class="print">22-12-2008 12:34</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0007758</td><td class="print"></td></tr><tr class="print"><td class="print">22-12-2008 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR-2105-address-bound-to-port-type-Resolution-V1-081222.doc</td><td class="print"></td></tr><tr class="print"><td class="print">22-12-2008 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; </td></tr><tr class="print"><td class="print">22-12-2008 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">22-12-2008 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0007759</td><td class="print"></td></tr><tr class="print"><td class="print">22-12-2008 12:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.1.1 (not yet published) =&gt; Edition 4.2.1 (not yet published)</td></tr><tr class="print"><td class="print">22-12-2008 12:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">16-02-2010 14:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">16-02-2010 14:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009216</td><td class="print"></td></tr><tr class="print"><td class="print">16-02-2010 14:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">16-02-2010 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Status</td><td class="print">closed =&gt; feedback</td></tr><tr class="print"><td class="print">16-02-2010 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Resolution</td><td class="print">won't fix =&gt; reopened</td></tr><tr class="print"><td class="print">16-02-2010 15:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a></td><td class="print">Note Added: 0009225</td><td class="print"></td></tr><tr class="print"><td class="print">18-03-2010 07:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print">Edition 4.2.1 (not yet published) =&gt; Edition 5.1.1 (not yet published)</td></tr><tr class="print"><td class="print">23-03-2010 13:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Priority</td><td class="print">normal =&gt; low</td></tr><tr class="print"><td class="print">24-03-2010 08:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0009273</td><td class="print"></td></tr><tr class="print"><td class="print">24-03-2010 08:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Relationship added</td><td class="print">related to 0005417</td></tr><tr class="print"><td class="print">25-03-2010 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009294</td><td class="print"></td></tr><tr class="print"><td class="print">25-03-2010 09:09</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009294</td><td class="print"></td></tr><tr class="print"><td class="print">26-03-2010 09:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">feedback =&gt; assigned</td></tr><tr class="print"><td class="print">26-03-2010 09:41</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009321</td><td class="print"></td></tr><tr class="print"><td class="print">26-03-2010 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009294</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 16:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR2105-Resolution-Jens-100630.zip</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 16:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009435</td><td class="print"></td></tr><tr class="print"><td class="print">30-06-2010 16:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-07-2010 10:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009443</td><td class="print"></td></tr><tr class="print"><td class="print">01-07-2010 10:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">02-07-2010 10:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009462</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 10:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">02-07-2010 10:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">02-07-2010 10:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; fixed</td></tr><tr class="print"><td class="print">02-07-2010 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009463</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Status</td><td class="print">resolved =&gt; assigned</td></tr><tr class="print"><td class="print">02-07-2010 10:21</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009463</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">02-07-2010 11:32</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">File Added: CR2105-Resolution-Jens-100702.zip</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0009469</td><td class="print"></td></tr><tr class="print"><td class="print">02-07-2010 11:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Gyorgy Rethy</td></tr><tr class="print"><td class="print">01-12-2010 10:07</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0009877</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0009877</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">File Added: CR2105-Resolution-101201.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 10:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Assigned To</td><td class="print">Gyorgy Rethy =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">01-12-2010 13:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0009896</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR2105-Resolution-101201a.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">01-12-2010 13:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 4.3.1 (not yet published)</td></tr><tr class="print"><td class="print">01-12-2010 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Deleted: CR2105-Resolution-101201a.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">File Added: CR2105-Resolution-101201a.doc</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2010 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">14-12-2010 15:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0005588</td></tr><tr class="print"><td class="print">29-09-2011 09:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0005923</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0003655)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-10-2007 11:18&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This CR is to be considered in the wider scope of test configuration and therefore considered in 2008 only.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0006327)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				18-07-2008 09:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR is in principle OK. Proposed implementation in the standard needs to be refined.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0007758)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-12-2008 12:34&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The following problems arose when trying to implement this CR.<br />
<br />
(1) Clause 5.2.2 &quot;Uniqueness of identifiers&quot; will be violated because the keyword address (which is also the identifier of that type) may be bound to several types within one module. So far, TTCN-3 only allows dot notation to resolve ambiguities with identifiers only on module level (e.g., the module identifier is used to distinguish between local and imported definitions). Weakening this clause requires a larger discussion (why shall overloading only allowed for the address type?).<br />
<br />
(2) Implementing this CR requires larger changes in the BNF. Special rules have to be defined to allow the binding of the address type to a port and the dot notation with port type identifiers has to be introdruced for referenced types.<br />
<br />
The conclusion is that the CR looks simple and easy to implement, but needs a further discussion. Therefore, the CR should be moved to 2009.<br />
<br />
A proposal for the text implementing the CR in the clauses 6.2.9 and 6.2.12 is uploaded.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0007759)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-12-2008 12:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This CR requires more discussion			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009216)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-02-2010 14:23&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Issue was reported 3 years ago! After report no one again showed interest in this CR. Therefore, it is closed.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009225)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=88">tepelmann</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-02-2010 15:22&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Testing Technologies still claim interest for this CR.<br />
If any clarification or support can be provided, don't hesitate to contact us.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009273)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-03-2010 08:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The problems mentioned earlier with this CR are (in part) not valid anymore, as now the BNF already allows referencing parts of types for structured types. To enlarge the semantics to work on port-types as well (with the special field reference address which should be the address type specified in the port type, and only applicable if such an address type was specified). There is no overloading involved as the declarations would be local to the port type definition.<br />
<br />
However, this is not really necessary at all as one could always just reference the type of the address specification of the port directly. <br />
<br />
So, instead of <br />
<br />
var P.address x := 0;<br />
<br />
one could write<br />
<br />
var integer x := 0;<br />
<br />
The static semantics would need to reflect that the referenced address expressions used in to and from clauses are compatible with the address type of the port (if one is declared in its type).<br />
<br />
Thus, the only really necessary changes in the standard are the addition of the address declaration in the port type definition and the change in the description of the to/from clauses accordingly.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009294)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-03-2010 09:08&#160;&#160;&#160;
				<br />(edited on:&#32;26-03-2010 14:37)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree that the addressing should be bound to the port type, as today no one can know that in case of which port implementations the address type should be supported and in which cases it is not needed (i.e. how to implement it in the adapter). <br />
<br />
1. I don't like the syntax, namely using the type keyword inside a port type definition. It looks like as if a new type had been defined, while this is not the case. The type has to be defined normally, as a global type (or is a built-in type) and the port type shall just denote that it wants to use that type definition for addressing purposes. I propose instead:<br />
type port MyPort<br />
message {<br />
&#160;&#160;inout Tinky-winky,<br />
&#160;&#160;address MyRecordType<br />
&#160;&#160;}<br />
procedure {<br />
&#160;&#160;inout Gipsy,<br />
&#160;&#160;address integer<br />
}<br />
<br />
2. It should be made explicit that a port either using the global address type OR its own address binding, i.e. if a port type binds a global type for  addressing, instances of that port type shall not use the global address type.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009321)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-03-2010 09:41&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				status feedback shall only be used when we are waiting for an external feedback.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009435)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				30-06-2010 16:05&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Resolution version 1 uploaded, re-assigned to GyÃ¶rgy for proofreading.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009443)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-07-2010 10:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The proposed text is quite OK but I propose to make explicit address type declaration in port types mandatory; i.e. deprecate the feature of using to/from clauses on mapped ports without explicit address type declaration. This would allow using the predefined type name address further on (otherwise we would have backward compatibility problem) but would remove the problems we have today:<br />
- there is a strange implicit binding by declaring address and the port type within the same module that is not optimal for practical use (normally each port type is declared in a separate module to allow th user to select which ports he/she wants to use).<br />
- but if several port types are declared in the same module it is unclear today that in context of which addressing can be used and in context of which it shall not be used. This information is not given in the TTCN-3 code, thus the code has to be supplemented with an informal information specifying this (adapter implementation issue).<br />
<br />
The syntax, when using the address type:<br />
type port message {<br />
&#160;&#160;&#160;address address,<br />
...<br />
looks a little bit strange, but I think this is some thing we can and have to live with...			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009462)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 10:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Deprecating the address type should be proposed in a new CR which should be discussed with MTS and possibly the tool vendors. Removing the address type from the text requires some work.<br />
<br />
For the moment, I assign the CR to Ina, set the resolution to fixed and set the status to resolved.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009463)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 10:21&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The new restrictions that<br />
AddressRef shall not contain matching mechanisms<br />
is not correct. We allowed using templates in to/from clauses to support multicasting and be able to provide a list of addressees in form of a value list. But value list is a matching mechanism, so at least value list matching shall be allowed in both to and from clauses. But in fact in most cases addresses are not simple types but structured types, mostly records. Why disallow e.g.<br />
... from { connEP := ?, entity:= XYentity } ...?<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009469)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				02-07-2010 11:33&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				New resolution text uploaded. Reassigned to GyÃ¶rgy for proofreading.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009877)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 10:07&#160;&#160;&#160;
				<br />(edited on:&#32;01-12-2010 10:15)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I have noticed that the syntactical structures in clauses 22.2.1-22.4 contain AddressRef only (no AddressRefList and all|any component), so added a note to clarify this. Plus editorials. Pls. cross-check. See CR2105-Resolution-101201.doc<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0009896)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2010 13:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				basically ok, some smaller corrections and simplifications only			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
