<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:20:33 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0000387: Time-constraint send operation - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0000387</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Editorial</td><td class="print">public</td><td class="print">23-11-2006 14:27</td><td class="print">12-03-2008 10:27</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Stephan Schulz</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print"><font STYLE="text-decoration: line-through">developer_u</font></td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">feature</td><td class="print-category">Reproducibility</td><td class="print">N/A</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v3.3.2  (published 2008-04)</td><td class="print-category">Fixed in Version</td><td class="print">v3.3.2  (published 2008-04)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">Clause 23.2 (in 1); clause 9 (in 4)</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Andreas Ulrich, Siemens AG</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0000387: Time-constraint send operation</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">In order to simplify the specification of a send operation followed by a time-constraint receipt operation similar to a blocking procedure-based call operation, an extension of the current send operation is proposed.</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">23.2.4 Time-constraint send operation<br />
<br />
The send operation can be extended with a list of receive operations that are expected to occur after the message was sent to the SUT. The receive operations are guarded by an implicit timer, whose optional timeout value is set at the send operation. The syntax is similar to the call operation in procedure-based communication (see Clause 23.3.1.1). The time-constraint send operation is blocked until a matching receive message is received or the timer timed out. <br />
<br />
EXAMPLE:<br />
<br />
// The following expression?<br />
p.send(ReqMsgTemplate, 0.5) {     // send a request message and wait at most 0.5 sec<br />
&#160;&#160;[] p.receive(AckMsgTemplate) {  // acknowledgement message received within time<br />
&#160;&#160;&#160;&#160;&#160;&#160;setverdict(pass);<br />
&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;[] p.receive(NackMsgTemplate) { // or negative acknowledgement received<br />
&#160;&#160;&#160;&#160;&#160;&#160;setverdict(fail);<br />
&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;[] p.catch(timeout) {           // or no response received after 0.5 sec<br />
&#160;&#160;&#160;&#160;&#160;&#160;setverdict(inconc);<br />
&#160;&#160;&#160;&#160;&#160;}<br />
}<br />
// ?is a short form of<br />
timer t := 0.5;<br />
p.send(ReqMsgTemplate);<br />
t.start;<br />
alt {<br />
[] p.receive(AckMsgTemplate) {<br />
&#160;&#160;&#160;&#160;&#160;t.stop; setverdict(pass);<br />
&#160;&#160;&#160;}<br />
[] p.receive(NackMsgTemplate) {<br />
&#160;&#160;&#160;&#160;&#160;t.stop; setverdict(fail);<br />
&#160;&#160;&#160;}<br />
[] t.timeout { setverdict(inconc); }<br />
}<br />
<br />
The time-constraint send operation can be always resolved to a simple send operation followed by explicit timer operations and an alt expression that contains the list of possible receive operations. In particular, an activated default remains enabled when the list of alternative receipts is executed. (Note the difference to the blocking call operation with optional call body, clause 23.3.1.1).<br />
<br />
The receive operations allowed in a time-constraint send operation shall be restricted to receive, trigger, check, and catch(timeout).  It is possible to perform receive operations on ports different to the port used for the send operation. The timeout catch expression shall refer to the same port as used for the send operation though. If it is desired to receive several messages that are all guarded by a single timer, then the simple send operation without the time-constraint and appropriate alt and/or interleave and timer expressions shall be used.<br />
<br />
If necessary, it is possible to enable/disable an alternative by means of a boolean expression placed between the '[ ]' brackets of the alternative. In order to avoid unexpected side effects, the same rules as for the Boolean guards in alt statements shall be applied (see clause 20.1.1).<br />
<br />
<br />
<br />
A.1.6.2.4 Port operations<br />
<br />
320. PortSendOp ::= SendOpKeyword &quot;(&quot; SendParameter [&quot;,&quot; SendTimerValue] &quot;)&quot; [ToClause]<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[PortSendBody]<br />
/* STATIC SEMANTICS PortSendBody shall be present only if SendTimerValue is used */<br />
xxx. SendTimerValue := TimerValue<br />
xxx. PortSendBody := BeginChar SendBodyStatementList EndChar<br />
xxx. SendBodyStatementList ::= {SendBodyStatement [SemiColon]}+<br />
xxx. SendBodyStatement ::= SendBodyGuard StatementBlock<br />
xxx. SendBodyGuard ::= AltGuardChar SendBodyOps<br />
xxx. SendBodyOps ::= ReceiveStatement | TriggerStatement | CheckStatement | CatchTimeoutStatement<br />
xxx. CatchTimeoutStatement ::= Port Dot PortTimeoutOp<br />
xxx. PortTimeoutOp ::= CatchOpKeyword &quot;(&quot; TimeoutKeyword &quot;)&quot;<br />
<br />
<br />
<br />
in part 4: Operational semantics?<br />
9.7 Replacement of time-constraint send operations<br />
<br />
The time-constraint send operation is a short form of a simple send operation followed by an alt expression that contains the alternative receive operations plus appropriate timer operations. The replacement shall be made at the syntactical level. The receive operations allowed in a time-constraint send operation shall be restricted to receive, trigger, check, and catch(timeout).<br />
<br />
EXAMPLE:<br />
<br />
// The time-constraint send operation?<br />
p.send(ReqMsgTemplate, TimeoutValue) {<br />
&#160;&#160;[] p.receive(AckMsgTemplate) { ? }<br />
&#160;&#160;[] ?<br />
&#160;&#160;[] p.catch(timeout) { ? }<br />
}<br />
<br />
// ?shall be replaced by<br />
timer implicit_timer;<br />
:<br />
p.send(ReqMsgTemplate);<br />
implicit_timer.start(TimeoutValue);<br />
alt {<br />
&#160;[] p.receive(AckMsgTemplate) { implicit_timer.stop; ? }<br />
&#160;[] ?<br />
&#160;[] implicit_timer.timeout { ? }<br />
}<br />
<br />
<br />
<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">23-11-2006 14:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">23-11-2006 14:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; Clause 23.2 (in 1); clause 9 (in 4)</td></tr><tr class="print"><td class="print">23-11-2006 14:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt; Andreas Ulrich, Siemens AG</td></tr><tr class="print"><td class="print">23-11-2006 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Note Added: 0000308</td><td class="print"></td></tr><tr class="print"><td class="print">23-11-2006 14:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Status</td><td class="print">new =&gt; confirmed</td></tr><tr class="print"><td class="print">15-06-2007 19:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">15-06-2007 19:19</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Ina Schieferdecker</td></tr><tr class="print"><td class="print">13-10-2007 19:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Assigned To</td><td class="print">Ina Schieferdecker =&gt; developer_u</td></tr><tr class="print"><td class="print">15-10-2007 14:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0003615</td><td class="print"></td></tr><tr class="print"><td class="print">17-10-2007 12:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">17-10-2007 12:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Note Added: 0003662</td><td class="print"></td></tr><tr class="print"><td class="print">17-10-2007 12:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">18-10-2007 13:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">closed =&gt; feedback</td></tr><tr class="print"><td class="print">18-10-2007 13:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">fixed =&gt; reopened</td></tr><tr class="print"><td class="print">18-10-2007 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Status</td><td class="print">feedback =&gt; closed</td></tr><tr class="print"><td class="print">18-10-2007 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Resolution</td><td class="print">reopened =&gt; won't fix</td></tr><tr class="print"><td class="print">18-10-2007 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 3.3.1 (not yet published)</td></tr><tr class="print"><td class="print">18-10-2007 13:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Additional Information Updated</td><td class="print"></td></tr><tr class="print"><td class="print">12-03-2008 10:27</td><td class="print"><font STYLE="text-decoration: line-through">user10</font></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 3.3.2 (not yet published)</td></tr><tr class="print"><td class="print">12-03-2008 10:27</td><td class="print"><font STYLE="text-decoration: line-through">user10</font></td><td class="print">Target Version</td><td class="print">Edition 3.3.1 --will not be published, see 3.3.2 =&gt; Edition 3.3.2 (not yet published)</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0000308)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-11-2006 14:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Agreed in principle			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0003615)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-10-2007 14:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Should be considered also for raise and reply.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0003662)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-10-2007 12:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				A timed send, timed raise and timed reply are syntactic sugar which do not add much ... more arguments will be provided by Thomas.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
