<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:19:48 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0000354: TimedTTCN-3 - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0000354</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">22-11-2006 13:55</td><td class="print">12-12-2008 11:57</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Stephan Schulz</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">low</td><td class="print-category">Severity</td><td class="print">feature</td><td class="print-category">Reproducibility</td><td class="print">always</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">suspended</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print">v2.2.1 (published 2003-02)</td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print">v3.1.1 (published 2005-06)</td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">6, 6.3.4, 14.2.2, 18, 19.3, 22.1, 22.4, 24, 25.1, 25.2, 27.1, A.1.5, A.1.6</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;Helmut Neukirchen, Institute for Telematics, University of Luebeck     </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0000354: TimedTTCN-3</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">This CR is intended to make TTCN-3 applicable to the (hard) real-time domain. <br />
Since the snapshot semantics was not designed for real-time testing and even timers cannot be used for real-time requirements which are distributed between several test components, current TTCN-3 cannot be applied for specifying real-time test cases.<br />
A TTCN-3 real-time extension has been developed in the context of the European research project INTERVAL. This change request reflects these extension which solve the described problems of using TTCN-3 for real-time. <br />
The proposed extension is based on the introduction of clocks which are local to test components, on a formalised logfile handling and on the notion of a testrun.<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5">This document describes the changes which are needed in order to extend the TTCN-3 Core Language by the concepts needed for specifing real-time tests. The changes have to be applied to the ETSI Standard ES 201 873 1 V2.2.0 (2002-03).<br />
<br />
1.	Clause 6 (ï¿½Types and Valuesï¿½): Add to Table 3 two rows on ï¿½Special testrun typesï¿½:<br />
with entries ï¿½testrunï¿½ and ï¿½logfileï¿½. <br />
Furthermore, add:<br />
ï¿½The special testrun types testrun and logfile  can be used to refer to the outcome of a test execution (see clause reference to clause on logfile operations and reference to clause on module control part).ï¿½<br />
2.	Clause 6.3.4 (ï¿½Enumerated type and valuesï¿½): Add: <br />
ï¿½The identifier timezones is a reserved identifier for defining an enumeration type which can be used to assign symbolic names to different clock synchronisation timezones. The values of the enumeration type timezones can be passed as parameter to the execute and create statement. The self.timezone statement returns a value of type timezones. A value of name none, which represents no clock synchronisation, is implicitly member of  the enumeration type timezones.ï¿½<br />
3.	Between Clause 14.2.2 (ï¿½Templates for acceptiong procedure invokationsï¿½) and Clause 14.3 (ï¿½Template matching mechanismsï¿½): Add a new clause ï¿½Templates for sorting logfile entriesï¿½: <br />
ï¿½A template used in a .first logfile operation defines a sorting key. The symbol ? defines the field element which is used as sorting key, all other template fields have to set to -. A sorting key shall be of a type which allows relational operators to be applied to.<br />
EXAMPLE:<br />
// timestamp type definition<br />
type record MyTimestampType<br />
{<br />
&#160;&#160;float field1,<br />
&#160;&#160;timezones field2,<br />
&#160;&#160;integer field3<br />
}<br />
<br />
// a sorting key template might be<br />
template MyTimestampType MyTemplate:=<br />
{<br />
&#160;&#160;field1 := ?,<br />
&#160;&#160;field2 := -,<br />
&#160;&#160;field3 := -<br />
}<br />
ï¿½<br />
4.	Clause 18 (ï¿½Overview of program statements and operationsï¿½): Add to table 11 several rows:<br />
Add section ï¿½Statements for real-time handlingï¿½: ï¿½Wait ; resume ;  ; Yesï¿½, ï¿½Read local clock ; self.now ; ; Yesï¿½, ï¿½Get timezone of test component ; self.timezone ;  ; Yesï¿½.<br />
In section ï¿½Verdict Operationsï¿½: ï¿½Set testrun verdict ; setverdict ; Yes ; Yes (see note 2)ï¿½, ï¿½Get testrun verdict ; getverdict ; Yes ; Yes (see note 2)ï¿½<br />
Add section ï¿½Logfile operationsï¿½: ï¿½Get logfile of testrun ; getlog ; Yes ; Yes (see note 2)ï¿½, ï¿½Sort logfile and move to first entry ; first ; Yes ; Yes (see note 2)ï¿½, ï¿½Move to next entry ; next ; Yes ; Yes (see note 2)ï¿½, ï¿½Move to previous entry ; previous ; Yes ; Yes (see note 2)ï¿½, ï¿½Retrieve entry at current position; first ; retrieve ; Yes (see note 2)ï¿½<br />
5.	Clause 19.3 (ï¿½The Log statementï¿½): Replace clause by:<br />
ï¿½The log statement provides means to write values of arbitrary data types to some local logging device associated with test control or the test component in which the statement is used. For example:<br />
log(ï¿½Line 248 in PTC_Aï¿½);<br />
// The string ï¿½Line 248 in PTC_Aï¿½ is written to some log device of the test system<br />
log(MyTimestampType:{self.now, self.timezone,1});<br />
// A structured value which contains local time, local time zone and the integer 1 is written to some log device of the test system<br />
The logfiles may be subject of further processing (see clause reference to clause on logfile operations).<br />
NOTE: The mechanisms for storing and maintaining logfiles are considered to be implementation specific and are outside the scope of the present document.ï¿½<br />
6.	Clause 22.1 (ï¿½The Create operationï¿½): Add:<br />
ï¿½The create operation may be called with an optional parameter of enumerated type timezones. In this case the test implementation has to take care that all test components which are created with the same timezones value (the timezones value of the MTC may be specified as an optional parameter of the execute operation) have synchronised clocks.<br />
NOTE 1: The concrete mechanism for clock synchronisation of test components is tool specific and therefore outside the scope of the present document.<br />
NOTE 2: If clock synchronisation cannot be established, the error verdict will be set.<br />
EXAMPLE:<br />
<br />
&#160;&#160;&#160;&#160;:<br />
type enumerate timezones {<br />
&#160;&#160;zone1, zone2, zone3<br />
}<br />
&#160;&#160;:<br />
var MyComponentType MyNewComponent;<br />
&#160;&#160;:<br />
MyNewComponent := MyComponentType.create(zone1); // create component in timezone zone1<br />
&#160;&#160;:<br />
ï¿½<br />
7.	After Clause 22.4 (ï¿½The MTC, System and Self operationsï¿½): Add a new clause ï¿½The self.timezone operationï¿½:<br />
ï¿½The timezone of a test component may be retrieved using the self.timezone operation which returns a value of enumerated type timezones. If the self.timezone operation is called within a test component which has no clock synchronisation, the value none is returned.<br />
&#160;EXAMPLE:<br />
<br />
&#160;&#160;&#160;&#160;:<br />
var timezones MyTimezone;<br />
&#160;&#160;:<br />
MyTimezone := self.timezone;  // Retrieve timezone of component<br />
&#160;&#160;:<br />
&#160;&#160;&#160;&#160;ï¿½<br />
8.	After Clause 24: Add a new clause ï¿½Real-time operationsï¿½:<br />
ï¿½TTCN-3 supports two operations which operate on the absolute value of a test components local clock.<br />
<br />
Subclause The self.now operation<br />
The self.now operation is used to read the absolute value of a test components clock. It is assumed that each test component has its own local clock. Further synchronisation of different test components may be specified by a timezone parameter passed to the execute and create statement (see clause reference to clause on Enumerated type and values, The Create operation and Execution of test cases). The return type of the self.now operation is of type float and represents local time by seconds elapsed since a fixed point in time.<br />
NOTE: The present document does not define a fixed starting point for time measurement,  but requires a starting point which is at least older than the point in time when a testrun has been started.<br />
<br />
Subclause The resume operation<br />
The resume operation allows a test component to suspend execution and resume at a certain absolute point in time with respect to the test components local clock. This absolute value is passed as a parameter of type float and represents local time as returned by the self.now operation.<br />
<br />
EXAMPLE:<br />
<br />
&#160;&#160;:<br />
var float myTime;<br />
&#160;&#160;:<br />
myTime:=self.now; // Read local clock<br />
resume(myTime+5.0); // Wait for five seconds<br />
&#160;&#160;:<br />
ï¿½<br />
9.	Clause 25.1 (ï¿½Test case verdictï¿½): Replace ï¿½This verdict is not accessible to the getverdict and setverdict operationsï¿½ by ï¿½This verdict is not accessible to the getverdict and setverdict operations within a test component, but by the setverdict and getverdict operations which can be applied in the module control part to a testrun handle for further processing of a global verdict (see clause reference to new clause on testrun handles). ï¿½<br />
Remove sentence ï¿½If the returned verdict is not explicitly saved in the control part (e.g. assigned to a variable) then it is lost.ï¿½<br />
10.	Clause 25.2 (ï¿½Verdict values and overwriting rulesï¿½): Replace ï¿½The verdict can have five different values: pass, fail, inconc, none and errorï¿½ by ï¿½The verdict can have six different values: pass, fail, inconc, conf, none and errorï¿½. <br />
Add ï¿½NOTE 2: conf means a verdict which indicates conformance with respect to pure functional behaviour, but a failure with respect to non-functional behaviour.ï¿½ <br />
&#160;Replace Table 21 (ï¿½Overwriting rules for the verdictï¿½) by:<br />
Current value of verdict	New verdict assignment value<br />
&#160;&#160;&#160;&#160;pass	conf	inconc	fail	none<br />
Pass	pass	conf	inconc	fail	pass<br />
Conf	conf	conf	inconc	fail	conf<br />
Inconc	inconc	inconc	inconc	fail	inconc<br />
Fail	fail	fail	fail	fail	fail<br />
None	pass	conf	inconc	fail	none<br />
<br />
11.	Clause 27.1 (ï¿½Execution of test casesï¿½): Replace ï¿½As the result of the execution of a test case a test verdict of either none, pass, inconclusive, fail or error shall be returned and may be assigned to a variable for further processing.ï¿½ by ï¿½As the result of the execution of a test case, a testrun handle shall be returned and may be used for further evaluation of  a testrun (see clause reference to clause on testrun handles).ï¿½<br />
Add:<br />
ï¿½A further, optional parameter of enumerated type timezones allows to specify a synchronisation timezone for the local clock of the main test component.<br />
If  a timezone parameter is passed to the execute statement, the test implementation has to take care that all parallel test components which are created with the same timezone value as the main test component have synchronised clocks.<br />
NOTE: The concrete mechanism for clock synchronisation of test components is tool specific and therefore outside the scope of the present document.ï¿½<br />
Replace example by:<br />
ï¿½execute(MyTestcase1()); // executes MyTestCase1, without storing the returned testrun handle and without time supervision nor clock synchronisation timezone<br />
<br />
MyTestrunHandle := execute(MyTestCase2()); // executes MyTestCase2 and stores the returned testrun handle in variable MyTestrunHandle.<br />
<br />
MyTestrunHandle := execute(MyTestCase3(),5E-3); // executes MyTestCase3 and stores the returned testrun handle in variable MyTestrunHandle. If the test case does not terminate within 5ms, MyVerdict will get the value ï¿½errorï¿½.<br />
<br />
MyTestrunHandle := execute(MyTestCase4(),zone1); // executes MyTestCase3 and stores the returned testrun handle in variable MyTestrunHandle. The clock synchronisation timezone of the MTC is set to value ï¿½zone1ï¿½.<br />
<br />
MyTestrunHandle := execute(MyTestCase5(),5E-3,zone1); // executes MyTestCase3 and stores the returned testrun handle in variable MyTestrunHandle. The clock synchronisation timezone of the MTC is set to value ï¿½zon1ï¿½. If the test case does not terminate within 5ms, MyVerdict will get the value ï¿½errorï¿½.<br />
ï¿½<br />
12.	After Clause 27.1: Add clause ï¿½Testrun handleï¿½:<br />
ï¿½The value which shall be returned by the execute statement shall be of type testrun. Values of this type may be used to handle the outcome of a testrun, e.g. pass it to a function for further evaluation of a testrun. Three operations which may be applied to a testrun handle are defined:<br />
<br />
Testrun operation<br />
Statement	Associated keyword<br />
Get logfile	getlog<br />
Get global verdict	getverdict<br />
Set global verdict	setverdict<br />
<br />
The getlog operations retrieves the global logfile of type logfile which is build when test execution finishes, i.e. the main test component terminates. The global logfile is merged from the local logfiles which are associated to test control or the test (see clause reference to clause on logfile operations).<br />
<br />
NOTE: The order in which entries of  the local logfiles are initially merged is tool specific and therefore outside the scope of the present document. An ordering of entries of a particular type may be explicitly requested by applying the first operation to a logfile variable.ï¿½<br />
<br />
The global verdict which is calculated when each test component finishes execution may be accessed by the getverdict and setverdict operations which may be applied to a variable of type testrun.<br />
<br />
EXAMPLE:<br />
control {<br />
&#160;&#160;var testrun myTestrun;              // Variable for testrun handling<br />
&#160;&#160;var logfile myLog;                  // Variable for testlog handling<br />
&#160;&#160;var verdicttype myVerdict           // Variable for verdict handling<br />
&#160;&#160;myTestrun := execute(MyTestCase()); // Execute testcase <br />
&#160;&#160;myVerdict := myTestrun.getverdict;  // Retrieval of testrun verdict<br />
&#160;&#160;myLog := myTestrun.getlog;          // Retrieval of testrun log<br />
&#160;&#160;&#160;&#160;:<br />
&#160;&#160;myTestrun.setverdict(fail);         // Change of testrun verdict<br />
}<br />
ï¿½<br />
13.	After Clause 27: Add new clause ï¿½Logfile operationsï¿½:<br />
ï¿½Five operations are defined for processing the logfiles which are created by test control and test components. <br />
<br />
Logfile operation<br />
Statement	Associated keyword<br />
Get logfile of a testrun	testrunhandle.getlog<br />
Get logfile of test control or test component	self.getlog<br />
Select entries from logfile, sort them and move cursor to first matching entry	first<br />
Move cursor to the next matching entry	next<br />
Move cursor to the previous matching entry	previous<br />
Retrieve entry from the current logfile cursor position	retrieve<br />
<br />
<br />
A test component or test control may call self.getlog operation to get its own logfile which is of type logfile.<br />
When test execution finishes, i.e. the main test component terminates, the local logfiles are merged into a global logfile of type logfile, which may be retrieved from within test control by applying the getlog operation to a testrun handle (see clause reference to clause Testrun handle).<br />
<br />
Further postprocessing of logfiles has to be initiated by applying the first operation on variables of type logfile. A search template shall be used as the first parameter of operation first to select entries from the logfiles by their type and to sort them. The type of the search template is used to select entries which are regarded by further next, previous and retrieve operations. The second parameter is used to move an internal cursor in the logfile to the first entry that matches this parameter. Templates may be used to avoid to restrictive search patterns. If no matching entry is found, the cursor position is undefined and operation first returns value false, otherwise value true.<br />
The operations next and previous may be applied to a logfile in order to move the logfiles cursor to the next or previous respectively entry which matches the search pattern which is given as parameter. If no matching entry is found, the cursor position remains unchanged and operation first returns value false, otherwise value true.<br />
If the logfiles cursor is at a defined position, the retrieve operation may be applied to a logfile in order to retrieve the logfile entry at the current cursor position. Otherwise, an undefined value will be returned. The type of the returned value is determined by the type of the search template specified as first parameter of operation first.<br />
<br />
NOTE: The mechanisms for storing, maintaining and processing logfiles are considered to be implementation specific and are outside the scope of the present document.<br />
<br />
EXAMPLE:<br />
control {<br />
&#160;&#160;var testrun myTestrun;              // Variable for testrun handling<br />
&#160;&#160;var logfile myLog;                  // Variable for testlog handling<br />
&#160;&#160;var MyTimestampType MyTimestamp;<br />
&#160;&#160;myTestrun := execute(MyTestCase(),Berlin); // Execute testcase <br />
&#160;&#160;<br />
&#160;&#160;myLog := myTestrun.getlog;          // Retrieval of testrun log<br />
&#160;&#160;if (myLog.first(MyTimestampType:{?,-,-},MyTimestampType{?,Berlin,?})) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// Select logfile entries of type<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// MyTimestampType and sort them<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ascending with respect to the<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// first field element. Set cursor to<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// the first entry with second field<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// element of value Berlin.<br />
&#160;&#160;&#160;&#160;if (myLog.next(MyTimestampType:{?,Berlin,?})) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// Advance cursor to next matching<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// entry with second field element of <br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// value Berlin.<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;MyTimestamp := myLog.retrieve;  // If first and next operation were<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// successful, retrieve value at<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// cursor position.<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;:<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;}<br />
}<br />
ï¿½<br />
14.	Annex A.1.5 (ï¿½TTCN-3 terminalsï¿½): Add to Table A.3:<br />
ï¿½conf, first, getlog, logfile, next, now, previous, resume, retrieve, testrun, timezone, timezones<br />
ï¿½<br />
15.	Annex A.1.6 (ï¿½TTCN-3 syntax BNF productionsï¿½): Change according to the following diffs:<br />
<br />
Old 187. TestcaseInstance ::= ExecuteKeyword &quot;(&quot; TestcaseRef &quot;(&quot; [TestcaseActualParList] &quot;)&quot; [&quot;,&quot; TimerValue] &quot;)&quot;<br />
New 187. TestcaseInstance ::= ExecuteKeyword &quot;(&quot; TestcaseRef &quot;(&quot; [TestcaseActualParList] &quot;)&quot; [&quot;,&quot; TimerValue] [&quot;,&quot; Expression] &quot;)&quot; /* STATIC SEMANTICS ï¿½ Expression must evaluate to timezones enumeration type */<br />
<br />
Old 272. ControlStatement ::= TimerStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BasicStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BehaviourStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;SUTStatements<br />
New 272. ControlStatement ::= TimerStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BasicStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BehaviourStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;SUTStatements |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;SetGlobalVerdict<br />
<br />
Old 288. ConfigurationOps ::= CreateOp | SelfOp | SystemOp | MTCOp | RunningOp<br />
New 288. ConfigurationOps ::= CreateOp | SelfOp | SelfTimezoneOp | SelfNowOp | SelfGetLogOp| SystemOp | MTCOp | RunningOp<br />
<br />
Old 289. CreateOp ::= ComponentType Dot CreateKeyword<br />
New 289. CreateOp ::= ComponentType Dot CreateKeyword [&quot;(&quot; Expression] &quot;)&quot; /* STATIC SEMANTICS ï¿½ Expression must evaluate to timezones enumeration type */<br />
<br />
New 291b. SelfTimezoneOp ::= &quot;self&quot; Dot &quot;timezone&quot;<br />
<br />
New 291c. SelfNowOp ::= &quot;self&quot; Dot &quot;now&quot;<br />
<br />
New 291d. SelfGetLogOp ::= &quot;self&quot; Dot &quot;getlog&quot;<br />
<br />
Old 408. PredefinedType ::= BitStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BooleanKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;CharStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;UniversalCharString |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;CharKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;UniversalChar |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;IntegerKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;OctetStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ObjectIdentifierKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;HexStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;VerdictTypeKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;FloatKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;AddressKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;DefaultKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;AnyTypeKeyword<br />
New 408. PredefinedType ::= BitStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;BooleanKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;CharStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;UniversalCharString |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;CharKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;UniversalChar |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;IntegerKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;OctetStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ObjectIdentifierKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;HexStringKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;VerdictTypeKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;FloatKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;AddressKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;DefaultKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;AnyTypeKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestrunKeyword |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;LogfileKeyword<br />
<br />
New 423b. TestrunKeyword ::= &quot;testrun&quot;<br />
<br />
New 423c. LogfileKeyword ::= &quot;logfile&quot;<br />
<br />
Old 444. VerdictTypeValue ::= &quot;pass&quot; | &quot;fail&quot; | &quot;inconc&quot; | &quot;none&quot; | &quot;error&quot;<br />
New 444. VerdictTypeValue ::= &quot;pass&quot; | &quot;conf&quot; | &quot;fail&quot; | &quot;inconc&quot; | &quot;none&quot; | &quot;error&quot;<br />
<br />
Old 445. EnumeratedValue ::= EnumerationIdentifier<br />
New 445. EnumeratedValue ::= EnumerationIdentifier | &quot;none&quot; /* STATIC SEMANTICS ï¿½ implicit value &quot;none&quot; only for enumeration types of name &quot;timezones&quot; */<br />
<br />
Old 509. VerdictStatements ::= SetLocalVerdict<br />
Old 509. VerdictStatements ::= SetLocalVerdict | SetGlobalVerdict<br />
<br />
New 511b. SetGlobalVerdict ::= TestrunIdentifier Dot SetVerdictKeyword &quot;(&quot; SingleExpression &quot;)&quot;<br />
<br />
Old 540. BasicStatements ::= Assignment | LogStatement | LoopConstruct | ConditionalConstruct<br />
New 540. BasicStatements ::= Assignment | LogStatement | LoopConstruct | ConditionalConstruct | ResumeStatement<br />
<br />
Old 568. OpCall ::= 	ConfigurationOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;VerdictOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TimerOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestcaseInstance |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;FunctionInstance |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TemplateOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ActivateOp<br />
New 568. OpCall ::= 	ConfigurationOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;VerdictOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TimerOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestcaseInstance |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;FunctionInstance |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TemplateOps |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ActivateOp |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestlogOp |<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;TestrunOp <br />
<br />
Old 577. LogStatement ::= LogKeyword &quot;(&quot; [FreeText] &quot;)&quot;<br />
New 577. LogStatement ::= LogKeyword &quot;(&quot; [TemplateInstance] &quot;)&quot;<br />
<br />
New 578b. ResumeStatement ::= ResumeKeyword &quot;(&quot; Expression &quot;)&quot; /* STATIC SEMANTICS: expression must resolve to value of type float */<br />
<br />
New 578b. ResumeKeyword ::= &quot;resume&quot;<br />
<br />
New heading: A.1.5.2.6 Testrun and Testlog Operations<br />
<br />
New 406b. TestlogOps ::=  FirstOp  | NextOp | PreviousOp | RetrieveOp<br />
<br />
New 406c. FirstOp ::=  TestlogIdentifier Dot FirstKeyword &quot;(&quot; TemplateInstance &quot;,&quot; TemplateInstance &quot;)&quot;<br />
<br />
New 406d. FirstKeyword ::= &quot;first&quot;<br />
<br />
New 406e. NextOp ::= TestlogIdentifier Dot NextKeyword &quot;(&quot; TemplateInstance &quot;)&quot;<br />
<br />
New 406f. NextKeyword ::= &quot;next&quot;<br />
<br />
New 406g. PreviousOp ::= TestlogIdentifier Dot PreviousKeyword &quot;(&quot; TemplateInstance &quot;)&quot;<br />
<br />
New 406h. PreviousKeyword ::= &quot;previous&quot;<br />
<br />
New 406i. RetrieveOp ::= TestlogIdentifier Dot RetrieveKeyword<br />
<br />
New 406j. RetrieveKeyword ::= &quot;retrieve&quot;<br />
<br />
New 406k. TestlogIdentifier ::= FunctionInstance | VariableRef<br />
<br />
New 406l. TestrunOps ::= GetlogOp | GetGlobalVerdictOp<br />
<br />
New 406m. GetlogOp ::=  TestrunIdentifier Dot GetlogKeyword /* STATIC SEMANTICS: may only be applied in module control part */<br />
<br />
New 406n. GetlogKeyword ::= &quot;getlog&quot;<br />
<br />
New 406o. GetGlobalVerdictOp ::=  TestrunIdentifier Dot GetverdictKeyword /* STATIC SEMANTICS: may only be applied in module control part */<br />
<br />
New 406p. TestrunIdentifier ::= FunctionInstance | VariableRef  <br />
<br />
</td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0000355</td><td class="print">closed&#160;</td><td class="print">&#160;</td><td class="print">TimedGFT&#160;</td></tr><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0004483</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">New Concepts to Test Real Time Properties&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">22-11-2006 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">22-11-2006 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Clause Reference(s)</td><td class="print"> =&gt; 6, 6.3.4, 14.2.2, 18, 19.3, 22.1, 22.4, 24, 25.1, 25.2, 27.1, A.1.5, A.1.6</td></tr><tr class="print"><td class="print">22-11-2006 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Source  (company  - Author)</td><td class="print"> =&gt;  Helmut Neukirchen, Institute for Telematics, University of Luebeck     </td></tr><tr class="print"><td class="print">22-11-2006 13:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Note Added: 0000283</td><td class="print"></td></tr><tr class="print"><td class="print">22-11-2006 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Status</td><td class="print">new =&gt; closed</td></tr><tr class="print"><td class="print">22-11-2006 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Note Added: 0000284</td><td class="print"></td></tr><tr class="print"><td class="print">22-11-2006 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Resolution</td><td class="print">open =&gt; suspended</td></tr><tr class="print"><td class="print">22-11-2006 13:58</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; Edition 3.1.1</td></tr><tr class="print"><td class="print">24-11-2006 13:38</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a></td><td class="print">Relationship added</td><td class="print">related to 0000355</td></tr><tr class="print"><td class="print">12-12-2008 11:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Product Version</td><td class="print"> =&gt; Edition 2.2.1</td></tr><tr class="print"><td class="print">12-12-2008 11:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Fixed in Version</td><td class="print">Edition 3.1.1 =&gt; </td></tr><tr class="print"><td class="print">12-12-2008 11:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Target Version</td><td class="print"> =&gt; Edition 3.1.1</td></tr><tr class="print"><td class="print">12-12-2008 11:57</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Additional Information Updated</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2008 12:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=81">Ina Schieferdecker</a></td><td class="print">Relationship added</td><td class="print">related to 0004483</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0000283)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-11-2006 13:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The usage of this extension was presented as a paper at Testcom 2002. This paper contains a complete example and shows the interworking of the individual extensions provided in this change request. Thus it is recommonded to read this paper. It can be downloaded via:<br />
<a href="http://www.itm.mu-luebeck.de/pubs/single_pub/index.php?lang=en&amp;pub_nr=183">http://www.itm.mu-luebeck.de/pubs/single_pub/index.php?lang=en&amp;pub_nr=183</a> [<a href="http://www.itm.mu-luebeck.de/pubs/single_pub/index.php?lang=en&amp;pub_nr=183" target="_blank">^</a>]			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0000284)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=56">Stephan Schulz</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				22-11-2006 13:58&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Will be addressed in the continuation project for STF213			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
