<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:11 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008113: Type traits and user defined methods - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - TTCN-3 Change Requests</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008113</td><td class="print">TTCN-3 Change Requests</td><td class="print">New Feature</td><td class="print">public</td><td class="print">17-08-2022 07:14</td><td class="print">16-12-2024 12:49</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">resolved</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">New Extension</td></tr><tr class="print"><td class="print-category">For STF discussion</td><td class="print" colspan="4"></td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia -- Matthias Simon</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008113: Type traits and user defined methods</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">Type traits allow to compose behavior in a lightweight, but powerful way.<br />
<br />
## Methods<br />
<br />
This extensions allows to specify methods for any user defined types. The<br />
receiver type is specified using the &quot;for&quot; keyword. Inside the behavior the<br />
receiver value is accessible via &quot;this&quot; symbol:<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;module Example {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type integer Timestamp<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function year() for Timestamp return string {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return int2str(1970+this/SECONDS_PER_YEAR);<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;control {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;const Timestamp t := 1660681400;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(t.year()) // logs &quot;2022&quot;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
## Traits<br />
<br />
A trait is a set of methods and can be defined using the &quot;trait&quot; keyword:<br />
<br />
&#160;&#160;&#160;&#160;trait Stringer {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function String() charstring;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
A variable of a trait type can hold any value that implements the trait:<br />
<br />
&#160;&#160;&#160;&#160;module Example {<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record Point2D { integer x, integer y }<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function string() for Point3D return charstring {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return sprintf(&quot;(%d|%d)&quot;, this.x, this.y)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record Point3D { integer x, integer y, integer z }<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function string() for Point2D return charstring {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return sprintf(&quot;(%d|%d|%d)&quot;, this.x, this.y, this.z)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;trait Stringer {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function string() charstring;<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function logPoints(Stringer s) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(s.string())<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;control {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var Point2D p1 := {1,2};<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var Point3D p2 := {1,2,3}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;logPoints(p1); // okay because Point2D implements Stringer trait<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;logPoints(p2); // okay because Point3D also implements Stringer trait<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
## Embedding<br />
<br />
When the field name is omitted, the field is called an embedded field:<br />
<br />
&#160;&#160;&#160;&#160;type integer Timestamp;<br />
&#160;&#160;&#160;&#160;external function year() for Timestamp return charstring;<br />
<br />
&#160;&#160;&#160;&#160;type record Date {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Timestamp,      // embedded field<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;charstring zone // regular field<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
An embedded field is accessible by its type name:<br />
<br />
&#160;&#160;&#160;&#160;var Data d := { Timestamp := 1660681400, zone := &quot;GMT+2&quot; };<br />
&#160;&#160;&#160;&#160;d.Timestamp := d.Timestamp + 3600;<br />
<br />
<br />
Embedded fields must be unique:<br />
<br />
&#160;&#160;&#160;&#160;type record Date {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Timestamp,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Timestamp // not allowed.<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
Methods of an embedded field are promoted and become methods of the embedding type:<br />
<br />
&#160;&#160;&#160;&#160;var Data d := { Timestamp := 1660681400, zone := &quot;GMT+2&quot; };<br />
&#160;&#160;&#160;&#160;log(d.year()); // year is a promoted method implemented by the Timestamp type<br />
<br />
<br />
Conflicting promoted methods have to be resolved explicitly:<br />
<br />
&#160;&#160;&#160;&#160;type integer Duration;<br />
&#160;&#160;&#160;&#160;external function year() for Duration return charstring;<br />
<br />
&#160;&#160;&#160;&#160;type record Event {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Timestamp,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Duration<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Timestamp and Duration both provide a &quot;year&quot;-method. Event type need<br />
&#160;&#160;&#160;&#160;// to resolve this conflict explicitly:<br />
&#160;&#160;&#160;&#160;function year() for Event return charstring {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return sprintf(&quot;start=%s, duration=%s&quot;, this.Timestamp, this.Duration)<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
## Notes and Open Questions<br />
<br />
* Should we call it &quot;trait&quot; or rather &quot;interface&quot; like in Java, C# and Go?<br />
* Should we support default implementations for traits (requires &quot;implements&quot; keyword)?<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">17-08-2022 07:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2022 07:16</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Description Updated</td><td class="print">bug_revision_view_page.php?rev_id=587#r587</td></tr><tr class="print"><td class="print">17-08-2022 09:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016228</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2022 09:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">17-08-2022 09:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-11-2022 08:15</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016267</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2022 08:22</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016267</td><td class="print">bug_revision_view_page.php?rev_id=595</td></tr><tr class="print"><td class="print">08-11-2022 08:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016267</td><td class="print">bug_revision_view_page.php?rev_id=596</td></tr><tr class="print"><td class="print">08-11-2022 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016267</td><td class="print">bug_revision_view_page.php?rev_id=597</td></tr><tr class="print"><td class="print">10-11-2022 09:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016267</td><td class="print">bug_revision_view_page.php?rev_id=600</td></tr><tr class="print"><td class="print">10-11-2022 09:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Deleted: 0016267</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2022 09:52</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016287</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2022 10:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016287</td><td class="print">bug_revision_view_page.php?bugnote_id=16287#r602</td></tr><tr class="print"><td class="print">10-11-2022 10:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0016290</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2022 12:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016287</td><td class="print">bug_revision_view_page.php?bugnote_id=16287#r603</td></tr><tr class="print"><td class="print">07-12-2022 08:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016363</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 09:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016382</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 14:37</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016388</td><td class="print"></td></tr><tr class="print"><td class="print">20-12-2022 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016437</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016552</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2023 13:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">26-01-2024 16:27</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a></td><td class="print">Note Added: 0016607</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2024 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016726</td><td class="print"></td></tr><tr class="print"><td class="print">16-12-2024 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">16-12-2024 12:49</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016228)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2022 09:53&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: CR should be splitted into Methods &amp; Traits and Embedded Fields. Matthias will make more complete proposals. Questions to be answered are related to import and type compatibility.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016287)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-11-2022 09:52&#160;&#160;&#160;
				<br />(edited on:&#32;10-11-2022 12:50)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				What syntax for defining methods do your prefer?<br />
<br />
# Free floating (like in Go, Perl, ...)<br />
<br />
Example:<br />
&#160;&#160;&#160;&#160;function F() for T runs on C return boolean {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return this &gt; 5;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
Variations:<br />
&#160;&#160;&#160;&#160;function F() with T ...<br />
&#160;&#160;&#160;&#160;function F() extends T ...<br />
&#160;&#160;&#160;&#160;function F() on T ...<br />
&#160;&#160;&#160;&#160;function F() to T ...<br />
&#160;&#160;&#160;&#160;function F() at T ...<br />
&#160;&#160;&#160;&#160;function F() in T ...<br />
&#160;&#160;&#160;&#160;function F() -&gt; T ...<br />
&#160;&#160;&#160;&#160;function F() =&gt; T ...<br />
&#160;&#160;&#160;&#160;on T function F() ...<br />
&#160;&#160;&#160;&#160;function for T F() ...<br />
<br />
&#160;&#160;&#160;&#160;&#160;<br />
# Qualified names (like in C++)<br />
<br />
Example:<br />
&#160;&#160;&#160;&#160;function T::F() runs on C return boolean {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;return this &gt; 5;<br />
&#160;&#160;&#160;&#160;}<br />
<br />
Variations:<br />
&#160;&#160;&#160;&#160;function T.F() ...<br />
&#160;&#160;&#160;&#160;function T:F() ...<br />
<br />
<br />
# Nested declarations (like in Java, Python, ...)<br />
<br />
Example:<br />
&#160;&#160;&#160;&#160;type record T {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer x,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function F() runs on C return boolean { return true },<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer y<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;type integer I8 (-127..128) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function F() runs on C return boolean { return true };<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
# Dedicated method block<br />
<br />
Example:<br />
&#160;&#160;&#160;&#160;type record T {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer x,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer y<br />
&#160;&#160;&#160;&#160;} with {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function F() runs on C return boolean { return true };<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;type integer I8 (-127..128) with {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;function F() runs T return boolean { return true };<br />
&#160;&#160;&#160;&#160;}<br />
<br />
Variations:<br />
&#160;&#160;&#160;&#160;type integer I8 extends { ... }<br />
&#160;&#160;&#160;&#160;type integer I8 implements { ... }<br />
&#160;&#160;&#160;&#160;type integer I8 group { ... }<br />
&#160;&#160;&#160;&#160;type integer I8 bind { ... }<br />
&#160;&#160;&#160;&#160;type integer I8 connect { ... }<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016290)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-11-2022 10:46&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This is a topic for a discussion. <br />
<br />
Free floating syntax resembles what we already have in TTCN-3. It can extend built-in types as well. However, there are two major problems that are not easy to resolve (valid for qualified names too):<br />
1. Import of traits, especially when they are defined in a different module than the type (could be resolved by dedicated import rules)<br />
2. Violation of scoping principles of TTCN-3: So far all lower scopes are declared inside a definition. Using free floating could lead to traits with the same name but different functionality being present in more than one module and we would need a whole set of rule for handling that.<br />
<br />
For these reasons, I would prefer an encapsulation approach. Out of the proposed options I like nested declarations more, because the syntax doesn't use excess symbols.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016363)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-12-2022 08:26&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Open questions are related to syntax and semantics. Unclear where to put this CR. May become part of core language or may become part of the OO extension. Resolution of issues should be discussed in the scope of language renovation.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016382)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2022 09:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Split of embedded fields part: <a href="http://oldforge.etsi.org/mantis/view.php?id=8154">http://oldforge.etsi.org/mantis/view.php?id=8154</a> [<a href="http://oldforge.etsi.org/mantis/view.php?id=8154" target="_blank">^</a>]			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016388)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2022 14:37&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Split of methods part: <a href="http://oldforge.etsi.org/mantis/view.php?id=8156">http://oldforge.etsi.org/mantis/view.php?id=8156</a> [<a href="http://oldforge.etsi.org/mantis/view.php?id=8156" target="_blank">^</a>]			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016437)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-12-2022 11:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Proposal will not be finalized and agreed upon until end of year. Proposal will be prepared until end of the year. To be shifted into the next TTF.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016552)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2023 13:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: To be discussed in the scope of OO features in new major release.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016607)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-01-2024 16:27&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				We assume/expect that this CR will not become part of the core language but will become part of an extension or be added to an extension (e.g. OO extension).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016726)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-12-2024 12:49&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Discussion continues in Gitlab			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
