<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:25 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008108: Uniqueness of identifiers for fields and enumerations - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - TTCN-3 Change Requests</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008108</td><td class="print">TTCN-3 Change Requests</td><td class="print">Clarification</td><td class="print">public</td><td class="print">16-08-2022 07:43</td><td class="print">04-01-2023 11:12</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">5.2.2 Uniqueness of identifiers</td></tr><tr class="print"><td class="print-category">For STF discussion</td><td class="print" colspan="4"></td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia -- Matthias Simon     </td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008108: Uniqueness of identifiers for fields and enumerations</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">The core language standard states that identifiers of scope units shall be unique:<br />
<br />
&gt; TTCN-3 requires uniqueness of identifiers, i.e. all identifiers in the same scope hierarchy shall be distinctive.<br />
&gt; This means that a declaration in a lower level of scope shall not re-use the same identifier as a declaration in<br />
&gt; a higher level of scope in the same branch of the scope hierarchy.<br />
<br />
However it is not clear if this requirement includes field identifiers of records or enumeration labels or not.<br />
<br />
I'd argue they are not included. Hence I propose to add some clarifying examples:<br />
<br />
<br />
EXAMPLE 3: Explicit scopes<br />
<br />
// The following IS allowed as the custom type definition provide an explicit scope for fields and enumeration labels<br />
module A {<br />
&#160;&#160;type record B {<br />
&#160;&#160;&#160;&#160;&#160;&#160;integer A,<br />
&#160;&#160;&#160;&#160;&#160;&#160;integer B<br />
&#160;&#160;}<br />
<br />
&#160;&#160;type enumerated C { A, B }<br />
}<br />
<br />
<br />
<br />
</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8108.docx (80,337) <span class="italic">09-11-2022 11:44</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4074&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8108-r1.docx (80,749) <span class="italic">11-11-2022 10:53</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4079&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">16-08-2022 07:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 09:03</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016212</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 09:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">16-08-2022 09:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">08-11-2022 11:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">09-11-2022 11:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR8108.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016274</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">09-11-2022 11:45</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">09-11-2022 15:46</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016281</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 15:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Edited: 0016281</td><td class="print">bug_revision_view_page.php?bugnote_id=16281#r599</td></tr><tr class="print"><td class="print">09-11-2022 16:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016282</td><td class="print"></td></tr><tr class="print"><td class="print">10-11-2022 21:05</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">11-11-2022 10:53</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR8108-r1.docx</td><td class="print"></td></tr><tr class="print"><td class="print">11-11-2022 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">11-11-2022 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">11-11-2022 10:55</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016308</td><td class="print"></td></tr><tr class="print"><td class="print">06-12-2022 10:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">06-12-2022 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; resolved</td></tr><tr class="print"><td class="print">06-12-2022 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">06-12-2022 13:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">04-01-2023 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016463</td><td class="print"></td></tr><tr class="print"><td class="print">04-01-2023 11:12</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016212)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				16-08-2022 09:03&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF Discussion: Examples are correct and should be added.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016274)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 11:45&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Examples have been added.<br />
<br />
Please check to resolve the issue.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016281)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 15:46&#160;&#160;&#160;
				<br />(edited on:&#32;09-11-2022 15:51)			</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Do you think we should find a different term for &quot;explicit scopes&quot;?<br />
Because we don't use &quot;explicit scope&quot; anywhere else in the standard. Similarly, I would suggest to rename:<br />
* &quot;field labels&quot; to &quot;field identifiers&quot;<br />
* &quot;enumeration labels&quot; to &quot;enumerated values&quot;<br />
<br />
I think a consistent use of terms is beneficial. How about:<br />
<br />
EXAMPLE 4:	User defined type scopes<br />
<br />
&#160;&#160;&#160;&#160;module A {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type record B {  // Identifiers for fields of structured types do not have to be globally unique identifiers<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer A, // no name clash with module identifier<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;integer B  // no name clash with record identifier<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;type enumerated C { // Identifiers for enumerated do not have to be globally unique<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// TODO: See follow up comment.<br />
&#160;&#160;&#160;&#160;}<br />
<br />
Further I think we have to discuss, if my proposed example for enumerated types is not correct.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016282)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 16:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I believe my enumerated type example is not correct:<br />
<br />
&#160;&#160;&#160;&#160;type enumerated C {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;A, // name clash with module identifier<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;B, // name clash with identifier of previous record definition<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;C, // name clash with identifier of enumerated type<br />
&#160;&#160;&#160;&#160;}<br />
<br />
The enumerated values violate restriction [1]:<br />
<br />
&gt; # Chapter 5.2.2 &quot;Uniqueness of identifiers&quot;:<br />
&gt; [1] enumerated values [...] within the same module [...] shall only be reused:<br />
&gt; [1a] for enumerated values within other enumerated types<br />
&gt; [1b] as identifiers for fields of structured types			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016308)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-11-2022 10:55&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please check the modified solution following your notes.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016463)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-01-2023 11:12&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented as proposed in resolution.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
