<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:18 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008090: Deprecate `lengthof` in favor of `length` - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008090</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">23-03-2022 15:43</td><td class="print">26-01-2024 16:24</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">won't fix</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">C.2.1 Length of strings and lists</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Nokia - Matthias Simon</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008090: Deprecate `lengthof` in favor of `length`</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">I often accidentally use keyword `length` instead of predefined function `lengthof`. The result is an irritating syntax error ala `unexpected length, expecting expression`.  <br />
<br />
This mistake is easy to make. Hence I propose to rename predefined function `lengthof` to `length`. And begin deprecation process for the `lengthof` keyword.<br />
<br />
This would become valid TTCN-3 code:<br />
<br />
&#160;&#160;&#160;&#160;for (i := 0; i &lt; length('1100101'b); i := i + 1) { /* ... */ }</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"></td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">23-03-2022 15:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 14:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">17-08-2022 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016233</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2022 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">17-08-2022 11:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">09-11-2022 10:42</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0016272</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 11:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016277</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 12:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016278</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2022 12:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">09-11-2023 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016566</td><td class="print"></td></tr><tr class="print"><td class="print">09-11-2023 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">assigned =&gt; closed</td></tr><tr class="print"><td class="print">09-11-2023 11:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Resolution</td><td class="print">open =&gt; won't fix</td></tr><tr class="print"><td class="print">26-01-2024 16:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a></td><td class="print">Note Added: 0016604</td><td class="print"></td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016233)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2022 11:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Similar argumentation as for operators. Needs to be studied. There might be a potential grammer conflict.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016272)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 10:42&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Input for a discussion: <br />
The proposed change is technically possible, there are no grammar conflicts. Unfortunately it is not so straightforward. As &quot;length&quot; is one of the keywords,  it is not possible to keep this statement in the category of predefined functions and it has to be changed to a unary expression operator. There were similar changes of this type in the past (e.g. isvalue), but the reasons were different - these function calls required specific handling for parameters which differed from standard function calls. This time we are dealing just with naming.<br />
There are two minor drawbacks when changing a predefined function into an operator:<br />
1. The function can no-longer be used as an standalone statement (irrelevant in case of lengthof as a standalone lengthof call does nothing).<br />
2. Impossibility to use function pointers with lengthof (this functionality is specified in an extension package, extremely unlikely option)<br />
I can prepare a proposal but I need an approval of the TTF for this kind of change.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016277)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 11:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				&gt; it is not possible to keep this statement in the category of predefined functions<br />
<br />
Why can't predefined functions with a reserved name be a statement? <br />
I would have excepted the situation is similar to predefined type or builtin functions like `log` oder `match`.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016278)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2022 12:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: CR is postponed and should become part of a larger discussion about the further development of the standard.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016566)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-11-2023 11:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				CR is postponed and should become part of a larger discussion. CR will become part of CR 8180.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016604)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=769">Olivier Genoud</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				26-01-2024 16:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				This change is non-backwards compatible, so it would need a grace period in which &quot;lengthof&quot; still needs to be supported by TTCN-3 tools. <br />
On the other hand, there seems to be no technical benefit, &quot;lengthof&quot; and &quot;length&quot; are different things, so why shall they have the same name?<br />
=&gt; TF160 does not support this proposal.			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
