<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:29 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0008069: Range-based for loop - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0008069</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">New Feature</td><td class="print">public</td><td class="print">06-12-2021 15:04</td><td class="print">03-01-2023 12:44</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Matthias Simon</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">minor</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print"></td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">19.4 The For statement</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">Matthias Simon - Nokia</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0008069: Range-based for loop</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">SUMMARY<br />
<br />
Allow range clause as a second form of for-loops, to improve developer convenience and readability of TTCN-3 source code.<br />
<br />
<br />
MOTIVATION<br />
<br />
Many programming languages (C++, Python, Go, Perl, Rust, ...) provide ranged loops as a concise and convenient alternative to the classic C-style loop.  <br />
Most developers would probably benefit from having this kind of loop in TTCN-3, as well:<br />
The Nokia TTCN-3 code base for 4G and 5G C-Plane contains over 14000 for-loops; 99 percent could be simplified into ranged loops. Other TTCN-3 code bases show a similar picture [1].<br />
<br />
A key idea of TTCN-3 is having the look and feel of a regular programming language, without distracting complexity [2]. A ranged for-loop reduces complexity.<br />
<br />
<br />
PROPOSAL<br />
<br />
**Syntactical Structure**<br />
<br />
&#160;&#160;&#160;&#160;for &quot;(&quot; (VarInstance|ValueRef) &quot;:=&quot; &quot;range&quot; Expression &quot;)&quot; StatementBlock<br />
<br />
<br />
**Semantic Description**<br />
<br />
A _for_ statement with a range clause iterates through all entries of a _record of_, _set of_, _array_, _map_ type or string type (bitstring, hextstring, octettstring, charstring, universal charstring). For each entry it assigns an iteration value to corresponding iteration variable and then executed the statement block.<br />
<br />
Iteration values must be compatible with the iteration variable. Rules for accessing single elements apply (15.6, ...).<br />
<br />
The iteration order over maps is not specified and is not guaranteed to be the same from one iteration to the next.<br />
<br />
The expression on the right in the &quot;range&quot; clause is evaluated once before beginning the loop.<br />
<br />
<br />
**Examples**<br />
<br />
&#160;&#160;&#160;&#160;// Iterating over an array variable<br />
&#160;&#160;&#160;&#160;var charstring myArray[3] := { &quot;foo&quot;, &quot;bar&quot;, &quot;baz&quot; }<br />
&#160;&#160;&#160;&#160;for (var charstring s := range myArray) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Iterating over maps<br />
&#160;&#160;&#160;&#160;var map from charstring to boolean visited := {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[&quot;A&quot;] := true,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[&quot;B&quot;] := true,<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;[&quot;C&quot;] := true,<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Use &quot;from&quot; to iterate over map keys<br />
&#160;&#160;&#160;&#160;for (var charstring k := range visited.from) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Use &quot;to&quot; to iterate over map values<br />
&#160;&#160;&#160;&#160;for (var charstring v := range visited.to) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Iterating over expressions and literal values<br />
&#160;&#160;&#160;&#160;for (var integer x := range {1, 1, 2} &amp; {3, 5, 8}) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Modifying length has no impact on iteration,<br />
&#160;&#160;&#160;&#160;// because range expression is evaluated only once.<br />
&#160;&#160;&#160;&#160;type record of integer RoI;<br />
&#160;&#160;&#160;&#160;var RoI ints := {2, 4}<br />
&#160;&#160;&#160;&#160;for (var integer i := range ints) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;ints[lengthof(ints)] = i*3 // append<br />
&#160;&#160;&#160;&#160;}<br />
&#160;&#160;&#160;&#160;log(int) // {2, 4, 6, 12}<br />
<br />
&#160;&#160;&#160;&#160;// Iterating over templates could use some examples<br />
<br />
OPEN QUESTIONS<br />
<br />
**Keywords**<br />
<br />
It might be a good idea to reuse existing keywords, instead of adding a new one. Some suggestions are:<br />
<br />
* &quot;all from&quot;: for (var integer i := all from myArray)<br />
* &quot;repeat&quot;: for (var integer i := repeat myArray)<br />
* &quot;select&quot;: for (var integer i := select myArray)<br />
* no keyword: for (var integer i := myArray)<br />
<br />
<br />
**Expanding Values**<br />
<br />
Expanding value lists in range loops could be an interesting feature worth exploring:<br />
<br />
&#160;&#160;&#160;&#160;// Example 1:<br />
&#160;&#160;&#160;&#160;for (var integer i := range (0..2, 4, 6) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// this loop will repeat five times: i:= 0, 1, 2, 4, 6<br />
&#160;&#160;&#160;&#160;}<br />
<br />
&#160;&#160;&#160;&#160;// Example 2: generating permutations<br />
&#160;&#160;&#160;&#160;for (var RoI r := range permutation({1,2,3}) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// this loop will repeat six time: r := {1, 2, 3}, {2, 1, 3}, {2, 3, 1}, ...<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
<br />
REFERENCES<br />
<br />
[1](<a href="https://github.com/osmocom/osmo-ttcn3-hacks">https://github.com/osmocom/osmo-ttcn3-hacks</a> [<a href="https://github.com/osmocom/osmo-ttcn3-hacks" target="_blank">^</a>])<br />
[2](<a href="http://www.ttcn-3.org/index.php/about/why-use-ttcn3">http://www.ttcn-3.org/index.php/about/why-use-ttcn3</a> [<a href="http://www.ttcn-3.org/index.php/about/why-use-ttcn3" target="_blank">^</a>])</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8069.docx (117,554) <span class="italic">11-12-2022 09:06</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4091&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8069(1).docx (117,436) <span class="italic">12-12-2022 14:23</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4097&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR8069(2).docx (136,085) <span class="italic">13-12-2022 15:11</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4098&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">06-12-2021 15:04</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2021 09:02</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0016145</td><td class="print"></td></tr><tr class="print"><td class="print">09-12-2021 12:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016147</td><td class="print"></td></tr><tr class="print"><td class="print">16-08-2022 14:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">17-08-2022 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016236</td><td class="print"></td></tr><tr class="print"><td class="print">17-08-2022 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">17-08-2022 11:31</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">new =&gt; assigned</td></tr><tr class="print"><td class="print">11-12-2022 09:06</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">File Added: CR8069.docx</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016373</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016374</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">11-12-2022 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">11-12-2022 09:08</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Deleted: 0016373</td><td class="print"></td></tr><tr class="print"><td class="print">11-12-2022 09:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016375</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 12:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016384</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 12:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Matthias Simon</td></tr><tr class="print"><td class="print">12-12-2022 12:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">12-12-2022 14:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016386</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 14:23</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">File Added: CR8069(1).docx</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 14:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Added: 0016387</td><td class="print"></td></tr><tr class="print"><td class="print">12-12-2022 14:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Assigned To</td><td class="print">Matthias Simon =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">12-12-2022 14:24</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">12-12-2022 14:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a></td><td class="print">Note Deleted: 0016386</td><td class="print"></td></tr><tr class="print"><td class="print">13-12-2022 15:11</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">File Added: CR8069(2).docx</td><td class="print"></td></tr><tr class="print"><td class="print">13-12-2022 15:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016389</td><td class="print"></td></tr><tr class="print"><td class="print">13-12-2022 15:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">13-12-2022 15:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">13-12-2022 15:13</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">03-01-2023 12:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016448</td><td class="print"></td></tr><tr class="print"><td class="print">03-01-2023 12:44</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016145)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2021 09:02&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				how about <br />
<br />
for (var &lt;type&gt; &lt;name&gt; from &lt;record of/set of/array&gt;) { ... }			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016147)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-12-2021 12:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				What about:<br />
<br />
&#160;&#160;&#160;&#160;for (var &lt;type&gt; &lt;name&gt; in &lt;record of/set of/array&gt;) { ... }<br />
<br />
<br />
The &quot;in&quot; form looks a little more python-ish.<br />
I am missing &quot;:=&quot;, though. Maybe it's just habit, but:<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (var Rec r := all from myArray) { ... }<br />
<br />
looks more familiar than:<br />
<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;for (var Rec r from myArray) { ...}<br />
<br />
<br />
<br />
One (minor) advantage of keeping the &quot;:=&quot; is less syntactic variation.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016236)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				17-08-2022 11:31&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: Useful feature. Details to be studied.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016374)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-12-2022 09:08&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The first version of the resolution uploaded. Please check and let me know what should be changed or added.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016375)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-12-2022 09:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				NOTE: There's an issue with iterating template strings. For example:<br />
<br />
&#160;&#160;&#160;&#160;template hexstring t := '1*D'H;<br />
&#160;&#160;&#160;&#160;for (var x in t) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(x);<br />
&#160;&#160;&#160;&#160;}<br />
<br />
<br />
Above code could be translated to:<br />
<br />
&#160;&#160;&#160;&#160;_r := t;<br />
&#160;&#160;&#160;&#160;_l := lengthof(_r) // &lt;-- here's the problem<br />
&#160;&#160;&#160;&#160;for (var integer _i := 0; _i&lt;_l; i++) {<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;var x := _r[_i];<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;log(x);<br />
&#160;&#160;&#160;&#160;}<br />
<br />
Problem: We cannot retrieve the length of template strings for the iteration, because lengthof('1*D'H) causes an error.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016384)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2022 12:47&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				It would be better to separate the different loop forms using different subsections 19.4.1 and 19.4.2.<br />
<br />
According to the reported note #16375 the solution contains an issue that needs to be solved in the solution first.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016387)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1237">Matthias Simon</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				12-12-2022 14:24&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Updated version using different subsections.<br />
<br />
The lengthof issue is independent of this CR and can be solved in an new CR independently: <a href="http://oldforge.etsi.org/mantis/view.php?id=8155">http://oldforge.etsi.org/mantis/view.php?id=8155</a> [<a href="http://oldforge.etsi.org/mantis/view.php?id=8155" target="_blank">^</a>]			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016389)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				13-12-2022 15:13&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The proposed solution file looks right and just has been updated a bit for editorial issues.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016448)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				03-01-2023 12:44&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented as proposed			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
