<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="http://oldforge.etsi.org/mantis/css/default.css" />
	<script type="text/javascript"><!--
		if(document.layers) {document.write("<style>td{padding:0px;}<\/style>")}
	// --></script>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma-directive" content="no-cache" />
	<meta http-equiv="Cache-Directive" content="no-cache" />
	<meta http-equiv="Expires" content="Tue, 17 Dec 2024 09:14:32 GMT" />
	<link rel="shortcut icon" href="/mantis/images/favicon.ico" type="image/x-icon" />
	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Text Search" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=text" />	<link rel="search" type="application/opensearchdescription+xml" title="MantisBT: Issue Id" href="http://oldforge.etsi.org/mantis/browser_search_plugin.php?type=id" />	<title>0007999: Evaluation of function calls in templates - ETSI's Bug Tracker</title>
<script type="text/javascript" src="/mantis/javascript/min/common.js"></script>
<script type="text/javascript">var loading_lang = "Loading...";</script><script type="text/javascript" src="/mantis/javascript/min/ajax.js"></script>
</head>
<body>
<br /><table class="width100" cellspacing="1"><tr><td class="form-title" colspan="6"><div class="center">ETSI's Bug Tracker - Part 01: TTCN-3 Core Language</div></td></tr><tr><td class="form-title" colspan="6">View Issue Details</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print-category"><td class="print" width="16%">ID</td><td class="print" width="16%">Project</td><td class="print" width="16%">Category</td><td class="print" width="16%">View Status</td><td class="print" width="16%">Date Submitted</td><td class="print" width="16%">Last Update</td></tr><tr class="print"><td class="print">0007999</td><td class="print">Part 01: TTCN-3 Core Language</td><td class="print">Technical</td><td class="print">public</td><td class="print">15-01-2021 10:20</td><td class="print">01-12-2021 08:25</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Reporter</td><td class="print">Wolfgang Seka</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Assigned To</td><td class="print">Jens Grabowski</td><td class="print" colspan="4">&#160;</td></tr><tr class="print"><td class="print-category">Priority</td><td class="print">normal</td><td class="print-category">Severity</td><td class="print">major</td><td class="print-category">Reproducibility</td><td class="print">have not tried</td></tr><tr class="print"><td class="print-category">Status</td><td class="print">closed</td><td class="print-category">Resolution</td><td class="print">fixed</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Platform</td><td class="print"></td><td class="print-category">OS</td><td class="print"></td><td class="print-category">OS Version</td><td class="print"></td></tr><tr class="print"><td class="print-category">Product Version</td><td class="print"></td><td class="print" colspan="4">&#160;</td></tr><tr><td class="print-category">Target Version</td><td class="print"></td><td class="print-category">Fixed in Version</td><td class="print">4.13.1 (ongoing)</td><td class="print" colspan="2">&#160;</td></tr><tr class="print"><td class="print-category">Clause Reference(s)</td><td class="print" colspan="4">15.3</td></tr><tr class="print"><td class="print-category">Source  (company  - Author)</td><td class="print" colspan="4">&#160;&#160;&#160;&#160;&#160;MCC TF160 - Wolfgang</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr class="print"><td class="print-category">Summary</td><td class="print" colspan="5">0007999: Evaluation of function calls in templates</td></tr><tr class="print"><td class="print-category">Description</td><td class="print" colspan="5">ES 201 873-1 clause 15.3 distinguishes template fields affected by parameterisation from (static) template fields not affected by parameterisation: &quot;Both global and local templates are initialized at the place of their declaration. This means, all template fields which are not affected by parameterization shall receive a value or matching mechanism. Template fields affected by parameterization are initialized at the time of template use.&quot;<br />
<br />
Use of pre-defined (built-in) functions (e.g. testcasename) or external functions does not seem to have been considered (yet).<br />
<br />
Strictly applying clause 15.3 may cause non-deterministic behaviour as a function call from a template, not using any parameter of this template, may be treated as static and therefore done only once at the point in time when the static fields are evaluated. This point in time depends on the compiler implementation and on the test environment.<br />
<br />
=&gt; When e.g. using, in a send-template, an external function retrieving the system time, the used time value may not be the time when sending the message but a non-deterministic time somewhere in the past. This is surely not what a user wants or expects.<br />
<br />
=&gt; We would like to propose to clarify ES 201 873-1 clause 15.3 to explicitly state that template fields using function calls shall be treated like template fields which are affected by parameterization. Hereafter is an example text update to exemplify what we have in mind:<br />
<br />
&quot;Both global and local templates are initialized at the place of their declaration. This means, all template fields which are not affected by parameterization shall receive a value or matching mechanism. Template fields affected by parameterization or using function calls are initialized at the time of template use.&quot;</td></tr><tr class="print"><td class="print-category">Steps To Reproduce</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Additional Information</td><td class="print" colspan="5"></td></tr><tr class="print"><td class="print-category">Tags</td><td class="print" colspan="5">No tags attached.</td></tr><tr class="print"><td class="print-category">Relationships</td><td class="print" colspan="5"><table border="0" width="100%" cellpadding="0" cellspacing="1"><tr><td class="print"><span class="nowrap">related to</span>&#160;</td><td class="print">0008032</td><td class="print">closed&#160;</td><td class="print"><span class="nowrap"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></span>&#160;</td><td class="print">BNF links and formatting&#160;</td></tr></table></td></tr><tr class="print"><td class="print-category">Attached Files</td><td class="print" colspan="5"><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7999.docx (173,425) <span class="italic">05-02-2021 12:39</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3995&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7999-v2.docx (198,269) <span class="italic">07-02-2021 09:33</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=3996&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7999-v3.docx (253,255) <span class="italic">09-09-2021 11:30</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4010&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7999-v4.docx (332,918) <span class="italic">08-11-2021 10:36</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4017&amp;type=bug<br /><img src="http://oldforge.etsi.org/mantis/images/fileicons/doc.gif" alt="docx" />&#160;CR7999-v5.docx (279,176) <span class="italic">08-11-2021 14:35</span><br />http://oldforge.etsi.org/mantis/file_download.php?file_id=4027&amp;type=bug</td></tr><tr><td class="print-spacer" colspan="6"><hr size="1" /></td></tr><tr><td class="form-title">Issue History</td></tr><tr class="print-category"><td class="row-category-history">Date Modified</td><td class="row-category-history">Username</td><td class="row-category-history">Field</td><td class="row-category-history">Change</td></tr><tr class="print"><td class="print">15-01-2021 10:20</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">New Issue</td><td class="print"></td></tr><tr class="print"><td class="print">20-01-2021 18:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015901</td><td class="print"></td></tr><tr class="print"><td class="print">21-01-2021 09:43</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Note Added: 0015902</td><td class="print"></td></tr><tr class="print"><td class="print">25-01-2021 11:01</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a></td><td class="print">Note Added: 0015903</td><td class="print"></td></tr><tr class="print"><td class="print">04-02-2021 09:51</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0015904</td><td class="print"></td></tr><tr class="print"><td class="print">05-02-2021 12:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7999.docx</td><td class="print"></td></tr><tr class="print"><td class="print">05-02-2021 12:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015905</td><td class="print"></td></tr><tr class="print"><td class="print">05-02-2021 12:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">05-02-2021 12:40</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">new =&gt; confirmed</td></tr><tr class="print"><td class="print">07-02-2021 09:33</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7999-v2.docx</td><td class="print"></td></tr><tr class="print"><td class="print">07-02-2021 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015906</td><td class="print"></td></tr><tr class="print"><td class="print">07-02-2021 09:50</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">09-02-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015907</td><td class="print"></td></tr><tr class="print"><td class="print">10-02-2021 11:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015908</td><td class="print"></td></tr><tr class="print"><td class="print">11-02-2021 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Added: 0015909</td><td class="print"></td></tr><tr class="print"><td class="print">11-02-2021 11:10</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a></td><td class="print">Note Edited: 0015909</td><td class="print">bug_revision_view_page.php?bugnote_id=15909#r544</td></tr><tr class="print"><td class="print">15-02-2021 10:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015910</td><td class="print"></td></tr><tr class="print"><td class="print">24-02-2021 13:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a></td><td class="print">Note Added: 0015911</td><td class="print"></td></tr><tr class="print"><td class="print">25-02-2021 10:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015912</td><td class="print"></td></tr><tr class="print"><td class="print">23-03-2021 15:59</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Project</td><td class="print">TTCN-3 Change Requests =&gt; Part 01: TTCN-3 Core Language</td></tr><tr class="print"><td class="print">09-09-2021 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7999-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-09-2021 11:26</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Deleted: CR7999-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-09-2021 11:30</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7999-v3.docx</td><td class="print"></td></tr><tr class="print"><td class="print">09-09-2021 11:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; </td></tr><tr class="print"><td class="print">09-09-2021 11:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print"> =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">09-09-2021 11:47</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">09-09-2021 11:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0015966</td><td class="print"></td></tr><tr class="print"><td class="print">09-09-2021 11:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Tomas Urban</td></tr><tr class="print"><td class="print">09-09-2021 11:48</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">14-09-2021 11:39</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1194">sekaw</a></td><td class="print">Note Added: 0015992</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 10:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">File Added: CR7999-v4.docx</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 10:54</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015994</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 10:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Note Added: 0015995</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 10:56</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a></td><td class="print">Assigned To</td><td class="print">Tomas Urban =&gt; Jacob Wieland - Spirent</td></tr><tr class="print"><td class="print">08-11-2021 14:35</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">File Added: CR7999-v5.docx</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Note Added: 0016005</td><td class="print"></td></tr><tr class="print"><td class="print">08-11-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Status</td><td class="print">confirmed =&gt; resolved</td></tr><tr class="print"><td class="print">08-11-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Fixed in Version</td><td class="print"> =&gt; 4.13.1 (ongoing)</td></tr><tr class="print"><td class="print">08-11-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Resolution</td><td class="print">open =&gt; fixed</td></tr><tr class="print"><td class="print">08-11-2021 14:36</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a></td><td class="print">Assigned To</td><td class="print">Jacob Wieland - Spirent =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">23-11-2021 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016092</td><td class="print"></td></tr><tr class="print"><td class="print">23-11-2021 11:17</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">resolved =&gt; closed</td></tr><tr class="print"><td class="print">23-11-2021 15:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016099</td><td class="print"></td></tr><tr class="print"><td class="print">23-11-2021 15:28</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">closed =&gt; confirmed</td></tr><tr class="print"><td class="print">30-11-2021 12:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Assigned To</td><td class="print">Jens Grabowski =&gt; Axel Rennoch</td></tr><tr class="print"><td class="print">30-11-2021 12:14</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; assigned</td></tr><tr class="print"><td class="print">01-12-2021 07:18</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Relationship added</td><td class="print">related to 0008032</td></tr><tr class="print"><td class="print">01-12-2021 07:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Note Added: 0016135</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2021 07:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Assigned To</td><td class="print">Axel Rennoch =&gt; Jens Grabowski</td></tr><tr class="print"><td class="print">01-12-2021 07:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a></td><td class="print">Status</td><td class="print">assigned =&gt; confirmed</td></tr><tr class="print"><td class="print">01-12-2021 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Note Added: 0016140</td><td class="print"></td></tr><tr class="print"><td class="print">01-12-2021 08:25</td><td class="print"><a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a></td><td class="print">Status</td><td class="print">confirmed =&gt; closed</td></tr></table>
<br />
<table class="width100" cellspacing="1">
<tr>
	<td class="form-title" colspan="2">
		Notes	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015901)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				20-01-2021 18:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The intention of the standard so far is to say that it basically should not matter where a template body is evaluated, it should have the same value in the same context. This implies that all the fields whose right-hand-side is not dependent of a parameter should be initializeable at the point of declaration of the template, while, of course, the fields that are dependent on a template parameter can only be evaluated once the formal parameter is instantiated with an actual parameter at the point of usage of the template:<br />
<br />
To illustrate this, consider the following example:<br />
<br />
type record R { integer a, integer b }<br />
function f(integer x) return integer { ... }<br />
<br />
function g() {<br />
&#160;&#160;var integer a := 3;<br />
&#160;&#160;template R t := { a, f(a) };<br />
&#160;&#160;a := 5;<br />
<br />
&#160;&#160;if (match({3,f(3)}, t)) { ... // true with the standard until now <br />
&#160;&#160;}<br />
&#160;&#160;if (match({3,f(5)}, t)) { ... // true with the proposal, but unexpected/confusing<br />
&#160;&#160;}<br />
&#160;&#160;if (match({5,f(5)}, t)) { ... // expectation if templates are fully evaluated lazy<br />
&#160;&#160;}  <br />
<br />
}<br />
<br />
For this reason, this would be backward incompatible change.<br />
<br />
If you want the template to consider the change of a, you should make a a parameter of the template:<br />
<br />
template R t(integer x) := { x, f(x) }<br />
<br />
and then use t(a) whereever you want { a, f(a) }			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015902)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				21-01-2021 09:43&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Additionally we would like to get a question clarified, that is related this discussion, but not covered by CR7999 Subject yet:<br />
<br />
Question, regarding the direct use of variable a:<br />
Using the modified function g() below, what is the expected behaviour?<br />
<br />
function g() {<br />
&#160;&#160;var integer a;<br />
&#160;&#160;template R t := { a, f(a) };  // local template declaration: here a is undefined; CR7999 covers f(a), but not yet the direct use of variable a<br />
&#160;&#160;a := 3;<br />
&#160;&#160;...<br />
&#160;&#160;a := 5;<br />
&#160;&#160;p.send(t); // Question: is it a test case error (as a is not initialized at template declaration), is it { 3, f(3) } (first bound value to a is 3) or is it { 5, f(5) } (value bound to a when t is used for the first time) ?<br />
&#160;&#160;...<br />
}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015903)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=455">Wolfgang Seka</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-01-2021 11:01&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Some remarks:<br />
a) First of all I'm confused about Jacob's note: In your first mail you've stated that the Spirent compiler behaves as we expect i.e. evaluates function when a template is used. Or is it different for global and local templates ??<br />
<br />
b) Generally it seems that there are differences for global and local templates:<br />
- It is pretty clear and visible for users when a local template gets initialised; from a user's point of view it is similar to a template variable.<br />
- With literal interpretation of 15.3 the initialisation of a global template is unpredictable when it uses a function call like retrieving the system time. On the other hand the common expectation by users might be, that global templates behave like function calls (predictable and easy to understand).<br />
<br />
c) Different compilers seem to use different interpretations regarding global templates =&gt; the TTCN-3 standard may not be clear enough and independent of outcome of this discussion there might always be a compatibility issue:<br />
For MCC160 test suites it would be a severe issue when we would need to change our code to align it with changes of the compiler(s) (please note that we are using testcasename() in templates since at least ten years). And if so, the criteria for users are still not clear (as templates may use other templates using functions; in this case all templates are affected)<br />
<br />
Conclusion: <br />
We (MCC160) need a solution with minimum impact on our code. This would be served with the proposed clarification of 15.3. In addition global and local templates may need to be distinguished. As alternative some global directive may be introduced to specify whether or not global and/or local templates are treated as &quot;fuzzy&quot;.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015904)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				04-02-2021 09:51&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				TTF discussion: TTF agrees that a solution is required. The TTF proposes to follow the idea of a global &quot;fuzzy&quot; directive (maybe as an attribute on groups or modules).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015905)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				05-02-2021 12:40&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				uploaded draft proposal, please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015906)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				07-02-2021 09:50&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I removed the reference to explicit lazy templates, because there's no such option in TTCN-3 at the moment. Static templates can be either fuzzy or without a modifier.<br />
<br />
However, I think we still have to discuss two aspects of the added feature:<br />
1. Is it necessary to change how local templates behave? Their lifetime is limited to the lifetime of their parent block and their place in the code determines quite precisely when they are initialized. I would prefer that only global templates would be affected.<br />
2. In case we decide in favour of local templates, there's a question what to do with template variables and parameters (which are always local). Technically they are not affected by the rule as they are quite different entities. But it might not be so obvious without detailed knowledge of the specification, so I would prefer to add a note saying they are not affected by the rule.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015907)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-02-2021 14:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				The initializer in a template variable declaration is a place of usage, so, of course, the value (unless lazy/fuzzy) is evaluated before the assignment to the variable, at the place of the declaration of the variable. <br />
<br />
I don't see why it should be different for local and global templates. That will just add another source of confusion in my opinion. The semantics should not change if I move a local template into the global scope, if it was already independent from its context. With your proposal, suddenly the semantics could change from non-fuzzy to fuzzy.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015908)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				10-02-2021 11:35&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I admit that for the sake of consistency, it is better to have a rule that affects all static templates. <br />
<br />
However, I would still like to have the note about template variables and paremeters.<br />
<br />
We should also consider what happens, if how nesting works in case of groups. Does a group with a missing @fuzzy modifier turn off a @fuzzy setting of the surrounding module?<br />
<br />
In my opinion, it would be better if a missing modifier on a group level meant that the setting is inherited. In order to allow overwriting, I propose to introduce another modifier (e.g. @static) that would mean the old &quot;resolve as early as possible&quot; mode and could be used for overwriting the mode set on a higher level (both on group level and in template declarations).<br />
<br />
We should also consider adding @lazy modifier support to static templates, modules and groups. I dont'n see a reason, why it should be missing.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015909)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=127">Gyorgy Rethy</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				11-02-2021 11:10&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Hi,<br />
In general I disagree with the module and group @fuzzy solution for two reasons:<br />
- that would complicate user's life even more (and what is worth, decrease their productivity, that managers are looking at when choosing a tool/language for a new project...); a typical workflow is: user is writing/debugging a function, which uses a template. In Eclipse ctrl+F3 -&gt; jump to definition, looks at the template; it will see the template ALONE but not it's context in term of group/module; this 'feature' could just increase users' frustration, while not really giving too much to him/her.<br />
- the second is Jacob's point: a definition's behavior shall not change just by moving it out of a group, into another group, other module etc. In the course of normal development re-structuring the code happens quite open in the way from a prototype to a more and more feature-rich 'product'. This could easily lead to chaos in case of such restructurings.<br />
<br />
On Thilo's question: TTCN-3 code is executed statement-by-statement. As template t is declared completely, i.e. not parameterized, it is evaluated at the place of its declaration, and as 'a' is unbound, and used as a value of a field, the send operation shall cause an error as trying to send a not completely initialized template.<br />
<br />
In summary: as a general rule, the standard should state, that the template shall be evaluated at the place where it gets completely defined. This would be a simple, easy to remember rule and remove ambiguities.<br />
<br />
			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015910)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				15-02-2021 10:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I agree with Georgys assessment completely and I always thought that this was the intended way of the standard. Unfortunately, this clarification seems to cause trouble for people because some tools misinterpreted the standard (or did not read it as it was intended) and this led to problems with certain code when used by different tools that interepreted it more like the standard intended.<br />
<br />
This will then lead to the old code having to be rewritten. In general, I am confused about the whole situation as we informed people that were using our tools some years ago what the problem with their code was (when the problem first cropped up after testcasename was introduced) and they obviously did not heed our advice and instead chose to use other tools which now cause this problem.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015911)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=131">Thilo Lauer</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				24-02-2021 13:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				In preparation of tomorrow's GoToMeeting:<br />
-----------------------------------------<br />
To get back to FACTS and towards a COMMON understanding of the TTCN-3 standard<br />
let's have a look at this enhanced example and questions Q1 .. Q4:<br />
<br />
type record R { integer a, integer b, integer c }<br />
function f(integer x) return integer { ... }<br />
function g() {<br />
&#160;&#160;var integer a, c:=2;<br />
&#160;&#160;// local template declarations:<br />
&#160;&#160;template R t := { a, f(a), c};                            // field 'a' is undefined; field 'c' is NOT parameterized<br />
&#160;&#160;template R u(integer k) := {k * a, k* f(a), c};           // field 'a' is undefined, param 'k' has NO default value, field 'c' is NOT parameterized<br />
&#160;&#160;template R v := {8, f(9), c};                             // all fields are defined at template declaration time<br />
&#160;&#160;template R w(integer m := 1) := {m * 8, m * f(9), m * c}; // param 'm' has default value, all fields are parameterized<br />
&#160;&#160;a := 3;<br />
&#160;&#160;...<br />
&#160;&#160;a := 5;<br />
&#160;&#160;c := 10;<br />
<br />
&#160;&#160;// Question 1:<br />
&#160;&#160;p.send(t);<br />
&#160;&#160;&#160;&#160;// Q1a: ==&gt; ERROR as 'a' is not initialized at template declaration or<br />
&#160;&#160;&#160;&#160;// Q1b: ==&gt; { 3, f(3), 2}  (first bound value to 'a' is 3 and to 'c' is 2) <br />
&#160;&#160;&#160;&#160;// Q1c: ==&gt; { 5, f(5), 2}  (value bound to 'a' when 't' is used for the first time)<br />
&#160;&#160;&#160;&#160;// Q1d: ==&gt; { 5, f(5), 10} (completely evaluated at time of use)<br />
<br />
&#160;&#160;// Question 2:<br />
&#160;&#160;p.send(u(1)); 	// note: p should be a LOOPBACK port (!)<br />
&#160;&#160;p.receive(t);		// should it match?, see Question 1 above <br />
&#160;&#160;&#160;&#160;// Q2a: p.send(u(1)); ==&gt; { 1*5, 1*f(5), 2}  ==&gt; { 5, f(5), 2}    (only parameterized fields are evaluated, 'c' is 2 at decl. time) <br />
&#160;&#160;&#160;&#160;// Q2b: p.send(u(1)); ==&gt; { 1*5, 1*f(5), 10} ==&gt; { 5, f(5), 10}   (completely evaluated at time of use)<br />
<br />
&#160;&#160;// Question 3: How to explain possible differences to TTCN-3 users / test suite maintainers?<br />
&#160;&#160;p.send(v());	// Q3a: ==&gt; { 8, f(9), 2}                             (completely assigned at decl. time; although c==10 when template is used)<br />
&#160;&#160;p.send(w); 	// Q3b: ==&gt; { 1*8, 1*f(9), 1*2}  ==&gt; { 8, f(9), 2 }   (completely assigned at decl. time; although DECLARATION is parameterized)<br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;// Q3c: ==&gt; { 1*8, 1*f(9), 1*10} ==&gt; { 8, f(9), 10 }  (completely evaluated at time of use)<br />
&#160;&#160;p.send(w(1)); // Q3d: ==&gt; { 1*8, 1*f(9), 1*10} ==&gt; { 8, f(9), 10 }  (all fields are parameterized and therefore evaluated at time of use)<br />
<br />
&#160;&#160;// Q4: Generally asking from a TTCN-3 user's perspective:<br />
&#160;&#160;// ======================================================<br />
&#160;&#160;// How to remember easily the differences between u(1) and t AND between v, w and w(1) ???<br />
&#160;&#160;// Why do we need different handling rules for parameterized  and non-parameterized templates?<br />
}			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015912)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				25-02-2021 10:30&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Discussion with STF 160: We propose to introduce a template-field modifier @fuzzy into the standard that signifies that the evaluation of the right-hand-side of the field is deferred until the place of usage of the field (where modification of the template or instantiation of the template inside another template does not count as 'place of usage'). <br />
<br />
Such a fuzzy field shall only be evaluated inside a template-structure when the whole template-structure is evaluated for use (i.e. for sending, for isvalue, for matching or other places that require templates to be evaluated like actual parameters).<br />
<br />
Here a few examples to my current understanding of the new feature:<br />
<br />
template R base := { @fuzzy name := testcasename() }<br />
<br />
template R modifiedR modifies base := { a := 5 } // name-field is still fuzzy<br />
<br />
template R modifiedR2 modifies base := { name := &quot;foobar&quot; } // name-field not fuzzy<br />
<br />
When a fuzzy field is used in some non-fuzzy evaluation, it needs to be evaluated.<br />
<br />
template R modifiedR3 modifies base := { name := base.name &amp; &quot;_used&quot; } // base.name is evaluated, so this might lead to global evaluation of the name field<br />
<br />
template R modifiedR4 modifies base := { @fuzzy name := base.name &amp; &quot;_used&quot; } // here, base.name would only be evaluated when modifiedR4.name is evaluated (fuzzy field assignment overridden by new fuzzy assignment)			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015966)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				09-09-2021 11:48&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Please review			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015992)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=1194">sekaw</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				14-09-2021 11:39&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				A minor issue:<br />
The new text says &quot;... shall only be evaluated when ...&quot;.<br />
So, I wonder in which cases the assignment shall not be evaluated when it would be evaluated without the &quot;@fuzzy&quot; modifier.<br />
According to my understanding the &quot;@fuzzy&quot; modifier should force the evaluation to be done whenever the template is used - or do I miss anything ??<br />
<br />
Furthermore the examples modifiedR3 and modifiedR4 are hard to understand (at least for me):<br />
Assuming that testcasename() returns &quot;&quot; at the time the templates are created (as no testcase is running yet), in modifiedR3 base.n is still &quot;&quot; and modifiedR3.n will be &quot; used&quot; where ever used, but modifiedR4.n is &quot;&lt;test case&gt; used&quot; with the name of the test case in which modifiedR4 is used.<br />
Is this correct ??<br />
<br />
And another question: <br />
Even though in general we are not using local templates (e.g. declared in a function) - is there any difference ??<br />
Is the local template of a function without any parameters and without &quot;@fuzzy&quot; modifier instantiated (and therefore evaluated) whenever the function is called or only once at the very beginning of a test campaign ??.<br />
(in the first case modifiedR3 and modifiedR4 would be effectively the same).			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015994)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2021 10:54&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Regarding Wolfgang's questions:<br />
<br />
1. Basically you are correct. However, templates with the @fuzzy modifier can be used in lazy/fuzzy context which doesn't trigger evaluation. For that reason we cannot just write &quot;whenever the template is used&quot;, but list either the cases that trigger evaluation or the exception. We chose the fist option.<br />
<br />
2. Correct. However, there are diffirences between various tools, because the original version of the TTCN-3 core language specification didn't precisely when this evaluation should take place. Unfortunately it is impossible to overcome this issue at this point as setting a hard limit would make some of the tools incompatible with the standard.<br />
<br />
3. There are no major functional differences, both fuzzy and local templates will be evaluated inside test cases (when called). You could also use templates decladed inside component types.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0015995)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=659">Tomas Urban</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2021 10:56&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				I moved the rules concerning modifications to 15.5 and made a couple of minor adjustments. Please check.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016005)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=508">Jacob Wieland - Spirent</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				08-11-2021 14:36&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Fixed one typo (modifier -&gt; modified) but otherwise ok.			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016092)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-11-2021 11:17&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				implemented			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016099)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				23-11-2021 15:28&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				BNF needs to be checked			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016135)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=514">Axel Rennoch</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2021 07:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				BNF changes in CR 7999 have been implemented in CR0008031+32_Core-Language-without-CR7910-r1.docx 			</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td class="print-spacer" colspan="2">
		<hr size="1" />
	</td>
</tr>
<tr>
	<td class="nopad" valign="top" width="20%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				(0016140)
			</td>
		</tr>
		<tr>
			<td class="print">
				<a href="http://oldforge.etsi.org/mantis/view_user_page.php?id=82">Jens Grabowski</a>&#160;&#160;&#160;
			</td>
		</tr>
		<tr>
			<td class="print">
				01-12-2021 08:25&#160;&#160;&#160;
							</td>
		</tr>
		</table>
	</td>
	<td class="nopad" valign="top" width="85%">
		<table class="hide" cellspacing="1">
		<tr>
			<td class="print">
				Implemented			</td>
		</tr>
		</table>
	</td>
</tr>
</table>
</body>
</html>
